/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.codeGen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.codeGen.CodeGenResult;
import org.jetbrains.kotlinx.dataframe.codeGen.CodeWithTypeCastGenerator;
import org.jetbrains.kotlinx.dataframe.codeGen.Marker;
import org.jetbrains.kotlinx.dataframe.codeGen.TypeCastGenerator;
import org.jetbrains.kotlinx.dataframe.keywords.HardKeywords;
import org.jetbrains.kotlinx.dataframe.keywords.ModifierKeywords;
import org.jetbrains.kotlinx.dataframe.schema.ComparisonMode;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\f\u0010\u0017\u001a\u00020\u0003*\u00020\u0001H\u0000\u001a\n\u0010\u0018\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0001\u001a\u0016\u0010\u001a\u001a\u00020\u0001*\f\u0012\b\u0012\u00060\u0001j\u0002`\u001b0\u0005H\u0000\u001a \u0010\u001c\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a$\u0010\u001c\u001a\u00020\u0001*\u00060\u0001j\u0002`\u001b2\u0006\u0010\u001d\u001a\u00020\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a \u0010\u001c\u001a\u00020\u0001*\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\"\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"renderNullability", "", "nullable", "", "filterRequiredForSchema", "", "Lorg/jetbrains/kotlinx/dataframe/codeGen/Marker;", "", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "charsToQuote", "Lkotlin/text/Regex;", "getCharsToQuote", "()Lkotlin/text/Regex;", "createCodeWithTypeCastGenerator", "Lorg/jetbrains/kotlinx/dataframe/codeGen/CodeWithTypeCastGenerator;", "code", "targetTypeNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlinx/dataframe/codeGen/CodeWithTypeCastGenerator;", "letterCategories", "", "Lkotlin/text/CharCategory;", "needsQuoting", "isQuoted", "quoteIfNeeded", "join", "Lorg/jetbrains/kotlinx/dataframe/codeGen/Code;", "toStandaloneSnippet", "packageName", "additionalImports", "Lorg/jetbrains/kotlinx/dataframe/codeGen/CodeGenResult;", "core"})
@SourceDebugExtension(value={"SMAP\nCodeGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeGeneratorImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/codeGen/CodeGeneratorImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,595:1\n774#2:596\n865#2,2:597\n1869#2,2:603\n1069#3,2:599\n1088#3,2:601\n*S KotlinDebug\n*F\n+ 1 CodeGeneratorImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/codeGen/CodeGeneratorImplKt\n*L\n45#1:596\n45#1:597,2\n586#1:603,2\n73#1:599,2\n74#1:601,2\n*E\n"})
public final class CodeGeneratorImplKt {
    @NotNull
    private static final Regex charsToQuote = new Regex("[ `(){}\\[\\].<>'\"/|\\\\!?@:;%^&*#$-]");
    @NotNull
    private static final Set<CharCategory> letterCategories;

    private static final String renderNullability(boolean nullable) {
        return nullable ? "?" : "";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Marker> filterRequiredForSchema(@NotNull Iterable<? extends Marker> $this$filterRequiredForSchema, @NotNull DataFrameSchema schema) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterRequiredForSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Iterable<? extends Marker> $this$filter$iv = $this$filterRequiredForSchema;
        boolean $i$f$filter = false;
        Iterable<? extends Marker> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Marker it = (Marker)element$iv$iv;
            boolean bl = false;
            if (!(it.isOpen() && it.getSchema().compare(schema, ComparisonMode.STRICT_FOR_NESTED_SCHEMAS).isSuperOrEqual())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Regex getCharsToQuote() {
        return charsToQuote;
    }

    @NotNull
    public static final CodeWithTypeCastGenerator createCodeWithTypeCastGenerator(@NotNull String code, String ... targetTypeNames) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)targetTypeNames, (String)"targetTypeNames");
        return new CodeWithTypeCastGenerator(code, TypeCastGenerator.DataFrameApi.Companion.invoke(Arrays.copyOf(targetTypeNames, targetTypeNames.length)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean needsQuoting(@NotNull String $this$needsQuoting) {
        char it;
        char element$iv;
        int n;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$needsQuoting, (String)"<this>");
            if (CodeGeneratorImplKt.isQuoted($this$needsQuoting)) {
                return false;
            }
            if (StringsKt.isBlank((CharSequence)$this$needsQuoting)) return true;
            if (Character.isDigit(StringsKt.first((CharSequence)$this$needsQuoting))) return true;
            CharSequence charSequence = $this$needsQuoting;
            if (charsToQuote.containsMatchIn(charSequence)) return true;
            if (HardKeywords.Companion.getVALUES().contains($this$needsQuoting)) return true;
            if (ModifierKeywords.Companion.getVALUES().contains($this$needsQuoting)) return true;
            CharSequence $this$all$iv = $this$needsQuoting;
            boolean $i$f$all = false;
            n = 0;
            while (n < $this$all$iv.length()) {
                it = element$iv = $this$all$iv.charAt(n);
                boolean bl = false;
                if (it == '_') {
                    ++n;
                    continue;
                }
                break block6;
            }
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        CharSequence $this$any$iv = $this$needsQuoting;
        boolean $i$f$any = false;
        n = 0;
        while (n < $this$any$iv.length()) {
            it = element$iv = $this$any$iv.charAt(n);
            boolean bl2 = false;
            if (it != '_' && !letterCategories.contains(CharsKt.getCategory((char)it))) {
                return true;
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuoted, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isQuoted, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$isQuoted, (String)"`", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String quoteIfNeeded(@NotNull String $this$quoteIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$quoteIfNeeded, (String)"<this>");
        return CodeGeneratorImplKt.needsQuoting($this$quoteIfNeeded) ? '`' + $this$quoteIfNeeded + '`' : $this$quoteIfNeeded;
    }

    @NotNull
    public static final String join(@NotNull List<String> $this$join) {
        Intrinsics.checkNotNullParameter($this$join, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$join, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull CodeWithTypeCastGenerator $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        return CodeGeneratorImplKt.toStandaloneSnippet($this$toStandaloneSnippet.getDeclarations(), packageName, additionalImports);
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull String $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        StringBuilder $this$toStandaloneSnippet_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)packageName).length() > 0) {
            $this$toStandaloneSnippet_u24lambda_u244.append("package " + packageName).append('\n');
            $this$toStandaloneSnippet_u24lambda_u244.append('\n');
        }
        $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.ColumnsScope").append('\n');
        $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.DataColumn").append('\n');
        $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.DataFrame").append('\n');
        $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.DataRow").append('\n');
        $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup").append('\n');
        $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.annotations.ColumnName").append('\n');
        $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.annotations.DataSchema").append('\n');
        $this$toStandaloneSnippet_u24lambda_u244.append("import org.jetbrains.kotlinx.dataframe.api.cast").append('\n');
        Iterable $this$forEach$iv = additionalImports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$toStandaloneSnippet_u24lambda_u244.append(it).append('\n');
        }
        $this$toStandaloneSnippet_u24lambda_u244.append('\n');
        $this$toStandaloneSnippet_u24lambda_u244.append($this$toStandaloneSnippet).append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull CodeGenResult $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        return CodeGeneratorImplKt.toStandaloneSnippet($this$toStandaloneSnippet.getCode(), packageName, additionalImports);
    }

    public static final /* synthetic */ String access$renderNullability(boolean nullable) {
        return CodeGeneratorImplKt.renderNullability(nullable);
    }

    static {
        Object[] objectArray = new CharCategory[]{CharCategory.UPPERCASE_LETTER, CharCategory.TITLECASE_LETTER, CharCategory.MODIFIER_LETTER, CharCategory.LOWERCASE_LETTER, CharCategory.DECIMAL_DIGIT_NUMBER};
        letterCategories = SetsKt.setOf((Object[])objectArray);
    }
}

