/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.RemoteBuildReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTimeMetric;
import org.jetbrains.kotlin.buildtools.api.SourcesChanges;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.metadata.KotlinMetadataCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.EventManagerImpl;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemonKt;
import org.jetbrains.kotlin.daemon.KotlinRemoteReplServiceKt;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcher;
import org.jetbrains.kotlin.daemon.RunningCompilations;
import org.jetbrains.kotlin.daemon.common.BuildMetricsValue;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationPerformanceMetrics;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.MultiModuleICSettings;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporter;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.CompileScopeExpansionMode;
import org.jetbrains.kotlin.incremental.CompilerRunnerUtils;
import org.jetbrains.kotlin.incremental.IncrementalCompilationFeatures;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunnerKt;
import org.jetbrains.kotlin.incremental.IncrementalFirJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJsCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.EmptyModulesApiHistory;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistory;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryJs;
import org.jetbrains.kotlin.incremental.storage.FileLocations;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.util.PerformanceManager;
import org.jetbrains.kotlin.util.PhaseType;
import org.jetbrains.kotlin.util.Time;
import org.jetbrains.kotlin.util.UnitStats;
import org.jetbrains.kotlin.util.UnitStatsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\b\u008f\u0001\u0090\u0001\u0091\u0001\u0092\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\f\u0010,\u001a\u00020-*\u00020\u0007H\u0004J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0004J\b\u0010?\u001a\u00020\fH$J\b\u0010@\u001a\u00020\fH$J\b\u0010A\u001a\u00020\fH$J\u001a\u0010B\u001a\u00020\f2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0084\b\u00f8\u0001\u0000J\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0004J\u0080\u0002\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00070=\"\u0004\b\u0000\u0010K\"\u0004\b\u0001\u0010L\"\u0004\b\u0002\u0010M2\u0006\u0010N\u001a\u00020\u00072\u000e\u0010O\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u0002HK2\u0006\u0010T\u001a\u0002HM2\u0017\u0010U\u001a\u0013\u0012\u0004\u0012\u0002HL\u0012\u0004\u0012\u00020W0V\u00a2\u0006\u0002\bX2\u0018\u0010Y\u001a\u0014\u0012\u0004\u0012\u0002HK\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020[0Z2\u0018\u0010\\\u001a\u0014\u0012\u0004\u0012\u0002HK\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020]0Z2\u001e\u0010^\u001a\u001a\u0012\u0004\u0012\u0002HL\u0012\u0004\u0012\u00020`\u0012\u0004\u0012\u00020a\u0012\u0004\u0012\u00020b0_2,\u0010c\u001a(\u0012\u0004\u0012\u0002HK\u0012\u0006\u0012\u0004\u0018\u0001HM\u0012\u0004\u0012\u00020d\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u00020g0e0_2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010\u0007H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ\b\u0010j\u001a\u00020\fH\u0001J]\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00070=2\u0006\u0010N\u001a\u00020\u00072\u0006\u0010l\u001a\u00020]2\b\u0010m\u001a\u0004\u0018\u00010n2\b\u0010h\u001a\u0004\u0018\u00010\u00072 \u0010C\u001a\u001c\u0012\u0004\u0012\u00020`\u0012\u0004\u0012\u00020a\u0012\u0006\u0012\u0004\u0018\u00010o\u0012\u0004\u0012\u00020p0_H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010qJ\n\u0010r\u001a\u00020/*\u00020/J\n\u0010s\u001a\u00020/*\u00020/J5\u0010t\u001a\u0002Hu\"\u0004\b\u0000\u0010u2\u0006\u0010l\u001a\u00020]2\u0006\u0010v\u001a\u00020a2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002Hu0\u000bH\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010wJ\u0006\u0010x\u001a\u00020\fJ\u0006\u0010y\u001a\u00020\fJ6\u0010z\u001a\b\u0012\u0004\u0012\u0002Hu0=\"\u0004\b\u0000\u0010u2\b\b\u0002\u0010{\u001a\u00020|2\u0012\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hu0=0\u000bH\u0084\b\u00f8\u0001\u0000JB\u0010}\u001a\b\u0012\u0004\u0012\u0002Hu0=\"\u0004\b\u0000\u0010u2\u0006\u0010N\u001a\u00020\u00072 \u0010C\u001a\u001c\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u007f\u0018\u00010~\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hu0=0VH\u0084\b\u00f8\u0001\u0000J:\u0010\u0080\u0001\u001a\u00020p2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020d2\u0007\u0010\u0084\u0001\u001a\u00020[2\u0013\u0010\u0085\u0001\u001a\u000e\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u00020g0eH\u0004J\u000f\u0010\u0086\u0001\u001a\u00030\u0087\u0001*\u00030\u0088\u0001H\u0002JG\u0010\u0089\u0001\u001a\u00020p2\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u0083\u0001\u001a\u00020d2\u0007\u0010\u0084\u0001\u001a\u00020[2\u0013\u0010\u0085\u0001\u001a\u000e\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u00020g0e2\u000b\b\u0002\u0010\u008c\u0001\u001a\u0004\u0018\u00010oH\u0004JH\u0010\u008d\u0001\u001a\b\u0012\u0004\u0012\u0002Hu0=\"\u0004\b\u0000\u0010u\"\u0005\b\u0001\u0010\u008e\u00012\u0006\u0010N\u001a\u00020\u00072\u001e\u0010C\u001a\u001a\u0012\u0005\u0012\u0003H\u008e\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hu0=0V\u00a2\u0006\u0002\bXH\u0084\b\u00f8\u0001\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R#\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010 \u001a\u00020!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010.\u001a\u00020/X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0012\u00104\u001a\u00020/X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00101R\u001a\u00106\u001a\u000207X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0093\u0001"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "<init>", "(Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerId;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "getDaemonOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "getCompilerId", "()Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "getPort", "()I", "getTimer", "()Ljava/util/Timer;", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "compilationsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCompilationsCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "classpathWatcher", "Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher;", "getClasspathWatcher", "()Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher;", "state", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$CompileServiceState;", "getState", "()Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$CompileServiceState;", "toAlivenessName", "", "_lastUsedSeconds", "", "get_lastUsedSeconds", "()J", "set_lastUsedSeconds", "(J)V", "lastUsedSeconds", "getLastUsedSeconds", "runFile", "Ljava/io/File;", "getRunFile", "()Ljava/io/File;", "setRunFile", "(Ljava/io/File;)V", "postReleaseCompileSession", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "", "periodicAndAfterSessionCheck", "periodicSeldomCheck", "initiateElections", "exceptionLoggingTimerThread", "body", "getPerformanceMetrics", "", "Lorg/jetbrains/kotlin/daemon/common/BuildMetricsValue;", "compiler", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "compileImpl", "ServicesFacadeT", "JpsServicesFacadeT", "CompilationResultsT", "sessionId", "compilerArguments", "", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "servicesFacade", "compilationResults", "hasIncrementalCaches", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "createMessageCollector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "createReporter", "Lorg/jetbrains/kotlin/daemon/report/DaemonMessageReporter;", "createServices", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/daemon/EventManager;", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "Lorg/jetbrains/kotlin/config/Services;", "getICReporter", "Lorg/jetbrains/kotlin/daemon/common/IncrementalCompilationOptions;", "Lorg/jetbrains/kotlin/build/report/RemoteBuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimeMetric;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "compilationId", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "maybeWaitForTestStart", "doCompile", "daemonMessageReporter", "tracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "(ILorg/jetbrains/kotlin/daemon/report/DaemonMessageReporter;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;Ljava/lang/Integer;Lkotlin/jvm/functions/Function3;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "ms", "kb", "checkedCompile", "R", "rpcProfiler", "(Lorg/jetbrains/kotlin/daemon/report/DaemonMessageReporter;Lorg/jetbrains/kotlin/daemon/common/Profiler;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "startDaemonElections", "configurePeriodicActivities", "ifAliveChecksImpl", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "withValidClientOrSessionProxy", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$ClientOrSessionProxy;", "", "execJsIncrementalCompiler", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "incrementalCompilationOptions", "compilerMessageCollector", "reporter", "toChangedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles;", "Lorg/jetbrains/kotlin/buildtools/api/SourcesChanges;", "execIncrementalCompiler", "k2jvmArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "compilationCanceledStatus", "withValidReplImpl", "KotlinJvmReplServiceT", "ClientOrSessionProxy", "Aliveness", "SessionsContainer", "CompileServiceState", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase\n+ 2 CompilerRunnerUtils.kt\norg/jetbrains/kotlin/incremental/CompilerRunnerUtils\n+ 3 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 IncrementalJsCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCompilerRunnerKt\n*L\n1#1,1267:1\n474#1,3:1276\n627#1,2:1279\n626#1,6:1281\n477#1,14:1287\n512#1,4:1301\n491#1:1307\n517#1:1312\n519#1,36:1318\n493#1,8:1354\n633#1:1362\n501#1,2:1363\n474#1,3:1366\n627#1,2:1369\n626#1,6:1371\n477#1,14:1377\n512#1,4:1391\n491#1:1397\n517#1:1401\n519#1,36:1407\n493#1,8:1443\n633#1:1451\n501#1,2:1452\n474#1,3:1463\n627#1,2:1466\n626#1,6:1468\n477#1,14:1474\n512#1,4:1488\n491#1:1494\n517#1:1497\n519#1,36:1503\n493#1,8:1539\n633#1:1547\n501#1,2:1548\n474#1,3:1560\n627#1,2:1563\n626#1,6:1565\n477#1,14:1571\n512#1,4:1585\n491#1:1591\n517#1:1594\n519#1,36:1600\n493#1,8:1636\n633#1:1644\n501#1,2:1645\n474#1,3:1648\n627#1,2:1651\n626#1,6:1653\n477#1,14:1659\n512#1,4:1673\n491#1:1677\n517#1:1680\n519#1,36:1686\n493#1,8:1722\n633#1:1730\n501#1,2:1731\n474#1,3:1734\n627#1,2:1737\n626#1,6:1739\n477#1,14:1745\n512#1,4:1759\n491#1:1765\n517#1:1768\n519#1,36:1774\n493#1,8:1810\n633#1:1818\n501#1,2:1819\n474#1,3:1830\n627#1,2:1833\n626#1,6:1835\n477#1,14:1841\n512#1,4:1855\n491#1:1861\n517#1:1864\n519#1,36:1870\n493#1,8:1906\n633#1:1914\n501#1,2:1915\n474#1,3:1918\n627#1,2:1921\n626#1,6:1923\n477#1,14:1929\n512#1,4:1943\n491#1:1949\n517#1:1952\n519#1,36:1958\n493#1,8:1994\n633#1:2002\n501#1,2:2003\n627#1,2:2005\n626#1,6:2007\n512#1,4:2013\n517#1:2021\n519#1,36:2027\n633#1:2063\n627#1,2:2073\n626#1,8:2075\n79#2,8:1268\n88#2:1365\n78#2,9:1454\n88#2:1550\n88#2:1733\n78#2,9:1821\n88#2:1917\n44#3,2:1305\n46#3,2:1310\n90#3,5:1313\n44#3,2:1395\n46#3,2:1399\n90#3,5:1402\n44#3,2:1492\n46#3,2:1495\n90#3,5:1498\n44#3,2:1589\n46#3,2:1592\n90#3,5:1595\n46#3,2:1678\n90#3,5:1681\n44#3,2:1763\n46#3,2:1766\n90#3,5:1769\n44#3,2:1859\n46#3,2:1862\n90#3,5:1865\n44#3,2:1947\n46#3,2:1950\n90#3,5:1953\n44#3,4:2017\n90#3,5:2022\n44#3,4:2064\n90#3,5:2068\n1915#4,2:1308\n1#5:1398\n64#6,9:1551\n74#6:1647\n*S KotlinDebug\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase\n*L\n377#1:1276,3\n377#1:1279,2\n377#1:1281,6\n377#1:1287,14\n377#1:1301,4\n377#1:1307\n377#1:1312\n377#1:1318,36\n377#1:1354,8\n377#1:1362\n377#1:1363,2\n393#1:1366,3\n393#1:1369,2\n393#1:1371,6\n393#1:1377,14\n393#1:1391,4\n393#1:1397\n393#1:1401\n393#1:1407,36\n393#1:1443,8\n393#1:1451\n393#1:1452,2\n417#1:1463,3\n417#1:1466,2\n417#1:1468,6\n417#1:1474,14\n417#1:1488,4\n417#1:1494\n417#1:1497\n417#1:1503,36\n417#1:1539,8\n417#1:1547\n417#1:1548,2\n432#1:1560,3\n432#1:1563,2\n432#1:1565,6\n432#1:1571,14\n432#1:1585,4\n432#1:1591\n432#1:1594\n432#1:1600,36\n432#1:1636,8\n432#1:1644\n432#1:1645,2\n377#1:1648,3\n377#1:1651,2\n377#1:1653,6\n377#1:1659,14\n377#1:1673,4\n377#1:1677\n377#1:1680\n377#1:1686,36\n377#1:1722,8\n377#1:1730\n377#1:1731,2\n393#1:1734,3\n393#1:1737,2\n393#1:1739,6\n393#1:1745,14\n393#1:1759,4\n393#1:1765\n393#1:1768\n393#1:1774,36\n393#1:1810,8\n393#1:1818\n393#1:1819,2\n417#1:1830,3\n417#1:1833,2\n417#1:1835,6\n417#1:1841,14\n417#1:1855,4\n417#1:1861\n417#1:1864\n417#1:1870,36\n417#1:1906,8\n417#1:1914\n417#1:1915,2\n432#1:1918,3\n432#1:1921,2\n432#1:1923,6\n432#1:1929,14\n432#1:1943,4\n432#1:1949\n432#1:1952\n432#1:1958,36\n432#1:1994,8\n432#1:2002\n432#1:2003,2\n476#1:2005,2\n476#1:2007,6\n490#1:2013,4\n490#1:2021\n490#1:2027,36\n476#1:2063\n745#1:2073,2\n745#1:2075,8\n376#1:1268,8\n376#1:1365\n416#1:1454,9\n416#1:1550\n376#1:1733\n416#1:1821,9\n416#1:1917\n377#1:1305,2\n377#1:1310,2\n377#1:1313,5\n393#1:1395,2\n393#1:1399,2\n393#1:1402,5\n417#1:1492,2\n417#1:1495,2\n417#1:1498,5\n432#1:1589,2\n432#1:1592,2\n432#1:1595,5\n377#1:1678,2\n377#1:1681,5\n393#1:1763,2\n393#1:1766,2\n393#1:1769,5\n417#1:1859,2\n417#1:1862,2\n417#1:1865,5\n432#1:1947,2\n432#1:1950,2\n432#1:1953,5\n490#1:2017,4\n490#1:2022,5\n515#1:2064,4\n517#1:2068,5\n383#1:1308,2\n431#1:1551,9\n431#1:1647\n*E\n"})
public abstract class CompileServiceImplBase
implements CompileService {
    @NotNull
    private final DaemonOptions daemonOptions;
    @NotNull
    private final CompilerId compilerId;
    private final int port;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Function0<Unit> onShutdown;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final AtomicInteger compilationsCounter;
    @NotNull
    private final LazyClasspathWatcher classpathWatcher;
    @NotNull
    private final CompileServiceState state;
    private volatile long _lastUsedSeconds;
    @NotNull
    private File runFile;

    public CompileServiceImplBase(@NotNull DaemonOptions daemonOptions, @NotNull CompilerId compilerId, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        Intrinsics.checkNotNullParameter(onShutdown, (String)"onShutdown");
        this.daemonOptions = daemonOptions;
        this.compilerId = compilerId;
        this.port = port;
        this.timer = timer;
        this.onShutdown = onShutdown;
        this.log$delegate = LazyKt.lazy(CompileServiceImplBase::log_delegate$lambda$0);
        CompilerSystemProperties.KOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY.setValue("true");
        this.compilationsCounter = new AtomicInteger(0);
        this.classpathWatcher = new LazyClasspathWatcher(this.compilerId.getCompilerClasspath(), 0L, 0L, 6, null);
        this.state = new CompileServiceState();
        this._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
        File runFileDir = new File(DaemonParamsKt.getRunFilesPathOrDefault(this.daemonOptions));
        runFileDir.mkdirs();
        String string = "%tFT%<tH-%<tM-%<tS.%<tLZ";
        Object[] objectArray = new Object[]{Calendar.getInstance(TimeZone.getTimeZone("Z"))};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        this.runFile = new File(runFileDir, ClientUtilsKt.makeRunFilenameString$default(string2, this.compilerId.digest(), String.valueOf(this.port), null, 8, null));
        try {
            if (!this.runFile.createNewFile()) {
                throw new Exception("createNewFile returned false");
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to create run file '" + this.runFile.getAbsolutePath() + '\'', e);
        }
        this.runFile.deleteOnExit();
    }

    @NotNull
    public final DaemonOptions getDaemonOptions() {
        return this.daemonOptions;
    }

    @NotNull
    public final CompilerId getCompilerId() {
        return this.compilerId;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final Timer getTimer() {
        return this.timer;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    protected final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    protected final AtomicInteger getCompilationsCounter() {
        return this.compilationsCounter;
    }

    @NotNull
    protected final LazyClasspathWatcher getClasspathWatcher() {
        return this.classpathWatcher;
    }

    @NotNull
    protected final CompileServiceState getState() {
        return this.state;
    }

    @NotNull
    protected final String toAlivenessName(int $this$toAlivenessName) {
        String string;
        try {
            string = ((Aliveness)((Object)Aliveness.getEntries().get($this$toAlivenessName))).name();
        }
        catch (Throwable throwable) {
            string = "invalid(" + $this$toAlivenessName + ')';
        }
        return string;
    }

    protected final long get_lastUsedSeconds() {
        return this._lastUsedSeconds;
    }

    protected final void set_lastUsedSeconds(long l) {
        this._lastUsedSeconds = l;
    }

    protected abstract long getLastUsedSeconds();

    @NotNull
    protected final File getRunFile() {
        return this.runFile;
    }

    protected final void setRunFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.runFile = file;
    }

    @NotNull
    protected final CompileService.CallResult postReleaseCompileSession() {
        if (this.state.getSessions().isEmpty()) {
            // empty if block
        }
        Timer timer = this.timer;
        long l = 0L;
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ CompileServiceImplBase this$0;
            {
                this.this$0 = compileServiceImplBase;
            }

            public void run() {
                TimerTask $this$postReleaseCompileSession_u24lambda_u240 = this;
                boolean bl = false;
                this.this$0.periodicAndAfterSessionCheck();
            }
        };
        timer.schedule(timerTask, l);
        return new CompileService.CallResult.Ok();
    }

    protected abstract void periodicAndAfterSessionCheck();

    protected abstract void periodicSeldomCheck();

    protected abstract void initiateElections();

    protected final void exceptionLoggingTimerThread(@NotNull Function0<Unit> body) {
        block2: {
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean $i$f$exceptionLoggingTimerThread = false;
            try {
                body.invoke();
            }
            catch (Throwable e) {
                System.err.println("Exception in timer thread: " + e.getMessage());
                e.printStackTrace(System.err);
                this.getLog().log(Level.SEVERE, "Exception in timer thread", e);
                if (!(e instanceof LinkageError)) break block2;
                this.getOnShutdown().invoke();
            }
        }
    }

    @NotNull
    protected final List<BuildMetricsValue> getPerformanceMetrics(@NotNull CLICompiler<CommonCompilerArguments> compiler) {
        Intrinsics.checkNotNullParameter(compiler, (String)"compiler");
        ArrayList<BuildMetricsValue> performanceMetrics = new ArrayList<BuildMetricsValue>();
        PerformanceManager performanceManager = compiler.getDefaultPerformanceManager();
        UnitStats moduleStats = performanceManager.getUnitStats();
        if (moduleStats.getLinesCount() > 0) {
            performanceMetrics.add(new BuildMetricsValue(CompilationPerformanceMetrics.SOURCE_LINES_NUMBER, moduleStats.getLinesCount()));
        }
        Ref.ObjectRef codegenTime = new Ref.ObjectRef();
        codegenTime.element = Time.Companion.getZERO();
        UnitStatsKt.forEachPhaseMeasurement((UnitStats)moduleStats, (arg_0, arg_1) -> CompileServiceImplBase.getPerformanceMetrics$lambda$0(codegenTime, performanceMetrics, moduleStats, arg_0, arg_1));
        if (!Intrinsics.areEqual((Object)codegenTime.element, (Object)Time.Companion.getZERO())) {
            performanceMetrics.add(new BuildMetricsValue(CompilationPerformanceMetrics.CODE_GENERATION, ((Time)codegenTime.element).getMillis()));
            CompileServiceImplBase.getPerformanceMetrics$reportLps(performanceMetrics, moduleStats, CompilationPerformanceMetrics.CODE_GENERATION_LPS, (Time)codegenTime.element);
        }
        return performanceMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    protected final <ServicesFacadeT, JpsServicesFacadeT, CompilationResultsT> CompileService.CallResult<Integer> compileImpl(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, ServicesFacadeT servicesFacade, CompilationResultsT compilationResults, @NotNull Function1<? super JpsServicesFacadeT, Boolean> hasIncrementalCaches, @NotNull Function2<? super ServicesFacadeT, ? super CompilationOptions, ? extends MessageCollector> createMessageCollector, @NotNull Function2<? super ServicesFacadeT, ? super CompilationOptions, ? extends DaemonMessageReporter> createReporter, @NotNull Function3<? super JpsServicesFacadeT, ? super EventManager, ? super Profiler, Services> createServices, @NotNull Function3<? super ServicesFacadeT, ? super CompilationResultsT, ? super IncrementalCompilationOptions, RemoteBuildReporter<BuildTimeMetric, BuildPerformanceMetric>> getICReporter, @Nullable Integer compilationId) {
        block113: {
            block112: {
                Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
                Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
                Intrinsics.checkNotNullParameter(hasIncrementalCaches, (String)"hasIncrementalCaches");
                Intrinsics.checkNotNullParameter(createMessageCollector, (String)"createMessageCollector");
                Intrinsics.checkNotNullParameter(createReporter, (String)"createReporter");
                Intrinsics.checkNotNullParameter(createServices, (String)"createServices");
                Intrinsics.checkNotNullParameter(getICReporter, (String)"getICReporter");
                $i$f$compileImpl = false;
                $i$a$-run-CompileServiceImplBase$compileImpl$1 = false;
                this.maybeWaitForTestStart();
                messageCollector = (MessageCollector)createMessageCollector.invoke(servicesFacade, (Object)compilationOptions);
                daemonReporter = (DaemonMessageReporter)createReporter.invoke(servicesFacade, (Object)compilationOptions);
                targetPlatform = compilationOptions.getTargetPlatform();
                CompileServiceImplBase.access$getLog(this).info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])compilerArguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                var17_17 = targetPlatform;
                var18_18 = WhenMappings.$EnumSwitchMapping$1[var17_17.ordinal()];
                switch (var18_18) {
                    case 1: {
                        v0 = (CLICompiler)new K2JVMCompiler();
                        break;
                    }
                    case 2: {
                        v0 = (CLICompiler)new K2JSCompiler();
                        break;
                    }
                    case 3: {
                        v0 = (CLICompiler)new KotlinMetadataCompiler();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                compiler = var19_20 = v0;
                k2PlatformArgs = compiler.createArguments();
                ParseCommandLineArgumentsKt.parseCommandLineArguments$default((List)ArraysKt.asList((Object[])compilerArguments), (CommonToolArguments)((CommonToolArguments)k2PlatformArgs), (boolean)false, (int)4, null);
                argumentParseError = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)k2PlatformArgs.getErrors());
                if (argumentParseError == null) break block112;
                MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)argumentParseError, null, (int)4, null);
                v1 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                break block113;
            }
            var18_19 = compilationOptions.getCompilerMode();
            var21_22 = WhenMappings.$EnumSwitchMapping$2[var18_19.ordinal()];
            block20 : switch (var21_22) {
                case 1: {
                    var22_23 = k2PlatformArgs;
                    enabled$iv = (Boolean)hasIncrementalCaches.invoke(servicesFacade);
                    $i$f$withIncrementalCompilation = false;
                    isEnabledBackup$iv = IncrementalCompilation.isEnabledForJvm();
                    IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv);
                    try {
                        if (args$iv.getIncrementalCompilation() == null) {
                            args$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv));
                        }
                        $i$a$-withIncrementalCompilation-CompileServiceImplBase$compileImpl$1$1 = false;
                        var27_39 = this;
                        var28_43 = sessionId;
                        var29_47 = daemonReporter;
                        var30_51 = null;
                        compilationId$iv = compilationId;
                        $i$f$doCompile = false;
                        $this$doCompile_u24lambda_u240$iv = (CompileServiceImplBase)this_$iv;
                        $i$a$-run-CompileServiceImplBase$doCompile$1$iv = false;
                        CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("alive!");
                        var35_71 = $this$doCompile_u24lambda_u240$iv;
                        sessionId$iv$iv = sessionId$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId$iv$iv != false) ** GOTO lbl68
                        v2 = null;
                        ** GOTO lbl72
lbl68:
                        // 1 sources

                        v2 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getSessions().get((int)sessionId$iv$iv);
                        if (v2 != null) ** GOTO lbl72
                        v3 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv);
                        ** GOTO lbl226
lbl72:
                        // 2 sources

                        session$iv$iv = v2;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv).incrementAndGet();
                            session$iv = session$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv = false;
                            v4 = compilationId$iv;
                            if (v4 != null) {
                                compilationId$iv = ((Number)v4).intValue();
                                $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv = false;
                                v5 = session$iv;
                                var43_111 = v5 != null ? v5.getData() : null;
                                v6 = var43_111 instanceof RunningCompilations != false ? (RunningCompilations)var43_111 : null;
                                if (v6 != null) {
                                    runningCompilations$iv = var43_111 = v6;
                                    $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = false;
                                    runningCompilations$iv.add(compilationId$iv);
                                    v7 = var43_111;
                                } else {
                                    v7 = null;
                                }
                            } else {
                                v7 = null;
                            }
                            v8 = runningCompilations$iv = v7;
                            compilationCanceledStatus$iv = v8 != null ? v8.getCompilationCanceledStatus(compilationId$iv) : null;
                            rpcProfiler$iv = $this$doCompile_u24lambda_u240$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                            eventManager$iv = new EventManagerImpl();
                            try {
                                CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("trying get exitCode");
                                runningCompilations$iv = $this$doCompile_u24lambda_u240$iv;
                                $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = daemonMessageReporter$iv;
                                rpcProfiler$iv$iv = rpcProfiler$iv;
                                $i$f$checkedCompile = false;
                                try {
                                    var51_158 = profiler$iv$iv = this_$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                    obj$iv$iv$iv = null;
                                    $i$f$withMeasure = false;
                                    startState$iv$iv$iv = $this$withMeasure$iv$iv$iv.beginMeasure(obj$iv$iv$iv);
                                    $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = false;
                                    var56_181 = rpcProfiler$iv;
                                    eventManger = eventManager$iv;
                                    $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1 = false;
                                    services = (Services)createServices.invoke(servicesFacade, (Object)eventManger, (Object)profiler);
                                    exitCode = compiler.exec(messageCollector, services, k2PlatformArgs);
                                    it = var61_207 = compilationResults;
                                    $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1 = false;
                                    Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                    compilationResult = (CompilationResults)it;
                                    $this$forEach$iv = CompileServiceImplBase.access$getPerformanceMetrics(this, compiler);
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        it = (BuildMetricsValue)element$iv;
                                        $i$a$-forEach-CompileServiceImplBase$compileImpl$1$1$1$1$1 = false;
                                        compilationResult.add(CompilationResultCategory.BUILD_METRICS.getCode(), it);
                                    }
                                    res$iv$iv$iv = exitCode.getCode();
                                    $this$withMeasure$iv$iv$iv.endMeasure(obj$iv$iv$iv, startState$iv$iv$iv);
                                    res$iv$iv = res$iv$iv$iv;
                                    if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                        withGC$iv$iv$iv = false;
                                        $i$f$usedMemory = false;
                                        rt$iv$iv$iv = Runtime.getRuntime();
                                        v9 = rt$iv$iv$iv.totalMemory() - rt$iv$iv$iv.freeMemory();
                                    } else {
                                        v9 = 0L;
                                    }
                                    endMem$iv$iv = v9;
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info("Done with result " + res$iv$iv);
                                    if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                        pc$iv$iv = profiler$iv$iv.getTotalCounters();
                                        rpc$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                        v10 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv.ms(pc$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv.ms(pc$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv.ms(pc$iv$iv.getThreadTime() - pc$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv.ms(rpc$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv.ms(rpc$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv.kb(endMem$iv$iv)).append(" kb (");
                                        rt$iv$iv$iv = "%+d";
                                        var75_257 = new Object[]{this_$iv$iv.kb(pc$iv$iv.getMemory())};
                                        v11 = String.format((String)rt$iv$iv$iv, Arrays.copyOf(var75_257, ((Object[])var75_257).length));
                                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"format(...)");
                                        it$iv$iv = v10.append(v11).append(" kb)").toString();
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv = false;
                                        daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(it$iv$iv);
                                        for (Object var75_257 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                            obj$iv$iv = var75_257.getKey();
                                            counters$iv$iv = (PerfCounters)var75_257.getValue();
                                            it$iv$iv = "PERF: rpc by " + obj$iv$iv + ": " + counters$iv$iv.getCount() + " calls, " + this_$iv$iv.ms(counters$iv$iv.getTime()) + " ms, thread " + this_$iv$iv.ms(counters$iv$iv.getThreadTime()) + " ms";
                                            $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv = false;
                                            daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(it$iv$iv);
                                        }
                                    }
                                    v12 = res$iv$iv;
                                }
                                catch (Throwable e$iv$iv) {
                                    v13 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv);
                                    v14 = new StringBuilder().append("Exception: ").append(e$iv$iv).append("\n  ");
                                    v15 = e$iv$iv.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"getStackTrace(...)");
                                    v16 = v14.append(ArraysKt.joinToString$default((Object[])v15, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                    if (e$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv.getCause(), (Object)e$iv$iv)) {
                                        v17 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv.getCause()).append("\n  ");
                                        v18 = e$iv$iv.getCause();
                                        Intrinsics.checkNotNull((Object)v18);
                                        v19 = v18.getStackTrace();
                                        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"getStackTrace(...)");
                                        v20 = v17.append(ArraysKt.joinToString$default((Object[])v19, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                    } else {
                                        v20 = "";
                                    }
                                    v13.log(Level.SEVERE, v16.append(v20).toString());
                                    throw e$iv$iv;
                                }
                                exitCode$iv = ((Number)v12).intValue();
                                exitCode$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv);
                            }
                            catch (Throwable this_$iv$iv) {
                                InlineMarker.finallyStart((int)1);
                                v21 = runningCompilations$iv;
                                if (v21 != null) {
                                    v21.remove(compilationId$iv);
                                    v22 = Unit.INSTANCE;
                                } else {
                                    v22 = null;
                                }
                                ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                eventManager$iv.fireCompilationFinished();
                                InlineMarker.finallyEnd((int)1);
                                throw this_$iv$iv;
                            }
                            InlineMarker.finallyStart((int)1);
                            v23 = runningCompilations$iv;
                            if (v23 != null) {
                                v23.remove(compilationId$iv);
                                v24 = Unit.INSTANCE;
                            } else {
                                v24 = null;
                            }
                            ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                            eventManager$iv.fireCompilationFinished();
                            InlineMarker.finallyEnd((int)1);
                            var80_263 = exitCode$iv;
                            v3 = var80_263;
                        }
                        finally {
                            InlineMarker.finallyStart((int)1);
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv, CompileServiceImplKt.nowSeconds());
                            InlineMarker.finallyEnd((int)1);
                        }
lbl226:
                        // 2 sources

                        var82_265 = v3;
                        v1 = var82_265;
                        break;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv);
                        InlineMarker.finallyEnd((int)1);
                    }
                }
                case 2: {
                    args$iv = this;
                    enabled$iv = sessionId;
                    $i$f$withIncrementalCompilation = daemonReporter;
                    isEnabledBackup$iv = null;
                    compilationId$iv = compilationId;
                    $i$f$doCompile = false;
                    $this$doCompile_u24lambda_u240$iv = (CompileServiceImplBase)this_$iv;
                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv = false;
                    CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("alive!");
                    tracer$iv = $this$doCompile_u24lambda_u240$iv;
                    sessionId$iv$iv = sessionId$iv;
                    $i$f$withValidClientOrSessionProxy = false;
                    if (sessionId$iv$iv == false) {
                        v25 = null;
                    } else {
                        v25 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getSessions().get((int)sessionId$iv$iv);
                        if (v25 == null) {
                            v1 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv);
                            break;
                        }
                    }
                    session$iv$iv = v25;
                    try {
                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv).incrementAndGet();
                        session$iv = session$iv$iv;
                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv = false;
                        v26 = compilationId$iv;
                        if (v26 != null) {
                            compilationId$iv = ((Number)v26).intValue();
                            $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv = false;
                            v27 = session$iv;
                            session$iv$iv = v27 != null ? v27.getData() : null;
                            v28 = session$iv$iv instanceof RunningCompilations != false ? (RunningCompilations)session$iv$iv : null;
                            if (v28 != null) {
                                runningCompilations$iv = session$iv$iv = v28;
                                $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = false;
                                runningCompilations$iv.add(compilationId$iv);
                                v29 = session$iv$iv;
                            } else {
                                v29 = null;
                            }
                        } else {
                            v29 = null;
                        }
                        v30 = runningCompilations$iv = v29;
                        compilationCanceledStatus$iv = v30 != null ? v30.getCompilationCanceledStatus(compilationId$iv) : null;
                        rpcProfiler$iv = $this$doCompile_u24lambda_u240$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                        eventManager$iv = new EventManagerImpl();
                        try {
                            CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("trying get exitCode");
                            runningCompilations$iv = $this$doCompile_u24lambda_u240$iv;
                            $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = daemonMessageReporter$iv;
                            rpcProfiler$iv$iv = rpcProfiler$iv;
                            $i$f$checkedCompile = false;
                            try {
                                runningCompilations$iv = profiler$iv$iv = this_$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                obj$iv$iv$iv = null;
                                $i$f$withMeasure = false;
                                startState$iv$iv$iv = $this$withMeasure$iv$iv$iv.beginMeasure(obj$iv$iv$iv);
                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = false;
                                $this$withMeasure$iv$iv$iv = compilationCanceledStatus$iv;
                                obj$iv$iv$iv = rpcProfiler$iv;
                                pc$iv$iv = eventManager$iv;
                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2 = false;
                                v31 = compiler;
                                v32 = messageCollector;
                                v33 = compilationCanceled;
                                if (v33 == null) ** GOTO lbl317
                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = v33;
                                profiler = v32;
                                eventManger = v31;
                                $i$a$-let-CompileServiceImplBase$compileImpl$1$2$exitCode$1 = false;
                                services = new Services.Builder().register(CompilationCanceledStatus.class, (Object)it).build();
                                v31 = eventManger;
                                v32 = profiler;
                                v34 = services;
                                v33 = v34;
                                if (v34 != null) ** GOTO lbl318
lbl317:
                                // 2 sources

                                v33 = Services.EMPTY;
lbl318:
                                // 2 sources

                                exitCode = v31.exec(v32, v33, k2PlatformArgs);
                                perfString = compiler.getDefaultPerformanceManager().createPerformanceReport(PerformanceManager.DumpFormat.PlainText);
                                v35 = compilationResults;
                                if (v35 != null) {
                                    it = it = v35;
                                    $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1 = false;
                                    $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1 = new String[]{perfString};
                                    ((CompilationResults)it).add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), CollectionsKt.arrayListOf((Object[])$i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1));
                                    v36 = it;
                                } else {
                                    v36 = null;
                                }
                                res$iv$iv$iv = exitCode.getCode();
                                $this$withMeasure$iv$iv$iv.endMeasure(obj$iv$iv$iv, startState$iv$iv$iv);
                                res$iv$iv = res$iv$iv$iv;
                                if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                    withGC$iv$iv$iv = false;
                                    $i$f$usedMemory = false;
                                    rt$iv$iv$iv = Runtime.getRuntime();
                                    v37 = rt$iv$iv$iv.totalMemory() - rt$iv$iv$iv.freeMemory();
                                } else {
                                    v37 = 0L;
                                }
                                endMem$iv$iv = v37;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info("Done with result " + res$iv$iv);
                                if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                    pc$iv$iv = profiler$iv$iv.getTotalCounters();
                                    rpc$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                    v38 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv.ms(pc$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv.ms(pc$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv.ms(pc$iv$iv.getThreadTime() - pc$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv.ms(rpc$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv.ms(rpc$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv.kb(endMem$iv$iv)).append(" kb (");
                                    var64_221 = "%+d";
                                    element$iv = new Object[]{this_$iv$iv.kb(pc$iv$iv.getMemory())};
                                    v39 = String.format(var64_221, Arrays.copyOf(element$iv, element$iv.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)v39, (String)"format(...)");
                                    it$iv$iv = v38.append(v39).append(" kb)").toString();
                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv = false;
                                    daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, (String)it$iv$iv);
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info((String)it$iv$iv);
                                    for (Object it$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                        obj$iv$iv = it$iv$iv.getKey();
                                        counters$iv$iv = (PerfCounters)it$iv$iv.getValue();
                                        it$iv$iv = "PERF: rpc by " + obj$iv$iv + ": " + counters$iv$iv.getCount() + " calls, " + this_$iv$iv.ms(counters$iv$iv.getTime()) + " ms, thread " + this_$iv$iv.ms(counters$iv$iv.getThreadTime()) + " ms";
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv = false;
                                        daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(it$iv$iv);
                                    }
                                }
                                v40 = res$iv$iv;
                            }
                            catch (Throwable e$iv$iv) {
                                v41 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv);
                                v42 = new StringBuilder().append("Exception: ").append(e$iv$iv).append("\n  ");
                                v43 = e$iv$iv.getStackTrace();
                                Intrinsics.checkNotNullExpressionValue((Object)v43, (String)"getStackTrace(...)");
                                v44 = v42.append(ArraysKt.joinToString$default((Object[])v43, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                if (e$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv.getCause(), (Object)e$iv$iv)) {
                                    v45 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv.getCause()).append("\n  ");
                                    v46 = e$iv$iv.getCause();
                                    Intrinsics.checkNotNull((Object)v46);
                                    v47 = v46.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)v47, (String)"getStackTrace(...)");
                                    v48 = v45.append(ArraysKt.joinToString$default((Object[])v47, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                } else {
                                    v48 = "";
                                }
                                v41.log(Level.SEVERE, v44.append(v48).toString());
                                throw e$iv$iv;
                            }
                            exitCode$iv = ((Number)v40).intValue();
                            exitCode$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv);
                        }
                        catch (Throwable this_$iv$iv) {
                            InlineMarker.finallyStart((int)1);
                            v49 = runningCompilations$iv;
                            if (v49 != null) {
                                v49.remove(compilationId$iv);
                                v50 = Unit.INSTANCE;
                            } else {
                                v50 = null;
                            }
                            ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                            eventManager$iv.fireCompilationFinished();
                            InlineMarker.finallyEnd((int)1);
                            throw this_$iv$iv;
                        }
                        InlineMarker.finallyStart((int)1);
                        v51 = runningCompilations$iv;
                        if (v51 != null) {
                            v51.remove(compilationId$iv);
                            v52 = Unit.INSTANCE;
                        } else {
                            v52 = null;
                        }
                        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                        eventManager$iv.fireCompilationFinished();
                        InlineMarker.finallyEnd((int)1);
                        var86_268 = exitCode$iv;
                        v1 = var86_268;
                        break;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv, CompileServiceImplKt.nowSeconds());
                        InlineMarker.finallyEnd((int)1);
                    }
                }
                case 3: {
                    gradleIncrementalArgs = (IncrementalCompilationOptions)compilationOptions;
                    gradleIncrementalServicesFacade = servicesFacade;
                    var24_31 = targetPlatform;
                    var25_34 = WhenMappings.$EnumSwitchMapping$1[var24_31.ordinal()];
                    switch (var25_34) {
                        case 1: {
                            args$iv = k2PlatformArgs;
                            enabled$iv = true;
                            $i$f$withIncrementalCompilation = false;
                            isEnabledBackup$iv = IncrementalCompilation.isEnabledForJvm();
                            IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv);
                            try {
                                if (args$iv.getIncrementalCompilation() == null) {
                                    args$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv));
                                }
                                $i$a$-withIncrementalCompilation$default-CompileServiceImplBase$compileImpl$1$3 = false;
                                sessionId$iv$iv = this;
                                $i$f$withValidClientOrSessionProxy = sessionId;
                                session$iv$iv = daemonReporter;
                                session$iv = null;
                                compilationId$iv = compilationId;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u240$iv = (CompileServiceImplBase)this_$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv = false;
                                CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("alive!");
                                this_$iv$iv = $this$doCompile_u24lambda_u240$iv;
                                sessionId$iv$iv = sessionId$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv != false) ** GOTO lbl453
                                v53 = null;
                                ** GOTO lbl457
lbl453:
                                // 1 sources

                                v53 = CompileServiceImplBase.access$getState(this_$iv$iv).getSessions().get((int)sessionId$iv$iv);
                                if (v53 != null) ** GOTO lbl457
                                v54 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv);
                                ** GOTO lbl602
lbl457:
                                // 2 sources

                                session$iv$iv = v53;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv).incrementAndGet();
                                    session$iv = session$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv = false;
                                    v55 = compilationId$iv;
                                    if (v55 != null) {
                                        compilationId$iv = ((Number)v55).intValue();
                                        $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv = false;
                                        v56 = session$iv;
                                        obj$iv$iv$iv = v56 != null ? v56.getData() : null;
                                        v57 = obj$iv$iv$iv instanceof RunningCompilations != false ? (RunningCompilations)obj$iv$iv$iv : null;
                                        if (v57 != null) {
                                            runningCompilations$iv = obj$iv$iv$iv = v57;
                                            $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = false;
                                            runningCompilations$iv.add(compilationId$iv);
                                            v58 = obj$iv$iv$iv;
                                        } else {
                                            v58 = null;
                                        }
                                    } else {
                                        v58 = null;
                                    }
                                    v59 = runningCompilations$iv = v58;
                                    compilationCanceledStatus$iv = v59 != null ? v59.getCompilationCanceledStatus(compilationId$iv) : null;
                                    rpcProfiler$iv = $this$doCompile_u24lambda_u240$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("trying get exitCode");
                                        runningCompilations$iv = $this$doCompile_u24lambda_u240$iv;
                                        $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = daemonMessageReporter$iv;
                                        rpcProfiler$iv$iv = rpcProfiler$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            it = profiler$iv$iv = this_$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv = $this$withMeasure$iv$iv$iv.beginMeasure(obj$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = false;
                                            exitCode = compilationCanceledStatus$iv;
                                            (EventManager)eventManager$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1 = false;
                                            Intrinsics.checkNotNull((Object)k2PlatformArgs, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments");
                                            v60 = (K2JVMCompilerArguments)k2PlatformArgs;
                                            v61 = compilationResults;
                                            Intrinsics.checkNotNull(v61);
                                            res$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler(this, v60, gradleIncrementalArgs, messageCollector, (RemoteBuildReporter)getICReporter.invoke(gradleIncrementalServicesFacade, v61, (Object)gradleIncrementalArgs), (CompilationCanceledStatus)compilationCanceled).getCode();
                                            $this$withMeasure$iv$iv$iv.endMeasure(obj$iv$iv$iv, startState$iv$iv$iv);
                                            res$iv$iv = res$iv$iv$iv;
                                            if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv = Runtime.getRuntime();
                                                v62 = rt$iv$iv$iv.totalMemory() - rt$iv$iv$iv.freeMemory();
                                            } else {
                                                v62 = 0L;
                                            }
                                            endMem$iv$iv = v62;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info("Done with result " + res$iv$iv);
                                            if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv = profiler$iv$iv.getTotalCounters();
                                                rpc$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v63 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv.ms(pc$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv.ms(pc$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv.ms(pc$iv$iv.getThreadTime() - pc$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv.ms(rpc$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv.ms(rpc$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv.kb(endMem$iv$iv)).append(" kb (");
                                                rt$iv$iv$iv = "%+d";
                                                $i$f$forEach = new Object[]{this_$iv$iv.kb(pc$iv$iv.getMemory())};
                                                v64 = String.format((String)rt$iv$iv$iv, Arrays.copyOf($i$f$forEach, $i$f$forEach.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v64, (String)"format(...)");
                                                it$iv$iv = v63.append(v64).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv = false;
                                                daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, (String)it$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info((String)it$iv$iv);
                                                for (Object it$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv = it$iv$iv.getKey();
                                                    counters$iv$iv = (PerfCounters)it$iv$iv.getValue();
                                                    it$iv$iv = "PERF: rpc by " + obj$iv$iv + ": " + counters$iv$iv.getCount() + " calls, " + this_$iv$iv.ms(counters$iv$iv.getTime()) + " ms, thread " + this_$iv$iv.ms(counters$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv = false;
                                                    daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(it$iv$iv);
                                                }
                                            }
                                            v65 = res$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv) {
                                            v66 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv);
                                            v67 = new StringBuilder().append("Exception: ").append(e$iv$iv).append("\n  ");
                                            v68 = e$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v68, (String)"getStackTrace(...)");
                                            v69 = v67.append(ArraysKt.joinToString$default((Object[])v68, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv.getCause(), (Object)e$iv$iv)) {
                                                v70 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv.getCause()).append("\n  ");
                                                v71 = e$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v71);
                                                v72 = v71.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v72, (String)"getStackTrace(...)");
                                                v73 = v70.append(ArraysKt.joinToString$default((Object[])v72, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v73 = "";
                                            }
                                            v66.log(Level.SEVERE, v69.append(v73).toString());
                                            throw e$iv$iv;
                                        }
                                        exitCode$iv = ((Number)v65).intValue();
                                        exitCode$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv);
                                    }
                                    catch (Throwable this_$iv$iv) {
                                        InlineMarker.finallyStart((int)1);
                                        v74 = runningCompilations$iv;
                                        if (v74 != null) {
                                            v74.remove(compilationId$iv);
                                            v75 = Unit.INSTANCE;
                                        } else {
                                            v75 = null;
                                        }
                                        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                        eventManager$iv.fireCompilationFinished();
                                        InlineMarker.finallyEnd((int)1);
                                        throw this_$iv$iv;
                                    }
                                    InlineMarker.finallyStart((int)1);
                                    v76 = runningCompilations$iv;
                                    if (v76 != null) {
                                        v76.remove(compilationId$iv);
                                        v77 = Unit.INSTANCE;
                                    } else {
                                        v77 = null;
                                    }
                                    ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                    eventManager$iv.fireCompilationFinished();
                                    InlineMarker.finallyEnd((int)1);
                                    var71_249 = exitCode$iv;
                                    v54 = var71_249;
                                }
                                finally {
                                    InlineMarker.finallyStart((int)1);
                                    CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv, CompileServiceImplKt.nowSeconds());
                                    InlineMarker.finallyEnd((int)1);
                                }
lbl602:
                                // 2 sources

                                var86_269 = v54;
                                v1 = var86_269;
                                break block20;
                            }
                            finally {
                                InlineMarker.finallyStart((int)1);
                                IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv);
                                InlineMarker.finallyEnd((int)1);
                            }
                        }
                        case 2: {
                            args$iv = k2PlatformArgs;
                            enabled$iv = true;
                            $i$f$withJsIC = false;
                            isJsEnabledBackup$iv = IncrementalCompilation.isEnabledForJs();
                            IncrementalCompilation.setIsEnabledForJs((boolean)true);
                            try {
                                if (args$iv.getIncrementalCompilation() == null) {
                                    args$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv));
                                }
                                $i$a$-withJsIC$default-CompileServiceImplBase$compileImpl$1$4 = false;
                                this_$iv = this;
                                sessionId$iv = sessionId;
                                daemonMessageReporter$iv = daemonReporter;
                                tracer$iv = null;
                                compilationId$iv = null;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u240$iv = this_$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv = false;
                                CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("alive!");
                                this_$iv$iv = $this$doCompile_u24lambda_u240$iv;
                                sessionId$iv$iv = sessionId$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv != 0) ** GOTO lbl636
                                v78 = null;
                                ** GOTO lbl640
lbl636:
                                // 1 sources

                                v78 = CompileServiceImplBase.access$getState(this_$iv$iv).getSessions().get(sessionId$iv$iv);
                                if (v78 != null) ** GOTO lbl640
                                v79 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv);
                                ** GOTO lbl751
lbl640:
                                // 2 sources

                                session$iv$iv = v78;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv).incrementAndGet();
                                    session$iv = session$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv = false;
                                    runningCompilations$iv = null;
                                    compilationCanceledStatus$iv = null;
                                    rpcProfiler$iv = $this$doCompile_u24lambda_u240$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("trying get exitCode");
                                        this_$iv$iv = $this$doCompile_u24lambda_u240$iv;
                                        daemonMessageReporter$iv$iv = daemonMessageReporter$iv;
                                        rpcProfiler$iv$iv = rpcProfiler$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            $this$withMeasure$iv$iv$iv = profiler$iv$iv = this_$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv = $this$withMeasure$iv$iv$iv.beginMeasure(obj$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = false;
                                            (EventManager)eventManager$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1 = false;
                                            Intrinsics.checkNotNull((Object)k2PlatformArgs, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments");
                                            v80 = (K2JSCompilerArguments)k2PlatformArgs;
                                            v81 = compilationResults;
                                            Intrinsics.checkNotNull(v81);
                                            res$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler(this, v80, gradleIncrementalArgs, messageCollector, (RemoteBuildReporter)getICReporter.invoke(gradleIncrementalServicesFacade, v81, (Object)gradleIncrementalArgs)).getCode();
                                            $this$withMeasure$iv$iv$iv.endMeasure(obj$iv$iv$iv, startState$iv$iv$iv);
                                            res$iv$iv = res$iv$iv$iv;
                                            if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv = Runtime.getRuntime();
                                                v82 = rt$iv$iv$iv.totalMemory() - rt$iv$iv$iv.freeMemory();
                                            } else {
                                                v82 = 0L;
                                            }
                                            endMem$iv$iv = v82;
                                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Done with result " + res$iv$iv);
                                            if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv = profiler$iv$iv.getTotalCounters();
                                                rpc$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v83 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv.ms(pc$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv.ms(pc$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv.ms(pc$iv$iv.getThreadTime() - pc$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv.ms(rpc$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv.ms(rpc$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv.kb(endMem$iv$iv)).append(" kb (");
                                                var61_210 = "%+d";
                                                e$iv$iv = new Object[]{this_$iv$iv.kb(pc$iv$iv.getMemory())};
                                                v84 = String.format(var61_210, Arrays.copyOf(e$iv$iv, e$iv$iv.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v84, (String)"format(...)");
                                                it$iv$iv = v83.append(v84).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv = false;
                                                daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                                CompileServiceImplBase.access$getLog(this_$iv$iv).info(it$iv$iv);
                                                for (Map.Entry var65_225 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv = var65_225.getKey();
                                                    counters$iv$iv = (PerfCounters)var65_225.getValue();
                                                    it$iv$iv = "PERF: rpc by " + obj$iv$iv + ": " + counters$iv$iv.getCount() + " calls, " + this_$iv$iv.ms(counters$iv$iv.getTime()) + " ms, thread " + this_$iv$iv.ms(counters$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv = false;
                                                    daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(it$iv$iv);
                                                }
                                            }
                                            v85 = res$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv) {
                                            v86 = CompileServiceImplBase.access$getLog(this_$iv$iv);
                                            v87 = new StringBuilder().append("Exception: ").append(e$iv$iv).append("\n  ");
                                            v88 = e$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v88, (String)"getStackTrace(...)");
                                            v89 = v87.append(ArraysKt.joinToString$default((Object[])v88, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv.getCause(), (Object)e$iv$iv)) {
                                                v90 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv.getCause()).append("\n  ");
                                                v91 = e$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v91);
                                                v92 = v91.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v92, (String)"getStackTrace(...)");
                                                v93 = v90.append(ArraysKt.joinToString$default((Object[])v92, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v93 = "";
                                            }
                                            v86.log(Level.SEVERE, v89.append(v93).toString());
                                            throw e$iv$iv;
                                        }
                                        exitCode$iv = ((Number)v85).intValue();
                                        var47_139 = new CompileService.CallResult.Good<Integer>(exitCode$iv);
                                    }
                                    finally {
                                        InlineMarker.finallyStart((int)1);
                                        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                        eventManager$iv.fireCompilationFinished();
                                        InlineMarker.finallyEnd((int)1);
                                    }
                                    var70_246 = var47_139;
                                    v79 = var70_246;
                                }
                                finally {
                                    InlineMarker.finallyStart((int)1);
                                    CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv, CompileServiceImplKt.nowSeconds());
                                    InlineMarker.finallyEnd((int)1);
                                }
lbl751:
                                // 2 sources

                                var72_255 = v79;
                                v1 = var72_255;
                                break block20;
                            }
                            finally {
                                InlineMarker.finallyStart((int)1);
                                IncrementalCompilation.setIsEnabledForJs((boolean)isJsEnabledBackup$iv);
                                InlineMarker.finallyEnd((int)1);
                            }
                        }
                    }
                    throw new IllegalStateException("Incremental compilation is not supported for target platform: " + targetPlatform);
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return v1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static /* synthetic */ CompileService.CallResult compileImpl$default(CompileServiceImplBase $this, int sessionId, String[] compilerArguments, CompilationOptions compilationOptions, Object servicesFacade, Object compilationResults, Function1 hasIncrementalCaches, Function2 createMessageCollector, Function2 createReporter, Function3 createServices, Function3 getICReporter, Integer compilationId, int var12_12, Object var13_13) {
        block115: {
            block114: {
                if (var13_13 != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: compileImpl");
                }
                if ((var12_12 & 1024) != 0) {
                    compilationId = null;
                }
                Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
                Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
                Intrinsics.checkNotNullParameter((Object)hasIncrementalCaches, (String)"hasIncrementalCaches");
                Intrinsics.checkNotNullParameter((Object)createMessageCollector, (String)"createMessageCollector");
                Intrinsics.checkNotNullParameter((Object)createReporter, (String)"createReporter");
                Intrinsics.checkNotNullParameter((Object)createServices, (String)"createServices");
                Intrinsics.checkNotNullParameter((Object)getICReporter, (String)"getICReporter");
                $i$f$compileImpl = false;
                $i$a$-run-CompileServiceImplBase$compileImpl$1 = false;
                $this.maybeWaitForTestStart();
                messageCollector = (MessageCollector)createMessageCollector.invoke(servicesFacade, (Object)compilationOptions);
                daemonReporter = (DaemonMessageReporter)createReporter.invoke(servicesFacade, (Object)compilationOptions);
                targetPlatform = compilationOptions.getTargetPlatform();
                CompileServiceImplBase.access$getLog($this).info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])compilerArguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                var17_18 = targetPlatform;
                var18_19 = WhenMappings.$EnumSwitchMapping$1[var17_18.ordinal()];
                switch (var18_19) {
                    case 1: {
                        v0 = (CLICompiler)new K2JVMCompiler();
                        break;
                    }
                    case 2: {
                        v0 = (CLICompiler)new K2JSCompiler();
                        break;
                    }
                    case 3: {
                        v0 = (CLICompiler)new KotlinMetadataCompiler();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                compiler = var19_21 = v0;
                k2PlatformArgs = compiler.createArguments();
                ParseCommandLineArgumentsKt.parseCommandLineArguments$default((List)ArraysKt.asList((Object[])compilerArguments), (CommonToolArguments)((CommonToolArguments)k2PlatformArgs), (boolean)false, (int)4, null);
                argumentParseError = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)k2PlatformArgs.getErrors());
                if (argumentParseError == null) break block114;
                MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)argumentParseError, null, (int)4, null);
                v1 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                break block115;
            }
            var18_20 = compilationOptions.getCompilerMode();
            var21_23 = WhenMappings.$EnumSwitchMapping$2[var18_20.ordinal()];
            block20 : switch (var21_23) {
                case 1: {
                    var22_24 = k2PlatformArgs;
                    enabled$iv = (Boolean)hasIncrementalCaches.invoke(servicesFacade);
                    $i$f$withIncrementalCompilation = false;
                    isEnabledBackup$iv = IncrementalCompilation.isEnabledForJvm();
                    IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv);
                    try {
                        if (args$iv.getIncrementalCompilation() == null) {
                            args$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv));
                        }
                        $i$a$-withIncrementalCompilation-CompileServiceImplBase$compileImpl$1$1 = false;
                        var27_40 = $this;
                        var28_44 = sessionId;
                        var29_48 = daemonReporter;
                        var30_52 = null;
                        compilationId$iv = compilationId;
                        $i$f$doCompile = false;
                        $this$doCompile_u24lambda_u240$iv = this_$iv;
                        $i$a$-run-CompileServiceImplBase$doCompile$1$iv = false;
                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv).fine("alive!");
                        var35_72 = $this$doCompile_u24lambda_u240$iv;
                        sessionId$iv$iv = sessionId$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId$iv$iv != false) ** GOTO lbl72
                        v2 = null;
                        ** GOTO lbl76
lbl72:
                        // 1 sources

                        v2 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getSessions().get((int)sessionId$iv$iv);
                        if (v2 != null) ** GOTO lbl76
                        v3 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv);
                        ** GOTO lbl230
lbl76:
                        // 2 sources

                        session$iv$iv = v2;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv).incrementAndGet();
                            session$iv = session$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv = false;
                            v4 = compilationId$iv;
                            if (v4 != null) {
                                compilationId$iv = ((Number)v4).intValue();
                                $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv = false;
                                v5 = session$iv;
                                var43_112 = v5 != null ? v5.getData() : null;
                                v6 = var43_112 instanceof RunningCompilations != false ? (RunningCompilations)var43_112 : null;
                                if (v6 != null) {
                                    runningCompilations$iv = var43_112 = v6;
                                    $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = false;
                                    runningCompilations$iv.add(compilationId$iv);
                                    v7 = var43_112;
                                } else {
                                    v7 = null;
                                }
                            } else {
                                v7 = null;
                            }
                            v8 = runningCompilations$iv = v7;
                            compilationCanceledStatus$iv = v8 != null ? v8.getCompilationCanceledStatus(compilationId$iv) : null;
                            rpcProfiler$iv = $this$doCompile_u24lambda_u240$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                            eventManager$iv = new EventManagerImpl();
                            try {
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv).fine("trying get exitCode");
                                runningCompilations$iv = $this$doCompile_u24lambda_u240$iv;
                                $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = daemonMessageReporter$iv;
                                rpcProfiler$iv$iv = rpcProfiler$iv;
                                $i$f$checkedCompile = false;
                                try {
                                    var51_159 = profiler$iv$iv = this_$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                    obj$iv$iv$iv = null;
                                    $i$f$withMeasure = false;
                                    startState$iv$iv$iv = $this$withMeasure$iv$iv$iv.beginMeasure(obj$iv$iv$iv);
                                    $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = false;
                                    var56_182 = rpcProfiler$iv;
                                    eventManger = eventManager$iv;
                                    $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1 = false;
                                    services = (Services)createServices.invoke(servicesFacade, (Object)eventManger, (Object)profiler);
                                    exitCode = compiler.exec(messageCollector, services, k2PlatformArgs);
                                    it = var61_208 = compilationResults;
                                    $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1 = false;
                                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                    compilationResult = (CompilationResults)it;
                                    $this$forEach$iv = CompileServiceImplBase.access$getPerformanceMetrics($this, compiler);
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        it = (BuildMetricsValue)element$iv;
                                        $i$a$-forEach-CompileServiceImplBase$compileImpl$1$1$1$1$1 = false;
                                        compilationResult.add(CompilationResultCategory.BUILD_METRICS.getCode(), it);
                                    }
                                    res$iv$iv$iv = exitCode.getCode();
                                    $this$withMeasure$iv$iv$iv.endMeasure(obj$iv$iv$iv, startState$iv$iv$iv);
                                    res$iv$iv = res$iv$iv$iv;
                                    if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                        withGC$iv$iv$iv = false;
                                        $i$f$usedMemory = false;
                                        rt$iv$iv$iv = Runtime.getRuntime();
                                        v9 = rt$iv$iv$iv.totalMemory() - rt$iv$iv$iv.freeMemory();
                                    } else {
                                        v9 = 0L;
                                    }
                                    endMem$iv$iv = v9;
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info("Done with result " + res$iv$iv);
                                    if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                        pc$iv$iv = profiler$iv$iv.getTotalCounters();
                                        rpc$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                        v10 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv.ms(pc$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv.ms(pc$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv.ms(pc$iv$iv.getThreadTime() - pc$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv.ms(rpc$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv.ms(rpc$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv.kb(endMem$iv$iv)).append(" kb (");
                                        rt$iv$iv$iv = "%+d";
                                        var75_258 = new Object[]{this_$iv$iv.kb(pc$iv$iv.getMemory())};
                                        v11 = String.format((String)rt$iv$iv$iv, Arrays.copyOf(var75_258, ((Object[])var75_258).length));
                                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"format(...)");
                                        it$iv$iv = v10.append(v11).append(" kb)").toString();
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv = false;
                                        daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(it$iv$iv);
                                        for (Object var75_258 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                            obj$iv$iv = var75_258.getKey();
                                            counters$iv$iv = (PerfCounters)var75_258.getValue();
                                            it$iv$iv = "PERF: rpc by " + obj$iv$iv + ": " + counters$iv$iv.getCount() + " calls, " + this_$iv$iv.ms(counters$iv$iv.getTime()) + " ms, thread " + this_$iv$iv.ms(counters$iv$iv.getThreadTime()) + " ms";
                                            $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv = false;
                                            daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(it$iv$iv);
                                        }
                                    }
                                    v12 = res$iv$iv;
                                }
                                catch (Throwable e$iv$iv) {
                                    v13 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv);
                                    v14 = new StringBuilder().append("Exception: ").append(e$iv$iv).append("\n  ");
                                    v15 = e$iv$iv.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"getStackTrace(...)");
                                    v16 = v14.append(ArraysKt.joinToString$default((Object[])v15, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                    if (e$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv.getCause(), (Object)e$iv$iv)) {
                                        v17 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv.getCause()).append("\n  ");
                                        v18 = e$iv$iv.getCause();
                                        Intrinsics.checkNotNull((Object)v18);
                                        v19 = v18.getStackTrace();
                                        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"getStackTrace(...)");
                                        v20 = v17.append(ArraysKt.joinToString$default((Object[])v19, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                    } else {
                                        v20 = "";
                                    }
                                    v13.log(Level.SEVERE, v16.append(v20).toString());
                                    throw e$iv$iv;
                                }
                                exitCode$iv = ((Number)v12).intValue();
                                exitCode$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv);
                            }
                            catch (Throwable this_$iv$iv) {
                                InlineMarker.finallyStart((int)1);
                                v21 = runningCompilations$iv;
                                if (v21 != null) {
                                    v21.remove(compilationId$iv);
                                    v22 = Unit.INSTANCE;
                                } else {
                                    v22 = null;
                                }
                                ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                eventManager$iv.fireCompilationFinished();
                                InlineMarker.finallyEnd((int)1);
                                throw this_$iv$iv;
                            }
                            InlineMarker.finallyStart((int)1);
                            v23 = runningCompilations$iv;
                            if (v23 != null) {
                                v23.remove(compilationId$iv);
                                v24 = Unit.INSTANCE;
                            } else {
                                v24 = null;
                            }
                            ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                            eventManager$iv.fireCompilationFinished();
                            InlineMarker.finallyEnd((int)1);
                            var80_264 = exitCode$iv;
                            v3 = var80_264;
                        }
                        finally {
                            InlineMarker.finallyStart((int)1);
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv, CompileServiceImplKt.nowSeconds());
                            InlineMarker.finallyEnd((int)1);
                        }
lbl230:
                        // 2 sources

                        var82_266 = v3;
                        v1 = var82_266;
                        break;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv);
                        InlineMarker.finallyEnd((int)1);
                    }
                }
                case 2: {
                    args$iv = $this;
                    enabled$iv = sessionId;
                    $i$f$withIncrementalCompilation = daemonReporter;
                    isEnabledBackup$iv = null;
                    compilationId$iv = compilationId;
                    $i$f$doCompile = false;
                    $this$doCompile_u24lambda_u240$iv = this_$iv;
                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv = false;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv).fine("alive!");
                    tracer$iv = $this$doCompile_u24lambda_u240$iv;
                    sessionId$iv$iv = sessionId$iv;
                    $i$f$withValidClientOrSessionProxy = false;
                    if (sessionId$iv$iv == false) {
                        v25 = null;
                    } else {
                        v25 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getSessions().get((int)sessionId$iv$iv);
                        if (v25 == null) {
                            v1 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv);
                            break;
                        }
                    }
                    session$iv$iv = v25;
                    try {
                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv).incrementAndGet();
                        session$iv = session$iv$iv;
                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv = false;
                        v26 = compilationId$iv;
                        if (v26 != null) {
                            compilationId$iv = ((Number)v26).intValue();
                            $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv = false;
                            v27 = session$iv;
                            session$iv$iv = v27 != null ? v27.getData() : null;
                            v28 = session$iv$iv instanceof RunningCompilations != false ? (RunningCompilations)session$iv$iv : null;
                            if (v28 != null) {
                                runningCompilations$iv = session$iv$iv = v28;
                                $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = false;
                                runningCompilations$iv.add(compilationId$iv);
                                v29 = session$iv$iv;
                            } else {
                                v29 = null;
                            }
                        } else {
                            v29 = null;
                        }
                        v30 = runningCompilations$iv = v29;
                        compilationCanceledStatus$iv = v30 != null ? v30.getCompilationCanceledStatus(compilationId$iv) : null;
                        rpcProfiler$iv = $this$doCompile_u24lambda_u240$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                        eventManager$iv = new EventManagerImpl();
                        try {
                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv).fine("trying get exitCode");
                            runningCompilations$iv = $this$doCompile_u24lambda_u240$iv;
                            $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = daemonMessageReporter$iv;
                            rpcProfiler$iv$iv = rpcProfiler$iv;
                            $i$f$checkedCompile = false;
                            try {
                                runningCompilations$iv = profiler$iv$iv = this_$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                obj$iv$iv$iv = null;
                                $i$f$withMeasure = false;
                                startState$iv$iv$iv = $this$withMeasure$iv$iv$iv.beginMeasure(obj$iv$iv$iv);
                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = false;
                                $this$withMeasure$iv$iv$iv = compilationCanceledStatus$iv;
                                obj$iv$iv$iv = rpcProfiler$iv;
                                pc$iv$iv = eventManager$iv;
                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2 = false;
                                v31 = compiler;
                                v32 = messageCollector;
                                v33 = compilationCanceled;
                                if (v33 == null) ** GOTO lbl321
                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = v33;
                                profiler = v32;
                                eventManger = v31;
                                $i$a$-let-CompileServiceImplBase$compileImpl$1$2$exitCode$1 = false;
                                services = new Services.Builder().register(CompilationCanceledStatus.class, it).build();
                                v31 = eventManger;
                                v32 = profiler;
                                v34 = services;
                                v33 = v34;
                                if (v34 != null) ** GOTO lbl322
lbl321:
                                // 2 sources

                                v33 = Services.EMPTY;
lbl322:
                                // 2 sources

                                exitCode = v31.exec(v32, v33, k2PlatformArgs);
                                perfString = compiler.getDefaultPerformanceManager().createPerformanceReport(PerformanceManager.DumpFormat.PlainText);
                                v35 = compilationResults;
                                if (v35 != null) {
                                    it = it = v35;
                                    $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1 = false;
                                    $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1 = new String[]{perfString};
                                    ((CompilationResults)it).add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), CollectionsKt.arrayListOf((Object[])$i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1));
                                    v36 = it;
                                } else {
                                    v36 = null;
                                }
                                res$iv$iv$iv = exitCode.getCode();
                                $this$withMeasure$iv$iv$iv.endMeasure(obj$iv$iv$iv, startState$iv$iv$iv);
                                res$iv$iv = res$iv$iv$iv;
                                if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                    withGC$iv$iv$iv = false;
                                    $i$f$usedMemory = false;
                                    rt$iv$iv$iv = Runtime.getRuntime();
                                    v37 = rt$iv$iv$iv.totalMemory() - rt$iv$iv$iv.freeMemory();
                                } else {
                                    v37 = 0L;
                                }
                                endMem$iv$iv = v37;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info("Done with result " + res$iv$iv);
                                if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                    pc$iv$iv = profiler$iv$iv.getTotalCounters();
                                    rpc$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                    v38 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv.ms(pc$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv.ms(pc$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv.ms(pc$iv$iv.getThreadTime() - pc$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv.ms(rpc$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv.ms(rpc$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv.kb(endMem$iv$iv)).append(" kb (");
                                    var64_222 = "%+d";
                                    element$iv = new Object[]{this_$iv$iv.kb(pc$iv$iv.getMemory())};
                                    v39 = String.format(var64_222, Arrays.copyOf(element$iv, element$iv.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)v39, (String)"format(...)");
                                    it$iv$iv = v38.append(v39).append(" kb)").toString();
                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv = false;
                                    daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, (String)it$iv$iv);
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info((String)it$iv$iv);
                                    for (Object it$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                        obj$iv$iv = it$iv$iv.getKey();
                                        counters$iv$iv = (PerfCounters)it$iv$iv.getValue();
                                        it$iv$iv = "PERF: rpc by " + obj$iv$iv + ": " + counters$iv$iv.getCount() + " calls, " + this_$iv$iv.ms(counters$iv$iv.getTime()) + " ms, thread " + this_$iv$iv.ms(counters$iv$iv.getThreadTime()) + " ms";
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv = false;
                                        daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(it$iv$iv);
                                    }
                                }
                                v40 = res$iv$iv;
                            }
                            catch (Throwable e$iv$iv) {
                                v41 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv);
                                v42 = new StringBuilder().append("Exception: ").append(e$iv$iv).append("\n  ");
                                v43 = e$iv$iv.getStackTrace();
                                Intrinsics.checkNotNullExpressionValue((Object)v43, (String)"getStackTrace(...)");
                                v44 = v42.append(ArraysKt.joinToString$default((Object[])v43, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                if (e$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv.getCause(), (Object)e$iv$iv)) {
                                    v45 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv.getCause()).append("\n  ");
                                    v46 = e$iv$iv.getCause();
                                    Intrinsics.checkNotNull((Object)v46);
                                    v47 = v46.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)v47, (String)"getStackTrace(...)");
                                    v48 = v45.append(ArraysKt.joinToString$default((Object[])v47, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                } else {
                                    v48 = "";
                                }
                                v41.log(Level.SEVERE, v44.append(v48).toString());
                                throw e$iv$iv;
                            }
                            exitCode$iv = ((Number)v40).intValue();
                            exitCode$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv);
                        }
                        catch (Throwable this_$iv$iv) {
                            InlineMarker.finallyStart((int)1);
                            v49 = runningCompilations$iv;
                            if (v49 != null) {
                                v49.remove(compilationId$iv);
                                v50 = Unit.INSTANCE;
                            } else {
                                v50 = null;
                            }
                            ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                            eventManager$iv.fireCompilationFinished();
                            InlineMarker.finallyEnd((int)1);
                            throw this_$iv$iv;
                        }
                        InlineMarker.finallyStart((int)1);
                        v51 = runningCompilations$iv;
                        if (v51 != null) {
                            v51.remove(compilationId$iv);
                            v52 = Unit.INSTANCE;
                        } else {
                            v52 = null;
                        }
                        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                        eventManager$iv.fireCompilationFinished();
                        InlineMarker.finallyEnd((int)1);
                        var86_269 = exitCode$iv;
                        v1 = var86_269;
                        break;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv, CompileServiceImplKt.nowSeconds());
                        InlineMarker.finallyEnd((int)1);
                    }
                }
                case 3: {
                    gradleIncrementalArgs = (IncrementalCompilationOptions)compilationOptions;
                    gradleIncrementalServicesFacade = servicesFacade;
                    var24_32 = targetPlatform;
                    var25_35 = WhenMappings.$EnumSwitchMapping$1[var24_32.ordinal()];
                    switch (var25_35) {
                        case 1: {
                            args$iv = k2PlatformArgs;
                            enabled$iv = true;
                            $i$f$withIncrementalCompilation = false;
                            isEnabledBackup$iv = IncrementalCompilation.isEnabledForJvm();
                            IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv);
                            try {
                                if (args$iv.getIncrementalCompilation() == null) {
                                    args$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv));
                                }
                                $i$a$-withIncrementalCompilation$default-CompileServiceImplBase$compileImpl$1$3 = false;
                                sessionId$iv$iv = $this;
                                $i$f$withValidClientOrSessionProxy = sessionId;
                                session$iv$iv = daemonReporter;
                                session$iv = null;
                                compilationId$iv = compilationId;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u240$iv = this_$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv).fine("alive!");
                                this_$iv$iv = $this$doCompile_u24lambda_u240$iv;
                                sessionId$iv$iv = sessionId$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv != false) ** GOTO lbl457
                                v53 = null;
                                ** GOTO lbl461
lbl457:
                                // 1 sources

                                v53 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv).getSessions().get((int)sessionId$iv$iv);
                                if (v53 != null) ** GOTO lbl461
                                v54 = new CompileService.CallResult.Error("Unknown or invalid session " + (int)sessionId$iv$iv);
                                ** GOTO lbl606
lbl461:
                                // 2 sources

                                session$iv$iv = v53;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv).incrementAndGet();
                                    session$iv = session$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv = false;
                                    v55 = compilationId$iv;
                                    if (v55 != null) {
                                        compilationId$iv = ((Number)v55).intValue();
                                        $i$a$-let-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$iv = false;
                                        v56 = session$iv;
                                        obj$iv$iv$iv = v56 != null ? v56.getData() : null;
                                        v57 = obj$iv$iv$iv instanceof RunningCompilations != false ? (RunningCompilations)obj$iv$iv$iv : null;
                                        if (v57 != null) {
                                            runningCompilations$iv = obj$iv$iv$iv = v57;
                                            $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = false;
                                            runningCompilations$iv.add(compilationId$iv);
                                            v58 = obj$iv$iv$iv;
                                        } else {
                                            v58 = null;
                                        }
                                    } else {
                                        v58 = null;
                                    }
                                    v59 = runningCompilations$iv = v58;
                                    compilationCanceledStatus$iv = v59 != null ? v59.getCompilationCanceledStatus(compilationId$iv) : null;
                                    rpcProfiler$iv = $this$doCompile_u24lambda_u240$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u240$iv).fine("trying get exitCode");
                                        runningCompilations$iv = $this$doCompile_u24lambda_u240$iv;
                                        $i$a$-also-CompileServiceImplBase$doCompile$1$1$runningCompilations$1$1$iv = daemonMessageReporter$iv;
                                        rpcProfiler$iv$iv = rpcProfiler$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            it = profiler$iv$iv = this_$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv = $this$withMeasure$iv$iv$iv.beginMeasure(obj$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = false;
                                            exitCode = compilationCanceledStatus$iv;
                                            (EventManager)eventManager$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1 = false;
                                            Intrinsics.checkNotNull((Object)k2PlatformArgs, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments");
                                            v60 = (K2JVMCompilerArguments)k2PlatformArgs;
                                            v61 = compilationResults;
                                            Intrinsics.checkNotNull((Object)v61);
                                            res$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler($this, v60, gradleIncrementalArgs, messageCollector, (RemoteBuildReporter)getICReporter.invoke(gradleIncrementalServicesFacade, v61, (Object)gradleIncrementalArgs), (CompilationCanceledStatus)compilationCanceled).getCode();
                                            $this$withMeasure$iv$iv$iv.endMeasure(obj$iv$iv$iv, startState$iv$iv$iv);
                                            res$iv$iv = res$iv$iv$iv;
                                            if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv = Runtime.getRuntime();
                                                v62 = rt$iv$iv$iv.totalMemory() - rt$iv$iv$iv.freeMemory();
                                            } else {
                                                v62 = 0L;
                                            }
                                            endMem$iv$iv = v62;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info("Done with result " + res$iv$iv);
                                            if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv = profiler$iv$iv.getTotalCounters();
                                                rpc$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v63 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv.ms(pc$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv.ms(pc$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv.ms(pc$iv$iv.getThreadTime() - pc$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv.ms(rpc$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv.ms(rpc$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv.kb(endMem$iv$iv)).append(" kb (");
                                                rt$iv$iv$iv = "%+d";
                                                $i$f$forEach = new Object[]{this_$iv$iv.kb(pc$iv$iv.getMemory())};
                                                v64 = String.format((String)rt$iv$iv$iv, Arrays.copyOf($i$f$forEach, $i$f$forEach.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v64, (String)"format(...)");
                                                it$iv$iv = v63.append(v64).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv = false;
                                                daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, (String)it$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info((String)it$iv$iv);
                                                for (Object it$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv = it$iv$iv.getKey();
                                                    counters$iv$iv = (PerfCounters)it$iv$iv.getValue();
                                                    it$iv$iv = "PERF: rpc by " + obj$iv$iv + ": " + counters$iv$iv.getCount() + " calls, " + this_$iv$iv.ms(counters$iv$iv.getTime()) + " ms, thread " + this_$iv$iv.ms(counters$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv = false;
                                                    daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv).info(it$iv$iv);
                                                }
                                            }
                                            v65 = res$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv) {
                                            v66 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv);
                                            v67 = new StringBuilder().append("Exception: ").append(e$iv$iv).append("\n  ");
                                            v68 = e$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v68, (String)"getStackTrace(...)");
                                            v69 = v67.append(ArraysKt.joinToString$default((Object[])v68, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv.getCause(), (Object)e$iv$iv)) {
                                                v70 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv.getCause()).append("\n  ");
                                                v71 = e$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v71);
                                                v72 = v71.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v72, (String)"getStackTrace(...)");
                                                v73 = v70.append(ArraysKt.joinToString$default((Object[])v72, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v73 = "";
                                            }
                                            v66.log(Level.SEVERE, v69.append(v73).toString());
                                            throw e$iv$iv;
                                        }
                                        exitCode$iv = ((Number)v65).intValue();
                                        exitCode$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv);
                                    }
                                    catch (Throwable this_$iv$iv) {
                                        InlineMarker.finallyStart((int)1);
                                        v74 = runningCompilations$iv;
                                        if (v74 != null) {
                                            v74.remove(compilationId$iv);
                                            v75 = Unit.INSTANCE;
                                        } else {
                                            v75 = null;
                                        }
                                        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                        eventManager$iv.fireCompilationFinished();
                                        InlineMarker.finallyEnd((int)1);
                                        throw this_$iv$iv;
                                    }
                                    InlineMarker.finallyStart((int)1);
                                    v76 = runningCompilations$iv;
                                    if (v76 != null) {
                                        v76.remove(compilationId$iv);
                                        v77 = Unit.INSTANCE;
                                    } else {
                                        v77 = null;
                                    }
                                    ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                    eventManager$iv.fireCompilationFinished();
                                    InlineMarker.finallyEnd((int)1);
                                    var71_250 = exitCode$iv;
                                    v54 = var71_250;
                                }
                                finally {
                                    InlineMarker.finallyStart((int)1);
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv, CompileServiceImplKt.nowSeconds());
                                    InlineMarker.finallyEnd((int)1);
                                }
lbl606:
                                // 2 sources

                                var86_270 = v54;
                                v1 = var86_270;
                                break block20;
                            }
                            finally {
                                InlineMarker.finallyStart((int)1);
                                IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv);
                                InlineMarker.finallyEnd((int)1);
                            }
                        }
                        case 2: {
                            args$iv = k2PlatformArgs;
                            enabled$iv = true;
                            $i$f$withJsIC = false;
                            isJsEnabledBackup$iv = IncrementalCompilation.isEnabledForJs();
                            IncrementalCompilation.setIsEnabledForJs((boolean)true);
                            try {
                                if (args$iv.getIncrementalCompilation() == null) {
                                    args$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv));
                                }
                                $i$a$-withJsIC$default-CompileServiceImplBase$compileImpl$1$4 = false;
                                this_$iv = $this;
                                sessionId$iv = sessionId;
                                daemonMessageReporter$iv = daemonReporter;
                                tracer$iv = null;
                                compilationId$iv = null;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u240$iv = this_$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv = false;
                                CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("alive!");
                                this_$iv$iv = $this$doCompile_u24lambda_u240$iv;
                                sessionId$iv$iv = sessionId$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId$iv$iv != 0) ** GOTO lbl640
                                v78 = null;
                                ** GOTO lbl644
lbl640:
                                // 1 sources

                                v78 = CompileServiceImplBase.access$getState(this_$iv$iv).getSessions().get(sessionId$iv$iv);
                                if (v78 != null) ** GOTO lbl644
                                v79 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv$iv);
                                ** GOTO lbl755
lbl644:
                                // 2 sources

                                session$iv$iv = v78;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv).incrementAndGet();
                                    session$iv = session$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv = false;
                                    runningCompilations$iv = null;
                                    compilationCanceledStatus$iv = null;
                                    rpcProfiler$iv = $this$doCompile_u24lambda_u240$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u240$iv).fine("trying get exitCode");
                                        this_$iv$iv = $this$doCompile_u24lambda_u240$iv;
                                        daemonMessageReporter$iv$iv = daemonMessageReporter$iv;
                                        rpcProfiler$iv$iv = rpcProfiler$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            $this$withMeasure$iv$iv$iv = profiler$iv$iv = this_$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv = $this$withMeasure$iv$iv$iv.beginMeasure(obj$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv = false;
                                            (EventManager)eventManager$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1 = false;
                                            Intrinsics.checkNotNull((Object)k2PlatformArgs, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments");
                                            v80 = (K2JSCompilerArguments)k2PlatformArgs;
                                            v81 = compilationResults;
                                            Intrinsics.checkNotNull((Object)v81);
                                            res$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler($this, v80, gradleIncrementalArgs, messageCollector, (RemoteBuildReporter)getICReporter.invoke(gradleIncrementalServicesFacade, v81, (Object)gradleIncrementalArgs)).getCode();
                                            $this$withMeasure$iv$iv$iv.endMeasure(obj$iv$iv$iv, startState$iv$iv$iv);
                                            res$iv$iv = res$iv$iv$iv;
                                            if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv = Runtime.getRuntime();
                                                v82 = rt$iv$iv$iv.totalMemory() - rt$iv$iv$iv.freeMemory();
                                            } else {
                                                v82 = 0L;
                                            }
                                            endMem$iv$iv = v82;
                                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Done with result " + res$iv$iv);
                                            if (this_$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv = profiler$iv$iv.getTotalCounters();
                                                rpc$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v83 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv.ms(pc$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv.ms(pc$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv.ms(pc$iv$iv.getThreadTime() - pc$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv.ms(rpc$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv.ms(rpc$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv.kb(endMem$iv$iv)).append(" kb (");
                                                var61_211 = "%+d";
                                                e$iv$iv = new Object[]{this_$iv$iv.kb(pc$iv$iv.getMemory())};
                                                v84 = String.format(var61_211, Arrays.copyOf(e$iv$iv, e$iv$iv.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v84, (String)"format(...)");
                                                it$iv$iv = v83.append(v84).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv = false;
                                                daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                                CompileServiceImplBase.access$getLog(this_$iv$iv).info(it$iv$iv);
                                                for (Map.Entry var65_226 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv = var65_226.getKey();
                                                    counters$iv$iv = (PerfCounters)var65_226.getValue();
                                                    it$iv$iv = "PERF: rpc by " + obj$iv$iv + ": " + counters$iv$iv.getCount() + " calls, " + this_$iv$iv.ms(counters$iv$iv.getTime()) + " ms, thread " + this_$iv$iv.ms(counters$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv = false;
                                                    daemonMessageReporter$iv$iv.report(ReportSeverity.INFO, it$iv$iv);
                                                    CompileServiceImplBase.access$getLog(this_$iv$iv).info(it$iv$iv);
                                                }
                                            }
                                            v85 = res$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv) {
                                            v86 = CompileServiceImplBase.access$getLog(this_$iv$iv);
                                            v87 = new StringBuilder().append("Exception: ").append(e$iv$iv).append("\n  ");
                                            v88 = e$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v88, (String)"getStackTrace(...)");
                                            v89 = v87.append(ArraysKt.joinToString$default((Object[])v88, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv.getCause(), (Object)e$iv$iv)) {
                                                v90 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv.getCause()).append("\n  ");
                                                v91 = e$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v91);
                                                v92 = v91.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v92, (String)"getStackTrace(...)");
                                                v93 = v90.append(ArraysKt.joinToString$default((Object[])v92, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v93 = "";
                                            }
                                            v86.log(Level.SEVERE, v89.append(v93).toString());
                                            throw e$iv$iv;
                                        }
                                        exitCode$iv = ((Number)v85).intValue();
                                        var47_140 = new CompileService.CallResult.Good<Integer>(exitCode$iv);
                                    }
                                    finally {
                                        InlineMarker.finallyStart((int)1);
                                        ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                                        eventManager$iv.fireCompilationFinished();
                                        InlineMarker.finallyEnd((int)1);
                                    }
                                    var70_247 = var47_140;
                                    v79 = var70_247;
                                }
                                finally {
                                    InlineMarker.finallyStart((int)1);
                                    CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv, CompileServiceImplKt.nowSeconds());
                                    InlineMarker.finallyEnd((int)1);
                                }
lbl755:
                                // 2 sources

                                var72_256 = v79;
                                v1 = var72_256;
                                break block20;
                            }
                            finally {
                                InlineMarker.finallyStart((int)1);
                                IncrementalCompilation.setIsEnabledForJs((boolean)isJsEnabledBackup$iv);
                                InlineMarker.finallyEnd((int)1);
                            }
                        }
                    }
                    throw new IllegalStateException("Incremental compilation is not supported for target platform: " + targetPlatform);
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return v1;
    }

    @PublishedApi
    public final void maybeWaitForTestStart() {
        if (Intrinsics.areEqual((Object)CompilerSystemProperties.COMPILE_WAIT_BEFORE_COMPILATION_FOR_TESTS.getValue(), (Object)"true")) {
            String string = DaemonParamsKt.getRunFilesPathOrDefault(this.daemonOptions);
            String[] stringArray = new String[]{"daemon-test-start"};
            Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path daemonStartFile = path;
            this.getLog().info("Waiting for file " + ((Object)daemonStartFile.toAbsolutePath()).toString() + " to appear...");
            int n = 10;
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(daemonStartFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    this.getLog().info("Found " + ((Object)daemonStartFile.toAbsolutePath()).toString() + ". Starting compilation.");
                    continue;
                }
                Thread.sleep(500L);
            }
            this.getLog().info("Didn't find " + ((Object)daemonStartFile.toAbsolutePath()).toString() + " after 5000ms, starting compilation anyway.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected final CompileService.CallResult<Integer> doCompile(int sessionId, @NotNull DaemonMessageReporter daemonMessageReporter, @Nullable RemoteOperationsTracer tracer, @Nullable Integer compilationId, @NotNull Function3<? super EventManager, ? super Profiler, ? super CompilationCanceledStatus, ? extends ExitCode> body) {
        CompileService.CallResult callResult;
        void this_$iv;
        ClientOrSessionProxy<Object> clientOrSessionProxy;
        Intrinsics.checkNotNullParameter((Object)daemonMessageReporter, (String)"daemonMessageReporter");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$doCompile = false;
        CompileServiceImplBase $this$doCompile_u24lambda_u240 = this;
        boolean bl = false;
        $this$doCompile_u24lambda_u240.getLog().fine("alive!");
        CompileServiceImplBase compileServiceImplBase = $this$doCompile_u24lambda_u240;
        int sessionId$iv = sessionId;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId$iv == 0) {
            clientOrSessionProxy = null;
        } else {
            clientOrSessionProxy = ((CompileServiceImplBase)this_$iv).state.getSessions().get(sessionId$iv);
            if (clientOrSessionProxy == null) {
                callResult = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv);
                return callResult;
            }
        }
        ClientOrSessionProxy<Object> session$iv = clientOrSessionProxy;
        try {
            CompileService.CallResult.Good<Integer> good;
            RunningCompilations runningCompilations;
            Object object;
            Object runningCompilations2;
            ((CompileServiceImplBase)this_$iv).compilationsCounter.incrementAndGet();
            ClientOrSessionProxy<Object> session = session$iv;
            boolean bl2 = false;
            Integer n = compilationId;
            if (n != null) {
                int compilationId2 = ((Number)n).intValue();
                boolean bl3 = false;
                ClientOrSessionProxy<Object> clientOrSessionProxy2 = session;
                Object object2 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                RunningCompilations runningCompilations3 = object2 instanceof RunningCompilations ? (RunningCompilations)object2 : null;
                if (runningCompilations3 != null) {
                    runningCompilations2 = object2 = runningCompilations3;
                    boolean bl4 = false;
                    ((RunningCompilations)runningCompilations2).add(compilationId2);
                    object = object2;
                } else {
                    object = null;
                }
            } else {
                object = null;
            }
            RunningCompilations runningCompilations4 = runningCompilations = object;
            CompilationCanceledStatus compilationCanceledStatus = runningCompilations4 != null ? runningCompilations4.getCompilationCanceledStatus(compilationId) : null;
            RemoteOperationsTracer remoteOperationsTracer = tracer;
            if (remoteOperationsTracer != null) {
                remoteOperationsTracer.before("compile");
            }
            Profiler rpcProfiler = $this$doCompile_u24lambda_u240.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
            EventManagerImpl eventManager = new EventManagerImpl();
            try {
                Integer n2;
                void this_$iv2;
                $this$doCompile_u24lambda_u240.getLog().fine("trying get exitCode");
                runningCompilations2 = $this$doCompile_u24lambda_u240;
                DaemonMessageReporter bl4 = daemonMessageReporter;
                Profiler rpcProfiler$iv = rpcProfiler;
                boolean $i$f$checkedCompile = false;
                try {
                    long l;
                    void $this$withMeasure$iv$iv;
                    Profiler profiler$iv;
                    Profiler profiler = profiler$iv = this_$iv2.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                    Object obj$iv$iv = null;
                    boolean $i$f$withMeasure = false;
                    List<Long> startState$iv$iv = $this$withMeasure$iv$iv.beginMeasure(obj$iv$iv);
                    boolean bl5 = false;
                    Integer res$iv$iv = ((ExitCode)body.invoke((Object)eventManager, (Object)rpcProfiler, (Object)compilationCanceledStatus)).getCode();
                    $this$withMeasure$iv$iv.endMeasure(obj$iv$iv, startState$iv$iv);
                    Integer res$iv = res$iv$iv;
                    if (this_$iv2.getDaemonOptions().getReportPerf()) {
                        boolean withGC$iv$iv = false;
                        boolean $i$f$usedMemory = false;
                        Runtime rt$iv$iv = Runtime.getRuntime();
                        l = rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory();
                    } else {
                        l = 0L;
                    }
                    long endMem$iv = l;
                    ((CompileServiceImplBase)this_$iv2).getLog().info("Done with result " + res$iv);
                    if (this_$iv2.getDaemonOptions().getReportPerf()) {
                        void daemonMessageReporter$iv;
                        PerfCounters pc$iv = profiler$iv.getTotalCounters();
                        PerfCounters rpc$iv = rpcProfiler$iv.getTotalCounters();
                        StringBuilder stringBuilder = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv2.ms(pc$iv.getTime())).append(" ms; thread: user ").append(this_$iv2.ms(pc$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv2.ms(pc$iv.getThreadTime() - pc$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv.getCount()).append(" calls, ").append(this_$iv2.ms(rpc$iv.getTime())).append(" ms, thread ").append(this_$iv2.ms(rpc$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv2.kb(endMem$iv)).append(" kb (");
                        String string = "%+d";
                        Object[] objectArray2 = new Object[]{this_$iv2.kb(pc$iv.getMemory())};
                        objectArray2 = objectArray2;
                        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        String string3 = stringBuilder.append(string2).append(" kb)").toString();
                        boolean bl6 = false;
                        daemonMessageReporter$iv.report(ReportSeverity.INFO, string3);
                        ((CompileServiceImplBase)this_$iv2).getLog().info(string3);
                        for (Map.Entry entry : rpcProfiler$iv.getCounters().entrySet()) {
                            Object obj$iv = entry.getKey();
                            PerfCounters counters$iv = (PerfCounters)entry.getValue();
                            String it$iv = "PERF: rpc by " + obj$iv + ": " + counters$iv.getCount() + " calls, " + this_$iv2.ms(counters$iv.getTime()) + " ms, thread " + this_$iv2.ms(counters$iv.getThreadTime()) + " ms";
                            boolean bl7 = false;
                            daemonMessageReporter$iv.report(ReportSeverity.INFO, it$iv);
                            ((CompileServiceImplBase)this_$iv2).getLog().info(it$iv);
                        }
                    }
                    n2 = res$iv;
                }
                catch (Throwable e$iv) {
                    String string;
                    Logger logger = ((CompileServiceImplBase)this_$iv2).getLog();
                    StringBuilder stringBuilder = new StringBuilder().append("Exception: ").append(e$iv).append("\n  ");
                    StackTraceElement[] stackTraceElementArray = e$iv.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append(ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                    if (e$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv.getCause(), (Object)e$iv)) {
                        StringBuilder stringBuilder3 = new StringBuilder().append("\nCaused by: ").append(e$iv.getCause()).append("\n  ");
                        Throwable throwable = e$iv.getCause();
                        Intrinsics.checkNotNull((Object)throwable);
                        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray2, (String)"getStackTrace(...)");
                        string = stringBuilder3.append(ArraysKt.joinToString$default((Object[])stackTraceElementArray2, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                    } else {
                        string = "";
                    }
                    logger.log(Level.SEVERE, stringBuilder2.append(string).toString());
                    throw e$iv;
                }
                int exitCode = ((Number)n2).intValue();
                good = new CompileService.CallResult.Good<Integer>(exitCode);
            }
            finally {
                InlineMarker.finallyStart((int)1);
                RunningCompilations runningCompilations5 = runningCompilations;
                if (runningCompilations5 != null) {
                    runningCompilations5.remove(compilationId);
                }
                ProgressIndicatorAndCompilationCanceledStatus.setCompilationCanceledStatus(null);
                eventManager.fireCompilationFinished();
                RemoteOperationsTracer remoteOperationsTracer2 = tracer;
                if (remoteOperationsTracer2 != null) {
                    remoteOperationsTracer2.after("compile");
                }
                InlineMarker.finallyEnd((int)1);
            }
            CompileService.CallResult callResult2 = good;
            callResult = callResult2;
            return callResult;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            ((CompileServiceImplBase)this_$iv)._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
            InlineMarker.finallyEnd((int)1);
        }
    }

    public final long ms(long $this$ms) {
        return TimeUnit.NANOSECONDS.toMillis($this$ms);
    }

    public final long kb(long $this$kb) {
        return $this$kb / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    protected final <R> R checkedCompile(@NotNull DaemonMessageReporter daemonMessageReporter, @NotNull Profiler rpcProfiler, @NotNull Function0<? extends R> body) {
        Intrinsics.checkNotNullParameter((Object)daemonMessageReporter, (String)"daemonMessageReporter");
        Intrinsics.checkNotNullParameter((Object)rpcProfiler, (String)"rpcProfiler");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$checkedCompile = false;
        try {
            long l;
            void $this$withMeasure$iv;
            Profiler profiler;
            Profiler profiler2 = profiler = this.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
            Object obj$iv = null;
            boolean $i$f$withMeasure = false;
            List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(obj$iv);
            Object res$iv = body.invoke();
            $this$withMeasure$iv.endMeasure(obj$iv, startState$iv);
            Object res = res$iv;
            if (this.getDaemonOptions().getReportPerf()) {
                boolean withGC$iv = false;
                boolean $i$f$usedMemory = false;
                Runtime rt$iv = Runtime.getRuntime();
                l = rt$iv.totalMemory() - rt$iv.freeMemory();
            } else {
                l = 0L;
            }
            long endMem = l;
            this.getLog().info("Done with result " + res);
            if (this.getDaemonOptions().getReportPerf()) {
                PerfCounters pc = profiler.getTotalCounters();
                PerfCounters rpc = rpcProfiler.getTotalCounters();
                StringBuilder stringBuilder = new StringBuilder().append("PERF: Compile on daemon: ").append(this.ms(pc.getTime())).append(" ms; thread: user ").append(this.ms(pc.getThreadUserTime())).append(" ms, sys ").append(this.ms(pc.getThreadTime() - pc.getThreadUserTime())).append(" ms; rpc: ").append(rpc.getCount()).append(" calls, ").append(this.ms(rpc.getTime())).append(" ms, thread ").append(this.ms(rpc.getThreadTime())).append(" ms; memory: ").append(this.kb(endMem)).append(" kb (");
                String string = "%+d";
                Object[] objectArray = new Object[]{this.kb(pc.getMemory())};
                objectArray = objectArray;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String string3 = stringBuilder.append(string2).append(" kb)").toString();
                boolean bl = false;
                daemonMessageReporter.report(ReportSeverity.INFO, string3);
                this.getLog().info(string3);
                for (Map.Entry entry : rpcProfiler.getCounters().entrySet()) {
                    Object obj = entry.getKey();
                    PerfCounters counters = (PerfCounters)entry.getValue();
                    String it2 = "PERF: rpc by " + obj + ": " + counters.getCount() + " calls, " + this.ms(counters.getTime()) + " ms, thread " + this.ms(counters.getThreadTime()) + " ms";
                    boolean bl2 = false;
                    daemonMessageReporter.report(ReportSeverity.INFO, it2);
                    this.getLog().info(it2);
                }
            }
            return (R)res;
        }
        catch (Throwable e) {
            String string;
            Logger logger = this.getLog();
            StringBuilder stringBuilder = new StringBuilder().append("Exception: ").append(e).append("\n  ");
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
            if (e.getCause() != null && !Intrinsics.areEqual((Object)e.getCause(), (Object)e)) {
                StringBuilder stringBuilder3 = new StringBuilder().append("\nCaused by: ").append(e.getCause()).append("\n  ");
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray2, (String)"getStackTrace(...)");
                string = stringBuilder3.append(ArraysKt.joinToString$default((Object[])stackTraceElementArray2, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
            } else {
                string = "";
            }
            logger.log(Level.SEVERE, stringBuilder2.append(string).toString());
            throw e;
        }
    }

    public final void startDaemonElections() {
        Timer timer = this.timer;
        long l = 10L;
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ CompileServiceImplBase this$0;
            {
                this.this$0 = compileServiceImplBase;
            }

            public void run() {
                block2: {
                    TimerTask $this$startDaemonElections_u24lambda_u240 = this;
                    boolean bl = false;
                    CompileServiceImplBase this_$iv = this.this$0;
                    boolean $i$f$exceptionLoggingTimerThread = false;
                    try {
                        boolean bl2 = false;
                        this.this$0.initiateElections();
                    }
                    catch (Throwable e$iv) {
                        System.err.println("Exception in timer thread: " + e$iv.getMessage());
                        e$iv.printStackTrace(System.err);
                        CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception in timer thread", e$iv);
                        if (!(e$iv instanceof LinkageError)) break block2;
                        this_$iv.getOnShutdown().invoke();
                    }
                }
            }
        };
        timer.schedule(timerTask, l);
    }

    public final void configurePeriodicActivities() {
        this.getLog().info("Periodic liveness check activities configured");
        Timer timer = this.timer;
        long l = KotlinCompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS();
        long l2 = KotlinCompileDaemonKt.getDAEMON_PERIODIC_CHECK_INTERVAL_MS();
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ CompileServiceImplBase this$0;
            {
                this.this$0 = compileServiceImplBase;
            }

            public void run() {
                block2: {
                    TimerTask $this$configurePeriodicActivities_u24lambda_u240 = this;
                    boolean bl = false;
                    CompileServiceImplBase this_$iv = this.this$0;
                    boolean $i$f$exceptionLoggingTimerThread = false;
                    try {
                        boolean bl2 = false;
                        this.this$0.periodicAndAfterSessionCheck();
                    }
                    catch (Throwable e$iv) {
                        System.err.println("Exception in timer thread: " + e$iv.getMessage());
                        e$iv.printStackTrace(System.err);
                        CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception in timer thread", e$iv);
                        if (!(e$iv instanceof LinkageError)) break block2;
                        this_$iv.getOnShutdown().invoke();
                    }
                }
            }
        };
        timer.schedule(timerTask, l, l2);
        timer = this.timer;
        l = KotlinCompileDaemonKt.getDAEMON_PERIODIC_SELDOM_CHECK_INTERVAL_MS() + (long)100;
        l2 = KotlinCompileDaemonKt.getDAEMON_PERIODIC_SELDOM_CHECK_INTERVAL_MS();
        timerTask = new TimerTask(this){
            final /* synthetic */ CompileServiceImplBase this$0;
            {
                this.this$0 = compileServiceImplBase;
            }

            public void run() {
                block2: {
                    TimerTask $this$configurePeriodicActivities_u24lambda_u241 = this;
                    boolean bl = false;
                    CompileServiceImplBase this_$iv = this.this$0;
                    boolean $i$f$exceptionLoggingTimerThread = false;
                    try {
                        boolean bl2 = false;
                        this.this$0.periodicSeldomCheck();
                    }
                    catch (Throwable e$iv) {
                        System.err.println("Exception in timer thread: " + e$iv.getMessage());
                        e$iv.printStackTrace(System.err);
                        CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception in timer thread", e$iv);
                        if (!(e$iv instanceof LinkageError)) break block2;
                        this_$iv.getOnShutdown().invoke();
                    }
                }
            }
        };
        timer.schedule(timerTask, l, l2);
    }

    @NotNull
    protected final <R> CompileService.CallResult<R> ifAliveChecksImpl(@NotNull Aliveness minAliveness, @NotNull Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        block7: {
            CompileService.CallResult callResult2;
            block4: {
                Object object;
                int curState;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)((Object)minAliveness), (String)"minAliveness");
                        Intrinsics.checkNotNullParameter(body, (String)"body");
                        boolean $i$f$ifAliveChecksImpl = false;
                        curState = this.state.getAlive().get();
                        if (curState >= minAliveness.ordinal()) break block4;
                        Object[] stackTrace = Thread.currentThread().getStackTrace();
                        int rmiBusinessCallDepth = 1;
                        Intrinsics.checkNotNull((Object)stackTrace);
                        object = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace, (int)rmiBusinessCallDepth);
                        if (object == null) break block5;
                        StackTraceElement it = object;
                        boolean bl = false;
                        String string = " Operation: " + it;
                        object = string;
                        if (string != null) break block6;
                    }
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                    object = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                }
                Object callSource = object;
                this.getLog().info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + this.toAlivenessName(curState) + "\n                    |" + (String)callSource + "\n                    "), null, (int)1, null));
                callResult = new CompileService.CallResult.Dying();
                break block7;
            }
            try {
                callResult2 = (CompileService.CallResult)body.invoke();
            }
            catch (Throwable e) {
                this.getLog().log(Level.SEVERE, "Exception", e);
                callResult2 = new CompileService.CallResult.Error(e);
            }
            callResult = callResult2;
        }
        return callResult;
    }

    public static /* synthetic */ CompileService.CallResult ifAliveChecksImpl$default(CompileServiceImplBase $this, Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        block10: {
            CompileService.CallResult callResult2;
            block7: {
                Object object2;
                int curState;
                block9: {
                    block8: {
                        if (object != null) {
                            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ifAliveChecksImpl");
                        }
                        if ((n & 1) != 0) {
                            minAliveness = Aliveness.LastSession;
                        }
                        Intrinsics.checkNotNullParameter((Object)((Object)minAliveness), (String)"minAliveness");
                        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                        boolean $i$f$ifAliveChecksImpl = false;
                        curState = $this.state.getAlive().get();
                        if (curState >= minAliveness.ordinal()) break block7;
                        Object[] stackTrace = Thread.currentThread().getStackTrace();
                        int rmiBusinessCallDepth = 1;
                        Intrinsics.checkNotNull((Object)stackTrace);
                        object2 = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTrace, (int)rmiBusinessCallDepth);
                        if (object2 == null) break block8;
                        StackTraceElement it = object2;
                        boolean bl = false;
                        String string = " Operation: " + it;
                        object2 = string;
                        if (string != null) break block9;
                    }
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                    object2 = ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n at ", (CharSequence)" at ", null, (int)0, null, null, (int)60, null);
                }
                Object callSource = object2;
                $this.getLog().info(StringsKt.trimMargin$default((String)("\n                    |Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + $this.toAlivenessName(curState) + "\n                    |" + (String)callSource + "\n                    "), null, (int)1, null));
                callResult = new CompileService.CallResult.Dying();
                break block10;
            }
            try {
                callResult2 = (CompileService.CallResult)body.invoke();
            }
            catch (Throwable e) {
                $this.getLog().log(Level.SEVERE, "Exception", e);
                callResult2 = new CompileService.CallResult.Error(e);
            }
            callResult = callResult2;
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final <R> CompileService.CallResult<R> withValidClientOrSessionProxy(int sessionId, @NotNull Function1<? super ClientOrSessionProxy<? extends Object>, ? extends CompileService.CallResult<? extends R>> body) {
        ClientOrSessionProxy<Object> clientOrSessionProxy;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId == 0) {
            clientOrSessionProxy = null;
        } else {
            clientOrSessionProxy = this.state.getSessions().get(sessionId);
            if (clientOrSessionProxy == null) {
                return new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
            }
        }
        ClientOrSessionProxy<Object> session = clientOrSessionProxy;
        try {
            this.compilationsCounter.incrementAndGet();
            CompileService.CallResult callResult = (CompileService.CallResult)body.invoke(session);
            return callResult;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ExitCode execJsIncrementalCompiler(@NotNull K2JSCompilerArguments args, @NotNull IncrementalCompilationOptions incrementalCompilationOptions, @NotNull MessageCollector compilerMessageCollector, @NotNull RemoteBuildReporter<BuildTimeMetric, BuildPerformanceMetric> reporter) {
        ModulesApiHistory modulesApiHistory;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)incrementalCompilationOptions, (String)"incrementalCompilationOptions");
        Intrinsics.checkNotNullParameter((Object)compilerMessageCollector, (String)"compilerMessageCollector");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        BuildMetricsReporterKt.startMeasureGc((BuildMetricsReporter)((BuildMetricsReporter)reporter));
        List allKotlinFiles = IncrementalCompilerRunnerKt.extractKotlinSourcesFromFreeCompilerArguments((CommonCompilerArguments)((CommonCompilerArguments)args), (Set)SetsKt.setOf((Object)"kt"), (boolean)false);
        File workingDir = incrementalCompilationOptions.getWorkingDir();
        MultiModuleICSettings multiModuleICSettings = incrementalCompilationOptions.getMultiModuleICSettings();
        if (multiModuleICSettings != null) {
            MultiModuleICSettings $this$execJsIncrementalCompiler_u24lambda_u240 = multiModuleICSettings;
            boolean bl = false;
            IncrementalModuleInfo incrementalModuleInfo = incrementalCompilationOptions.getModulesInfo();
            if (incrementalModuleInfo == null) {
                throw new IllegalStateException("The build is configured to use the history-file based IC approach, but doesn't provide the modulesInfo".toString());
            }
            IncrementalModuleInfo modulesInfo = incrementalModuleInfo;
            File file = incrementalCompilationOptions.getRootProjectDir();
            if (file == null) {
                throw new IllegalStateException("rootProjectDir is expected to be non null when the history-file based IC approach is used".toString());
            }
            File rootProjectDir = file;
            modulesApiHistory = (ModulesApiHistory)new ModulesApiHistoryJs(rootProjectDir, modulesInfo);
        } else {
            modulesApiHistory = (ModulesApiHistory)EmptyModulesApiHistory.INSTANCE;
        }
        ModulesApiHistory modulesApiHistory2 = modulesApiHistory;
        MultiModuleICSettings multiModuleICSettings2 = incrementalCompilationOptions.getMultiModuleICSettings();
        File file = multiModuleICSettings2 != null ? multiModuleICSettings2.getBuildHistoryFile() : null;
        CompileScopeExpansionMode compileScopeExpansionMode = CompileScopeExpansionMode.ALWAYS;
        IncrementalCompilationFeatures incrementalCompilationFeatures = incrementalCompilationOptions.getIcFeatures();
        IncrementalJsCompilerRunner compiler = new IncrementalJsCompilerRunner(workingDir, (BuildReporter)reporter, file, modulesApiHistory2, compileScopeExpansionMode, incrementalCompilationFeatures);
        try {
            file = IncrementalCompilerRunner.compile$default((IncrementalCompilerRunner)((IncrementalCompilerRunner)compiler), (List)allKotlinFiles, (CommonCompilerArguments)((CommonCompilerArguments)args), (MessageCollector)compilerMessageCollector, (ChangedFiles)this.toChangedFiles(incrementalCompilationOptions.getSourceChanges()), null, (int)16, null);
        }
        finally {
            BuildMetricsReporterKt.endMeasureGc((BuildMetricsReporter)((BuildMetricsReporter)reporter));
            reporter.flush();
        }
        return file;
    }

    private final ChangedFiles toChangedFiles(SourcesChanges $this$toChangedFiles) {
        ChangedFiles changedFiles;
        SourcesChanges sourcesChanges = $this$toChangedFiles;
        if (sourcesChanges instanceof SourcesChanges.Unknown) {
            changedFiles = (ChangedFiles)ChangedFiles.Unknown.INSTANCE;
        } else if (sourcesChanges instanceof SourcesChanges.ToBeCalculated) {
            changedFiles = (ChangedFiles)ChangedFiles.DeterminableFiles.ToBeComputed.INSTANCE;
        } else if (sourcesChanges instanceof SourcesChanges.Known) {
            changedFiles = (ChangedFiles)new ChangedFiles.DeterminableFiles.Known(((SourcesChanges.Known)$this$toChangedFiles).getModifiedFiles(), ((SourcesChanges.Known)$this$toChangedFiles).getRemovedFiles(), false, 4, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return changedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ExitCode execIncrementalCompiler(@NotNull K2JVMCompilerArguments k2jvmArgs, @NotNull IncrementalCompilationOptions incrementalCompilationOptions, @NotNull MessageCollector compilerMessageCollector, @NotNull RemoteBuildReporter<BuildTimeMetric, BuildPerformanceMetric> reporter, @Nullable CompilationCanceledStatus compilationCanceledStatus) {
        IncrementalJvmCompilerRunner incrementalJvmCompilerRunner;
        boolean bl;
        IncrementalCompilationFeatures incrementalCompilationFeatures;
        ClasspathChanges classpathChanges;
        ExitCode exitCode;
        Intrinsics.checkNotNullParameter((Object)k2jvmArgs, (String)"k2jvmArgs");
        Intrinsics.checkNotNullParameter((Object)incrementalCompilationOptions, (String)"incrementalCompilationOptions");
        Intrinsics.checkNotNullParameter((Object)compilerMessageCollector, (String)"compilerMessageCollector");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        BuildMetricsReporterKt.startMeasureGc((BuildMetricsReporter)((BuildMetricsReporter)reporter));
        Set set = SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS();
        Object[] objectArray = incrementalCompilationOptions.getKotlinScriptExtensions();
        if (objectArray == null) {
            objectArray = new String[]{};
        }
        Set allKotlinJvmExtensions = CollectionsKt.toSet((Iterable)SetsKt.plus((Set)set, (Object[])objectArray));
        List allSourceFiles = IncrementalCompilerRunnerKt.extractKotlinSourcesFromFreeCompilerArguments((CommonCompilerArguments)((CommonCompilerArguments)k2jvmArgs), (Set)allKotlinJvmExtensions, (boolean)true);
        File workingDir = incrementalCompilationOptions.getWorkingDir();
        File rootProjectDir = incrementalCompilationOptions.getRootProjectDir();
        File buildDir = incrementalCompilationOptions.getBuildDir();
        boolean verifiedPreciseJavaTracking = CompilerRunnerUtils.disablePreciseJavaTrackingIfK2((K2JVMCompilerArguments)k2jvmArgs, (boolean)incrementalCompilationOptions.getIcFeatures().getUsePreciseJavaTracking());
        if (incrementalCompilationOptions.getUseJvmFirRunner()) {
            exitCode = incrementalCompilationOptions.getOutputFiles();
            classpathChanges = incrementalCompilationOptions.getClasspathChanges();
            incrementalCompilationFeatures = IncrementalCompilationFeatures.copy$default((IncrementalCompilationFeatures)incrementalCompilationOptions.getIcFeatures(), (boolean)verifiedPreciseJavaTracking, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)62, null);
            bl = incrementalCompilationOptions.getGenerateCompilerRefIndex();
            incrementalJvmCompilerRunner = (IncrementalJvmCompilerRunner)new IncrementalFirJvmCompilerRunner(workingDir, (BuildReporter)reporter, exitCode, classpathChanges, allKotlinJvmExtensions, incrementalCompilationFeatures, bl, compilationCanceledStatus);
        } else {
            exitCode = incrementalCompilationOptions.getOutputFiles();
            classpathChanges = incrementalCompilationOptions.getClasspathChanges();
            incrementalCompilationFeatures = IncrementalCompilationFeatures.copy$default((IncrementalCompilationFeatures)incrementalCompilationOptions.getIcFeatures(), (boolean)verifiedPreciseJavaTracking, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)62, null);
            bl = incrementalCompilationOptions.getGenerateCompilerRefIndex();
            incrementalJvmCompilerRunner = new IncrementalJvmCompilerRunner(workingDir, (BuildReporter)reporter, exitCode, classpathChanges, allKotlinJvmExtensions, incrementalCompilationFeatures, bl, compilationCanceledStatus);
        }
        IncrementalJvmCompilerRunner compiler = incrementalJvmCompilerRunner;
        try {
            exitCode = compiler.compile(allSourceFiles, (CommonCompilerArguments)k2jvmArgs, compilerMessageCollector, this.toChangedFiles(incrementalCompilationOptions.getSourceChanges()), rootProjectDir != null && buildDir != null ? new FileLocations(rootProjectDir, buildDir) : null);
        }
        finally {
            BuildMetricsReporterKt.endMeasureGc((BuildMetricsReporter)((BuildMetricsReporter)reporter));
            reporter.flush();
        }
        return exitCode;
    }

    public static /* synthetic */ ExitCode execIncrementalCompiler$default(CompileServiceImplBase compileServiceImplBase, K2JVMCompilerArguments k2JVMCompilerArguments, IncrementalCompilationOptions incrementalCompilationOptions, MessageCollector messageCollector, RemoteBuildReporter remoteBuildReporter, CompilationCanceledStatus compilationCanceledStatus, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: execIncrementalCompiler");
        }
        if ((n & 0x10) != 0) {
            compilationCanceledStatus = null;
        }
        return compileServiceImplBase.execIncrementalCompiler(k2JVMCompilerArguments, incrementalCompilationOptions, messageCollector, (RemoteBuildReporter<BuildTimeMetric, BuildPerformanceMetric>)remoteBuildReporter, compilationCanceledStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected final <R, KotlinJvmReplServiceT> CompileService.CallResult<R> withValidReplImpl(int sessionId, @NotNull Function1<? super KotlinJvmReplServiceT, ? extends CompileService.CallResult<? extends R>> body) {
        Object object;
        void this_$iv;
        ClientOrSessionProxy<Object> clientOrSessionProxy;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$withValidReplImpl = false;
        CompileServiceImplBase compileServiceImplBase = this;
        int sessionId$iv = sessionId;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId$iv == 0) {
            clientOrSessionProxy = null;
        } else {
            clientOrSessionProxy = ((CompileServiceImplBase)this_$iv).state.getSessions().get(sessionId$iv);
            if (clientOrSessionProxy == null) {
                object = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId$iv);
                return object;
            }
        }
        ClientOrSessionProxy<Object> session$iv = clientOrSessionProxy;
        try {
            Object object2;
            ((CompileServiceImplBase)this_$iv).compilationsCounter.incrementAndGet();
            ClientOrSessionProxy<Object> session = session$iv;
            boolean bl = false;
            ClientOrSessionProxy<Object> clientOrSessionProxy2 = session;
            Object object3 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
            if (object3 == null) {
                object3 = object2 = null;
            }
            if (object3 == null || (object2 = (CompileService.CallResult)body.invoke(object2)) == null) {
                object2 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
            }
            Object object4 = object2;
            object = object4;
            return object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            ((CompileServiceImplBase)this_$iv)._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final Logger log_delegate$lambda$0() {
        return Logger.getLogger("compiler");
    }

    private static final void getPerformanceMetrics$reportLps(ArrayList<BuildMetricsValue> performanceMetrics, UnitStats moduleStats, CompilationPerformanceMetrics lpsMetrics, Time time) {
        if (!Intrinsics.areEqual((Object)time, (Object)Time.Companion.getZERO())) {
            performanceMetrics.add(new BuildMetricsValue(lpsMetrics, (long)UnitStatsKt.getLinesPerSecond((UnitStats)moduleStats, (Time)time)));
        }
    }

    private static final Unit getPerformanceMetrics$lambda$0(Ref.ObjectRef $codegenTime, ArrayList $performanceMetrics, UnitStats $moduleStats, PhaseType phaseType, Time time) {
        CompilationPerformanceMetrics metrics;
        Intrinsics.checkNotNullParameter((Object)phaseType, (String)"phaseType");
        if (time == null) {
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[phaseType.ordinal()]) {
            case 1: {
                CompilationPerformanceMetrics compilationPerformanceMetrics = CompilationPerformanceMetrics.COMPILER_INITIALIZATION;
                break;
            }
            case 2: {
                CompilationPerformanceMetrics compilationPerformanceMetrics = CompilationPerformanceMetrics.CODE_ANALYSIS;
                break;
            }
            case 3: {
                $codegenTime.element = ((Time)$codegenTime.element).plus(time);
                CompilationPerformanceMetrics compilationPerformanceMetrics = null;
                break;
            }
            case 4: {
                $codegenTime.element = ((Time)$codegenTime.element).plus(time);
                CompilationPerformanceMetrics compilationPerformanceMetrics = null;
                break;
            }
            default: {
                CompilationPerformanceMetrics compilationPerformanceMetrics = metrics = null;
            }
        }
        if (metrics != null) {
            $performanceMetrics.add(new BuildMetricsValue(metrics, time.getMillis()));
            if (phaseType == PhaseType.Analysis) {
                CompileServiceImplBase.getPerformanceMetrics$reportLps($performanceMetrics, $moduleStats, CompilationPerformanceMetrics.ANALYSIS_LPS, time);
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$getPerformanceMetrics(CompileServiceImplBase $this, CLICompiler compiler) {
        return $this.getPerformanceMetrics((CLICompiler<CommonCompilerArguments>)compiler);
    }

    public static final /* synthetic */ ExitCode access$execIncrementalCompiler(CompileServiceImplBase $this, K2JVMCompilerArguments k2jvmArgs, IncrementalCompilationOptions incrementalCompilationOptions, MessageCollector compilerMessageCollector, RemoteBuildReporter reporter, CompilationCanceledStatus compilationCanceledStatus) {
        return $this.execIncrementalCompiler(k2jvmArgs, incrementalCompilationOptions, compilerMessageCollector, (RemoteBuildReporter<BuildTimeMetric, BuildPerformanceMetric>)reporter, compilationCanceledStatus);
    }

    public static final /* synthetic */ ExitCode access$execJsIncrementalCompiler(CompileServiceImplBase $this, K2JSCompilerArguments args, IncrementalCompilationOptions incrementalCompilationOptions, MessageCollector compilerMessageCollector, RemoteBuildReporter reporter) {
        return $this.execJsIncrementalCompiler(args, incrementalCompilationOptions, compilerMessageCollector, (RemoteBuildReporter<BuildTimeMetric, BuildPerformanceMetric>)reporter);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "", "<init>", "(Ljava/lang/String;I)V", "Dying", "LastSession", "Alive", "kotlin-daemon"})
    public static final class Aliveness
    extends Enum<Aliveness> {
        public static final /* enum */ Aliveness Dying = new Aliveness();
        public static final /* enum */ Aliveness LastSession = new Aliveness();
        public static final /* enum */ Aliveness Alive = new Aliveness();
        private static final /* synthetic */ Aliveness[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Aliveness[] values() {
            return (Aliveness[])$VALUES.clone();
        }

        public static Aliveness valueOf(String value) {
            return Enum.valueOf(Aliveness.class, value);
        }

        @NotNull
        public static EnumEntries<Aliveness> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = alivenessArray = new Aliveness[]{Aliveness.Dying, Aliveness.LastSession, Aliveness.Alive};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0004\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$ClientOrSessionProxy;", "T", "", "aliveFlagPath", "", "data", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Lcom/intellij/openapi/Disposable;)V", "getAliveFlagPath", "()Ljava/lang/String;", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "isAlive", "", "()Z", "dispose", "", "kotlin-daemon"})
    @SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase$ClientOrSessionProxy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1267:1\n1#2:1268\n*E\n"})
    protected static final class ClientOrSessionProxy<T> {
        @Nullable
        private final String aliveFlagPath;
        @Nullable
        private final T data;
        @Nullable
        private Disposable disposable;

        public ClientOrSessionProxy(@Nullable String aliveFlagPath, @Nullable T data, @Nullable Disposable disposable) {
            this.aliveFlagPath = aliveFlagPath;
            this.data = data;
            this.disposable = disposable;
        }

        public /* synthetic */ ClientOrSessionProxy(String string, Object object, Disposable disposable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                object = null;
            }
            if ((n & 4) != 0) {
                disposable = null;
            }
            this(string, object, disposable);
        }

        @Nullable
        public final String getAliveFlagPath() {
            return this.aliveFlagPath;
        }

        @Nullable
        public final T getData() {
            return this.data;
        }

        public final boolean isAlive() {
            boolean bl;
            String string = this.aliveFlagPath;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = new File(it).exists();
            } else {
                bl = true;
            }
            return bl;
        }

        public final void dispose() {
            block0: {
                Disposable disposable = this.disposable;
                if (disposable == null) break block0;
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
                this.disposable = null;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0#JM\u0010$\u001a\u00020%\"\u0004\b\u0000\u0010&*\b\u0012\u0004\u0012\u0002H&0'2\u0006\u0010(\u001a\u00020\u00052\u0014\b\u0004\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020%0*2\u0014\b\u0004\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020\u001f0*H\u0082\bJ\u0006\u0010,\u001a\u00020%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$CompileServiceState;", "", "<init>", "()V", "clientsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "clientProxies", "", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$ClientOrSessionProxy;", "sessions", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$SessionsContainer;", "getSessions", "()Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$SessionsContainer;", "delayedShutdownQueued", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getDelayedShutdownQueued", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "alive", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAlive", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setAlive", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "aliveClientsCount", "", "getAliveClientsCount", "()I", "_clientsCounter", "clientsCounter", "getClientsCounter", "addClient", "", "aliveFlagPath", "", "getClientsFlagPaths", "", "cleanMatching", "", "T", "", "lock", "pred", "Lkotlin/Function1;", "clean", "cleanDeadClients", "kotlin-daemon"})
    @SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase$CompileServiceState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1267:1\n212#1,3:1287\n215#1,4:1293\n219#1,4:1299\n1642#2,10:1268\n1915#2:1278\n1916#2:1280\n1652#2:1281\n777#2:1282\n873#2,2:1283\n1915#2,2:1285\n777#2:1290\n873#2,2:1291\n1915#2,2:1297\n1#3:1279\n*S KotlinDebug\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase$CompileServiceState\n*L\n226#1:1287,3\n226#1:1293,4\n226#1:1299,4\n204#1:1268,10\n204#1:1278\n204#1:1280\n204#1:1281\n214#1:1282\n214#1:1283,2\n218#1:1285,2\n226#1:1290\n226#1:1291,2\n226#1:1297,2\n204#1:1279\n*E\n"})
    protected static final class CompileServiceState {
        @NotNull
        private final ReentrantReadWriteLock clientsLock = new ReentrantReadWriteLock();
        @NotNull
        private final Set<ClientOrSessionProxy<Object>> clientProxies = new HashSet();
        @NotNull
        private final SessionsContainer sessions = new SessionsContainer();
        @NotNull
        private final AtomicBoolean delayedShutdownQueued = new AtomicBoolean(false);
        @NotNull
        private AtomicInteger alive = new AtomicInteger(Aliveness.Alive.ordinal());
        @NotNull
        private final AtomicInteger _clientsCounter = new AtomicInteger(0);

        @NotNull
        public final SessionsContainer getSessions() {
            return this.sessions;
        }

        @NotNull
        public final AtomicBoolean getDelayedShutdownQueued() {
            return this.delayedShutdownQueued;
        }

        @NotNull
        public final AtomicInteger getAlive() {
            return this.alive;
        }

        public final void setAlive(@NotNull AtomicInteger atomicInteger) {
            Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
            this.alive = atomicInteger;
        }

        public final int getAliveClientsCount() {
            return this.clientProxies.size();
        }

        public final int getClientsCounter() {
            return this._clientsCounter.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addClient(@Nullable String aliveFlagPath) {
            ReentrantReadWriteLock reentrantReadWriteLock = this.clientsLock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                this._clientsCounter.incrementAndGet();
                boolean bl2 = this.clientProxies.add(new ClientOrSessionProxy(aliveFlagPath, null, null, 6, null));
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getClientsFlagPaths() {
            List list;
            ReentrantReadWriteLock.ReadLock readLock = this.clientsLock.readLock();
            readLock.lock();
            try {
                void $this$mapNotNullTo$iv$iv;
                boolean bl = false;
                Iterable $this$mapNotNull$iv = this.clientProxies;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    ClientOrSessionProxy it = (ClientOrSessionProxy)element$iv$iv;
                    boolean bl3 = false;
                    if (it.getAliveFlagPath() == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            finally {
                readLock.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final <T> boolean cleanMatching(Iterable<? extends T> $this$cleanMatching, ReentrantReadWriteLock lock, Function1<? super T, Boolean> pred, Function1<? super T, Unit> clean) {
            boolean $i$f$cleanMatching = false;
            boolean anyDead = false;
            ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
            readLock.lock();
            try {
                void $this$filterTo$iv$iv;
                boolean bl = false;
                Iterable<? extends T> $this$filter$iv = $this$cleanMatching;
                boolean $i$f$filter = false;
                Iterable<? extends T> iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)pred.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List toRemove = (List)destination$iv$iv;
                if (!((Collection)toRemove).isEmpty()) {
                    anyDead = true;
                    ReentrantReadWriteLock reentrantReadWriteLock = lock;
                    ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        Iterable $this$forEach$iv = toRemove;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            clean.invoke(element$iv);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        for (int i = 0; i < n; ++i) {
                            readLock2.lock();
                        }
                        writeLock.unlock();
                        InlineMarker.finallyEnd((int)1);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                readLock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return anyDead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final boolean cleanDeadClients() {
            CompileServiceState compileServiceState = this;
            Iterable iterable = this.clientProxies;
            ReentrantReadWriteLock lock$iv = this.clientsLock;
            boolean $i$f$cleanMatching = false;
            boolean anyDead$iv = false;
            ReentrantReadWriteLock.ReadLock readLock = lock$iv.readLock();
            readLock.lock();
            try {
                void $this$filterTo$iv$iv$iv;
                void $this$cleanMatching$iv;
                boolean bl = false;
                void $this$filter$iv$iv = $this$cleanMatching$iv;
                boolean $i$f$filter = false;
                void var10_13 = $this$filter$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                    ClientOrSessionProxy it = (ClientOrSessionProxy)element$iv$iv$iv;
                    boolean bl2 = false;
                    if (!(!it.isAlive())) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                List toRemove$iv = (List)destination$iv$iv$iv;
                if (!((Collection)toRemove$iv).isEmpty()) {
                    anyDead$iv = true;
                    ReentrantReadWriteLock reentrantReadWriteLock = lock$iv;
                    ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl3 = false;
                        Iterable $this$forEach$iv$iv = toRemove$iv;
                        boolean $i$f$forEach = false;
                        for (Object element$iv$iv : $this$forEach$iv$iv) {
                            ClientOrSessionProxy it = (ClientOrSessionProxy)element$iv$iv;
                            boolean bl4 = false;
                            if (!this.clientProxies.remove(it)) continue;
                            it.dispose();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                readLock.unlock();
            }
            return anyDead$iv;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\b\"\b\b\u0000\u0010\u0010*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0019\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\bH\u0086\u0002J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0017\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$SessionsContainer;", "", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "sessions", "", "", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$ClientOrSessionProxy;", "sessionsIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "lastSessionId", "getLastSessionId", "()I", "leaseSession", "T", "session", "isEmpty", "", "get", "sessionId", "remove", "cleanDead", "kotlin-daemon"})
    @SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase$SessionsContainer\n+ 2 KotlinRemoteReplService.kt\norg/jetbrains/kotlin/daemon/KotlinRemoteReplServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1267:1\n178#2,10:1268\n1#3:1278\n507#4,7:1279\n221#5,2:1286\n*S KotlinDebug\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase$SessionsContainer\n*L\n149#1:1268,10\n167#1:1279,7\n171#1:1286,2\n*E\n"})
    protected static final class SessionsContainer {
        @NotNull
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        @NotNull
        private final Map<Integer, ClientOrSessionProxy<Object>> sessions = new HashMap();
        @NotNull
        private final AtomicInteger sessionsIdCounter = new AtomicInteger(0);

        public final int getLastSessionId() {
            return this.sessionsIdCounter.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> int leaseSession(@NotNull ClientOrSessionProxy<? extends T> session) {
            int n;
            Intrinsics.checkNotNullParameter(session, (String)"session");
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n2; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                AtomicInteger counter$iv = this.sessionsIdCounter;
                boolean $i$f$getValidId = false;
                int newId$iv = counter$iv.incrementAndGet();
                int attemptsLeft$iv = 100;
                while (true) {
                    int it = newId$iv;
                    boolean bl2 = false;
                    if (it != 0 && !this.sessions.containsKey(it)) break;
                    if (--attemptsLeft$iv <= 0) {
                        throw new IllegalStateException("Invalid state or algorithm error");
                    }
                    newId$iv = counter$iv.addAndGet(KotlinRemoteReplServiceKt.getInternalRng().nextInt());
                }
                int newId = newId$iv;
                this.sessions.put(newId, session);
                n = newId;
            }
            finally {
                for (int i = 0; i < n2; ++i) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isEmpty() {
            boolean bl;
            ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
            readLock.lock();
            try {
                boolean bl2 = false;
                bl = this.sessions.isEmpty();
            }
            finally {
                readLock.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ClientOrSessionProxy<Object> get(int sessionId) {
            ClientOrSessionProxy<Object> clientOrSessionProxy;
            ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                clientOrSessionProxy = this.sessions.get(sessionId);
            }
            finally {
                readLock.unlock();
            }
            return clientOrSessionProxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean remove(int sessionId) {
            boolean bl;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                ClientOrSessionProxy<Object> clientOrSessionProxy;
                boolean bl2 = false;
                ClientOrSessionProxy<Object> clientOrSessionProxy2 = this.sessions.remove(sessionId);
                if (clientOrSessionProxy2 != null) {
                    ClientOrSessionProxy<Object> clientOrSessionProxy3;
                    ClientOrSessionProxy<Object> $this$remove_u24lambda_u240_u240 = clientOrSessionProxy3 = clientOrSessionProxy2;
                    boolean bl3 = false;
                    $this$remove_u24lambda_u240_u240.dispose();
                    clientOrSessionProxy = clientOrSessionProxy3;
                } else {
                    clientOrSessionProxy = null;
                }
                bl = clientOrSessionProxy != null;
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean cleanDead() {
            boolean anyDead = false;
            ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                Map<Integer, ClientOrSessionProxy<Object>> $this$filterValues$iv = this.sessions;
                boolean $i$f$filterValues = false;
                LinkedHashMap<Integer, ClientOrSessionProxy<Object>> result$iv = new LinkedHashMap<Integer, ClientOrSessionProxy<Object>>();
                for (Map.Entry<Integer, ClientOrSessionProxy<Object>> entry$iv : $this$filterValues$iv.entrySet()) {
                    ClientOrSessionProxy<Object> it = entry$iv.getValue();
                    boolean bl2 = false;
                    if (!(!it.isAlive())) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                Map toRemove = result$iv;
                if (!toRemove.isEmpty()) {
                    anyDead = true;
                    ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
                    ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl3 = false;
                        Map $this$forEach$iv = toRemove;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry it = element$iv = iterator.next();
                            boolean bl4 = false;
                            ClientOrSessionProxy<Object> clientOrSessionProxy = this.sessions.remove(it.getKey());
                            if (clientOrSessionProxy == null) continue;
                            clientOrSessionProxy.dispose();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                readLock.unlock();
            }
            return anyDead;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=176)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[PhaseType.values().length];
            try {
                nArray[PhaseType.Initialization.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Analysis.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.IrLowering.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Backend.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CompileService.TargetPlatform.values().length];
            try {
                nArray[CompileService.TargetPlatform.JVM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompileService.TargetPlatform.JS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompileService.TargetPlatform.METADATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[CompilerMode.values().length];
            try {
                nArray[CompilerMode.JPS_COMPILER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMode.NON_INCREMENTAL_COMPILER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMode.INCREMENTAL_COMPILER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

