/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterBase;
import org.jetbrains.kotlin.build.report.RemoteICReporter;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseKt;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.report.DebugMessagesICReporterKt;

@VisibleForTesting
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0016J&\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/daemon/report/DebugMessagesICReporter;", "Lorg/jetbrains/kotlin/build/report/ICReporterBase;", "Lorg/jetbrains/kotlin/build/report/RemoteICReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "rootDir", "Ljava/io/File;", "reportSeverity", "Lorg/jetbrains/kotlin/build/report/ICReporter$ReportSeverity;", "<init>", "(Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/io/File;Lorg/jetbrains/kotlin/build/report/ICReporter$ReportSeverity;)V", "report", "", "message", "Lkotlin/Function0;", "", "severity", "reportCompileIteration", "incremental", "", "sourceFiles", "", "exitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "flush", "kotlin-daemon"})
public final class DebugMessagesICReporter
extends ICReporterBase
implements RemoteICReporter {
    @NotNull
    private final CompilerServicesFacadeBase servicesFacade;
    @NotNull
    private final ICReporter.ReportSeverity reportSeverity;

    public DebugMessagesICReporter(@NotNull CompilerServicesFacadeBase servicesFacade, @Nullable File rootDir, @NotNull ICReporter.ReportSeverity reportSeverity) {
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)reportSeverity, (String)"reportSeverity");
        super(rootDir);
        this.servicesFacade = servicesFacade;
        this.reportSeverity = reportSeverity;
    }

    public void report(@NotNull Function0<String> message, @NotNull ICReporter.ReportSeverity severity) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        if (severity.getLevel() < this.reportSeverity.getLevel()) {
            return;
        }
        CompilerServicesFacadeBaseKt.report$default(this.servicesFacade, ReportCategory.IC_MESSAGE, DebugMessagesICReporterKt.getSeverity(severity), (String)message.invoke(), null, 8, null);
    }

    public void reportCompileIteration(boolean incremental, @NotNull Collection<? extends File> sourceFiles, @NotNull ExitCode exitCode) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
    }

    public void flush() {
    }
}

