/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcher;
import org.jetbrains.kotlin.daemon.LazyClasspathWatcherKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001!B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher;", "", "classpath", "", "", "checkPeriod", "", "digestCheckPeriod", "<init>", "(Ljava/lang/Iterable;JJ)V", "getCheckPeriod", "()J", "getDigestCheckPeriod", "fileIdsLock", "Ljava/util/concurrent/Semaphore;", "fileIds", "", "Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher$FileId;", "lastChangedStatus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastUpdate", "Ljava/util/concurrent/atomic/AtomicLong;", "lastDigestUpdate", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "isChanged", "", "()Z", "FileId", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nLazyClasspathWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyClasspathWatcher.kt\norg/jetbrains/kotlin/daemon/LazyClasspathWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1557#2:130\n1628#2,3:131\n*S KotlinDebug\n*F\n+ 1 LazyClasspathWatcher.kt\norg/jetbrains/kotlin/daemon/LazyClasspathWatcher\n*L\n62#1:130\n62#1:131,3\n*E\n"})
public final class LazyClasspathWatcher {
    private final long checkPeriod;
    private final long digestCheckPeriod;
    @NotNull
    private final Semaphore fileIdsLock;
    @Nullable
    private List<FileId> fileIds;
    @NotNull
    private final AtomicBoolean lastChangedStatus;
    @NotNull
    private final AtomicLong lastUpdate;
    @NotNull
    private final AtomicLong lastDigestUpdate;
    @NotNull
    private final Lazy log$delegate;

    public LazyClasspathWatcher(@NotNull Iterable<String> classpath, long checkPeriod, long digestCheckPeriod) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        this.checkPeriod = checkPeriod;
        this.digestCheckPeriod = digestCheckPeriod;
        this.fileIdsLock = new Semaphore(1);
        this.lastChangedStatus = new AtomicBoolean(false);
        this.lastUpdate = new AtomicLong(0L);
        this.lastDigestUpdate = new AtomicLong(0L);
        this.log$delegate = LazyKt.lazy(LazyClasspathWatcher::log_delegate$lambda$0);
        this.fileIdsLock.acquire();
        ThreadsKt.thread$default((boolean)true, (boolean)true, null, null, (int)0, () -> LazyClasspathWatcher._init_$lambda$3(this, classpath), (int)28, null);
    }

    public /* synthetic */ LazyClasspathWatcher(Iterable iterable, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = LazyClasspathWatcherKt.getDEFAULT_CLASSPATH_WATCH_PERIOD_MS();
        }
        if ((n & 4) != 0) {
            l2 = LazyClasspathWatcherKt.getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS();
        }
        this(iterable, l, l2);
    }

    public final long getCheckPeriod() {
        return this.checkPeriod;
    }

    public final long getDigestCheckPeriod() {
        return this.digestCheckPeriod;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public final boolean isChanged() {
        FileId fileId;
        if (this.lastChangedStatus.get()) {
            return true;
        }
        long nowMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        if (nowMs - this.lastUpdate.get() < this.checkPeriod) {
            return false;
        }
        boolean checkDigest = nowMs - this.lastDigestUpdate.get() > this.digestCheckPeriod;
        this.fileIdsLock.acquire();
        this.fileIdsLock.release();
        List<FileId> list = this.fileIds;
        if (list != null) {
            Object v2;
            block12: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    boolean bl;
                    FileId it = (FileId)t;
                    boolean bl2 = false;
                    try {
                        boolean bl3;
                        if (!it.getFile().exists()) {
                            this.getLog().info("cp changed: " + it.getFile() + " doesn't exist any more");
                            bl3 = true;
                        } else if ((it.getFile().lastModified() != it.getLastModified() || checkDigest) && !Arrays.equals(it.getDigest(), LazyClasspathWatcherKt.md5Digest(it.getFile()))) {
                            this.getLog().info("cp changed: " + it.getFile() + " digests differ");
                            bl3 = true;
                        } else {
                            bl3 = false;
                        }
                        bl = bl3;
                    }
                    catch (IOException e) {
                        this.getLog().log(Level.INFO, "cp changed: " + it.getFile() + " access throws the exception", e);
                        bl = true;
                    }
                    if (!bl) continue;
                    v2 = t;
                    break block12;
                }
                v2 = null;
            }
            fileId = v2;
        } else {
            fileId = null;
        }
        boolean changed = fileId != null;
        this.lastUpdate.set(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
        if (checkDigest) {
            this.lastDigestUpdate.set(this.lastUpdate.get());
        }
        return changed;
    }

    private static final Logger log_delegate$lambda$0() {
        return Logger.getLogger("classpath watcher");
    }

    private static final Sequence lambda$3$lambda$1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)it, null, (int)1, null)), (Function1)1.2.1.INSTANCE);
    }

    private static final FileId lambda$3$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new FileId(it, it.lastModified(), LazyClasspathWatcherKt.md5Digest(it));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$3(LazyClasspathWatcher this$0, Iterable $classpath) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$classpath, (String)"$classpath");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = $classpath;
            LazyClasspathWatcher lazyClasspathWatcher = this$0;
            boolean $i$f$map = false;
            void var4_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            lazyClasspathWatcher.fileIds = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv)), LazyClasspathWatcher::lambda$3$lambda$1), LazyClasspathWatcher::lambda$3$lambda$2));
            long nowMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this$0.lastUpdate.set(nowMs);
            this$0.lastDigestUpdate.set(nowMs);
        }
        catch (IOException e) {
            this$0.getLog().log(Level.WARNING, "Error on walking classpath", e);
        }
        finally {
            this$0.fileIdsLock.release();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/daemon/LazyClasspathWatcher$FileId;", "", "file", "Ljava/io/File;", "lastModified", "", "digest", "", "<init>", "(Ljava/io/File;J[B)V", "getFile", "()Ljava/io/File;", "getLastModified", "()J", "getDigest", "()[B", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-daemon"})
    private static final class FileId {
        @NotNull
        private final File file;
        private final long lastModified;
        @NotNull
        private final byte[] digest;

        public FileId(@NotNull File file, long lastModified, @NotNull byte[] digest) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            this.file = file;
            this.lastModified = lastModified;
            this.digest = digest;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        @NotNull
        public final byte[] getDigest() {
            return this.digest;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        public final long component2() {
            return this.lastModified;
        }

        @NotNull
        public final byte[] component3() {
            return this.digest;
        }

        @NotNull
        public final FileId copy(@NotNull File file, long lastModified, @NotNull byte[] digest) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            return new FileId(file, lastModified, digest);
        }

        public static /* synthetic */ FileId copy$default(FileId fileId, File file, long l, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                file = fileId.file;
            }
            if ((n & 2) != 0) {
                l = fileId.lastModified;
            }
            if ((n & 4) != 0) {
                byArray = fileId.digest;
            }
            return fileId.copy(file, l, byArray);
        }

        @NotNull
        public String toString() {
            return "FileId(file=" + this.file + ", lastModified=" + this.lastModified + ", digest=" + Arrays.toString(this.digest) + ')';
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Long.hashCode(this.lastModified);
            result = result * 31 + Arrays.hashCode(this.digest);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileId)) {
                return false;
            }
            FileId fileId = (FileId)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)fileId.file)) {
                return false;
            }
            if (this.lastModified != fileId.lastModified) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.digest, (Object)fileId.digest);
        }
    }
}

