/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.EventManagerImpl;
import org.jetbrains.kotlin.daemon.KotlinJvmReplService;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteEnumWhenTracker;
import org.jetbrains.kotlin.daemon.RemoteExpectActualTracker;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalDataProvider;
import org.jetbrains.kotlin.daemon.RemoteIncrementalResultsConsumer;
import org.jetbrains.kotlin.daemon.RemoteInlineConstTracker;
import org.jetbrains.kotlin.daemon.RemoteLookupTrackerClient;
import org.jetbrains.kotlin.daemon.RemoteReplStateFacadeServer;
import org.jetbrains.kotlin.daemon.common.BuildMetricsValue;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.JpsCompilerServicesFacade;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.ReplStateFacade;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.daemon.report.CompileServicesFacadeMessageCollector;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterKt;
import org.jetbrains.kotlin.daemon.report.GetICReporterKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J<\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u00020\u000e2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001f0#\u00a2\u0006\u0002\b%H\u0082\bJ\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001fH\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020-0\u001fH\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0016J\u0018\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001f2\b\u00102\u001a\u0004\u0018\u00010-H\u0016J\u0014\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-040\u001fH\u0016J\u0018\u00105\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\b\u00102\u001a\u0004\u0018\u00010-H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002010\u001f2\u0006\u0010!\u001a\u00020\u000eH\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\bH\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020'0\u001f2\u0006\u0010;\u001a\u000208H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u0002010\u001fH\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u0002080\u001f2\u0006\u0010>\u001a\u000208H\u0016J*\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0@0\u001f2\u0006\u0010!\u001a\u00020\u000e2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0@H\u0016JE\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\u0006\u0010!\u001a\u00020\u000e2\u000e\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010KH\u0016\u00a2\u0006\u0002\u0010LJ\u0016\u0010M\u001a\b\u0012\u0004\u0012\u0002010\u001f2\u0006\u0010!\u001a\u00020\u000eH\u0016J \u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002JS\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001f2\b\u00102\u001a\u0004\u0018\u00010-2\u000e\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020B042\u0006\u0010X\u001a\u00020-H\u0016\u00a2\u0006\u0002\u0010YJ\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0\u001f2\u0006\u0010!\u001a\u00020\u000eH\u0016J&\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0\u001f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020`H\u0016J&\u0010a\u001a\b\u0012\u0004\u0012\u00020b0\u001f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020`H\u0016J\b\u0010c\u001a\u00020\u0013H\u0014J\b\u0010d\u001a\u00020\u0013H\u0014J\b\u0010e\u001a\u00020\u0013H\u0014J\b\u0010f\u001a\u00020\u0013H\u0002J\b\u0010g\u001a\u00020\u0013H\u0002J\u0010\u0010h\u001a\u0002082\u0006\u0010i\u001a\u000208H\u0002J\b\u0010j\u001a\u00020\u0013H\u0016J3\u0010k\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\b\b\u0002\u0010l\u001a\u00020m2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001f0\u0012H\u0082\bJ!\u0010n\u001a\u00020\u00132\b\b\u0002\u0010l\u001a\u00020m2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ3\u0010o\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 2\b\b\u0002\u0010l\u001a\u00020m2\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001f0\u0012H\u0082\bJ!\u0010p\u001a\u00020\u00132\b\b\u0002\u0010l\u001a\u00020m2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010&\u001a\u00020'8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "<init>", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "getRegistry", "()Ljava/rmi/registry/Registry;", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "withValidRepl", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "R", "sessionId", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lkotlin/ExtensionFunctionType;", "lastUsedSeconds", "", "getLastUsedSeconds", "()J", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getDaemonInfo", "", "getKotlinVersion", "getDaemonOptions", "registerClient", "", "aliveFlagPath", "getClients", "", "leaseCompileSession", "releaseCompileSession", "checkCompilerId", "", "expectedCompilerId", "getUsedMemory", "withGC", "shutdown", "scheduleShutdown", "graceful", "classesFqNamesByFiles", "", "sourceFiles", "Ljava/io/File;", "compile", "compilerArguments", "", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "releaseReplSession", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "leaseReplSession", "templateClasspath", "templateClassName", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "replCreateState", "Lorg/jetbrains/kotlin/daemon/common/ReplStateFacade;", "replCheck", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "replStateId", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "replCompile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "periodicAndAfterSessionCheck", "periodicSeldomCheck", "initiateElections", "shutdownNow", "shutdownWithDelay", "gracefulShutdown", "onAnotherThread", "clearJarCache", "ifAlive", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "ifAliveUnit", "ifAliveExclusive", "ifAliveExclusiveUnit", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nCompileServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n+ 2 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImplBase\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 5 CompilerRunnerUtils.kt\norg/jetbrains/kotlin/incremental/CompilerRunnerUtils\n+ 6 IncrementalJsCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCompilerRunnerKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1167:1\n1142#1,2:1180\n1144#1:1194\n1139#1,5:1195\n1144#1:1212\n1139#1,5:1213\n1144#1:1230\n1139#1,5:1231\n1144#1:1248\n1142#1,2:1249\n1144#1:1263\n1139#1,5:1264\n1144#1:1281\n1142#1,2:1282\n1144#1:1296\n1142#1,2:1297\n1144#1:1311\n1139#1,5:1315\n1144#1:1337\n1156#1,2:1338\n1158#1:1352\n1142#1,2:1353\n1144#1:1367\n1139#1,5:1368\n1144#1:1395\n1139#1,5:1396\n1144#1:1831\n1142#1,2:1832\n1144#1:1846\n1142#1,2:1847\n713#1:1858\n1144#1:1874\n1142#1,2:1875\n713#1:1886\n1144#1:1902\n1142#1,2:1903\n713#1:1914\n1144#1:1930\n1146#1,2:1931\n1148#1,2:1942\n1151#1:1947\n1146#1,2:1948\n1148#1,2:1959\n1151#1:1964\n1146#1,2:1965\n1148#1,2:1976\n1151#1:1981\n1146#1,2:1982\n1148#1:1993\n1149#1:2001\n1151#1:2005\n692#2:1168\n565#2,2:1169\n564#2,6:1171\n694#2:1177\n571#2:1178\n695#2:1179\n543#2,12:1182\n543#2,12:1200\n543#2,12:1218\n543#2,12:1236\n543#2,12:1251\n543#2,12:1269\n543#2,12:1284\n543#2,12:1299\n543#2,9:1320\n552#2,3:1334\n543#2,12:1340\n543#2,12:1355\n543#2,9:1373\n565#2,2:1382\n564#2,8:1384\n552#2,3:1392\n543#2,9:1401\n331#2,25:1410\n356#2:1443\n433#2,3:1444\n565#2,2:1447\n564#2,6:1449\n436#2,6:1455\n460#2,4:1461\n442#2:1467\n357#2,6:1468\n363#2,2:1475\n365#2,3:1478\n465#2:1483\n467#2,36:1489\n444#2,5:1525\n571#2:1530\n449#2,2:1531\n368#2:1533\n372#2:1535\n433#2,3:1536\n565#2,2:1539\n564#2,6:1541\n436#2,6:1547\n460#2,4:1553\n442#2:1557\n373#2,11:1558\n465#2:1571\n467#2,36:1577\n444#2,5:1613\n571#2:1618\n449#2,2:1619\n387#2,5:1621\n392#2:1636\n433#2,3:1637\n565#2,2:1640\n564#2,6:1642\n436#2,6:1648\n460#2,4:1654\n442#2:1658\n393#2,10:1659\n465#2:1671\n467#2,36:1677\n444#2,5:1713\n571#2:1718\n449#2,2:1719\n403#2:1721\n405#2:1723\n406#2:1734\n433#2,3:1735\n565#2,2:1738\n564#2,6:1740\n436#2,6:1746\n460#2,4:1752\n442#2:1756\n407#2,10:1757\n465#2:1769\n467#2,36:1775\n444#2,5:1811\n571#2:1816\n449#2,2:1817\n417#2:1819\n419#2,7:1821\n552#2,3:1828\n543#2,12:1834\n543#2,9:1849\n692#2:1859\n565#2,2:1860\n564#2,6:1862\n694#2:1868\n571#2:1869\n695#2:1870\n552#2,3:1871\n543#2,9:1877\n692#2:1887\n565#2,2:1888\n564#2,6:1890\n694#2:1896\n571#2:1897\n695#2:1898\n552#2,3:1899\n543#2,9:1905\n692#2:1915\n565#2,2:1916\n564#2,6:1918\n694#2:1924\n571#2:1925\n695#2:1926\n552#2,3:1927\n543#2,9:1933\n552#2,3:1944\n543#2,9:1950\n552#2,3:1961\n543#2,9:1967\n552#2,3:1978\n543#2,9:1984\n552#2,3:2002\n543#2,12:2008\n543#2,12:2020\n543#2,12:2032\n543#2,12:2044\n1734#3,3:1312\n1863#3:1474\n1864#3:1477\n1863#3:1994\n1863#3,2:1996\n1864#3:1998\n1863#3,2:1999\n90#4,5:1329\n44#4,2:1465\n46#4,2:1481\n90#4,5:1484\n46#4,2:1569\n90#4,5:1572\n46#4,2:1669\n90#4,5:1672\n46#4,2:1767\n90#4,5:1770\n85#5,8:1435\n94#5:1534\n83#5,10:1626\n94#5:1722\n71#6,10:1724\n82#6:1820\n1#7:1995\n13346#8,2:2006\n*S KotlinDebug\n*F\n+ 1 CompileServiceImpl.kt\norg/jetbrains/kotlin/daemon/CompileServiceImpl\n*L\n723#1:1180,2\n723#1:1194\n727#1:1195,5\n727#1:1212\n735#1:1213,5\n735#1:1230\n739#1:1231,5\n739#1:1248\n745#1:1249,2\n745#1:1263\n751#1:1264,5\n751#1:1281\n756#1:1282,2\n756#1:1296\n764#1:1297,2\n764#1:1311\n779#1:1315,5\n779#1:1337\n781#1:1338,2\n781#1:1352\n786#1:1353,2\n786#1:1367\n800#1:1368,5\n800#1:1395\n812#1:1396,5\n812#1:1831\n875#1:1832,2\n875#1:1846\n892#1:1847,2\n893#1:1858\n892#1:1874\n899#1:1875,2\n900#1:1886\n899#1:1902\n908#1:1903,2\n909#1:1914\n908#1:1930\n922#1:1931,2\n922#1:1942,2\n922#1:1947\n944#1:1948,2\n944#1:1959,2\n944#1:1964\n962#1:1965,2\n962#1:1976,2\n962#1:1981\n976#1:1982,2\n976#1:1993\n976#1:2001\n976#1:2005\n713#1:1168\n713#1:1169,2\n713#1:1171,6\n713#1:1177\n713#1:1178\n713#1:1179\n723#1:1182,12\n727#1:1200,12\n735#1:1218,12\n739#1:1236,12\n745#1:1251,12\n751#1:1269,12\n756#1:1284,12\n764#1:1299,12\n779#1:1320,9\n779#1:1334,3\n781#1:1340,12\n786#1:1355,12\n800#1:1373,9\n801#1:1382,2\n801#1:1384,8\n800#1:1392,3\n812#1:1401,9\n813#1:1410,25\n813#1:1443\n813#1:1444,3\n813#1:1447,2\n813#1:1449,6\n813#1:1455,6\n813#1:1461,4\n813#1:1467\n813#1:1468,6\n813#1:1475,2\n813#1:1478,3\n813#1:1483\n813#1:1489,36\n813#1:1525,5\n813#1:1530\n813#1:1531,2\n813#1:1533\n813#1:1535\n813#1:1536,3\n813#1:1539,2\n813#1:1541,6\n813#1:1547,6\n813#1:1553,4\n813#1:1557\n813#1:1558,11\n813#1:1571\n813#1:1577,36\n813#1:1613,5\n813#1:1618\n813#1:1619,2\n813#1:1621,5\n813#1:1636\n813#1:1637,3\n813#1:1640,2\n813#1:1642,6\n813#1:1648,6\n813#1:1654,4\n813#1:1658\n813#1:1659,10\n813#1:1671\n813#1:1677,36\n813#1:1713,5\n813#1:1718\n813#1:1719,2\n813#1:1721\n813#1:1723\n813#1:1734\n813#1:1735,3\n813#1:1738,2\n813#1:1740,6\n813#1:1746,6\n813#1:1752,4\n813#1:1756\n813#1:1757,10\n813#1:1769\n813#1:1775,36\n813#1:1811,5\n813#1:1816\n813#1:1817,2\n813#1:1819\n813#1:1821,7\n812#1:1828,3\n875#1:1834,12\n892#1:1849,9\n893#1:1859\n893#1:1860,2\n893#1:1862,6\n893#1:1868\n893#1:1869\n893#1:1870\n892#1:1871,3\n899#1:1877,9\n900#1:1887\n900#1:1888,2\n900#1:1890,6\n900#1:1896\n900#1:1897\n900#1:1898\n899#1:1899,3\n908#1:1905,9\n909#1:1915\n909#1:1916,2\n909#1:1918,6\n909#1:1924\n909#1:1925\n909#1:1926\n908#1:1927,3\n922#1:1933,9\n922#1:1944,3\n944#1:1950,9\n944#1:1961,3\n962#1:1967,9\n962#1:1978,3\n976#1:1984,9\n976#1:2002,3\n1143#1:2008,12\n1147#1:2020,12\n1157#1:2032,12\n1161#1:2044,12\n775#1:1312,3\n813#1:1474\n813#1:1477\n997#1:1994\n1000#1:1996,2\n997#1:1998\n1031#1:1999,2\n779#1:1329,5\n813#1:1465,2\n813#1:1481,2\n813#1:1484,5\n813#1:1569,2\n813#1:1572,5\n813#1:1669,2\n813#1:1672,5\n813#1:1767,2\n813#1:1770,5\n813#1:1435,8\n813#1:1534\n813#1:1626,10\n813#1:1722\n813#1:1724,10\n813#1:1820\n1056#1:2006,2\n*E\n"})
public final class CompileServiceImpl
extends CompileServiceImplBase
implements CompileService {
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    @NotNull
    private final Function0<Unit> onShutdown;
    @NotNull
    private final ReentrantReadWriteLock rwlock;

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        Intrinsics.checkNotNullParameter(onShutdown, (String)"onShutdown");
        super(daemonOptions, compilerId, port, timer);
        this.registry = registry;
        this.compiler = compiler;
        this.daemonJVMOptions = daemonJVMOptions;
        this.onShutdown = onShutdown;
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        Intrinsics.checkNotNull((Object)remote, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        CompileService stub = (CompileService)remote;
        this.registry.rebind("KotlinJvmCompilerService", stub);
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <R> CompileService.CallResult<R> withValidRepl(int sessionId, Function1<? super KotlinJvmReplService, ? extends CompileService.CallResult<? extends R>> body) {
        Object object;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
        boolean $i$f$withValidRepl = false;
        CompileServiceImplBase this_$iv = this;
        boolean $i$f$withValidReplImpl = false;
        CompileServiceImplBase this_$iv$iv = this_$iv;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId == 0) {
            clientOrSessionProxy = null;
        } else {
            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv).getSessions().get(sessionId);
            if (clientOrSessionProxy == null) {
                object = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                return object;
            }
        }
        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = clientOrSessionProxy;
        try {
            Object object2;
            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv).incrementAndGet();
            CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = session$iv$iv;
            boolean bl = false;
            CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv;
            Object object3 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
            if (object3 == null) {
                object3 = object2 = null;
            }
            if (object3 == null || (object2 = (CompileService.CallResult)body.invoke(object2)) == null) {
                object2 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
            }
            Object object4 = object2;
            object = object4;
            return object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv, CompileServiceImplKt.nowSeconds());
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Override
    protected long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this.get_lastUsedSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getDaemonInfo() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Dying;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<String>("Kotlin daemon on port " + this.getPort());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getKotlinVersion() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl2 = false;
                    try {
                        callResult4 = new CompileService.CallResult.Good<String>(KotlinCompilerVersion.VERSION);
                    }
                    catch (Exception e) {
                        callResult4 = new CompileService.CallResult.Error("Unknown Kotlin version");
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<DaemonOptions>(this.getDaemonOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.getLog().info("getDaemonJVMOptions: " + this.daemonJVMOptions);
                    callResult3 = new CompileService.CallResult.Good<DaemonJVMOptions>(this.daemonJVMOptions);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.getState().addClient(aliveFlagPath);
                    this.getLog().info("Registered a client alive file: " + aliveFlagPath);
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    callResult3 = new CompileService.CallResult.Good<List<String>>(this.getState().getClientsFlagPaths());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    Integer n = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy(aliveFlagPath, null, null, 6, null));
                    int $this$leaseCompileSession_u24lambda_u247_u24lambda_u246 = ((Number)n).intValue();
                    boolean bl3 = false;
                    this.getLog().info("leased a new session " + $this$leaseCompileSession_u24lambda_u247_u24lambda_u246 + ", session alive file: " + aliveFlagPath);
                    Integer n2 = n;
                    callResult3 = new CompileService.CallResult.Good<Integer>(n2);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.getState().getSessions().remove(sessionId);
                    this.getLog().info("cleaning after session " + sessionId);
                    ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
                    ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl3 = false;
                        this.clearJarCache();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                    callResult3 = this.postReleaseCompileSession();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expectedCompilerId, (String)"expectedCompilerId");
        if (!(((CharSequence)this.getCompilerId().getCompilerVersion()).length() == 0)) {
            if (!Intrinsics.areEqual((Object)this.getCompilerId().getCompilerVersion(), (Object)expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $this$all$iv = this.getCompilerId().getCompilerClasspath();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (this.getClasspathWatcher().isChanged()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory(boolean withGC) {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    boolean $i$f$usedMemory = false;
                    if (withGC) {
                        System.gc();
                    }
                    Runtime rt$iv = Runtime.getRuntime();
                    callResult3 = new CompileService.CallResult.Good<Long>(rt$iv.totalMemory() - rt$iv.freeMemory());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2 = false;
                    this.shutdownWithDelay();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl2;
                    boolean bl3 = false;
                    if (graceful) {
                        bl2 = this.gracefulShutdown(true);
                    } else {
                        this.shutdownWithDelay();
                        bl2 = true;
                    }
                    boolean res = bl2;
                    callResult3 = new CompileService.CallResult.Good<Boolean>(res);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Set<String>> classesFqNamesByFiles(int sessionId, @NotNull Set<? extends File> sourceFiles) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this).readLock();
        var5_5.lock();
        try {
            block13: {
                block12: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = this;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block12;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    block14: {
                        $i$a$-ifAlive$default-CompileServiceImpl$classesFqNamesByFiles$1 = false;
                        this_$iv = this;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != 0) break block14;
                        v1 = null;
                        ** GOTO lbl-1000
                    }
                    v1 = CompileServiceImplBase.access$getState(this_$iv).getSessions().get(sessionId);
                    if (v1 == null) {
                        v2 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv).incrementAndGet();
                            it = session$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImpl$classesFqNamesByFiles$1$1 = false;
                            var14_16 = new CompileService.CallResult.Good<Set>(ParseFileUtilsKt.classesFqNames(sourceFiles));
                            v2 = var14_16;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var16_19 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var16_19 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v0 = var16_19;
            }
            var6_7 = v0;
        }
        finally {
            var5_5.unlock();
        }
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> compile(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @Nullable CompilationResults compilationResults) {
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var8_8 = CompileServiceImpl.access$getRwlock$p(this).readLock();
        var8_8.lock();
        try {
            block95: {
                block94: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = this;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block94;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block95;
                }
                try {
                    block97: {
                        block96: {
                            $i$a$-ifAlive$default-CompileServiceImpl$compile$1 = false;
                            this_$iv = this;
                            $i$f$compileImpl = false;
                            $i$a$-run-CompileServiceImplBase$compileImpl$1$iv = false;
                            var17_19 = compilationOptions;
                            p0 /* !! */  = servicesFacade;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$2 = false;
                            messageCollector$iv = new CompileServicesFacadeMessageCollector(p0 /* !! */ , p1);
                            p1 = compilationOptions;
                            p0 /* !! */  = servicesFacade;
                            $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = false;
                            daemonReporter$iv = DaemonMessageReporterKt.DaemonMessageReporter(p0 /* !! */ , p1);
                            targetPlatform$iv = compilationOptions.getTargetPlatform();
                            CompileServiceImplBase.access$getLog(this_$iv).info("Starting compilation with args: " + ArraysKt.joinToString$default((Object[])compilerArguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                            switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[targetPlatform$iv.ordinal()]) {
                                case 1: {
                                    v1 = (CLICompiler)new K2JVMCompiler();
                                    break;
                                }
                                case 2: {
                                    v1 = (CLICompiler)new K2JSCompiler();
                                    break;
                                }
                                case 3: {
                                    v1 = (CLICompiler)new K2MetadataCompiler();
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            compiler$iv = v1;
                            k2PlatformArgs$iv = (CommonCompilerArguments)compiler$iv.createArguments();
                            ParseCommandLineArgumentsKt.parseCommandLineArguments$default((List)ArraysKt.asList((Object[])compilerArguments), (CommonToolArguments)((CommonToolArguments)k2PlatformArgs$iv), (boolean)false, (int)4, null);
                            argumentParseError$iv = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)k2PlatformArgs$iv.getErrors());
                            if (argumentParseError$iv == null) break block96;
                            MessageCollector.report$default((MessageCollector)messageCollector$iv, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)argumentParseError$iv, null, (int)4, null);
                            v2 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                            break block97;
                        }
                        block22 : switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[compilationOptions.getCompilerMode().ordinal()]) {
                            case 1: {
                                (Object)servicesFacade;
                                p0 /* !! */  = (JpsCompilerServicesFacade)servicesFacade;
                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = false;
                                enabled$iv$iv = p0 /* !! */ .hasIncrementalCaches();
                                $i$f$withIncrementalCompilation = false;
                                isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                try {
                                    if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                        k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                    }
                                    $i$a$-withIncrementalCompilation-CompileServiceImplBase$compileImpl$1$1$iv = false;
                                    var30_43 = this_$iv;
                                    tracer$iv$iv = null;
                                    $i$f$doCompile = false;
                                    $this$doCompile_u24lambda_u2418$iv$iv = this_$iv$iv;
                                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("alive!");
                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                    $i$f$withValidClientOrSessionProxy = false;
                                    if (sessionId != 0) ** GOTO lbl84
                                    v3 = null;
                                    ** GOTO lbl88
lbl84:
                                    // 1 sources

                                    v3 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                    if (v3 != null) ** GOTO lbl88
                                    v4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                    ** GOTO lbl202
lbl88:
                                    // 2 sources

                                    session$iv$iv$iv = v3;
                                    try {
                                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                        it$iv$iv = session$iv$iv$iv;
                                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                        rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                        eventManager$iv$iv = new EventManagerImpl();
                                        try {
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("trying get exitCode");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                            $i$f$checkedCompile = false;
                                            try {
                                                var45_108 = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                obj$iv$iv$iv$iv = null;
                                                $i$f$withMeasure = false;
                                                startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                var50_131 = rpcProfiler$iv$iv;
                                                eventManger$iv = eventManager$iv$iv;
                                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv = false;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$3 = profiler$iv;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$1 = eventManger$iv;
                                                p0 /* !! */  = (CompilerCallbackServicesFacade)servicesFacade;
                                                $i$a$-compileImpl-CompileServiceImpl$compile$1$4 = false;
                                                services$iv = this.createCompileServices((CompilerCallbackServicesFacade)p0 /* !! */ , (EventManager)p1, (Profiler)p2);
                                                exitCode$iv = compiler$iv.exec(messageCollector$iv, services$iv, (CommonToolArguments)k2PlatformArgs$iv);
                                                it$iv = var56_159 = compilationResults;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$1$1$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                compilationResult$iv = it$iv;
                                                $this$forEach$iv$iv = CompileServiceImplBase.access$getPerformanceMetrics(this_$iv, compiler$iv);
                                                $i$f$forEach = false;
                                                for (T element$iv$iv : $this$forEach$iv$iv) {
                                                    it$iv = (BuildMetricsValue)element$iv$iv;
                                                    $i$a$-forEach-CompileServiceImplBase$compileImpl$1$1$1$1$1$iv = false;
                                                    compilationResult$iv.add(CompilationResultCategory.BUILD_METRICS.getCode(), it$iv);
                                                }
                                                res$iv$iv$iv$iv = exitCode$iv.getCode();
                                                $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                res$iv$iv$iv = res$iv$iv$iv$iv;
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    withGC$iv$iv$iv$iv = false;
                                                    $i$f$usedMemory = false;
                                                    rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                    v5 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                } else {
                                                    v5 = 0L;
                                                }
                                                endMem$iv$iv$iv = v5;
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                    pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                    rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                    v6 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                    var66_202 = "%+d";
                                                    var70_212 = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                    v7 = String.format(var66_202, Arrays.copyOf(var70_212, ((Object[])var70_212).length));
                                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"format(...)");
                                                    it$iv$iv$iv = v6.append(v7).append(" kb)").toString();
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    for (Object var70_212 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                        obj$iv$iv$iv = var70_212.getKey();
                                                        counters$iv$iv$iv = (PerfCounters)var70_212.getValue();
                                                        it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                        daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                    }
                                                }
                                                v8 = res$iv$iv$iv;
                                            }
                                            catch (Throwable e$iv$iv$iv) {
                                                v9 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                v10 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                v11 = e$iv$iv$iv.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getStackTrace(...)");
                                                v12 = v10.append(ArraysKt.joinToString$default((Object[])v11, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                    v13 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                    v14 = e$iv$iv$iv.getCause();
                                                    Intrinsics.checkNotNull((Object)v14);
                                                    v15 = v14.getStackTrace();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"getStackTrace(...)");
                                                    v16 = v13.append(ArraysKt.joinToString$default((Object[])v15, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                } else {
                                                    v16 = "";
                                                }
                                                v9.log(Level.SEVERE, v12.append(v16).toString());
                                                throw e$iv$iv$iv;
                                            }
                                            exitCode$iv$iv = ((Number)v8).intValue();
                                            var75_219 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                        }
                                        finally {
                                            eventManager$iv$iv.fireCompilationFinished();
                                        }
                                        var18_23 = var75_219;
                                        v4 = var18_23;
                                    }
                                    finally {
                                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                    }
lbl202:
                                    // 2 sources

                                    var19_26 = v4;
                                    v2 = var19_26;
                                    break;
                                }
                                finally {
                                    IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                }
                            }
                            case 2: {
                                enabled$iv$iv = this_$iv;
                                tracer$iv$iv = null;
                                $i$f$doCompile = false;
                                $this$doCompile_u24lambda_u2418$iv$iv = this_$iv$iv;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("alive!");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId == 0) {
                                    v17 = null;
                                } else {
                                    v17 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                    if (v17 == null) {
                                        v2 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                        break;
                                    }
                                }
                                session$iv$iv$iv = v17;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    it$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("trying get exitCode");
                                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            eventManager$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            (EventManager)eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2$iv = false;
                                            exitCode$iv = compiler$iv.exec(messageCollector$iv, Services.EMPTY, (CommonToolArguments)k2PlatformArgs$iv);
                                            perfString$iv = compiler$iv.getDefaultPerformanceManager().renderCompilerPerformance();
                                            v18 = compilationResults;
                                            if (v18 != null) {
                                                it$iv = eventManger$iv = v18;
                                                $i$a$-also-CompileServiceImplBase$compileImpl$1$2$1$iv = false;
                                                Intrinsics.checkNotNull((Object)it$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompilationResults");
                                                exitCode$iv = new String[]{perfString$iv};
                                                it$iv.add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), CollectionsKt.arrayListOf((Object[])exitCode$iv));
                                                v19 = eventManger$iv;
                                            } else {
                                                v19 = null;
                                            }
                                            res$iv$iv$iv$iv = exitCode$iv.getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v20 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v20 = 0L;
                                            }
                                            endMem$iv$iv$iv = v20;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v21 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                rt$iv$iv$iv$iv = "%+d";
                                                $this$forEach$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                v22 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf($this$forEach$iv$iv, $this$forEach$iv$iv.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"format(...)");
                                                it$iv$iv$iv = v21.append(v22).append(" kb)").toString();
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                    obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                    counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                    it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                }
                                            }
                                            v23 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v24 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                            v25 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            v26 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"getStackTrace(...)");
                                            v27 = v25.append(ArraysKt.joinToString$default((Object[])v26, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                v28 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                v29 = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)v29);
                                                v30 = v29.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)v30, (String)"getStackTrace(...)");
                                                v31 = v28.append(ArraysKt.joinToString$default((Object[])v30, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v31 = "";
                                            }
                                            v24.log(Level.SEVERE, v27.append(v31).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v23).intValue();
                                        exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                    }
                                    finally {
                                        eventManager$iv$iv.fireCompilationFinished();
                                    }
                                    var66_203 = exitCode$iv$iv;
                                    v2 = var66_203;
                                    break;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
                            }
                            case 3: {
                                gradleIncrementalArgs$iv = (IncrementalCompilationOptions)compilationOptions;
                                gradleIncrementalServicesFacade$iv = servicesFacade;
                                switch (CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[targetPlatform$iv.ordinal()]) {
                                    case 1: {
                                        enabled$iv$iv = true;
                                        $i$f$withIncrementalCompilation = false;
                                        isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                                        IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                                        try {
                                            if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                                k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withIncrementalCompilation$default-CompileServiceImplBase$compileImpl$1$3$iv = false;
                                            it$iv$iv = this_$iv;
                                            tracer$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u2418$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId != 0) ** GOTO lbl357
                                            v32 = null;
                                            ** GOTO lbl361
lbl357:
                                            // 1 sources

                                            v32 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                            if (v32 != null) ** GOTO lbl361
                                            v33 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                            ** GOTO lbl471
lbl361:
                                            // 2 sources

                                            session$iv$iv$iv = v32;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                                it$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2418$iv$iv).fine("trying get exitCode");
                                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        exitCode$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments");
                                                        v34 = (K2JVMCompilerArguments)k2PlatformArgs$iv;
                                                        v35 = compilationResults;
                                                        Intrinsics.checkNotNull((Object)v35);
                                                        var78_223 = gradleIncrementalArgs$iv;
                                                        var79_225 = v35;
                                                        var80_228 = gradleIncrementalServicesFacade$iv;
                                                        var81_230 = messageCollector$iv;
                                                        var82_232 = gradleIncrementalArgs$iv;
                                                        var83_234 = v34;
                                                        var84_236 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v36 = b;
                                                        Intrinsics.checkNotNull((Object)v36);
                                                        var86_240 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v36, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler(var84_236, var83_234, var82_232, var81_230, var86_240).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v37 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v37 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v37;
                                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                            v38 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            rt$iv$iv$iv$iv = "%+d";
                                                            it$iv$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v39 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(it$iv$iv$iv, ((Object[])it$iv$iv$iv).length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v39, (String)"format(...)");
                                                            it$iv$iv$iv = v38.append(v39).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                            for (Object it$iv$iv$iv : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)it$iv$iv$iv.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v40 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v41 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                                        v42 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v43 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v43, (String)"getStackTrace(...)");
                                                        v44 = v42.append(ArraysKt.joinToString$default((Object[])v43, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v45 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v46 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v46);
                                                            v47 = v46.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v47, (String)"getStackTrace(...)");
                                                            v48 = v45.append(ArraysKt.joinToString$default((Object[])v47, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v48 = "";
                                                        }
                                                        v41.log(Level.SEVERE, v44.append(v48).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v40).intValue();
                                                    exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var66_204 = exitCode$iv$iv;
                                                v33 = var66_204;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl471:
                                            // 2 sources

                                            var80_228 = v33;
                                            v2 = var80_228;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                                        }
                                    }
                                    case 2: {
                                        enabled$iv$iv = true;
                                        $i$f$withJsIC = false;
                                        isJsEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJs();
                                        IncrementalCompilation.setIsEnabledForJs((boolean)true);
                                        try {
                                            if (k2PlatformArgs$iv.getIncrementalCompilation() == null) {
                                                k2PlatformArgs$iv.setIncrementalCompilation(Boolean.valueOf(enabled$iv$iv));
                                            }
                                            $i$a$-withJsIC$default-CompileServiceImplBase$compileImpl$1$4$iv = false;
                                            this_$iv$iv = this_$iv;
                                            tracer$iv$iv = null;
                                            $i$f$doCompile = false;
                                            $this$doCompile_u24lambda_u2418$iv$iv = this_$iv$iv;
                                            $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                            CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u2418$iv$iv).fine("alive!");
                                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                            $i$f$withValidClientOrSessionProxy = false;
                                            if (sessionId != 0) ** GOTO lbl499
                                            v49 = null;
                                            ** GOTO lbl503
lbl499:
                                            // 1 sources

                                            v49 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                                            if (v49 != null) ** GOTO lbl503
                                            v50 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                                            ** GOTO lbl613
lbl503:
                                            // 2 sources

                                            session$iv$iv$iv = v49;
                                            try {
                                                CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                                it$iv$iv = session$iv$iv$iv;
                                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                                rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                                eventManager$iv$iv = new EventManagerImpl();
                                                try {
                                                    CompileServiceImplBase.access$getLog($this$doCompile_u24lambda_u2418$iv$iv).fine("trying get exitCode");
                                                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2418$iv$iv;
                                                    $i$f$checkedCompile = false;
                                                    try {
                                                        $this$withMeasure$iv$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                                        obj$iv$iv$iv$iv = null;
                                                        $i$f$withMeasure = false;
                                                        startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                                        $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                                        (EventManager)eventManager$iv$iv;
                                                        $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1$iv = false;
                                                        Intrinsics.checkNotNull((Object)k2PlatformArgs$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments");
                                                        v51 = (K2JSCompilerArguments)k2PlatformArgs$iv;
                                                        v52 = compilationResults;
                                                        Intrinsics.checkNotNull((Object)v52);
                                                        var87_242 = gradleIncrementalArgs$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = v52;
                                                        c = gradleIncrementalServicesFacade$iv;
                                                        var81_231 = messageCollector$iv;
                                                        var82_233 = gradleIncrementalArgs$iv;
                                                        var83_235 = v51;
                                                        var84_237 = this_$iv;
                                                        $i$a$-compileImpl-CompileServiceImpl$compile$1$5 = false;
                                                        v53 = b;
                                                        Intrinsics.checkNotNull((Object)v53);
                                                        var86_241 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)v53, (IncrementalCompilationOptions)c);
                                                        res$iv$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler(var84_237, var83_235, var82_233, var81_231, var86_241).getCode();
                                                        $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                                        res$iv$iv$iv = res$iv$iv$iv$iv;
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            withGC$iv$iv$iv$iv = false;
                                                            $i$f$usedMemory = false;
                                                            rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                            v54 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                                        } else {
                                                            v54 = 0L;
                                                        }
                                                        endMem$iv$iv$iv = v54;
                                                        CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info("Done with result " + res$iv$iv$iv);
                                                        if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                            pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                            rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                            v55 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                            var56_162 = "%+d";
                                                            it$iv$iv$iv /* !! */  = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                            v56 = String.format(var56_162, Arrays.copyOf(it$iv$iv$iv /* !! */ , it$iv$iv$iv /* !! */ .length));
                                                            Intrinsics.checkNotNullExpressionValue((Object)v56, (String)"format(...)");
                                                            it$iv$iv$iv /* !! */  = v55.append(v56).append(" kb)").toString();
                                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                            daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv /* !! */ );
                                                            CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info((String)it$iv$iv$iv /* !! */ );
                                                            for (Map.Entry var60_175 : rpcProfiler$iv$iv.getCounters().entrySet()) {
                                                                obj$iv$iv$iv = var60_175.getKey();
                                                                counters$iv$iv$iv = (PerfCounters)var60_175.getValue();
                                                                it$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                                $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                                daemonReporter$iv.report(ReportSeverity.INFO, it$iv$iv$iv);
                                                                CompileServiceImplBase.access$getLog(this_$iv$iv$iv).info(it$iv$iv$iv);
                                                            }
                                                        }
                                                        v57 = res$iv$iv$iv;
                                                    }
                                                    catch (Throwable e$iv$iv$iv) {
                                                        v58 = CompileServiceImplBase.access$getLog(this_$iv$iv$iv);
                                                        v59 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                                        v60 = e$iv$iv$iv.getStackTrace();
                                                        Intrinsics.checkNotNullExpressionValue((Object)v60, (String)"getStackTrace(...)");
                                                        v61 = v59.append(ArraysKt.joinToString$default((Object[])v60, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                                        if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                            v62 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                            v63 = e$iv$iv$iv.getCause();
                                                            Intrinsics.checkNotNull((Object)v63);
                                                            v64 = v63.getStackTrace();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v64, (String)"getStackTrace(...)");
                                                            v65 = v62.append(ArraysKt.joinToString$default((Object[])v64, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                                        } else {
                                                            v65 = "";
                                                        }
                                                        v58.log(Level.SEVERE, v61.append(v65).toString());
                                                        throw e$iv$iv$iv;
                                                    }
                                                    exitCode$iv$iv = ((Number)v57).intValue();
                                                    var65_201 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                                }
                                                finally {
                                                    eventManager$iv$iv.fireCompilationFinished();
                                                }
                                                var66_205 = var65_201;
                                                v50 = var66_205;
                                            }
                                            finally {
                                                CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                            }
lbl613:
                                            // 2 sources

                                            var80_229 = v50;
                                            v2 = var80_229;
                                            break block22;
                                        }
                                        finally {
                                            IncrementalCompilation.setIsEnabledForJs((boolean)isJsEnabledBackup$iv$iv);
                                        }
                                    }
                                }
                                throw new IllegalStateException("Incremental compilation is not supported for target platform: " + targetPlatform$iv);
                            }
                            default: {
                                throw new IllegalStateException("Unknown compilation mode " + compilationOptions.getCompilerMode());
                            }
                        }
                    }
                    var89_244 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var89_244 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v0 = var89_244;
            }
            var9_10 = v0;
        }
        finally {
            var8_8.unlock();
        }
        return var9_10;
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseReplSession(int sessionId) {
        return this.releaseCompileSession(sessionId);
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches()) {
            builder.register(IncrementalCompilationComponents.class, (Object)new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasLookupTracker()) {
            builder.register(LookupTracker.class, (Object)new RemoteLookupTrackerClient(facade, eventManager, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, (Object)new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        if (facade.hasExpectActualTracker()) {
            builder.register(ExpectActualTracker.class, (Object)new RemoteExpectActualTracker(facade, rpcProfiler));
        }
        if (facade.hasInlineConstTracker()) {
            builder.register(InlineConstTracker.class, (Object)new RemoteInlineConstTracker(facade, rpcProfiler));
        }
        if (facade.hasEnumWhenTracker()) {
            builder.register(EnumWhenTracker.class, (Object)new RemoteEnumWhenTracker(facade, rpcProfiler));
        }
        if (facade.hasIncrementalResultsConsumer()) {
            builder.register(IncrementalResultsConsumer.class, (Object)new RemoteIncrementalResultsConsumer(facade, eventManager, rpcProfiler));
        }
        if (facade.hasIncrementalDataProvider()) {
            builder.register(IncrementalDataProvider.class, (Object)new RemoteIncrementalDataProvider(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl2 = false;
                    if (compilationOptions.getTargetPlatform() != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable((String)("Disposable for " + Reflection.getOrCreateKotlinClass(CompileServiceImpl.class).getSimpleName() + ".leaseReplSession"));
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                        Disposable disposable2 = disposable;
                        CompileServicesFacadeMessageCollector messageCollector = new CompileServicesFacadeMessageCollector(servicesFacade, compilationOptions);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, null);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplStateFacade> replCreateState(int sessionId) {
        var2_2 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv).readLock();
        var5_5.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$replCreateState$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != 0) break block17;
                        v1 = null;
                        ** GOTO lbl-1000
                    }
                    v1 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (v1 == null) {
                        v2 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                    } else lbl-1000:
                    // 2 sources

                    {
                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            v3 = session$iv$iv;
                            v4 = v3 != null ? v3.getData() : null;
                            if (v4 == null) {
                                v4 = null;
                            }
                            if (v4 != null) {
                                $this$replCreateState_u24lambda_u2423_u24lambda_u2422 = (KotlinJvmReplService)v4;
                                $i$a$-withValidRepl-CompileServiceImpl$replCreateState$1$1 = false;
                                v5 = new CompileService.CallResult.Good<RemoteReplStateFacadeServer>($this$replCreateState_u24lambda_u2423_u24lambda_u2422.createRemoteState(this.getPort()));
                            } else {
                                v5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            var22_26 = v5;
                            v2 = var22_26;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var23_27 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var23_27 = new CompileService.CallResult.Error(e$iv$iv);
                }
                v0 = var23_27;
            }
            var6_7 = v0;
        }
        finally {
            var5_5.unlock();
        }
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> replCheck(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block15: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block14: {
                    boolean bl = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    boolean $i$f$ifAliveChecksImpl = false;
                    int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block14;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    CompileService.CallResult callResult4;
                    block12: {
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        CompileServiceImplBase this_$iv$iv$iv;
                        block17: {
                            block16: {
                                boolean bl = false;
                                CompileServiceImpl this_$iv2 = this;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase this_$iv$iv2 = this_$iv2;
                                boolean $i$f$withValidReplImpl = false;
                                this_$iv$iv$iv = this_$iv$iv2;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != 0) break block16;
                                clientOrSessionProxy = null;
                                break block17;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                            if (clientOrSessionProxy != null) break block17;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                            break block12;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block19: {
                                block18: {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block18;
                                    KotlinJvmReplService $this$replCheck_u24lambda_u2426_u24lambda_u2425 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl2 = false;
                                    CompileService.CallResult callResult7 = $this$replCheck_u24lambda_u2426_u24lambda_u2425.withValidReplState(replStateId, arg_0 -> CompileServiceImpl.replCheck$lambda$26$lambda$25$lambda$24($this$replCheck_u24lambda_u2426_u24lambda_u2425, codeLine, arg_0));
                                    callResult5 = callResult7;
                                    if (callResult7 != null) break block19;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            CompileService.CallResult callResult8 = callResult5;
                            callResult4 = callResult8;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> replCompile(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block15: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block14: {
                    boolean bl = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    boolean $i$f$ifAliveChecksImpl = false;
                    int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block14;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block15;
                }
                try {
                    CompileService.CallResult callResult4;
                    block12: {
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        CompileServiceImplBase this_$iv$iv$iv;
                        block17: {
                            block16: {
                                boolean bl = false;
                                CompileServiceImpl this_$iv2 = this;
                                boolean $i$f$withValidRepl = false;
                                CompileServiceImplBase this_$iv$iv2 = this_$iv2;
                                boolean $i$f$withValidReplImpl = false;
                                this_$iv$iv$iv = this_$iv$iv2;
                                boolean $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != 0) break block16;
                                clientOrSessionProxy = null;
                                break block17;
                            }
                            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                            if (clientOrSessionProxy != null) break block17;
                            callResult4 = new CompileService.CallResult.Error("Unknown or invalid session " + sessionId);
                            break block12;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv$iv = clientOrSessionProxy;
                        try {
                            CompileService.CallResult callResult5;
                            block19: {
                                block18: {
                                    CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = session$iv$iv$iv;
                                    boolean bl = false;
                                    CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2 = session$iv$iv;
                                    CompileService.CallResult callResult6 = clientOrSessionProxy2 != null ? clientOrSessionProxy2.getData() : null;
                                    if (callResult6 == null) {
                                        callResult6 = callResult5 = null;
                                    }
                                    if (callResult6 == null) break block18;
                                    KotlinJvmReplService $this$replCompile_u24lambda_u2429_u24lambda_u2428 = (KotlinJvmReplService)((Object)callResult5);
                                    boolean bl2 = false;
                                    CompileService.CallResult callResult7 = $this$replCompile_u24lambda_u2429_u24lambda_u2428.withValidReplState(replStateId, arg_0 -> CompileServiceImpl.replCompile$lambda$29$lambda$28$lambda$27($this$replCompile_u24lambda_u2429_u24lambda_u2428, codeLine, arg_0));
                                    callResult5 = callResult7;
                                    if (callResult7 != null) break block19;
                                }
                                callResult5 = new CompileService.CallResult.Error("Not a REPL session " + sessionId);
                            }
                            CompileService.CallResult callResult8 = callResult5;
                            callResult4 = callResult8;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void periodicAndAfterSessionCheck() {
        block24: {
            block23: {
                block22: {
                    block27: {
                        if (this.getState().getDelayedShutdownQueued().get()) {
                            return;
                        }
                        anyDead = this.getState().getSessions().cleanDead() != false || this.getState().cleanDeadClients() != false;
                        var2_2 = this;
                        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                        $i$f$ifAliveUnit = false;
                        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
                        var5_5.lock();
                        $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                        this_$iv$iv = this_$iv;
                        $i$f$ifAliveChecksImpl = false;
                        curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv >= minAliveness$iv.ordinal()) break block27;
                        CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                        (CompileService.CallResult)new CompileService.CallResult.Dying();
                        ** GOTO lbl61
                    }
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = false;
                    if (this.getState().getAlive().get() != CompileServiceImplBase.Aliveness.LastSession.ordinal() || !this.getState().getSessions().isEmpty()) break block22;
                    this.getLog().info("All sessions finished");
                    this.shutdownWithDelay();
                    var5_5.unlock();
                    return;
                }
                if (this.getState().getAliveClientsCount() != 0) break block23;
                this.getLog().info("No more clients left");
                this.shutdownWithDelay();
                var5_5.unlock();
                return;
            }
            if (this.getRunFile().exists()) break block24;
            this.getLog().info("Run file removed");
            this.shutdownWithDelay();
            var5_5.unlock();
            return;
        }
        try {
            $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = new CompileService.CallResult.Ok();
            {
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
lbl61:
            // 3 sources

            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = Unit.INSTANCE;
        }
        catch (Throwable $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv) {
            throw $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv;
        }
        finally {
            var5_5.unlock();
        }
        this_$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAliveUnit = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv).readLock();
        var5_5.lock();
        try {
            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
            this_$iv$iv = this_$iv;
            $i$f$ifAliveChecksImpl = false;
            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                (CompileService.CallResult)new CompileService.CallResult.Dying();
            } else {
                try {
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$2 = false;
                    if (this.getDaemonOptions().getAutoshutdownUnusedSeconds() != 0 && this.getCompilationsCounter().get() == 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownUnusedSeconds()) {
                        this.getLog().info("Unused timeout exceeded " + this.getDaemonOptions().getAutoshutdownUnusedSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (this.getDaemonOptions().getAutoshutdownIdleSeconds() != 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownIdleSeconds()) {
                        this.getLog().info("Idle timeout exceeded " + this.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (anyDead) {
                        this.clearJarCache();
                    }
                    var10_18 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var10_16 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var6_10 = Unit.INSTANCE;
        }
        finally {
            var5_5.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void periodicSeldomCheck() {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = ((CompileServiceImpl)this_$iv).rwlock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (this.getClasspathWatcher().isChanged()) {
                        this.getLog().info("Compiler changed.");
                        this.gracefulShutdown(false);
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void initiateElections() {
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAliveUnit = false;
        var3_3 = CompileServiceImpl.access$getRwlock$p(this).readLock();
        var3_3.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                    this_$iv$iv = this;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    (CompileService.CallResult)new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        block18: {
                            $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                            $i$a$-ifAliveUnit$default-CompileServiceImpl$initiateElections$1 = false;
                            this.getLog().info("initiate elections");
                            aliveWithOpts = SequencesKt.toList(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.getDaemonOptions())), this.getCompilerId(), this.getRunFile(), (Function2<? super File, ? super Integer, Boolean>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, initiateElections$lambda$45$lambda$33(org.jetbrains.kotlin.daemon.CompileServiceImpl java.io.File int ), (Ljava/io/File;Ljava/lang/Integer;)Ljava/lang/Boolean;)((CompileServiceImpl)this), (Function2<? super DaemonReportCategory, ? super String, Unit>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, initiateElections$lambda$45$lambda$34(org.jetbrains.kotlin.daemon.CompileServiceImpl org.jetbrains.kotlin.daemon.common.DaemonReportCategory java.lang.String ), (Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;Ljava/lang/String;)Lkotlin/Unit;)((CompileServiceImpl)this)));
                            var11_15 = new DaemonJVMOptionsMemoryComparator();
                            var11_15 = new Comparator(var11_15){
                                final /* synthetic */ Comparator $comparator;
                                {
                                    this.$comparator = $comparator;
                                }

                                public final int compare(T a, T b) {
                                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)b;
                                    Comparator comparator = this.$comparator;
                                    boolean bl = false;
                                    DaemonWithMetadata it = (DaemonWithMetadata)a;
                                    DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                                    bl = false;
                                    DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                                    return comparator.compare(daemonJVMOptions, daemonJVMOptions2);
                                }
                            };
                            var12_16 = new FileAgeComparator();
                            comparator = new Comparator(var11_15, var12_16){
                                final /* synthetic */ Comparator $this_thenBy;
                                final /* synthetic */ Comparator $comparator;
                                {
                                    this.$this_thenBy = $receiver;
                                    this.$comparator = $comparator;
                                }

                                public final int compare(T a, T b) {
                                    int n;
                                    int previousCompare = this.$this_thenBy.compare(a, b);
                                    if (previousCompare != 0) {
                                        n = previousCompare;
                                    } else {
                                        DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                                        Comparator comparator = this.$comparator;
                                        boolean bl = false;
                                        DaemonWithMetadata it = (DaemonWithMetadata)b;
                                        File file = it.getRunFile();
                                        bl = false;
                                        File file2 = it.getRunFile();
                                        n = comparator.compare(file, file2);
                                    }
                                    return n;
                                }
                            };
                            v0 = (DaemonWithMetadata)CollectionsKt.maxWithOrNull((Iterable)aliveWithOpts, (Comparator)comparator);
                            if (v0 == null) break block17;
                            bestDaemonWithMetadata = v0;
                            $i$a$-let-CompileServiceImpl$initiateElections$1$1 = false;
                            fattestOpts = bestDaemonWithMetadata.getJvmOptions();
                            if (!DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.daemonJVMOptions)) break block18;
                            if (new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) >= 0) break block18;
                            this.getLog().info("Assuming other daemons have lower prio, taking clients from them and schedule them to shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            $this$forEach$iv = aliveWithOpts;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                var21_28 = (DaemonWithMetadata)element$iv;
                                $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$1 = false;
                                daemon = var21_28.component1();
                                runFile = var21_28.component2();
                                try {
                                    it = var25_36 = daemon.getClients();
                                    $i$a$-takeIf-CompileServiceImpl$initiateElections$1$1$1$1 = false;
                                    v1 = it.isGood() != false ? var25_36 : null;
                                    if (v1 != null) {
                                        it = v1;
                                        $i$a$-let-CompileServiceImpl$initiateElections$1$1$1$2 = false;
                                        $this$forEach$iv = it.get();
                                        $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            clientAliveFile = (String)element$iv;
                                            $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$1$2$1 = false;
                                            this.registerClient(clientAliveFile);
                                        }
                                    }
                                    daemon.scheduleShutdown(true);
                                }
                                catch (Throwable e) {
                                    this.getLog().info("Cannot connect to a daemon, assuming dying ('" + FilesKt.normalize((File)runFile).getAbsolutePath() + "'): " + e.getMessage());
                                }
                            }
                            break block17;
                        }
                        if (!DaemonParamsKt.memorywiseFitsInto(this.daemonJVMOptions, fattestOpts)) ** GOTO lbl-1000
                        if (new FileAgeComparator().compare(bestDaemonWithMetadata.getRunFile(), this.getRunFile()) > 0) {
                            this.getLog().info("Assuming other daemons have higher prio, handover clients to it and schedule shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                            it = var18_23 = this.getClients();
                            $i$a$-takeIf-CompileServiceImpl$initiateElections$1$1$2 = false;
                            v2 = it.isGood() != false ? var18_23 : null;
                            if (v2 != null) {
                                it = v2;
                                $i$a$-let-CompileServiceImpl$initiateElections$1$1$3 = false;
                                $this$forEach$iv = it.get();
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    $i$a$-forEach-CompileServiceImpl$initiateElections$1$1$3$1 = false;
                                    bestDaemonWithMetadata.getDaemon().registerClient(it);
                                }
                            }
                            this.scheduleShutdown(true);
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.getLog().info("Assuming other daemons have equal prio, continue: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + bestDaemonWithMetadata.getRunFile().getName() + " (" + bestDaemonWithMetadata.getRunFile().lastModified() + ')');
                        }
                    }
                    var8_11 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var8_12 = new CompileService.CallResult.Error(e$iv$iv);
                }
            }
            var4_5 = Unit.INSTANCE;
        }
        finally {
            var3_3.unlock();
        }
    }

    private final void shutdownNow() {
        this.getLog().info("Shutdown started");
        Runtime $this$shutdownNow_u24lambda_u2446 = Runtime.getRuntime();
        boolean bl = false;
        this.getLog().info("Memory stats: total: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2446.totalMemory()) + "mb, free: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2446.freeMemory()) + "mb, max: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2446.maxMemory()) + "mb");
        this.getState().getAlive().set(CompileServiceImplBase.Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.onShutdown.invoke();
        Handler[] handlerArray = this.getLog().getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"getHandlers(...)");
        Object[] $this$forEach$iv = handlerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Handler it = (Handler)element$iv;
            boolean bl2 = false;
            it.flush();
        }
    }

    private final void shutdownWithDelay() {
        this.getState().getDelayedShutdownQueued().set(true);
        int currentClientsCount = this.getState().getClientsCounter();
        int currentSessionId = this.getState().getSessions().getLastSessionId();
        int currentCompilationsCount = this.getCompilationsCounter().get();
        this.getLog().info("Delayed shutdown in " + this.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
        Timer timer = this.getTimer();
        long l = this.getDaemonOptions().getShutdownDelayMilliseconds();
        TimerTask timerTask = new TimerTask(this, currentClientsCount, currentCompilationsCount, currentSessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentClientsCount$inlined;
            final /* synthetic */ int $currentCompilationsCount$inlined;
            final /* synthetic */ int $currentSessionId$inlined;
            {
                this.this$0 = compileServiceImpl;
                this.$currentClientsCount$inlined = n;
                this.$currentCompilationsCount$inlined = n2;
                this.$currentSessionId$inlined = n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                TimerTask $this$shutdownWithDelay_u24lambda_u2449 = this;
                boolean bl = false;
                this.this$0.getState().getDelayedShutdownQueued().set(false);
                if (this.$currentClientsCount$inlined == this.this$0.getState().getClientsCounter() && this.$currentCompilationsCount$inlined == this.this$0.getCompilationsCounter().get() && this.$currentSessionId$inlined == this.this$0.getState().getSessions().getLastSessionId()) {
                    void this_$iv;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
                        boolean $i$f$ifAliveChecksImpl = false;
                        int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv < minAliveness$iv.ordinal()) {
                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                            CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                        } else {
                            CompileService.CallResult callResult;
                            try {
                                boolean bl3 = false;
                                boolean bl4 = false;
                                this.this$0.getLog().fine("Execute delayed shutdown");
                                CompileServiceImpl.access$shutdownNow(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                callResult = new CompileService.CallResult.Error(e$iv$iv);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
                this.this$0.getLog().info("Cancel delayed shutdown due to a new activity");
            }
        };
        timer.schedule(timerTask, l);
    }

    private final boolean gracefulShutdown(boolean onAnotherThread) {
        if (!this.getState().getAlive().compareAndSet(CompileServiceImplBase.Aliveness.Alive.ordinal(), CompileServiceImplBase.Aliveness.LastSession.ordinal())) {
            this.getLog().info("Invalid state for graceful shutdown: " + this.toAlivenessName(this.getState().getAlive().get()));
            return false;
        }
        this.getLog().info("Graceful shutdown signalled");
        if (!onAnotherThread) {
            CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this);
        } else {
            Timer timer = this.getTimer();
            long l = 1L;
            TimerTask timerTask = new TimerTask(this){
                final /* synthetic */ CompileServiceImpl this$0;
                {
                    this.this$0 = compileServiceImpl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void run() {
                    void this_$iv;
                    TimerTask $this$gracefulShutdown_u24lambda_u2451 = this;
                    boolean bl = false;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl2 = false;
                        CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
                        boolean $i$f$ifAliveChecksImpl = false;
                        int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv < minAliveness$iv.ordinal()) {
                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                            CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                        } else {
                            CompileService.CallResult callResult;
                            try {
                                boolean bl3 = false;
                                boolean bl4 = false;
                                CompileServiceImpl.access$gracefulShutdown$shutdownIfIdle(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                callResult = new CompileService.CallResult.Error(e$iv$iv);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
            };
            timer.schedule(timerTask, l);
        }
        return true;
    }

    @Override
    public void clearJarCache() {
        block2: {
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment;
            ZipHandler.clearFileAccessorCache();
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment2 = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            if (kotlinCoreApplicationEnvironment2 == null) break block2;
            KotlinCoreApplicationEnvironment $this$clearJarCache_u24lambda_u2452 = kotlinCoreApplicationEnvironment = kotlinCoreApplicationEnvironment2;
            boolean bl = false;
            VirtualFileSystem virtualFileSystem = $this$clearJarCache_u24lambda_u2452.getJarFileSystem();
            CoreJarFileSystem coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
            if (coreJarFileSystem != null) {
                coreJarFileSystem.clearHandlersCache();
            }
            virtualFileSystem = $this$clearJarCache_u24lambda_u2452.getJrtFileSystem();
            CoreJrtFileSystem coreJrtFileSystem = virtualFileSystem instanceof CoreJrtFileSystem ? (CoreJrtFileSystem)virtualFileSystem : null;
            if (coreJrtFileSystem != null) {
                coreJrtFileSystem.clearRoots();
            }
            $this$clearJarCache_u24lambda_u2452.idleCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAlive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = $this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock.ReadLock readLock = $this.rwlock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = $this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl2 = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAliveExclusive$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusive = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl = false;
            CompileServiceImplBase this_$iv = $this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult3 = new CompileService.CallResult.Error(e$iv);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveExclusiveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult;
                try {
                    boolean bl2 = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveExclusiveUnit$default(CompileServiceImpl $this, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusiveUnit = false;
        object = $this.rwlock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            CompileServiceImplBase this_$iv = $this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult;
                try {
                    boolean bl2 = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    callResult = new CompileService.CallResult.Error(e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final ReplCheckResult replCheck$lambda$26$lambda$25$lambda$24(KotlinJvmReplService $this_withValidRepl, ReplCodeLine $codeLine, IReplStageState state) {
        Intrinsics.checkNotNullParameter((Object)$this_withValidRepl, (String)"$this_withValidRepl");
        Intrinsics.checkNotNullParameter((Object)$codeLine, (String)"$codeLine");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $this_withValidRepl.check(state, $codeLine);
    }

    private static final ReplCompileResult replCompile$lambda$29$lambda$28$lambda$27(KotlinJvmReplService $this_withValidRepl, ReplCodeLine $codeLine, IReplStageState state) {
        Intrinsics.checkNotNullParameter((Object)$this_withValidRepl, (String)"$this_withValidRepl");
        Intrinsics.checkNotNullParameter((Object)$codeLine, (String)"$codeLine");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return $this_withValidRepl.compile(state, $codeLine);
    }

    private static final boolean initiateElections$lambda$45$lambda$33(CompileServiceImpl this$0, File file, int p) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)file, (String)"<unused var>");
        return p != this$0.getPort();
    }

    private static final Unit initiateElections$lambda$45$lambda$34(CompileServiceImpl this$0, DaemonReportCategory daemonReportCategory, String msg) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)daemonReportCategory), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.getLog().info(msg);
        return Unit.INSTANCE;
    }

    private static final long shutdownNow$mb(long $this$shutdownNow_u24mb) {
        return $this$shutdownNow_u24mb / (long)0x100000;
    }

    private static final void gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        if (this$0.getState().getSessions().isEmpty()) {
            this$0.shutdownWithDelay();
        } else {
            this$0.getDaemonOptions().setAutoshutdownIdleSeconds((int)TimeUnit.MILLISECONDS.toSeconds(this$0.getDaemonOptions().getForceShutdownTimeoutMilliseconds()));
            this$0.getDaemonOptions().setAutoshutdownUnusedSeconds(this$0.getDaemonOptions().getAutoshutdownIdleSeconds());
            this$0.getLog().info("Some sessions are active, waiting for them to finish");
            this$0.getLog().info("Unused/idle timeouts are set to " + this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + '/' + this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
        }
    }

    public static final /* synthetic */ void access$shutdownNow(CompileServiceImpl $this) {
        $this.shutdownNow();
    }

    public static final /* synthetic */ void access$gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this$0);
    }
}

