/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0013\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcher;", "", "pattern", "", "<init>", "(Ljava/lang/String;)V", "getPattern", "()Ljava/lang/String;", "key", "getKey", "mask", "", "getMask", "()I", "regex", "Lkotlin/text/Regex;", "matches", "", "name", "Lorg/jetbrains/kotlin/name/FqName;", "equals", "other", "hashCode", "Companion", "kotlin-compose-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nStabilityExternalClassNameMatching.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StabilityExternalClassNameMatching.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n1557#2:238\n1628#2,3:239\n2691#2,8:242\n*S KotlinDebug\n*F\n+ 1 StabilityExternalClassNameMatching.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcher\n*L\n194#1:238\n194#1:239,3\n195#1:242,8\n*E\n"})
public final class FqNameMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    @NotNull
    private final String key;
    private final int mask;
    @Nullable
    private final Regex regex;
    @NotNull
    private static final String PATTERN_SINGLE_WILD = "\\w+";
    @NotNull
    private static final String PATTERN_MULTI_WILD = "[\\w\\.]+";
    @NotNull
    private static final String PATTERN_PACKAGE_SEGMENT = "\\.";
    @NotNull
    private static final Regex validPatternMatcher = new Regex("((\\w+\\*{0,2}|\\*{1,2})\\.)*((\\w+(<?(?<genericmask>([*|_],)*[*|_])>)+)|(\\w+\\*{0,2}|\\*{1,2}))");
    @NotNull
    private static final Regex singleWildcardSuffix = new Regex("\\w+");
    @NotNull
    private static final Regex multiWildcardSuffix = new Regex("[\\w\\.]+");

    /*
     * WARNING - void declaration
     */
    public FqNameMatcher(@NotNull String pattern) {
        Regex regex;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        MatchResult matchResult = validPatternMatcher.matchEntire((CharSequence)this.pattern);
        if (matchResult == null) {
            throw new IllegalStateException((this.pattern + " is not a valid pattern").toString());
        }
        MatchResult matchResult2 = matchResult;
        StringBuilder regexPatternBuilder = new StringBuilder();
        StringBuilder keyBuilder = new StringBuilder();
        boolean hasWildcard = false;
        boolean hitGenericOpener = false;
        block5: for (int index = 0; index < this.pattern.length() && !hitGenericOpener; ++index) {
            char c = this.pattern.charAt(index);
            switch (c) {
                case '*': {
                    Object object;
                    hasWildcard = true;
                    Character c2 = StringsKt.getOrNull((CharSequence)this.pattern, (int)(index + 1));
                    char c3 = '*';
                    if (c2 != null && c2.charValue() == c3) {
                        regexPatternBuilder.append(PATTERN_MULTI_WILD);
                        object = index++;
                        continue block5;
                    }
                    object = regexPatternBuilder.append(PATTERN_SINGLE_WILD);
                    continue block5;
                }
                case '.': {
                    Object object;
                    if (hasWildcard) {
                        object = regexPatternBuilder.append(PATTERN_PACKAGE_SEGMENT);
                        continue block5;
                    }
                    object = keyBuilder.append('.');
                    continue block5;
                }
                case '<': {
                    hitGenericOpener = true;
                    Object object = Unit.INSTANCE;
                    continue block5;
                }
                default: {
                    Object object = hasWildcard ? regexPatternBuilder.append(c) : keyBuilder.append(c);
                }
            }
        }
        if (((CharSequence)regexPatternBuilder).length() > 0) {
            String string = regexPatternBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String regexPattern = string;
            regex = Intrinsics.areEqual((Object)regexPattern, (Object)singleWildcardSuffix.getPattern()) ? singleWildcardSuffix : (Intrinsics.areEqual((Object)regexPattern, (Object)multiWildcardSuffix.getPattern()) ? multiWildcardSuffix : new Regex(regexPattern));
        } else {
            regex = null;
        }
        this.regex = regex;
        MatchGroup genericMask = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"genericmask");
        if (genericMask == null) {
            this.key = keyBuilder.toString();
            this.mask = -1;
        } else {
            void $this$reduceIndexed$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)genericMask.getValue(), (String[])object, (boolean)false, (int)0, (int)6, null);
            FqNameMatcher fqNameMatcher = this;
            boolean $i$f$map = false;
            void var11_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Intrinsics.areEqual((Object)it, (Object)"*") ? 1 : 0);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduceIndexed = false;
            Iterator iterator$iv = $this$reduceIndexed$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            int index$iv = 1;
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void flag;
                void acc;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int item$iv$iv = ((Number)iterator$iv.next()).intValue();
                int it = ((Number)accumulator$iv).intValue();
                int i = n;
                boolean bl = false;
                accumulator$iv = acc | flag << i;
            }
            fqNameMatcher.mask = ((Number)accumulator$iv).intValue();
            this.key = ((Object)keyBuilder.subSequence(0, genericMask.getRange().getFirst() - 1)).toString();
        }
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public final int getMask() {
        return this.mask;
    }

    public final boolean matches(@Nullable FqName name) {
        if (Intrinsics.areEqual((Object)this.pattern, (Object)"**")) {
            return true;
        }
        Object object = name;
        if (object == null || (object = object.asString()) == null) {
            return false;
        }
        Object nameStr = object;
        String string = ((String)nameStr).substring(this.key.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String suffix = string;
        return this.regex != null ? StringsKt.startsWith$default((String)nameStr, (String)this.key, (boolean)false, (int)2, null) && this.regex.matches((CharSequence)suffix) : Intrinsics.areEqual((Object)this.key, (Object)name.asString());
    }

    public boolean equals(@Nullable Object other) {
        FqNameMatcher fqNameMatcher = other instanceof FqNameMatcher ? (FqNameMatcher)other : null;
        if (fqNameMatcher == null) {
            return false;
        }
        FqNameMatcher otherMatcher = fqNameMatcher;
        return Intrinsics.areEqual((Object)this.pattern, (Object)otherMatcher.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/compose/compiler/plugins/kotlin/analysis/FqNameMatcher$Companion;", "", "<init>", "()V", "PATTERN_SINGLE_WILD", "", "PATTERN_MULTI_WILD", "PATTERN_PACKAGE_SEGMENT", "validPatternMatcher", "Lkotlin/text/Regex;", "singleWildcardSuffix", "multiWildcardSuffix", "kotlin-compose-compiler-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

