/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.k1;

import androidx.compose.compiler.plugins.kotlin.k1.InferenceDescriptorType;
import androidx.compose.compiler.plugins.kotlin.k1.InferenceKotlinType;
import androidx.compose.compiler.plugins.kotlin.k1.InferenceNode;
import androidx.compose.compiler.plugins.kotlin.k1.InferenceNodeType;
import androidx.compose.compiler.plugins.kotlin.k1.InferenceUnknownType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Landroidx/compose/compiler/plugins/kotlin/k1/PsiElementNode;", "Landroidx/compose/compiler/plugins/kotlin/k1/InferenceNode;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "type", "Landroidx/compose/compiler/plugins/kotlin/k1/InferenceNodeType;", "getType", "()Landroidx/compose/compiler/plugins/kotlin/k1/InferenceNodeType;", "descriptorTypeOf", "kotlinTypeOf", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin-compose-compiler-plugin"})
final class PsiElementNode
extends InferenceNode {
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final InferenceNodeType type;

    public PsiElementNode(@NotNull PsiElement element, @NotNull BindingContext bindingContext) {
        InferenceNodeType inferenceNodeType;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        super(element, null);
        this.bindingContext = bindingContext;
        PsiElement psiElement = element;
        if (psiElement instanceof KtLambdaExpression) {
            KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)element).getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
            inferenceNodeType = this.descriptorTypeOf((PsiElement)ktFunctionLiteral);
        } else {
            inferenceNodeType = psiElement instanceof KtFunctionLiteral || psiElement instanceof KtFunction ? this.descriptorTypeOf(element) : (psiElement instanceof KtProperty ? this.kotlinTypeOf((KtExpression)element) : (psiElement instanceof KtPropertyAccessor ? this.kotlinTypeOf((KtExpression)element) : (psiElement instanceof KtExpression ? this.kotlinTypeOf((KtExpression)element) : this.descriptorTypeOf(element))));
        }
        this.type = inferenceNodeType;
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    @NotNull
    public InferenceNodeType getType() {
        return this.type;
    }

    private final InferenceNodeType descriptorTypeOf(PsiElement element) {
        InferenceNodeType inferenceNodeType;
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)element);
        if (simpleFunctionDescriptor != null) {
            SimpleFunctionDescriptor it = simpleFunctionDescriptor;
            boolean bl = false;
            inferenceNodeType = new InferenceDescriptorType((CallableDescriptor)it);
        } else {
            inferenceNodeType = new InferenceUnknownType();
        }
        return inferenceNodeType;
    }

    private final InferenceNodeType kotlinTypeOf(KtExpression element) {
        InferenceNodeType inferenceNodeType;
        KotlinType kotlinType = CodegenUtilKt.kotlinType((KtExpression)element, (BindingContext)this.bindingContext);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            inferenceNodeType = new InferenceKotlinType(it);
        } else {
            inferenceNodeType = new InferenceUnknownType();
        }
        return inferenceNodeType;
    }
}

