/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeClassIds;
import androidx.compose.compiler.plugins.kotlin.IncompatibleComposeRuntimeVersionException;
import androidx.compose.compiler.plugins.kotlin.VersionCheckerResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/compose/compiler/plugins/kotlin/VersionChecker;", "", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "check", "Landroidx/compose/compiler/plugins/kotlin/VersionCheckerResult;", "skipIfRuntimeNotFound", "", "noRuntimeOnClasspathError", "", "outdatedRuntimeWithUnknownVersionNumber", "outdatedRuntime", "actualVersion", "", "Companion", "kotlin-compose-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nVersionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionChecker.kt\nandroidx/compose/compiler/plugins/kotlin/VersionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1641#2,10:159\n1914#2:169\n1915#2:171\n1651#2:172\n295#2,2:173\n1#3:170\n*S KotlinDebug\n*F\n+ 1 VersionChecker.kt\nandroidx/compose/compiler/plugins/kotlin/VersionChecker\n*L\n106#1:159,10\n106#1:169\n106#1:171\n106#1:172\n107#1:173,2\n106#1:170\n*E\n"})
public final class VersionChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrPluginContext context;
    @NotNull
    private final MessageCollector messageCollector;
    @NotNull
    private static final Map<Integer, String> runtimeVersionToMavenVersionTable;
    private static final int minimumRuntimeVersionInt = 3300;
    @NotNull
    private static final String minimumRuntimeVersion = "1.0.0";

    public VersionChecker(@NotNull IrPluginContext context, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.context = context;
        this.messageCollector = messageCollector;
    }

    @NotNull
    public final IrPluginContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final VersionCheckerResult check(boolean skipIfRuntimeNotFound) {
        IrConst versionExpr;
        IrExpressionBody irExpressionBody;
        Object v0;
        Iterable iterable;
        block9: {
            void $this$firstOrNull$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            IrClassSymbol versionClass = this.context.referenceClass(ComposeClassIds.INSTANCE.getComposeVersion());
            if (versionClass == null) {
                if (skipIfRuntimeNotFound) {
                    MessageCollector.report$default((MessageCollector)this.messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.WARNING, (String)StringsKt.replace$default((String)"The Compose Compiler requires the Compose Runtime to be on the classpath, but\nnone could be found. Skipping transform because\nskipIrLoweringIfRuntimeNotFound flag was passed to the compiler.", (char)'\n', (char)' ', (boolean)false, (int)4, null), null, (int)4, null);
                    return VersionCheckerResult.NOT_FOUND;
                }
                IrClassSymbol composerClass = this.context.referenceClass(ComposeClassIds.INSTANCE.getComposer());
                if (composerClass != null) {
                    this.outdatedRuntimeWithUnknownVersionNumber();
                    throw new KotlinNothingValueException();
                }
                this.noRuntimeOnClasspathError();
                throw new KotlinNothingValueException();
            }
            if (!JvmPlatformKt.isJvm((TargetPlatform)this.context.getPlatform())) {
                return VersionCheckerResult.SUCCESS;
            }
            iterable = ((IrClass)versionClass.getOwner()).getDeclarations();
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrProperty it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrDeclaration it = (IrDeclaration)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof IrProperty ? (IrProperty)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrProperty it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"version")) continue;
                v0 = element$iv;
                break block9;
            }
            v0 = null;
        }
        IrProperty irProperty = v0;
        IrExpression irExpression = irProperty != null && (iterable = irProperty.getBackingField()) != null && (irExpressionBody = iterable.getInitializer()) != null ? irExpressionBody.getExpression() : null;
        IrConst irConst = versionExpr = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (versionExpr == null || !Intrinsics.areEqual((Object)versionExpr.getKind(), (Object)IrConstKind.Int.INSTANCE)) {
            this.outdatedRuntimeWithUnknownVersionNumber();
            throw new KotlinNothingValueException();
        }
        Object object = versionExpr.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int versionInt = (Integer)object;
        if (versionInt < 3300) {
            String string = runtimeVersionToMavenVersionTable.get(versionInt);
            if (string == null) {
                string = "<unknown>";
            }
            this.outdatedRuntime(string);
            throw new KotlinNothingValueException();
        }
        return VersionCheckerResult.SUCCESS;
    }

    public static /* synthetic */ VersionCheckerResult check$default(VersionChecker versionChecker, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return versionChecker.check(bl);
    }

    private final Void noRuntimeOnClasspathError() {
        throw new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)"The Compose Compiler requires the Compose Runtime to be on the class path, but\nnone could be found. The compose compiler plugin you are using expects a minimum\nruntime version of 1.0.0.", (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    private final Void outdatedRuntimeWithUnknownVersionNumber() {
        throw new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)"You are using an outdated version of Compose Runtime that is not compatible with\nthe version of the Compose Compiler plugin you have installed. The compose\ncompiler plugin you are using expects a minimum runtime version of\n1.0.0.", (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    private final Void outdatedRuntime(String actualVersion) {
        throw new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                You are using an outdated version of Compose Runtime that is not compatible with\n                the version of the Compose Compiler plugin you have installed. The compose\n                compiler plugin you are using expects a minimum runtime version of\n                1.0.0. The version of the runtime on the classpath currently is\n                " + actualVersion + ".\n            ")), (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1600, (Object)"0.1.0-dev16"), TuplesKt.to((Object)1700, (Object)"1.0.0-alpha06"), TuplesKt.to((Object)1800, (Object)"1.0.0-alpha07"), TuplesKt.to((Object)1900, (Object)"1.0.0-alpha08"), TuplesKt.to((Object)2000, (Object)"1.0.0-alpha09"), TuplesKt.to((Object)2100, (Object)"1.0.0-alpha10"), TuplesKt.to((Object)2200, (Object)"1.0.0-alpha11"), TuplesKt.to((Object)2300, (Object)"1.0.0-alpha12"), TuplesKt.to((Object)2400, (Object)"1.0.0-alpha13"), TuplesKt.to((Object)2500, (Object)"1.0.0-beta04"), TuplesKt.to((Object)2600, (Object)"1.0.0-beta05"), TuplesKt.to((Object)2700, (Object)"1.0.0-beta06"), TuplesKt.to((Object)2800, (Object)"1.0.0-beta07"), TuplesKt.to((Object)2900, (Object)"1.0.0-beta08"), TuplesKt.to((Object)3000, (Object)"1.0.0-beta09"), TuplesKt.to((Object)3100, (Object)"1.0.0-rc01"), TuplesKt.to((Object)3200, (Object)"1.0.0-rc02"), TuplesKt.to((Object)3300, (Object)minimumRuntimeVersion)};
        runtimeVersionToMavenVersionTable = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/compose/compiler/plugins/kotlin/VersionChecker$Companion;", "", "<init>", "()V", "runtimeVersionToMavenVersionTable", "", "", "", "minimumRuntimeVersionInt", "minimumRuntimeVersion", "kotlin-compose-compiler-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

