/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.k2;

import androidx.compose.compiler.plugins.kotlin.k2.ComposeErrors;
import androidx.compose.compiler.plugins.kotlin.k2.FirUtilsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/compiler/plugins/kotlin/k2/ComposableFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nComposableFunctionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableFunctionChecker.kt\nandroidx/compose/compiler/plugins/kotlin/k2/ComposableFunctionChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,99:1\n43#2:100\n13#2:101\n38#2:102\n*S KotlinDebug\n*F\n+ 1 ComposableFunctionChecker.kt\nandroidx/compose/compiler/plugins/kotlin/k2/ComposableFunctionChecker\n*L\n70#1:100\n75#1:101\n92#1:102\n*E\n"})
public final class ComposableFunctionChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final ComposableFunctionChecker INSTANCE = new ComposableFunctionChecker();

    private ComposableFunctionChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        boolean isComposable = FirUtilsKt.hasComposableAnnotation((FirAnnotationContainer)declaration, context.getSession());
        for (FirFunctionSymbol<?> override : FirUtilsKt.getDirectOverriddenFunctions(declaration, context)) {
            if (FirUtilsKt.isComposable((FirCallableSymbol)override, context.getSession()) == isComposable) continue;
            Object[] objectArray = new FirFunctionSymbol[]{declaration.getSymbol(), override};
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory1)FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), (Object)CollectionsKt.listOf((Object[])objectArray), (DiagnosticContext)((DiagnosticContext)context), null, (int)16, null);
        }
        FirFunctionSymbol firFunctionSymbol = ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull((FirFunctionSymbol)declaration.getSymbol());
        if (firFunctionSymbol != null) {
            FirFunctionSymbol expectDeclaration = firFunctionSymbol;
            boolean bl = false;
            if (FirUtilsKt.hasComposableAnnotation((FirBasedSymbol)expectDeclaration, context.getSession()) != isComposable) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getMISMATCHED_COMPOSABLE_IN_EXPECT_ACTUAL(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        }
        if (!isComposable) {
            return;
        }
        FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isSuspend = false;
        if ($this$isSuspend$iv.getStatus().isSuspend()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getCOMPOSABLE_SUSPEND_FUN(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
        FirMemberDeclaration $this$isOpen$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isOpen = false;
        if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) {
            for (FirValueParameter valueParameter : declaration.getValueParameters()) {
                FirExpression defaultValue;
                if (valueParameter.getDefaultValue() == null) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)defaultValue.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getABSTRACT_COMPOSABLE_DEFAULT_PARAMETER_VALUE(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        }
        if (FirUtilsKt.isMain(declaration.getSymbol(), context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getCOMPOSABLE_FUN_MAIN(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
        FirMemberDeclaration $this$isOperator$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isOperator = false;
        if ($this$isOperator$iv.getStatus().isOperator() && Intrinsics.areEqual((Object)FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)((FirMemberDeclaration)declaration)), (Object)OperatorNameConventions.SET_VALUE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getCOMPOSE_INVALID_DELEGATE(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }
}

