/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeConfiguration;
import androidx.compose.compiler.plugins.kotlin.ComposeIrGenerationExtension;
import androidx.compose.compiler.plugins.kotlin.ModuleMetrics;
import androidx.compose.compiler.plugins.kotlin.analysis.FqNameMatcher;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityConfigParser;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityInferencer;
import androidx.compose.compiler.plugins.kotlin.k1.ComposableCallChecker;
import androidx.compose.compiler.plugins.kotlin.k1.ComposableDeclarationChecker;
import androidx.compose.compiler.plugins.kotlin.k1.ComposableTargetChecker;
import androidx.compose.compiler.plugins.kotlin.k1.ComposeDiagnosticSuppressor;
import androidx.compose.compiler.plugins.kotlin.k1.ComposeTypeResolutionInterceptorExtension;
import androidx.compose.compiler.plugins.kotlin.k2.ComposeFirExtensionRegistrar;
import androidx.compose.compiler.plugins.kotlin.lower.ClassStabilityFieldSerializationPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.extensions.internal.TypeResolutionInterceptor;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrarAdapter;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;
import org.jetbrains.kotlin.serialization.DescriptorSerializerPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposePluginRegistrar;", "Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;", "<init>", "()V", "supportsK2", "", "getSupportsK2", "()Z", "registerProjectComponents", "", "project", "Lorg/jetbrains/kotlin/com/intellij/mock/MockProject;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "compiler-hosted"})
public final class ComposePluginRegistrar
implements ComponentRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean getSupportsK2() {
        return true;
    }

    public void registerProjectComponents(@NotNull MockProject project, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (Companion.checkCompilerVersion(configuration)) {
            Companion.registerCommonExtensions((Project)project);
            IrGenerationExtension.Companion.registerExtension((Project)project, (Object)androidx.compose.compiler.plugins.kotlin.ComposePluginRegistrar$Companion.createComposeIrExtension$default(Companion, configuration, null, 2, null));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f\u00a8\u0006\u0012"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposePluginRegistrar$Companion;", "", "<init>", "()V", "checkCompilerVersion", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "registerCommonExtensions", "", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "createComposeIrExtension", "Landroidx/compose/compiler/plugins/kotlin/ComposeIrGenerationExtension;", "moduleMetricsFactory", "Lkotlin/Function1;", "Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer;", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;", "compiler-hosted"})
    @SourceDebugExtension(value={"SMAP\nComposePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposePlugin.kt\nandroidx/compose/compiler/plugins/kotlin/ComposePluginRegistrar$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,486:1\n1#2:487\n1557#3:488\n1628#3,3:489\n*S KotlinDebug\n*F\n+ 1 ComposePlugin.kt\nandroidx/compose/compiler/plugins/kotlin/ComposePluginRegistrar$Companion\n*L\n462#1:488\n462#1:489,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean checkCompilerVersion(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            try {
                String KOTLIN_VERSION_EXPECTATION = "2.0.0-Beta4";
                String string = KotlinCompilerVersion.getVersion();
                if (string != null) {
                    String version = string;
                    boolean bl = false;
                    MessageCollector msgCollector = (MessageCollector)configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                    String suppressKotlinVersionCheck = (String)configuration.get(ComposeConfiguration.INSTANCE.getSUPPRESS_KOTLIN_VERSION_COMPATIBILITY_CHECK());
                    if (suppressKotlinVersionCheck != null && !Intrinsics.areEqual((Object)suppressKotlinVersionCheck, (Object)version)) {
                        if (Intrinsics.areEqual((Object)suppressKotlinVersionCheck, (Object)"true")) {
                            MessageCollector messageCollector = msgCollector;
                            if (messageCollector != null) {
                                MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.STRONG_WARNING, (String)(" `suppressKotlinVersionCompatibilityCheck` should specify the version of Kotlin for which you want the compatibility check to be disabled. For example, `suppressKotlinVersionCompatibilityCheck=" + version + "`"), null, (int)4, null);
                            }
                        } else {
                            MessageCollector messageCollector = msgCollector;
                            if (messageCollector != null) {
                                MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.STRONG_WARNING, (String)(" `suppressKotlinVersionCompatibilityCheck` is set to a version of Kotlin (" + suppressKotlinVersionCheck + ") that you are not using and should be set properly. (you are using Kotlin " + version + ")"), null, (int)4, null);
                            }
                        }
                    }
                    if (Intrinsics.areEqual((Object)suppressKotlinVersionCheck, (Object)KOTLIN_VERSION_EXPECTATION)) {
                        MessageCollector messageCollector = msgCollector;
                        if (messageCollector != null) {
                            MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.STRONG_WARNING, (String)(" `suppressKotlinVersionCompatibilityCheck` is set to the same version of Kotlin that the Compose Compiler was already expecting (Kotlin " + suppressKotlinVersionCheck + "), and thus has no effect and should be removed."), null, (int)4, null);
                        }
                    }
                    if (!(Intrinsics.areEqual((Object)suppressKotlinVersionCheck, (Object)"true") || Intrinsics.areEqual((Object)version, (Object)KOTLIN_VERSION_EXPECTATION) || Intrinsics.areEqual((Object)version, (Object)suppressKotlinVersionCheck))) {
                        MessageCollector messageCollector = msgCollector;
                        if (messageCollector != null) {
                            MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)("This version (1.5.11) of the Compose Compiler requires Kotlin version " + KOTLIN_VERSION_EXPECTATION + " but you appear to be using Kotlin version " + version + " which is not known to be compatible.  Please consult the Compose-Kotlin compatibility map located at https://developer.android.com/jetpack/androidx/releases/compose-kotlin to choose a compatible version pair (or `suppressKotlinVersionCompatibilityCheck` but don't say I didn't warn you!)."), null, (int)4, null);
                        }
                        return false;
                    }
                }
                return true;
            }
            catch (Throwable t) {
                throw new Error("Something went wrong while checking for version compatibility between the Compose Compiler and the Kotlin Compiler.  It is possible that the versions are incompatible.  Please verify your kotlin version  and consult the Compose-Kotlin compatibility map located at https://developer.android.com/jetpack/androidx/releases/compose-kotlin", t);
            }
        }

        public final void registerCommonExtensions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableCallChecker());
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableDeclarationChecker());
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableTargetChecker());
            DiagnosticSuppressor.Companion.registerExtension(project, (Object)new ComposeDiagnosticSuppressor());
            TypeResolutionInterceptor.Companion.registerExtension(project, (Object)new ComposeTypeResolutionInterceptorExtension());
            DescriptorSerializerPlugin.Companion.registerExtension(project, (Object)new ClassStabilityFieldSerializationPlugin());
            FirExtensionRegistrarAdapter.Companion.registerExtension(project, (Object)new ComposeFirExtensionRegistrar());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ComposeIrGenerationExtension createComposeIrExtension(@NotNull CompilerConfiguration configuration, @Nullable Function1<? super StabilityInferencer, ? extends ModuleMetrics> moduleMetricsFactory) {
            Collection collection;
            Iterable matchers;
            CharSequence charSequence;
            CharSequence charSequence2;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            boolean liveLiteralsEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_ENABLED_KEY());
            boolean liveLiteralsV2Enabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_V2_ENABLED_KEY());
            boolean generateFunctionKeyMetaClasses = configuration.getBoolean(ComposeConfiguration.INSTANCE.getGENERATE_FUNCTION_KEY_META_CLASSES_KEY());
            boolean sourceInformationEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getSOURCE_INFORMATION_ENABLED_KEY());
            Object object = configuration.get(ComposeConfiguration.INSTANCE.getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_KEY(), (Object)true);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            boolean intrinsicRememberEnabled = (Boolean)object;
            Object object2 = configuration.get(ComposeConfiguration.INSTANCE.getNON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_KEY(), (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            boolean nonSkippingGroupOptimizationEnabled = (Boolean)object2;
            boolean decoysEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getDECOYS_ENABLED_KEY());
            CharSequence charSequence3 = (CharSequence)configuration.get(ComposeConfiguration.INSTANCE.getMETRICS_DESTINATION_KEY(), (Object)"");
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                boolean bl = false;
                charSequence2 = null;
            } else {
                charSequence2 = charSequence3;
            }
            String metricsDestination = (String)charSequence2;
            CharSequence bl = (CharSequence)configuration.get(ComposeConfiguration.INSTANCE.getREPORTS_DESTINATION_KEY(), (Object)"");
            if (StringsKt.isBlank((CharSequence)bl)) {
                boolean bl2 = false;
                charSequence = null;
            } else {
                charSequence = bl;
            }
            String reportsDestination = (String)charSequence;
            boolean validateIr = configuration.getBoolean(JVMConfigurationKeys.VALIDATE_IR);
            boolean useK2 = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)configuration).getLanguageVersion().getUsesK2();
            Object object3 = configuration.get(ComposeConfiguration.INSTANCE.getSTRONG_SKIPPING_ENABLED_KEY(), (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            boolean strongSkippingEnabled = (Boolean)object3;
            List list = configuration.getList(ComposeConfiguration.INSTANCE.getSTABILITY_CONFIG_PATH_KEY());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
            List stabilityConfigPaths = list;
            Object object4 = configuration.get(ComposeConfiguration.INSTANCE.getTRACE_MARKERS_ENABLED_KEY(), (Object)true);
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            boolean traceMarkersEnabled = (Boolean)object4;
            MessageCollector msgCollector = (MessageCollector)configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            Set stableTypeMatchers = new LinkedHashSet();
            int n = ((Collection)stabilityConfigPaths).size();
            for (int i = 0; i < n; ++i) {
                Set set;
                String path = (String)stabilityConfigPaths.get(i);
                try {
                    set = StabilityConfigParser.Companion.fromFile(path).getStableTypeMatchers();
                }
                catch (Exception e) {
                    MessageCollector messageCollector = msgCollector;
                    if (messageCollector != null) {
                        Object object5 = e.getMessage();
                        if (object5 == null) {
                            object5 = "Error parsing stability configuration at " + path;
                        }
                        MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)object5, null, (int)4, null);
                    }
                    set = SetsKt.emptySet();
                }
                matchers = set;
                stableTypeMatchers.addAll((Collection)matchers);
            }
            Set set = (Set)configuration.get(ComposeConfiguration.INSTANCE.getTEST_STABILITY_CONFIG_KEY());
            if (set != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                matchers = set;
                boolean $i$f$map = false;
                void e = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(new FqNameMatcher((String)it));
                }
                collection = (List)destination$iv$iv;
            } else {
                collection = SetsKt.emptySet();
            }
            Collection testingMatchers = collection;
            stableTypeMatchers.addAll(testingMatchers);
            return new ComposeIrGenerationExtension(liveLiteralsEnabled, liveLiteralsV2Enabled, generateFunctionKeyMetaClasses, sourceInformationEnabled, traceMarkersEnabled, intrinsicRememberEnabled, nonSkippingGroupOptimizationEnabled, decoysEnabled, metricsDestination, reportsDestination, validateIr, useK2, strongSkippingEnabled, stableTypeMatchers, moduleMetricsFactory);
        }

        public static /* synthetic */ ComposeIrGenerationExtension createComposeIrExtension$default(Companion companion, CompilerConfiguration compilerConfiguration, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = null;
            }
            return companion.createComposeIrExtension(compilerConfiguration, (Function1<? super StabilityInferencer, ? extends ModuleMetrics>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

