/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBreakImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrContinueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDoWhileLoopImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DescriptorSymbolTableExtension;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.VariableLValue;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LoopExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "<init>", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktWhile", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "generateDoWhileLoop", "ktDoWhile", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "generateWhileLoopBody", "ktLoopBody", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "generateDoWhileLoopBody", "generateBreak", "ktBreak", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "generateContinue", "ktContinue", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "getLoopLabel", "", "ktLoop", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "findParentLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "ktWithLabel", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "targetLabel", "getLoop", "generateForLoop", "ktFor", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "ir.psi2ir"})
@SourceDebugExtension(value={"SMAP\nLoopExpressionGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoopExpressionGenerator.kt\norg/jetbrains/kotlin/psi2ir/generators/LoopExpressionGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,226:1\n1563#2:227\n1634#2,3:228\n1563#2:231\n1634#2,3:232\n1#3:235\n232#4:236\n*S KotlinDebug\n*F\n+ 1 LoopExpressionGenerator.kt\norg/jetbrains/kotlin/psi2ir/generators/LoopExpressionGenerator\n*L\n83#1:227\n83#1:228,3\n90#1:231\n90#1:232,3\n126#1:236\n*E\n"})
public final class LoopExpressionGenerator
extends StatementGeneratorExtension {
    public LoopExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkNotNullParameter((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateWhileLoop(@NotNull KtWhileExpression ktWhile) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)ktWhile, (String)"ktWhile");
        IrWhileLoopImpl irLoop = BuildersKt.IrWhileLoopImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktWhile), PsiUtilsKt.getEndOffset(ktWhile), this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getWHILE_LOOP());
        KtExpression ktExpression = ktWhile.getCondition();
        Intrinsics.checkNotNull((Object)ktExpression);
        irLoop.setCondition(this.genExpr(ktExpression));
        this.getStatementGenerator().getBodyGenerator().putLoop(ktWhile, irLoop);
        irLoop.setLabel(this.getLoopLabel(ktWhile));
        IrWhileLoopImpl irWhileLoopImpl = irLoop;
        KtExpression ktExpression2 = ktWhile.getBody();
        if (ktExpression2 != null) {
            void ktLoopBody;
            KtExpression ktExpression3 = ktExpression2;
            IrWhileLoopImpl irWhileLoopImpl2 = irWhileLoopImpl;
            boolean bl = false;
            irExpression = ktLoopBody instanceof KtBlockExpression ? this.generateWhileLoopBody((KtBlockExpression)ktLoopBody) : this.genExpr((KtExpression)ktLoopBody);
            irWhileLoopImpl = irWhileLoopImpl2;
        } else {
            irExpression = null;
        }
        irWhileLoopImpl.setBody(irExpression);
        return irLoop;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateDoWhileLoop(@NotNull KtDoWhileExpression ktDoWhile) {
        IrBlockImpl irBlockImpl;
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)ktDoWhile, (String)"ktDoWhile");
        IrDoWhileLoopImpl irLoop = BuildersKt.IrDoWhileLoopImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktDoWhile), PsiUtilsKt.getEndOffset(ktDoWhile), this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getDO_WHILE_LOOP());
        this.getStatementGenerator().getBodyGenerator().putLoop(ktDoWhile, irLoop);
        irLoop.setLabel(this.getLoopLabel(ktDoWhile));
        IrDoWhileLoopImpl irDoWhileLoopImpl = irLoop;
        KtExpression ktExpression = ktDoWhile.getBody();
        if (ktExpression != null) {
            void ktLoopBody;
            KtExpression ktExpression2 = ktExpression;
            IrDoWhileLoopImpl irDoWhileLoopImpl2 = irDoWhileLoopImpl;
            boolean bl = false;
            irExpression = ktLoopBody instanceof KtBlockExpression ? this.generateDoWhileLoopBody((KtBlockExpression)ktLoopBody) : this.genExpr((KtExpression)ktLoopBody);
            irDoWhileLoopImpl = irDoWhileLoopImpl2;
        } else {
            irExpression = null;
        }
        irDoWhileLoopImpl.setBody(irExpression);
        KtExpression ktExpression3 = ktDoWhile.getCondition();
        Intrinsics.checkNotNull((Object)ktExpression3);
        irLoop.setCondition(this.genExpr(ktExpression3));
        IrBlockImpl $this$generateDoWhileLoop_u24lambda_u241 = irBlockImpl = BuildersKt.IrBlockImpl$default(PsiUtilsKt.getStartOffsetSkippingComments(ktDoWhile), PsiUtilsKt.getEndOffset(ktDoWhile), this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
        boolean bl = false;
        $this$generateDoWhileLoop_u24lambda_u241.getStatements().add(irLoop);
        return irBlockImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateWhileLoopBody(KtBlockExpression ktLoopBody) {
        Collection<IrStatement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int n2 = PsiUtilsKt.getStartOffsetSkippingComments(ktLoopBody);
        int n3 = PsiUtilsKt.getEndOffset(ktLoopBody);
        IrType irType = this.getContext().getIrBuiltIns().getUnitType();
        List<KtExpression> list = ktLoopBody.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
        Iterable iterable = list;
        IrStatementOrigin irStatementOrigin = null;
        IrType irType2 = irType;
        int n4 = n3;
        int n5 = n2;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.genStmt((KtExpression)it));
        }
        collection = (List)destination$iv$iv;
        return BuildersKt.IrBlockImpl(n5, n4, irType2, irStatementOrigin, (List<? extends IrStatement>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateDoWhileLoopBody(KtBlockExpression ktLoopBody) {
        Collection<IrStatement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int n2 = PsiUtilsKt.getStartOffsetSkippingComments(ktLoopBody);
        int n3 = PsiUtilsKt.getEndOffset(ktLoopBody);
        IrType irType = this.getContext().getIrBuiltIns().getUnitType();
        List<KtExpression> list = ktLoopBody.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
        Iterable iterable = list;
        IrStatementOrigin irStatementOrigin = null;
        IrType irType2 = irType;
        int n4 = n3;
        int n5 = n2;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.genStmt((KtExpression)it));
        }
        Collection<IrStatement> collection2 = collection = (List)destination$iv$iv;
        IrStatementOrigin irStatementOrigin2 = irStatementOrigin;
        IrType irType3 = irType2;
        int n6 = n4;
        int n7 = n5;
        return new IrCompositeImpl(n7, n6, irType3, irStatementOrigin2, (List<? extends IrStatement>)collection2);
    }

    @NotNull
    public final IrExpression generateBreak(@NotNull KtBreakExpression ktBreak) {
        String string;
        IrBreakImpl irBreakImpl;
        Intrinsics.checkNotNullParameter((Object)ktBreak, (String)"ktBreak");
        IrLoop irLoop = this.findParentLoop(ktBreak);
        if (irLoop == null) {
            return new ErrorExpressionGenerator(this.getStatementGenerator()).generateErrorExpression(ktBreak, new RuntimeException("Loop not found for break expression: " + ktBreak.getText()));
        }
        IrLoop parentLoop = irLoop;
        IrBreakImpl $this$generateBreak_u24lambda_u240 = irBreakImpl = BuildersKt.IrBreakImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktBreak), PsiUtilsKt.getEndOffset(ktBreak), this.getContext().getIrBuiltIns().getNothingType(), parentLoop);
        boolean bl = false;
        String string2 = string = parentLoop.getLabel();
        IrBreakImpl irBreakImpl2 = $this$generateBreak_u24lambda_u240;
        boolean bl2 = false;
        irBreakImpl2.setLabel(Boolean.valueOf(ktBreak.getLabelName() != null) != false ? string : null);
        return irBreakImpl;
    }

    @NotNull
    public final IrExpression generateContinue(@NotNull KtContinueExpression ktContinue) {
        String string;
        IrContinueImpl irContinueImpl;
        Intrinsics.checkNotNullParameter((Object)ktContinue, (String)"ktContinue");
        IrLoop irLoop = this.findParentLoop(ktContinue);
        if (irLoop == null) {
            return new ErrorExpressionGenerator(this.getStatementGenerator()).generateErrorExpression(ktContinue, new RuntimeException("Loop not found for continue expression: " + ktContinue.getText()));
        }
        IrLoop parentLoop = irLoop;
        IrContinueImpl $this$generateContinue_u24lambda_u240 = irContinueImpl = BuildersKt.IrContinueImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktContinue), PsiUtilsKt.getEndOffset(ktContinue), this.getContext().getIrBuiltIns().getNothingType(), parentLoop);
        boolean bl = false;
        String string2 = string = parentLoop.getLabel();
        IrContinueImpl irContinueImpl2 = $this$generateContinue_u24lambda_u240;
        boolean bl2 = false;
        irContinueImpl2.setLabel(Boolean.valueOf(ktContinue.getLabelName() != null) != false ? string : null);
        return irContinueImpl;
    }

    private final String getLoopLabel(KtLoopExpression ktLoop) {
        PsiElement psiElement = ktLoop.getParent();
        KtLabeledExpression ktLabeledExpression = psiElement instanceof KtLabeledExpression ? (KtLabeledExpression)psiElement : null;
        return ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null;
    }

    private final IrLoop findParentLoop(KtExpressionWithLabel ktWithLabel) {
        return this.findParentLoop(ktWithLabel, ktWithLabel.getLabelName());
    }

    /*
     * WARNING - void declaration
     */
    private final IrLoop findParentLoop(KtExpression ktExpression, String targetLabel) {
        KtExpression finger = ktExpression;
        block0: while (finger != null) {
            void $this$getParentOfType$iv;
            PsiElement psiElement = finger;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            finger = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtLoopExpression.class, strict$iv);
            if (finger == null) break;
            if (targetLabel == null) {
                IrLoop irLoop = this.getLoop((KtLoopExpression)finger);
                if (irLoop == null) continue;
                return irLoop;
            }
            PsiElement parent2 = ((KtLoopExpression)finger).getParent();
            while (parent2 instanceof KtLabeledExpression) {
                String label;
                Intrinsics.checkNotNull((Object)((KtLabeledExpression)parent2).getLabelName());
                if (Intrinsics.areEqual((Object)targetLabel, (Object)label)) {
                    IrLoop irLoop = this.getLoop((KtLoopExpression)finger);
                    if (irLoop == null) continue block0;
                    return irLoop;
                }
                parent2 = ((KtLabeledExpression)parent2).getParent();
            }
        }
        return null;
    }

    private final IrLoop getLoop(KtLoopExpression ktLoop) {
        return this.getStatementGenerator().getBodyGenerator().getLoop(ktLoop);
    }

    @NotNull
    public final IrExpression generateForLoop(@NotNull KtForExpression ktFor) {
        IrVariable irVariable;
        Intrinsics.checkNotNullParameter((Object)ktFor, (String)"ktFor");
        KtParameter ktLoopParameter = ktFor.getLoopParameter();
        KtDestructuringDeclaration ktLoopDestructuringDeclaration = ktFor.getDestructuringDeclaration();
        if (ktLoopParameter == null && ktLoopDestructuringDeclaration == null) {
            throw new AssertionError((Object)("Either loopParameter or destructuringParameter should be present:\n" + ktFor.getText()));
        }
        KtExpression ktExpression = ktFor.getLoopRange();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression ktLoopRange = ktExpression;
        KtExpression ktForBody = ktFor.getBody();
        Generator generator = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL;
        Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"LOOP_RANGE_ITERATOR_RESOLVED_CALL");
        ResolvedCall iteratorResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator, writableSlice, ktLoopRange);
        Generator generator2 = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL;
        Intrinsics.checkNotNullExpressionValue(writableSlice2, (String)"LOOP_RANGE_HAS_NEXT_RESOLVED_CALL");
        ResolvedCall hasNextResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator2, writableSlice2, ktLoopRange);
        Generator generator3 = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL;
        Intrinsics.checkNotNullExpressionValue(writableSlice3, (String)"LOOP_RANGE_NEXT_RESOLVED_CALL");
        ResolvedCall nextResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator3, writableSlice3, ktLoopRange);
        CallGenerator callGenerator = new CallGenerator(this.getStatementGenerator());
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktFor);
        int endOffset = PsiUtilsKt.getEndOffset(ktFor);
        IrBlockImpl irForBlock = BuildersKt.IrBlockImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getFOR_LOOP());
        StatementGenerator statementGenerator = this.getStatementGenerator();
        Intrinsics.checkNotNull((Object)iteratorResolvedCall);
        CallBuilder iteratorCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator, iteratorResolvedCall);
        IrExpression irIteratorCall = CallGeneratorKt.generateCall$default(callGenerator, ktLoopRange, iteratorCall, IrStatementOrigin.Companion.getFOR_LOOP_ITERATOR(), 0, 0, 24, null);
        IrVariable irIterator = Scope.createTemporaryVariable$default(this.getScope(), irIteratorCall, "iterator", false, IrDeclarationOrigin.Companion.getFOR_LOOP_ITERATOR(), null, 0, 0, 116, null);
        VariableLValue iteratorValue = new VariableLValue(this.getContext(), irIterator, null, 0, 0, 28, null);
        irForBlock.getStatements().add(irIterator);
        IrWhileLoopImpl irInnerWhile = BuildersKt.IrWhileLoopImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE());
        irInnerWhile.setLabel(this.getLoopLabel(ktFor));
        this.getStatementGenerator().getBodyGenerator().putLoop(ktFor, irInnerWhile);
        irForBlock.getStatements().add(irInnerWhile);
        StatementGenerator statementGenerator2 = this.getStatementGenerator();
        Intrinsics.checkNotNull((Object)hasNextResolvedCall);
        CallBuilder hasNextCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator2, hasNextResolvedCall);
        CallBuilderKt.setExplicitReceiverValue(hasNextCall, iteratorValue);
        IrExpression irHasNextCall = CallGeneratorKt.generateCall$default(callGenerator, ktLoopRange, hasNextCall, IrStatementOrigin.Companion.getFOR_LOOP_HAS_NEXT(), 0, 0, 24, null);
        irInnerWhile.setCondition(irHasNextCall);
        IrBlockImpl irInnerBody = BuildersKt.IrBlockImpl(startOffset, endOffset, this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE());
        irInnerWhile.setBody(irInnerBody);
        StatementGenerator statementGenerator3 = this.getStatementGenerator();
        Intrinsics.checkNotNull((Object)nextResolvedCall);
        CallBuilder nextCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator3, nextResolvedCall);
        CallBuilderKt.setExplicitReceiverValue(nextCall, iteratorValue);
        IrExpression irNextCall = CallGeneratorKt.generateCall$default(callGenerator, ktLoopRange, nextCall, IrStatementOrigin.Companion.getFOR_LOOP_NEXT(), 0, 0, 24, null);
        if (ktLoopParameter != null && ktLoopDestructuringDeclaration == null) {
            Generator generator4 = this;
            WritableSlice<KtParameter, VariableDescriptor> writableSlice4 = BindingContext.VALUE_PARAMETER;
            Intrinsics.checkNotNullExpressionValue(writableSlice4, (String)"VALUE_PARAMETER");
            VariableDescriptor loopParameter = (VariableDescriptor)GeneratorKt.getOrFail(generator4, writableSlice4, ktLoopParameter);
            DescriptorSymbolTableExtension descriptorSymbolTableExtension = this.getContext().getSymbolTable().getDescriptorExtension();
            int n2 = PsiUtilsKt.getStartOffsetSkippingComments(ktLoopParameter);
            int n3 = PsiUtilsKt.getEndOffset(ktLoopParameter);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getFOR_LOOP_VARIABLE();
            Intrinsics.checkNotNull((Object)loopParameter);
            KotlinType kotlinType = loopParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            irVariable = descriptorSymbolTableExtension.declareVariable(n2, n3, irDeclarationOrigin, loopParameter, this.toIrType(kotlinType), irNextCall);
        } else {
            irVariable = Scope.createTemporaryVariable$default(this.getScope(), irNextCall, "loop_parameter", false, null, null, 0, 0, 124, null);
        }
        IrVariable irLoopParameter = irVariable;
        irInnerBody.getStatements().add(irLoopParameter);
        if (ktLoopDestructuringDeclaration != null) {
            VariableLValue firstContainerValue = new VariableLValue(this.getContext(), irLoopParameter, null, 0, 0, 28, null);
            this.getStatementGenerator().declareComponentVariablesInBlock(ktLoopDestructuringDeclaration, irInnerBody, firstContainerValue, this.getContext().getExtensions().getDebugInfoOnlyOnVariablesInDestructuringDeclarations() ? new VariableLValue(this.getContext(), irLoopParameter, null, -2, -2, 4, null) : firstContainerValue);
        }
        if (ktForBody != null) {
            irInnerBody.getStatements().add(this.genExpr(ktForBody));
        }
        return irForBlock;
    }
}

