/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.localfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.localfs.KotlinLocalVirtualFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/common/localfs/KotlinLocalFileSystem;", "Lcom/intellij/openapi/vfs/local/CoreLocalFileSystem;", "<init>", "()V", "getProtocol", "", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "refresh", "", "asynchronous", "", "refreshAndFindFileByPath", "getNioPath", "Ljava/nio/file/Path;", "file", "findFileByIoFile", "Ljava/io/File;", "findFileByNioFile", "cli-base"})
@SourceDebugExtension(value={"SMAP\nKotlinLocalFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLocalFileSystem.kt\norg/jetbrains/kotlin/cli/common/localfs/KotlinLocalFileSystem\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,42:1\n233#2:43\n*S KotlinDebug\n*F\n+ 1 KotlinLocalFileSystem.kt\norg/jetbrains/kotlin/cli/common/localfs/KotlinLocalFileSystem\n*L\n35#1:43\n*E\n"})
public final class KotlinLocalFileSystem
extends CoreLocalFileSystem {
    @Override
    @NotNull
    public String getProtocol() {
        return "file";
    }

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByIoFile(new File(path));
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    @Override
    @Nullable
    public Path getNioPath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Serializable serializable = file instanceof KotlinLocalVirtualFile ? (KotlinLocalVirtualFile)file : null;
        return serializable != null && (serializable = ((KotlinLocalVirtualFile)serializable).getFile()) != null ? ((File)serializable).toPath() : null;
    }

    @Override
    @Nullable
    public VirtualFile findFileByIoFile(@NotNull File file) {
        KotlinLocalVirtualFile kotlinLocalVirtualFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean condition$iv = file.exists();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            kotlinLocalVirtualFile = new KotlinLocalVirtualFile(file, this, null, 4, null);
        } else {
            kotlinLocalVirtualFile = null;
        }
        return kotlinLocalVirtualFile;
    }

    @Override
    @Nullable
    public VirtualFile findFileByNioFile(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = file.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return this.findFileByIoFile(file2);
    }
}

