/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsTry;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class TryTranslator
extends AbstractTranslator {
    @NotNull
    private final JetTryExpression expression;

    @NotNull
    public static JsTry translate(@NotNull JetTryExpression expression, @NotNull TranslationContext context) {
        return new TryTranslator(expression, context).translate();
    }

    private TryTranslator(@NotNull JetTryExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
    }

    private JsTry translate() {
        return new JsTry(this.translateTryBlock(), this.translateCatches(), this.translateFinallyBlock());
    }

    @Nullable
    private JsBlock translateFinallyBlock() {
        JetFinallySection finallyBlock = this.expression.getFinallyBlock();
        if (finallyBlock == null) {
            return null;
        }
        return JsAstUtils.convertToBlock(Translation.translateAsStatement(finallyBlock.getFinalExpression(), this.context()));
    }

    @NotNull
    private JsBlock translateTryBlock() {
        return JsAstUtils.convertToBlock(Translation.translateAsStatement(this.expression.getTryBlock(), this.context()));
    }

    @NotNull
    private List<JsCatch> translateCatches() {
        SmartList<JsCatch> result = new SmartList<JsCatch>();
        for (JetCatchClause catchClause : this.expression.getCatchClauses()) {
            result.add(this.translateCatchClause(catchClause));
        }
        return result;
    }

    @NotNull
    private JsCatch translateCatchClause(@NotNull JetCatchClause catchClause) {
        JetParameter catchParameter = catchClause.getCatchParameter();
        assert (catchParameter != null) : "Valid catch must have a parameter.";
        JsName parameterName = this.context().getNameForElement(catchParameter);
        JsCatch result = new JsCatch(this.context().scope(), parameterName.getIdent());
        result.setBody(this.translateCatchBody(catchClause));
        return result;
    }

    @NotNull
    private JsBlock translateCatchBody(@NotNull JetCatchClause catchClause) {
        JetExpression catchBody = catchClause.getCatchBody();
        if (catchBody == null) {
            return JsAstUtils.convertToBlock(this.program().getEmptyStmt());
        }
        return JsAstUtils.convertToBlock(Translation.translateAsStatement(catchBody, this.context()));
    }
}

