/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.TraceableThisAliasProvider;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.expression.InnerDeclarationTranslator;
import org.jetbrains.k2js.translate.expression.InnerFunctionTranslator;
import org.jetbrains.k2js.translate.expression.InnerObjectTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;

public class LiteralFunctionTranslator {
    private final List<JsPropertyInitializer> properties = new ArrayList<JsPropertyInitializer>();
    private final LabelGenerator labelGenerator = new LabelGenerator('f');
    private final JsNameRef containingVarRef = new JsNameRef("_f");
    private TranslationContext rootContext;

    public void setRootContext(@NotNull TranslationContext rootContext) {
        assert (this.rootContext == null);
        this.rootContext = rootContext;
        JsName containingVarName = rootContext.scope().declareName(this.containingVarRef.getIdent());
        this.containingVarRef.resolve(containingVarName);
    }

    public JsVars.JsVar getDeclaration() {
        return new JsVars.JsVar(this.containingVarRef.getName(), this.properties.isEmpty() ? null : new JsObjectLiteral(this.properties, true));
    }

    public JsExpression translate(@NotNull JetFunctionLiteralExpression declaration) {
        TranslationContext funContext;
        boolean asInner;
        FunctionDescriptor descriptor = BindingUtils.getFunctionDescriptor(this.rootContext.bindingContext(), declaration.getFunctionLiteral());
        JsFunction fun = this.createFunction();
        if (descriptor.getContainingDeclaration() instanceof ConstructorDescriptor) {
            asInner = true;
            fun.setName(fun.getScope().declareName("$fun"));
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor.getContainingDeclaration().getContainingDeclaration();
            assert (classDescriptor != null);
            funContext = this.createThisTraceableContext(classDescriptor, fun, new JsNameRef("o", (JsExpression)fun.getName().makeRef()));
        } else {
            asInner = DescriptorUtils.isTopLevelDeclaration(descriptor);
            funContext = this.rootContext.contextWithScope(fun);
        }
        fun.getBody().getStatements().addAll(FunctionBodyTranslator.translateFunctionBody(descriptor, declaration.getFunctionLiteral(), funContext).getStatements());
        InnerFunctionTranslator translator = null;
        if (!asInner && (translator = new InnerFunctionTranslator((JetElement)declaration, descriptor, funContext, fun)).isLocalVariablesAffected()) {
            asInner = true;
        }
        if (asInner) {
            FunctionTranslator.addParameters(fun.getParameters(), descriptor, funContext);
            if (funContext.thisAliasProvider() instanceof TraceableThisAliasProvider) {
                TraceableThisAliasProvider provider = (TraceableThisAliasProvider)funContext.thisAliasProvider();
                if (provider.wasThisCaptured()) {
                    return new JsInvocation(this.rootContext.namer().kotlin("assignOwner"), fun, JsLiteral.THIS);
                }
                fun.setName(null);
            }
            return fun;
        }
        return this.translate(translator, fun);
    }

    private JsFunction createFunction() {
        return new JsFunction(this.rootContext.scope(), new JsBlock());
    }

    public JsExpression translate(@NotNull ClassDescriptor containingClass, @NotNull JetClassOrObject declaration, @NotNull ClassDescriptor descriptor, @NotNull ClassTranslator classTranslator) {
        JsFunction fun = this.createFunction();
        JsName outerThisName = fun.getScope().declareName("$this");
        TranslationContext funContext = this.createThisTraceableContext(containingClass, fun, outerThisName.makeRef());
        fun.getBody().getStatements().add(new JsReturn(classTranslator.translateClassOrObjectCreation(funContext)));
        return this.translate(new InnerObjectTranslator(declaration, descriptor, funContext, fun), fun);
    }

    private JsExpression translate(@NotNull InnerDeclarationTranslator translator, @NotNull JsFunction fun) {
        JsNameRef nameRef = new JsNameRef(this.labelGenerator.generate(), (JsExpression)this.containingVarRef);
        this.properties.add(new JsPropertyInitializer(nameRef, fun));
        return translator.translate(nameRef);
    }

    private TranslationContext createThisTraceableContext(@NotNull ClassDescriptor containingClass, @NotNull JsFunction fun, @NotNull JsNameRef thisRef) {
        return this.rootContext.contextWithScope(fun, this.rootContext.aliasingContext().inner(new TraceableThisAliasProvider(containingClass, thisRef)));
    }
}

