/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class PropertyTranslator
extends AbstractTranslator {
    @NotNull
    private final PropertyDescriptor descriptor;
    @Nullable
    private final JetProperty declaration;

    public static void translateAccessors(@NotNull PropertyDescriptor descriptor, @NotNull List<JsPropertyInitializer> result, @NotNull TranslationContext context) {
        PropertyTranslator.translateAccessors(descriptor, null, result, context);
    }

    public static void translateAccessors(@NotNull PropertyDescriptor descriptor, @Nullable JetProperty declaration, @NotNull List<JsPropertyInitializer> result, @NotNull TranslationContext context) {
        if (context.isEcma5() && !JsDescriptorUtils.isAsPrivate(descriptor)) {
            return;
        }
        new PropertyTranslator(descriptor, declaration, context).translate(result);
    }

    private PropertyTranslator(@NotNull PropertyDescriptor descriptor, @Nullable JetProperty declaration, @NotNull TranslationContext context) {
        super(context);
        this.descriptor = descriptor;
        this.declaration = declaration;
    }

    private void translate(@NotNull List<JsPropertyInitializer> result) {
        List<JsPropertyInitializer> to;
        if (this.context().isEcma5() && !JsDescriptorUtils.isExtension(this.descriptor)) {
            to = new SmartList<JsPropertyInitializer>();
            result.add(new JsPropertyInitializer(this.context().nameToLiteral(this.descriptor), new JsObjectLiteral(to, true)));
        } else {
            to = result;
        }
        to.add(this.generateGetter());
        if (this.descriptor.isVar()) {
            to.add(this.generateSetter());
        }
    }

    private JsPropertyInitializer generateGetter() {
        if (this.hasCustomGetter()) {
            return this.translateCustomAccessor(this.getCustomGetterDeclaration());
        }
        return this.generateDefaultGetter();
    }

    private JsPropertyInitializer generateSetter() {
        if (this.hasCustomSetter()) {
            return this.translateCustomAccessor(this.getCustomSetterDeclaration());
        }
        return this.generateDefaultSetter();
    }

    private boolean hasCustomGetter() {
        return this.declaration != null && this.declaration.getGetter() != null && this.getCustomGetterDeclaration().getBodyExpression() != null;
    }

    private boolean hasCustomSetter() {
        return this.declaration != null && this.declaration.getSetter() != null && this.getCustomSetterDeclaration().getBodyExpression() != null;
    }

    @NotNull
    private JetPropertyAccessor getCustomGetterDeclaration() {
        assert (this.declaration != null);
        JetPropertyAccessor getterDeclaration = this.declaration.getGetter();
        assert (getterDeclaration != null);
        return getterDeclaration;
    }

    @NotNull
    private JetPropertyAccessor getCustomSetterDeclaration() {
        assert (this.declaration != null);
        JetPropertyAccessor setter = this.declaration.getSetter();
        assert (setter != null);
        return setter;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultGetter() {
        PropertyGetterDescriptor getterDescriptor = this.descriptor.getGetter();
        assert (getterDescriptor != null) : "Getter descriptor should not be null";
        return this.generateDefaultAccessor(getterDescriptor, this.generateDefaultGetterFunction(getterDescriptor));
    }

    @NotNull
    private JsFunction generateDefaultGetterFunction(@NotNull PropertyGetterDescriptor descriptor) {
        JsFunction fun = new JsFunction(this.context().getScopeForDescriptor(descriptor.getContainingDeclaration()));
        fun.setBody(new JsBlock((JsStatement)new JsReturn(TranslationUtils.backingFieldReference(this.context(), this.descriptor))));
        return fun;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultSetter() {
        PropertySetterDescriptor setterDescriptor = this.descriptor.getSetter();
        assert (setterDescriptor != null) : "Setter descriptor should not be null";
        return this.generateDefaultAccessor(setterDescriptor, this.generateDefaultSetterFunction(setterDescriptor));
    }

    @NotNull
    private JsFunction generateDefaultSetterFunction(@NotNull PropertySetterDescriptor setterDescriptor) {
        JsFunction fun = new JsFunction(this.context().getScopeForDescriptor(setterDescriptor.getContainingDeclaration()));
        JsParameter defaultParameter = new JsParameter(this.propertyAccessContext(setterDescriptor).scope().declareTemporary());
        fun.getParameters().add(defaultParameter);
        fun.setBody(new JsBlock(TranslationUtils.assignmentToBackingField(this.context(), this.descriptor, defaultParameter.getName().makeRef()).makeStmt()));
        return fun;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultAccessor(@NotNull PropertyAccessorDescriptor accessorDescriptor, @NotNull JsFunction function) {
        if (this.context().isEcma5()) {
            return TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function, accessorDescriptor, this.context());
        }
        return new JsPropertyInitializer(this.context().getNameForDescriptor(accessorDescriptor).makeRef(), function);
    }

    @NotNull
    private TranslationContext propertyAccessContext(@NotNull PropertySetterDescriptor propertySetterDescriptor) {
        return this.context().newDeclaration(propertySetterDescriptor);
    }

    @NotNull
    private JsPropertyInitializer translateCustomAccessor(@NotNull JetPropertyAccessor expression) {
        FunctionTranslator translator = Translation.functionTranslator(expression, this.context());
        return this.context().isEcma5() ? translator.translateAsEcma5PropertyDescriptor() : translator.translateAsMethod();
    }
}

