/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.common.collect.Maps;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.config.LibrarySourcesConfig;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.StandardClasses;
import org.jetbrains.k2js.translate.context.generator.Generator;
import org.jetbrains.k2js.translate.context.generator.Rule;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.intrinsic.Intrinsics;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PredefinedAnnotation;

public final class StaticContext {
    @NotNull
    private final JsProgram program;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final Namer namer;
    @NotNull
    private final Intrinsics intrinsics;
    @NotNull
    private final StandardClasses standardClasses;
    @NotNull
    private final JsScope rootScope;
    @NotNull
    private final Generator<JsName> names = new NameGenerator();
    @NotNull
    private final Generator<JsScope> scopes = new ScopeGenerator();
    @NotNull
    private final Generator<JsNameRef> qualifiers = new QualifierGenerator();
    @NotNull
    private final Generator<Boolean> qualifierIsNull = new QualifierIsNullGenerator();
    @NotNull
    private final Map<JsScope, JsFunction> scopeToFunction = Maps.newHashMap();
    @NotNull
    private final EcmaVersion ecmaVersion;
    @NotNull
    private final LiteralFunctionTranslator literalFunctionTranslator = new LiteralFunctionTranslator();

    public static StaticContext generateStaticContext(@NotNull BindingContext bindingContext, @NotNull EcmaVersion ecmaVersion) {
        JsProgram program = new JsProgram("main");
        Namer namer = Namer.newInstance(program.getRootScope());
        Intrinsics intrinsics = new Intrinsics();
        StandardClasses standardClasses = StandardClasses.bindImplementations(namer.getKotlinScope());
        return new StaticContext(program, bindingContext, namer, intrinsics, standardClasses, program.getRootScope(), ecmaVersion);
    }

    private StaticContext(@NotNull JsProgram program, @NotNull BindingContext bindingContext, @NotNull Namer namer, @NotNull Intrinsics intrinsics, @NotNull StandardClasses standardClasses, @NotNull JsScope rootScope, @NotNull EcmaVersion ecmaVersion) {
        this.program = program;
        this.bindingContext = bindingContext;
        this.namer = namer;
        this.intrinsics = intrinsics;
        this.rootScope = rootScope;
        this.standardClasses = standardClasses;
        this.ecmaVersion = ecmaVersion;
    }

    @NotNull
    public LiteralFunctionTranslator getLiteralFunctionTranslator() {
        return this.literalFunctionTranslator;
    }

    public boolean isEcma5() {
        return this.ecmaVersion == EcmaVersion.v5;
    }

    @NotNull
    public EcmaVersion getEcmaVersion() {
        return this.ecmaVersion;
    }

    @NotNull
    public JsProgram getProgram() {
        return this.program;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public Intrinsics getIntrinsics() {
        return this.intrinsics;
    }

    @NotNull
    public Namer getNamer() {
        return this.namer;
    }

    @NotNull
    public JsScope getRootScope() {
        return this.rootScope;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        JsScope scope = this.scopes.get(descriptor.getOriginal());
        assert (scope != null) : "Must have a scope for descriptor";
        return scope;
    }

    @NotNull
    public JsFunction getFunctionWithScope(@NotNull CallableDescriptor descriptor) {
        JsScope scope = this.getScopeForDescriptor(descriptor);
        JsFunction function = this.scopeToFunction.get(scope);
        assert (scope.equals(function.getScope())) : "Inconsistency.";
        return function;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        JsName name = this.names.get(descriptor.getOriginal());
        assert (name != null) : "Must have name for descriptor";
        return name;
    }

    @NotNull
    private JsScope getEnclosingScope(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containingDeclaration = JsDescriptorUtils.getContainingDeclaration(descriptor);
        return this.getScopeForDescriptor(containingDeclaration.getOriginal());
    }

    @Nullable
    public JsNameRef getQualifierForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (this.qualifierIsNull.get(descriptor.getOriginal()) != null) {
            return null;
        }
        return this.qualifiers.get(descriptor.getOriginal());
    }

    private static class QualifierIsNullGenerator
    extends Generator<Boolean> {
        private QualifierIsNullGenerator() {
            Rule<Boolean> propertiesHaveNoQualifiers = new Rule<Boolean>(){

                @Override
                public Boolean apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof PropertyDescriptor)) {
                        return null;
                    }
                    return true;
                }
            };
            Rule<Boolean> nativeObjectsHaveNoQualifiers = new Rule<Boolean>(){

                @Override
                public Boolean apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!AnnotationsUtils.isNativeObject(descriptor)) {
                        return null;
                    }
                    return true;
                }
            };
            Rule<Boolean> topLevelNamespaceHaveNoQualifier = new Rule<Boolean>(){

                @Override
                public Boolean apply(@NotNull DeclarationDescriptor descriptor) {
                    if (descriptor instanceof NamespaceDescriptor && DescriptorUtils.isRootNamespace((NamespaceDescriptor)descriptor)) {
                        return true;
                    }
                    return null;
                }
            };
            this.addRule(topLevelNamespaceHaveNoQualifier);
            this.addRule(propertiesHaveNoQualifiers);
            this.addRule(nativeObjectsHaveNoQualifiers);
        }
    }

    private final class QualifierGenerator
    extends Generator<JsNameRef> {
        public QualifierGenerator() {
            Rule<JsNameRef> standardObjectsHaveKotlinQualifier = new Rule<JsNameRef>(){

                @Override
                public JsNameRef apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!StaticContext.this.standardClasses.isStandardObject(descriptor)) {
                        return null;
                    }
                    return StaticContext.this.namer.kotlinObject();
                }
            };
            Rule<JsNameRef> namespaceLevelDeclarationsHaveEnclosingNamespacesNamesAsQualifier = new Rule<JsNameRef>(){

                @Override
                public JsNameRef apply(@NotNull DeclarationDescriptor descriptor) {
                    DeclarationDescriptor containingDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor);
                    if (!(containingDescriptor instanceof NamespaceDescriptor)) {
                        return null;
                    }
                    JsNameRef result = new JsNameRef(StaticContext.this.getNameForDescriptor(containingDescriptor));
                    if (DescriptorUtils.isRootNamespace((NamespaceDescriptor)containingDescriptor)) {
                        return result;
                    }
                    JsNameRef qualifier = result;
                    while ((containingDescriptor = JsDescriptorUtils.getContainingDeclaration(containingDescriptor)) instanceof NamespaceDescriptor && !DescriptorUtils.isRootNamespace((NamespaceDescriptor)containingDescriptor)) {
                        JsNameRef ref = StaticContext.this.getNameForDescriptor(containingDescriptor).makeRef();
                        qualifier.setQualifier(ref);
                        qualifier = ref;
                    }
                    PsiElement element = BindingContextUtils.descriptorToDeclaration(StaticContext.this.bindingContext, descriptor);
                    if (element == null && descriptor instanceof PropertyAccessorDescriptor) {
                        element = BindingContextUtils.descriptorToDeclaration(StaticContext.this.bindingContext, ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty());
                    }
                    if (element != null) {
                        PsiFile file = element.getContainingFile();
                        String moduleName = file.getUserData(LibrarySourcesConfig.EXTERNAL_MODULE_NAME);
                        if ("<unknown>".equals(moduleName)) {
                            return null;
                        }
                        if (moduleName != null) {
                            qualifier.setQualifier(new JsArrayAccess(StaticContext.this.namer.kotlin("modules"), StaticContext.this.program.getStringLiteral(moduleName)));
                        } else if (result != qualifier || result.getIdent().equals("kotlin")) {
                            // empty if block
                        }
                    }
                    if (qualifier.getQualifier() == null) {
                        qualifier.setQualifier(new JsNameRef(Namer.getRootNamespaceName()));
                    }
                    return result;
                }
            };
            Rule<JsNameRef> constructorHaveTheSameQualifierAsTheClass = new Rule<JsNameRef>(){

                @Override
                public JsNameRef apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof ConstructorDescriptor)) {
                        return null;
                    }
                    ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(descriptor);
                    assert (containingClass != null) : "Can't have constructor without a class";
                    return StaticContext.this.getQualifierForDescriptor(containingClass);
                }
            };
            Rule<JsNameRef> libraryObjectsHaveKotlinQualifier = new Rule<JsNameRef>(){

                @Override
                public JsNameRef apply(@NotNull DeclarationDescriptor descriptor) {
                    if (AnnotationsUtils.isLibraryObject(descriptor)) {
                        return StaticContext.this.namer.kotlinObject();
                    }
                    return null;
                }
            };
            this.addRule(libraryObjectsHaveKotlinQualifier);
            this.addRule(constructorHaveTheSameQualifierAsTheClass);
            this.addRule(standardObjectsHaveKotlinQualifier);
            this.addRule(namespaceLevelDeclarationsHaveEnclosingNamespacesNamesAsQualifier);
        }
    }

    private final class ScopeGenerator
    extends Generator<JsScope> {
        public ScopeGenerator() {
            Rule<JsScope> generateNewScopesForClassesWithNoAncestors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof ClassDescriptor)) {
                        return null;
                    }
                    if (JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor) == null) {
                        return StaticContext.this.getRootScope().innerScope("Scope for class " + descriptor.getName());
                    }
                    return null;
                }
            };
            Rule<JsScope> generateInnerScopesForDerivedClasses = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof ClassDescriptor)) {
                        return null;
                    }
                    ClassDescriptor superclass = JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor);
                    if (superclass == null) {
                        return null;
                    }
                    return StaticContext.this.getScopeForDescriptor(superclass).innerScope("Scope for class " + descriptor.getName());
                }
            };
            Rule<JsScope> generateNewScopesForNamespaceDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof NamespaceDescriptor)) {
                        return null;
                    }
                    return StaticContext.this.getRootScope().innerScope("Namespace " + descriptor.getName());
                }
            };
            Rule<JsScope> generateInnerScopesForMembers = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    JsScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor);
                    return enclosingScope.innerScope("Scope for member " + descriptor.getName());
                }
            };
            Rule<JsScope> createFunctionObjectsForCallableDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof CallableDescriptor)) {
                        return null;
                    }
                    JsScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor);
                    JsFunction correspondingFunction = JsAstUtils.createFunctionWithEmptyBody(enclosingScope);
                    assert (!StaticContext.this.scopeToFunction.containsKey(correspondingFunction.getScope())) : "Scope to function value overridden for " + descriptor;
                    StaticContext.this.scopeToFunction.put(correspondingFunction.getScope(), correspondingFunction);
                    return correspondingFunction.getScope();
                }
            };
            this.addRule(createFunctionObjectsForCallableDescriptors);
            this.addRule(generateNewScopesForClassesWithNoAncestors);
            this.addRule(generateInnerScopesForDerivedClasses);
            this.addRule(generateNewScopesForNamespaceDescriptors);
            this.addRule(generateInnerScopesForMembers);
        }
    }

    private final class NameGenerator
    extends Generator<JsName> {
        private JsName declareName(DeclarationDescriptor descriptor, String name) {
            JsScope scope = StaticContext.this.getEnclosingScope(descriptor);
            return StaticContext.this.isEcma5() ? scope.declareName(name) : scope.declareFreshName(name);
        }

        public NameGenerator() {
            Rule<JsName> namesForStandardClasses = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor data) {
                    if (!StaticContext.this.standardClasses.isStandardObject(data)) {
                        return null;
                    }
                    return StaticContext.this.standardClasses.getStandardObjectName(data);
                }
            };
            Rule<JsName> namespacesShouldBeDefinedInRootScope = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof NamespaceDescriptor)) {
                        return null;
                    }
                    String name = Namer.generateNamespaceName(descriptor);
                    return StaticContext.this.getRootScope().declareName(name);
                }
            };
            Rule<JsName> memberDeclarationsInsideParentsScope = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    JsScope scope = StaticContext.this.getEnclosingScope(descriptor);
                    return scope.declareFreshName(descriptor.getName().asString());
                }
            };
            Rule<JsName> constructorHasTheSameNameAsTheClass = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof ConstructorDescriptor)) {
                        return null;
                    }
                    ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(descriptor);
                    assert (containingClass != null) : "Can't have constructor without a class";
                    return StaticContext.this.getNameForDescriptor(containingClass);
                }
            };
            Rule<JsName> accessorsHasNamesWithSpecialPrefixes = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof PropertyAccessorDescriptor)) {
                        return null;
                    }
                    PropertyAccessorDescriptor accessorDescriptor = (PropertyAccessorDescriptor)descriptor;
                    String propertyName = accessorDescriptor.getCorrespondingProperty().getName().asString();
                    if (BindingUtils.isObjectDeclaration(StaticContext.this.bindingContext, accessorDescriptor.getCorrespondingProperty())) {
                        return NameGenerator.this.declareName(descriptor, propertyName);
                    }
                    boolean isGetter = descriptor instanceof PropertyGetterDescriptor;
                    String accessorName = Namer.getNameForAccessor(propertyName, isGetter, accessorDescriptor.getReceiverParameter() == null && StaticContext.this.isEcma5());
                    return NameGenerator.this.declareName(descriptor, accessorName);
                }
            };
            Rule<JsName> predefinedObjectsHasUnobfuscatableNames = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    for (PredefinedAnnotation annotation : PredefinedAnnotation.values()) {
                        if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation)) continue;
                        String name = AnnotationsUtils.getNameForAnnotatedObject(descriptor, annotation);
                        name = name != null ? name : descriptor.getName().asString();
                        return StaticContext.this.getEnclosingScope(descriptor).declareName(name);
                    }
                    return null;
                }
            };
            Rule<JsName> propertiesCorrespondToSpeciallyTreatedBackingFieldNames = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof PropertyDescriptor)) {
                        return null;
                    }
                    String name = descriptor.getName().asString();
                    if (!StaticContext.this.isEcma5() || JsDescriptorUtils.isAsPrivate((PropertyDescriptor)descriptor)) {
                        name = Namer.getKotlinBackingFieldName(name);
                    }
                    return NameGenerator.this.declareName(descriptor, name);
                }
            };
            Rule<JsName> toStringHack = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof FunctionDescriptor)) {
                        return null;
                    }
                    if (!descriptor.getName().asString().equals("toString")) {
                        return null;
                    }
                    if (((FunctionDescriptor)descriptor).getValueParameters().isEmpty()) {
                        return StaticContext.this.getEnclosingScope(descriptor).declareName("toString");
                    }
                    return null;
                }
            };
            Rule<JsName> overridingDescriptorsReferToOriginalName = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof FunctionDescriptor)) {
                        return null;
                    }
                    FunctionDescriptor overriddenDescriptor = JsDescriptorUtils.getOverriddenDescriptor((FunctionDescriptor)descriptor);
                    if (overriddenDescriptor == null) {
                        return null;
                    }
                    JsScope scope = StaticContext.this.getEnclosingScope(descriptor);
                    JsName result = StaticContext.this.getNameForDescriptor(overriddenDescriptor);
                    scope.declareName(result.getIdent());
                    return result;
                }
            };
            this.addRule(namesForStandardClasses);
            this.addRule(constructorHasTheSameNameAsTheClass);
            this.addRule(predefinedObjectsHasUnobfuscatableNames);
            this.addRule(toStringHack);
            this.addRule(propertiesCorrespondToSpeciallyTreatedBackingFieldNames);
            this.addRule(namespacesShouldBeDefinedInRootScope);
            this.addRule(overridingDescriptorsReferToOriginalName);
            this.addRule(accessorsHasNamesWithSpecialPrefixes);
            this.addRule(memberDeclarationsInsideParentsScope);
        }
    }
}

