/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.common.collect.Maps;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public class AliasingContext {
    private static final ThisAliasProvider EMPTY_THIS_ALIAS_PROVIDER = new ThisAliasProvider(){

        @Override
        @Nullable
        public JsNameRef get(@NotNull DeclarationDescriptor descriptor) {
            return null;
        }

        @Override
        @Nullable
        public JsExpression get(@NotNull ResolvedCall<?> call) {
            ReceiverValue callThisObject = call.getThisObject();
            return callThisObject.exists() && (callThisObject instanceof ClassReceiver || callThisObject instanceof ExtensionReceiver) ? JsLiteral.THIS : null;
        }
    };
    private static final AliasingContext ROOT = new AliasingContext(null, EMPTY_THIS_ALIAS_PROVIDER){

        @Override
        public JsName getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
            return null;
        }

        @Override
        public JsName getAliasForExpression(@NotNull JetExpression element) {
            return null;
        }
    };
    @NotNull
    private final Map<DeclarationDescriptor, JsName> aliasesForDescriptors = Maps.newHashMap();
    @NotNull
    final ThisAliasProvider thisAliasProvider;
    @NotNull
    private final Map<JetExpression, JsName> aliasesForExpressions = Maps.newHashMap();
    @Nullable
    private final AliasingContext parent;

    public static AliasingContext getCleanContext() {
        return new AliasingContext(ROOT, AliasingContext.ROOT.thisAliasProvider);
    }

    private AliasingContext(@Nullable AliasingContext parent, @NotNull ThisAliasProvider thisAliasProvider) {
        this.parent = parent;
        this.thisAliasProvider = thisAliasProvider;
    }

    @NotNull
    public AliasingContext inner(@NotNull ThisAliasProvider thisAliasProvider) {
        return new AliasingContext(this, thisAliasProvider);
    }

    @NotNull
    public AliasingContext inner(final @NotNull DeclarationDescriptor correspondingDescriptor, final @NotNull JsName alias) {
        return this.inner(new AbstractThisAliasProvider(){

            @Override
            @Nullable
            public JsNameRef get(@NotNull DeclarationDescriptor descriptor) {
                return correspondingDescriptor == 3.normalize(descriptor) ? alias.makeRef() : null;
            }
        });
    }

    @NotNull
    public AliasingContext withAliasesForExpressions(@NotNull Map<JetExpression, JsName> aliasesForExpressions) {
        AliasingContext newContext = new AliasingContext(this, this.thisAliasProvider);
        newContext.aliasesForExpressions.putAll(aliasesForExpressions);
        return newContext;
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsName> aliases) {
        AliasingContext newContext = new AliasingContext(this, this.thisAliasProvider);
        newContext.aliasesForDescriptors.putAll(aliases);
        return newContext;
    }

    @Nullable
    public JsName getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        JsName alias = this.aliasesForDescriptors.get(descriptor.getOriginal());
        if (alias != null) {
            return alias;
        }
        assert (this.parent != null);
        return this.parent.getAliasForDescriptor(descriptor);
    }

    @Nullable
    public JsName getAliasForExpression(@NotNull JetExpression element) {
        JsName alias = this.aliasesForExpressions.get(element);
        if (alias != null) {
            return alias;
        }
        assert (this.parent != null);
        return this.parent.getAliasForExpression(element);
    }

    public static abstract class AbstractThisAliasProvider
    implements ThisAliasProvider {
        @NotNull
        protected static DeclarationDescriptor normalize(@NotNull DeclarationDescriptor descriptor) {
            if (descriptor instanceof ClassOrNamespaceDescriptor) {
                return descriptor;
            }
            if (descriptor instanceof CallableDescriptor) {
                DeclarationDescriptor receiverDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor((CallableDescriptor)descriptor);
                assert (receiverDescriptor != null);
                return receiverDescriptor;
            }
            return descriptor;
        }

        @Override
        @Nullable
        public JsExpression get(@NotNull ResolvedCall<?> call) {
            JsNameRef ref;
            ReceiverValue thisObject = call.getThisObject();
            if (!thisObject.exists()) {
                return null;
            }
            if ((thisObject instanceof ExtensionReceiver || thisObject instanceof ClassReceiver) && (ref = this.get(((ThisReceiver)thisObject).getDeclarationDescriptor())) != null) {
                return ref;
            }
            ref = this.get(JsDescriptorUtils.getDeclarationDescriptorForReceiver(thisObject));
            return ref == null ? JsLiteral.THIS : ref;
        }
    }

    public static interface ThisAliasProvider {
        @Nullable
        public JsNameRef get(@NotNull DeclarationDescriptor var1);

        @Nullable
        public JsExpression get(@NotNull ResolvedCall<?> var1);
    }
}

