/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.utils.JetFileUtils;

public class LibrarySourceDirectoriesConfig
extends Config {
    @NotNull
    protected final String[] directories;

    public LibrarySourceDirectoriesConfig(@NotNull Project project, @NotNull String moduleId, @NotNull String[] directories, @NotNull EcmaVersion ecmaVersion) {
        super(project, moduleId, ecmaVersion);
        this.directories = directories;
    }

    @Override
    @NotNull
    public List<JetFile> generateLibFiles() {
        try {
            ArrayList<JetFile> results = Lists.newArrayList();
            for (String directory : this.directories) {
                File rootDir = new File(directory);
                results.addAll(this.traverseDirectory(rootDir, rootDir));
            }
            return results;
        }
        catch (IOException e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @NotNull
    private List<JetFile> traverseDirectory(@NotNull File rootDir, @NotNull File dir) throws IOException {
        File[] files = dir.listFiles();
        File[] children = dir.listFiles();
        ArrayList<JetFile> result = Lists.newArrayList();
        if (children != null && children.length > 0) {
            for (File child : children) {
                if (child.isDirectory()) {
                    List<JetFile> childFiles = this.traverseDirectory(rootDir, child);
                    result.addAll(childFiles);
                    continue;
                }
                String name = child.getName();
                if (!name.toLowerCase().endsWith(".kt")) continue;
                String text = FileUtil.loadFile(child);
                String path = child.getPath();
                JetFile jfile = JetFileUtils.createPsiFile(path, text, this.getProject());
                result.add(jfile);
            }
        }
        return result;
    }
}

