/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.utils.KotlinPaths;
import org.jetbrains.jet.utils.KotlinPathsFromHomeDir;

public class PathUtil {
    public static final String JPS_KOTLIN_HOME_PROPERTY = "jps.kotlin.home";
    public static final String JS_LIB_JAR_NAME = "kotlin-jslib.jar";
    public static final String JS_LIB_JS_NAME = "kotlinEcma3.js";
    public static final String JDK_ANNOTATIONS_JAR = "kotlin-jdk-annotations.jar";
    public static final String ANDROID_SDK_ANNOTATIONS_JAR = "kotlin-android-sdk-annotations.jar";
    public static final String KOTLIN_JAVA_RUNTIME_JAR = "kotlin-runtime.jar";
    public static final String HOME_FOLDER_NAME = "kotlinc";
    private static final File NO_PATH = new File("<no_path>");

    private PathUtil() {
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForIdeaPlugin() {
        return new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForIdeaPlugin());
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForJpsPlugin() {
        String jpsKotlinHome = System.getProperty(JPS_KOTLIN_HOME_PROPERTY);
        if (jpsKotlinHome != null) {
            return new KotlinPathsFromHomeDir(new File(jpsKotlinHome));
        }
        return new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForJpsPlugin());
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForJpsPluginOrJpsTests() {
        if ("true".equalsIgnoreCase(System.getProperty("kotlin.jps.tests"))) {
            return PathUtil.getKotlinPathsForDistDirectory();
        }
        return PathUtil.getKotlinPathsForJpsPlugin();
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForCompiler() {
        if (!PathUtil.getPathUtilJar().isFile()) {
            return PathUtil.getKotlinPathsForDistDirectory();
        }
        return new KotlinPathsFromHomeDir(PathUtil.getCompilerPathForCompilerJar());
    }

    @NotNull
    public static KotlinPaths getKotlinPathsForDistDirectory() {
        return new KotlinPathsFromHomeDir(new File("dist", HOME_FOLDER_NAME));
    }

    @NotNull
    private static File getCompilerPathForCompilerJar() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            return NO_PATH;
        }
        if (jar.getName().equals("kotlin-compiler.jar")) {
            File lib = jar.getParentFile();
            return lib.getParentFile();
        }
        return NO_PATH;
    }

    @NotNull
    private static File getCompilerPathForJpsPlugin() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            return NO_PATH;
        }
        if (jar.getName().equals("kotlin-jps-plugin.jar")) {
            File pluginHome = jar.getParentFile().getParentFile().getParentFile();
            return new File(pluginHome, HOME_FOLDER_NAME);
        }
        return NO_PATH;
    }

    @NotNull
    private static File getCompilerPathForIdeaPlugin() {
        File jar = PathUtil.getPathUtilJar();
        if (!jar.exists()) {
            return NO_PATH;
        }
        if (jar.getName().equals("kotlin-plugin.jar")) {
            File lib = jar.getParentFile();
            File pluginHome = lib.getParentFile();
            return new File(pluginHome, HOME_FOLDER_NAME);
        }
        return NO_PATH;
    }

    private static File getPathUtilJar() {
        return PathUtil.getJarPathForClass(PathUtil.class);
    }

    @NotNull
    public static File getJarPathForClass(@NotNull Class aClass) {
        String resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        return new File(resourceRoot).getAbsoluteFile();
    }

    @NotNull
    public static VirtualFile jarFileOrDirectoryToVirtualFile(@NotNull File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return VirtualFileManager.getInstance().findFileByUrl("file://" + FileUtil.toSystemIndependentName(file.getAbsolutePath()));
            }
            return VirtualFileManager.getInstance().findFileByUrl("jar://" + FileUtil.toSystemIndependentName(file.getAbsolutePath()) + "!/");
        }
        throw new IllegalStateException("Path " + file + " does not exist.");
    }

    @NotNull
    public static File findRtJar() {
        return PathUtil.findRtJar(System.getProperty("java.home"));
    }

    private static File findRtJar(String javaHome) {
        if (SystemInfo.isMac && !SystemInfo.isJavaVersionAtLeast("1.7")) {
            File classesJar = new File(new File(javaHome).getParentFile(), "Classes/classes.jar");
            if (classesJar.exists()) {
                return classesJar;
            }
            throw new IllegalArgumentException("No classes.jar found under " + classesJar.getParent());
        }
        File rtJar = new File(javaHome, "lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        throw new IllegalArgumentException("No rt.jar found under " + rtJar.getParent());
    }
}

