/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DFS {
    public static <N, R> R dfs(@NotNull Collection<N> nodes, @NotNull Neighbors<N> neighbors, @NotNull Visited<N> visited, @NotNull NodeHandler<N, R> handler) {
        for (N node : nodes) {
            DFS.doDfs(node, neighbors, visited, handler);
        }
        return handler.result();
    }

    public static <N, R> R dfs(@NotNull Collection<N> nodes, @NotNull Neighbors<N> neighbors, @NotNull NodeHandler<N, R> handler) {
        return DFS.dfs(nodes, neighbors, new VisitedWithSet(), handler);
    }

    public static <N, R> R dfsFromNode(@NotNull N node, @NotNull Neighbors<N> neighbors, @NotNull Visited<N> visited, @NotNull NodeHandler<N, R> handler) {
        DFS.doDfs(node, neighbors, visited, handler);
        return handler.result();
    }

    public static <N> void dfsFromNode(@NotNull N node, @NotNull Neighbors<N> neighbors, @NotNull Visited<N> visited) {
        DFS.dfsFromNode(node, neighbors, visited, new AbstractNodeHandler<N, Void>(){

            @Override
            public Void result() {
                return null;
            }
        });
    }

    public static <N> List<N> topologicalOrder(@NotNull Iterable<N> nodes, @NotNull Neighbors<N> neighbors, @NotNull Visited<N> visited) {
        TopologicalOrder handler = new TopologicalOrder();
        for (N node : nodes) {
            DFS.doDfs(node, neighbors, visited, handler);
        }
        return handler.result();
    }

    public static <N> List<N> topologicalOrder(@NotNull Iterable<N> nodes, @NotNull Neighbors<N> neighbors) {
        return DFS.topologicalOrder(nodes, neighbors, new VisitedWithSet());
    }

    private static <N> void doDfs(@NotNull N current, @NotNull Neighbors<N> neighbors, @NotNull Visited<N> visited, @NotNull NodeHandler<N, ?> handler) {
        if (!visited.checkAndMarkVisited(current)) {
            return;
        }
        handler.beforeChildren(current);
        for (N neighbor : neighbors.getNeighbors(current)) {
            DFS.doDfs(neighbor, neighbors, visited, handler);
        }
        handler.afterChildren(current);
    }

    public static class TopologicalOrder<N>
    extends NodeHandlerWithListResult<N, N> {
        @Override
        public void afterChildren(N current) {
            this.result.addFirst(current);
        }
    }

    public static abstract class NodeHandlerWithListResult<N, R>
    extends AbstractNodeHandler<N, List<R>> {
        protected final LinkedList<R> result = Lists.newLinkedList();

        @Override
        public List<R> result() {
            return this.result;
        }
    }

    public static class VisitedWithSet<N>
    implements Visited<N> {
        private final Set<N> visited;

        public VisitedWithSet() {
            this(Sets.newHashSet());
        }

        public VisitedWithSet(@NotNull Set<N> visited) {
            this.visited = visited;
        }

        @Override
        public boolean checkAndMarkVisited(N current) {
            return this.visited.add(current);
        }
    }

    public static abstract class AbstractNodeHandler<N, R>
    implements NodeHandler<N, R> {
        @Override
        public void beforeChildren(N current) {
        }

        @Override
        public void afterChildren(N current) {
        }
    }

    public static interface Visited<N> {
        public boolean checkAndMarkVisited(N var1);
    }

    public static interface Neighbors<N> {
        @NotNull
        public Iterable<N> getNeighbors(N var1);
    }

    public static interface NodeHandler<N, R> {
        public void beforeChildren(N var1);

        public void afterChildren(N var1);

        public R result();
    }
}

