/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.util.slicedmap;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.util.slicedmap.MutableSlicedMap;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.RemovableSlice;
import org.jetbrains.jet.util.slicedmap.RewritePolicy;
import org.jetbrains.jet.util.slicedmap.SlicedMap;
import org.jetbrains.jet.util.slicedmap.SlicedMapKey;
import org.jetbrains.jet.util.slicedmap.WritableSlice;
import org.jetbrains.jet.utils.Printer;

public class TrackingSlicedMap
implements MutableSlicedMap {
    private final MutableSlicedMap delegate;
    private final Map<ReadOnlySlice<?, ?>, SliceWithStackTrace<?, ?>> sliceTranslationMap = Maps.newHashMap();

    public TrackingSlicedMap(@NotNull MutableSlicedMap delegate) {
        this.delegate = delegate;
    }

    private <K, V> SliceWithStackTrace<K, V> wrapSlice(ReadOnlySlice<K, V> slice) {
        SliceWithStackTrace<Object, Object> translated = this.sliceTranslationMap.get(slice);
        if (translated == null) {
            translated = new SliceWithStackTrace(slice);
            this.sliceTranslationMap.put(slice, translated);
        }
        return translated;
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return (V)((WithStackTrace)this.delegate.get(this.wrapSlice(slice), key)).value;
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        return this.delegate.getKeys(this.wrapSlice(slice));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<SlicedMapKey<?, ?>, ?>> iterator() {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : this.delegate) {
            map.put(entry.getKey(), ((WithStackTrace)entry.getValue()).value);
        }
        return map.entrySet().iterator();
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value) {
        this.delegate.put(this.wrapSlice(slice), key, new WithStackTrace(value));
    }

    @Override
    public <K, V> V remove(RemovableSlice<K, V> slice, K key) {
        return (V)((WithStackTrace)this.delegate.remove(this.wrapSlice(slice), key)).value;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    @NotNull
    public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
        return this.delegate.getSliceContents(slice);
    }

    public class SliceWithStackTrace<K, V>
    implements RemovableSlice<K, WithStackTrace<V>> {
        private final ReadOnlySlice<K, V> delegate;

        private SliceWithStackTrace(@NotNull ReadOnlySlice<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public SlicedMapKey<K, WithStackTrace<V>> makeKey(K key) {
            return this.delegate.makeKey(key);
        }

        @Override
        public WithStackTrace<V> computeValue(SlicedMap map, K key, WithStackTrace<V> value, boolean valueNotFound) {
            return new WithStackTrace(this.delegate.computeValue(map, key, value == null ? null : ((WithStackTrace)value).value, valueNotFound));
        }

        @Override
        public ReadOnlySlice<K, WithStackTrace<V>> makeRawValueVersion() {
            return TrackingSlicedMap.this.wrapSlice(this.delegate.makeRawValueVersion());
        }

        private WritableSlice<K, V> getWritableDelegate() {
            return (WritableSlice)this.delegate;
        }

        @Override
        public boolean isCollective() {
            return this.getWritableDelegate().isCollective();
        }

        @Override
        public RewritePolicy getRewritePolicy() {
            return this.getWritableDelegate().getRewritePolicy();
        }

        @Override
        public void afterPut(MutableSlicedMap map, K key, WithStackTrace<V> value) {
            this.getWritableDelegate().afterPut(map, key, ((WithStackTrace)value).value);
        }

        @Override
        public boolean check(K key, WithStackTrace<V> value) {
            return this.getWritableDelegate().check(key, ((WithStackTrace)value).value);
        }
    }

    private static class WithStackTrace<V> {
        private final V value;
        private final StackTraceElement[] stackTrace;

        private WithStackTrace(V value) {
            this.value = value;
            this.stackTrace = Thread.currentThread().getStackTrace();
        }

        private Appendable printStackTrace(Appendable appendable) {
            StackTraceElement[] trace;
            Printer s = new Printer(appendable);
            s.println(this.value);
            s.println("Written at ");
            for (StackTraceElement aTrace : trace = this.stackTrace) {
                s.println("\tat " + aTrace);
            }
            s.println("---------");
            return appendable;
        }

        public String toString() {
            return this.printStackTrace(new StringBuilder()).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WithStackTrace other = (WithStackTrace)o;
            return !(this.value != null ? !this.value.equals(other.value) : other.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

