/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    protected PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    @Override
    public JetTypeInfo visitIsExpression(JetIsExpression expression, ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression leftHandSide = expression.getLeftHandSide();
        JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(leftHandSide, (ExpressionTypingContext)context.replaceScope(context.scope));
        JetType knownType = typeInfo.getType();
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        if (expression.getTypeRef() != null) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(leftHandSide, knownType, context.trace.getBindingContext());
            DataFlowInfo conditionInfo = PatternMatchingTypingVisitor.checkTypeForIs(context, knownType, expression.getTypeRef(), dataFlowValue).thenInfo;
            DataFlowInfo newDataFlowInfo = conditionInfo.and(dataFlowInfo);
            context.trace.record(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression, newDataFlowInfo);
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getBooleanType(), expression, contextWithExpectedType, dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitWhenExpression(JetWhenExpression expression, ExpressionTypingContext context) {
        return this.visitWhenExpression(expression, context, false);
    }

    public JetTypeInfo visitWhenExpression(JetWhenExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        JetType subjectType;
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression subjectExpression = expression.getSubjectExpression();
        if (subjectExpression == null) {
            subjectType = ErrorUtils.createErrorType("Unknown type");
        } else {
            JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(subjectExpression, context);
            subjectType = typeInfo.getType();
            context = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        }
        DataFlowValue subjectDataFlowValue = subjectExpression != null ? DataFlowValueFactory.INSTANCE.createDataFlowValue(subjectExpression, subjectType, context.trace.getBindingContext()) : DataFlowValue.NULL;
        HashSet<JetType> expressionTypes = Sets.newHashSet();
        DataFlowInfo commonDataFlowInfo = null;
        DataFlowInfo elseDataFlowInfo = context.dataFlowInfo;
        for (JetWhenEntry whenEntry : expression.getEntries()) {
            JetExpression bodyExpression;
            DataFlowInfo newDataFlowInfo;
            WritableScopeImpl scopeToExtend;
            JetWhenCondition[] conditions = whenEntry.getConditions();
            if (whenEntry.isElse()) {
                scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope extended in when-else entry");
                newDataFlowInfo = elseDataFlowInfo;
            } else if (conditions.length == 1) {
                scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope extended in when entry");
                newDataFlowInfo = context.dataFlowInfo;
                JetWhenCondition condition = conditions[0];
                if (condition != null) {
                    DataFlowInfos infos = this.checkWhenCondition(subjectExpression, subjectExpression == null, subjectType, condition, context, subjectDataFlowValue);
                    newDataFlowInfo = infos.thenInfo;
                    elseDataFlowInfo = elseDataFlowInfo.and(infos.elseInfo);
                }
            } else {
                scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, "pattern matching");
                newDataFlowInfo = null;
                for (JetWhenCondition condition : conditions) {
                    DataFlowInfos infos = this.checkWhenCondition(subjectExpression, subjectExpression == null, subjectType, condition, context, subjectDataFlowValue);
                    newDataFlowInfo = newDataFlowInfo == null ? infos.thenInfo : newDataFlowInfo.or(infos.thenInfo);
                    elseDataFlowInfo = elseDataFlowInfo.and(infos.elseInfo);
                }
                if (newDataFlowInfo == null) {
                    newDataFlowInfo = context.dataFlowInfo;
                }
            }
            if ((bodyExpression = whenEntry.getExpression()) == null) continue;
            ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceScope(scopeToExtend)).replaceDataFlowInfo(newDataFlowInfo);
            CoercionStrategy coercionStrategy = isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION;
            JetTypeInfo typeInfo = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(bodyExpression), coercionStrategy, newContext, context.trace);
            JetType type = typeInfo.getType();
            if (type != null) {
                expressionTypes.add(type);
            }
            if (commonDataFlowInfo == null) {
                commonDataFlowInfo = typeInfo.getDataFlowInfo();
                continue;
            }
            commonDataFlowInfo = commonDataFlowInfo.or(typeInfo.getDataFlowInfo());
        }
        if (commonDataFlowInfo == null) {
            commonDataFlowInfo = context.dataFlowInfo;
        }
        if (!expressionTypes.isEmpty()) {
            return DataFlowUtils.checkImplicitCast(CommonSupertypes.commonSupertype(expressionTypes), expression, contextWithExpectedType, isStatement, commonDataFlowInfo);
        }
        return JetTypeInfo.create(null, commonDataFlowInfo);
    }

    private DataFlowInfos checkWhenCondition(final @Nullable JetExpression subjectExpression, final boolean expectedCondition, final JetType subjectType, JetWhenCondition condition, final ExpressionTypingContext context, final DataFlowValue subjectDataFlowValue) {
        final Ref<DataFlowInfos> newDataFlowInfo = new Ref<DataFlowInfos>(PatternMatchingTypingVisitor.noChange(context));
        condition.accept(new JetVisitorVoid(){

            @Override
            public void visitWhenConditionInRange(JetWhenConditionInRange condition) {
                JetExpression rangeExpression = condition.getRangeExpression();
                if (rangeExpression == null) {
                    return;
                }
                if (expectedCondition) {
                    context.trace.report(Errors.EXPECTED_CONDITION.on(condition));
                    DataFlowInfo dataFlowInfo = PatternMatchingTypingVisitor.this.facade.getTypeInfo(rangeExpression, context).getDataFlowInfo();
                    newDataFlowInfo.set(new DataFlowInfos(dataFlowInfo, dataFlowInfo));
                    return;
                }
                JetTypeInfo typeInfo = PatternMatchingTypingVisitor.this.facade.checkInExpression(condition, condition.getOperationReference(), subjectExpression, rangeExpression, context);
                DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
                newDataFlowInfo.set(new DataFlowInfos(dataFlowInfo, dataFlowInfo));
                if (!KotlinBuiltIns.getInstance().getBooleanType().equals(typeInfo.getType())) {
                    context.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on(condition));
                }
            }

            @Override
            public void visitWhenConditionIsPattern(JetWhenConditionIsPattern condition) {
                if (expectedCondition) {
                    context.trace.report(Errors.EXPECTED_CONDITION.on(condition));
                }
                if (condition.getTypeRef() != null) {
                    DataFlowInfos result = PatternMatchingTypingVisitor.checkTypeForIs(context, subjectType, condition.getTypeRef(), subjectDataFlowValue);
                    if (condition.isNegated()) {
                        newDataFlowInfo.set(new DataFlowInfos(result.elseInfo, result.thenInfo));
                    } else {
                        newDataFlowInfo.set(result);
                    }
                }
            }

            @Override
            public void visitWhenConditionWithExpression(JetWhenConditionWithExpression condition) {
                JetExpression expression = condition.getExpression();
                if (expression != null) {
                    newDataFlowInfo.set(PatternMatchingTypingVisitor.this.checkTypeForExpressionCondition(context, expression, subjectType, subjectExpression == null, subjectDataFlowValue));
                }
            }

            @Override
            public void visitJetElement(JetElement element) {
                context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
            }
        });
        return newDataFlowInfo.get();
    }

    private DataFlowInfos checkTypeForExpressionCondition(ExpressionTypingContext context, JetExpression expression, JetType subjectType, boolean conditionExpected, DataFlowValue subjectDataFlowValue) {
        if (expression == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(expression, context);
        JetType type = typeInfo.getType();
        if (type == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (conditionExpected) {
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            if (JetTypeChecker.INSTANCE.equalTypes(booleanType, type)) {
                DataFlowInfo ifInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expression, true, context);
                DataFlowInfo elseInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expression, false, context);
                return new DataFlowInfos(ifInfo, elseInfo);
            }
            context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(expression, type));
            return PatternMatchingTypingVisitor.noChange(context);
        }
        PatternMatchingTypingVisitor.checkTypeCompatibility(context, type, subjectType, expression);
        DataFlowValue expressionDataFlowValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(expression, type, context.trace.getBindingContext());
        DataFlowInfos result = PatternMatchingTypingVisitor.noChange(context);
        result = new DataFlowInfos(result.thenInfo.equate(subjectDataFlowValue, expressionDataFlowValue), result.elseInfo.disequate(subjectDataFlowValue, expressionDataFlowValue));
        return result;
    }

    private static DataFlowInfos checkTypeForIs(ExpressionTypingContext context, JetType subjectType, JetTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        if (typeReferenceAfterIs == null) {
            return PatternMatchingTypingVisitor.noChange(context);
        }
        JetType type = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, typeReferenceAfterIs, context.trace, true);
        if (!subjectType.isNullable() && type.isNullable()) {
            JetTypeElement element = typeReferenceAfterIs.getTypeElement();
            assert (element instanceof JetNullableType) : "element must be instance of " + JetNullableType.class.getName();
            JetNullableType nullableType = (JetNullableType)element;
            context.trace.report(Errors.USELESS_NULLABLE_CHECK.on(nullableType));
        }
        PatternMatchingTypingVisitor.checkTypeCompatibility(context, type, subjectType, typeReferenceAfterIs);
        if (BasicExpressionTypingVisitor.isCastErased(subjectType, type, JetTypeChecker.INSTANCE)) {
            context.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on(typeReferenceAfterIs, type));
        }
        return new DataFlowInfos(context.dataFlowInfo.establishSubtyping(subjectDataFlowValue, type), context.dataFlowInfo);
    }

    private static DataFlowInfos noChange(ExpressionTypingContext context) {
        return new DataFlowInfos(context.dataFlowInfo, context.dataFlowInfo);
    }

    private static void checkTypeCompatibility(@NotNull ExpressionTypingContext context, @Nullable JetType type, @NotNull JetType subjectType, @NotNull JetElement reportErrorOn) {
        if (type == null) {
            return;
        }
        if (TypeUtils.isIntersectionEmpty(type, subjectType)) {
            context.trace.report(Errors.INCOMPATIBLE_TYPES.on(reportErrorOn, type, subjectType));
            return;
        }
        if (KotlinBuiltIns.getInstance().isNullableNothing(type) && !subjectType.isNullable()) {
            context.trace.report(Errors.SENSELESS_NULL_IN_WHEN.on(reportErrorOn));
        }
    }

    private static class DataFlowInfos {
        private final DataFlowInfo thenInfo;
        private final DataFlowInfo elseInfo;

        private DataFlowInfos(DataFlowInfo thenInfo, DataFlowInfo elseInfo) {
            this.thenInfo = thenInfo;
            this.elseInfo = elseInfo;
        }
    }
}

