/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.ResolveMode;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantResolver;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;

public class ExpressionTypingContext
extends ResolutionContext<ExpressionTypingContext> {
    public final ExpressionTypingServices expressionTypingServices;
    public final LabelResolver labelResolver;
    private CompileTimeConstantResolver compileTimeConstantResolver;

    @NotNull
    public static ExpressionTypingContext newContext(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull ExpressionPosition expressionPosition) {
        return ExpressionTypingContext.newContext(expressionTypingServices, new LabelResolver(), trace, scope, dataFlowInfo, expectedType, expressionPosition);
    }

    @NotNull
    public static ExpressionTypingContext newContext(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull LabelResolver labelResolver, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull ExpressionPosition expressionPosition) {
        return new ExpressionTypingContext(expressionTypingServices, labelResolver, trace, scope, dataFlowInfo, expectedType, expressionPosition);
    }

    private ExpressionTypingContext(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull LabelResolver labelResolver, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull ExpressionPosition expressionPosition) {
        super(trace, scope, expectedType, dataFlowInfo, expressionPosition);
        this.expressionTypingServices = expressionTypingServices;
        this.labelResolver = labelResolver;
    }

    @Override
    protected ExpressionTypingContext create(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull ExpressionPosition expressionPosition) {
        return new ExpressionTypingContext(this.expressionTypingServices, this.labelResolver, trace, scope, dataFlowInfo, expectedType, expressionPosition);
    }

    @Override
    protected ExpressionTypingContext self() {
        return this;
    }

    public CompileTimeConstantResolver getCompileTimeConstantResolver() {
        if (this.compileTimeConstantResolver == null) {
            this.compileTimeConstantResolver = new CompileTimeConstantResolver();
        }
        return this.compileTimeConstantResolver;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull Call call, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        return this.expressionTypingServices.getCallResolver().resolveCallWithGivenName(BasicCallResolutionContext.create(this, call, ResolveMode.TOP_LEVEL_CALL, CheckValueArgumentsMode.ENABLED, ResolutionResultsCache.create()), functionReference, name);
    }
}

