/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderers;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DelegatedPropertyUtils {
    @Nullable
    public static JetType getDelegatedPropertyGetMethodReturnType(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull BindingTrace trace, @NotNull JetScope scope) {
        DelegatedPropertyUtils.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, expressionTypingServices, trace, scope, true);
        return DelegatedPropertyUtils.getDelegateGetMethodReturnType(trace.getBindingContext(), propertyDescriptor);
    }

    @Nullable
    private static JetType getDelegateGetMethodReturnType(@NotNull BindingContext context, @NotNull PropertyDescriptor descriptor) {
        ResolvedCall<FunctionDescriptor> resolvedCall = context.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, descriptor.getGetter());
        return resolvedCall != null ? resolvedCall.getResultingDescriptor().getReturnType() : null;
    }

    public static void resolveDelegatedPropertyGetMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull BindingTrace trace, @NotNull JetScope scope) {
        DelegatedPropertyUtils.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, expressionTypingServices, trace, scope, true);
        JetType returnType = DelegatedPropertyUtils.getDelegateGetMethodReturnType(trace.getBindingContext(), propertyDescriptor);
        JetType propertyType = propertyDescriptor.getType();
        if (!(propertyType instanceof DeferredType) && returnType != null && !JetTypeChecker.INSTANCE.isSubtypeOf(returnType, propertyType)) {
            Call call = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, propertyDescriptor.getGetter());
            assert (call != null) : "Call should exists for " + propertyDescriptor.getGetter();
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on(delegateExpression, DelegatedPropertyUtils.renderCall(call, trace.getBindingContext()), propertyDescriptor.getType(), returnType));
        }
    }

    public static void resolveDelegatedPropertySetMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull BindingTrace trace, @NotNull JetScope scope) {
        DelegatedPropertyUtils.resolveDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, expressionTypingServices, trace, scope, false);
    }

    private static void resolveDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull BindingTrace trace, @NotNull JetScope scope, boolean isGet) {
        PropertyAccessorDescriptor accessor;
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        assert (accessor != null) : "Delegated property should have getter/setter " + propertyDescriptor + " " + delegateExpression.getText();
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults<FunctionDescriptor> functionResults = DelegatedPropertyUtils.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, delegateType, expressionTypingServices, trace, scope, isGet);
        Call call = trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
        assert (call != null) : "'getDelegatedPropertyConventionMethod' didn't record a call";
        if (!functionResults.isSuccess()) {
            String expectedFunction = DelegatedPropertyUtils.renderCall(call, trace.getBindingContext());
            if (functionResults.isIncomplete()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on(delegateExpression, expectedFunction, delegateType));
            } else if (functionResults.isSingleResult() || functionResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else if (functionResults.isAmbiguity()) {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY.on(delegateExpression, expectedFunction, functionResults.getResultingCalls()));
            } else {
                trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on(delegateExpression, expectedFunction, delegateType));
            }
            return;
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, functionResults.getResultingCall());
    }

    public static OverloadResolutionResults<FunctionDescriptor> getDelegatedPropertyConventionMethod(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetType delegateType, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull BindingTrace trace, @NotNull JetScope scope, boolean isGet) {
        PropertyAccessorDescriptor accessor;
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        assert (accessor != null) : "Delegated property should have getter/setter " + propertyDescriptor + " " + delegateExpression.getText();
        ExpressionTypingContext context = ExpressionTypingContext.newContext(expressionTypingServices, trace, scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, ExpressionPosition.FREE);
        Project project = context.expressionTypingServices.getProject();
        boolean hasThis = propertyDescriptor.getReceiverParameter() != null || propertyDescriptor.getExpectedThisObject() != null;
        ArrayList<JetExpression> arguments = Lists.newArrayList();
        arguments.add(JetPsiFactory.createExpression(project, hasThis ? "this" : "null"));
        arguments.add(JetPsiFactory.createExpression(project, KotlinBuiltIns.getInstance().getPropertyMetadataImpl().getName().asString() + "(\"" + propertyDescriptor.getName().asString() + "\")"));
        if (!isGet) {
            JetReferenceExpression fakeArgument = (JetReferenceExpression)ExpressionTypingUtils.createFakeExpressionOfType(context.expressionTypingServices.getProject(), trace, "fakeArgument" + arguments.size(), propertyDescriptor.getType());
            arguments.add(fakeArgument);
            List<ValueParameterDescriptor> valueParameters = accessor.getValueParameters();
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters.get(0));
        }
        Name functionName = Name.identifier(isGet ? "get" : "set");
        JetSimpleNameExpression fakeCalleeExpression = JetPsiFactory.createSimpleName(project, functionName.asString());
        ExpressionReceiver receiver = new ExpressionReceiver(delegateExpression, delegateType);
        Call call = CallMaker.makeCallWithExpressions(fakeCalleeExpression, receiver, null, fakeCalleeExpression, arguments, Call.CallType.DEFAULT);
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, call);
        return context.resolveCallWithGivenName(call, fakeCalleeExpression, functionName);
    }

    private static String renderCall(@NotNull Call call, @NotNull BindingContext context) {
        JetExpression calleeExpression = call.getCalleeExpression();
        assert (calleeExpression != null) : "CalleeExpression should exists for fake call of convention method";
        StringBuilder builder = new StringBuilder(calleeExpression.getText());
        builder.append("(");
        ArrayList<JetType> argumentTypes = Lists.newArrayList();
        for (ValueArgument valueArgument : call.getValueArguments()) {
            argumentTypes.add(context.get(BindingContext.EXPRESSION_TYPE, valueArgument.getArgumentExpression()));
        }
        builder.append(Renderers.RENDER_COLLECTION_OF_TYPES.render(argumentTypes));
        builder.append(")");
        return builder.toString();
    }

    private DelegatedPropertyUtils() {
    }
}

