/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.util.CommonSuppliers;

public class SubstitutionUtils {
    @NotNull
    public static Map<TypeConstructor, TypeProjection> buildSubstitutionContext(@NotNull JetType context) {
        return SubstitutionUtils.buildSubstitutionContext(context.getConstructor().getParameters(), context.getArguments());
    }

    @NotNull
    public static TypeSubstitutor buildDeepSubstitutor(@NotNull JetType type) {
        HashMap<TypeConstructor, TypeProjection> substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitution);
        SubstitutionUtils.fillInDeepSubstitutor(type, typeSubstitutor, substitution, null);
        return typeSubstitutor;
    }

    @NotNull
    public static Multimap<TypeConstructor, TypeProjection> buildDeepSubstitutionMultimap(@NotNull JetType type) {
        SetMultimap<TypeConstructor, TypeProjection> fullSubstitution = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        HashMap<TypeConstructor, TypeProjection> substitution = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitution);
        SubstitutionUtils.fillInDeepSubstitutor(type, typeSubstitutor, substitution, fullSubstitution);
        return fullSubstitution;
    }

    private static void fillInDeepSubstitutor(@NotNull JetType context, @NotNull TypeSubstitutor substitutor, @NotNull Map<TypeConstructor, TypeProjection> substitution, @Nullable Multimap<TypeConstructor, TypeProjection> fullSubstitution) {
        List<TypeParameterDescriptor> parameters = context.getConstructor().getParameters();
        List<TypeProjection> arguments = context.getArguments();
        if (parameters.size() != arguments.size()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < arguments.size(); ++i) {
            TypeProjection argument = arguments.get(i);
            TypeParameterDescriptor parameter = parameters.get(i);
            TypeProjection substitute = substitutor.substitute(argument);
            assert (substitute != null);
            substitution.put(parameter.getTypeConstructor(), substitute);
            if (fullSubstitution == null) continue;
            fullSubstitution.put(parameter.getTypeConstructor(), substitute);
        }
        if (KotlinBuiltIns.getInstance().isNothingOrNullableNothing(context)) {
            return;
        }
        for (JetType supertype : context.getConstructor().getSupertypes()) {
            SubstitutionUtils.fillInDeepSubstitutor(supertype, substitutor, substitution, fullSubstitution);
        }
    }

    @NotNull
    public static Map<TypeConstructor, TypeProjection> buildSubstitutionContext(@NotNull List<TypeParameterDescriptor> parameters, @NotNull List<TypeProjection> contextArguments) {
        HashMap<TypeConstructor, TypeProjection> parameterValues = new HashMap<TypeConstructor, TypeProjection>();
        SubstitutionUtils.fillInSubstitutionContext(parameters, contextArguments, parameterValues);
        return parameterValues;
    }

    private static void fillInSubstitutionContext(List<TypeParameterDescriptor> parameters, List<TypeProjection> contextArguments, Map<TypeConstructor, TypeProjection> parameterValues) {
        if (parameters.size() != contextArguments.size()) {
            throw new IllegalArgumentException("type parameter count != context arguments");
        }
        int parametersSize = parameters.size();
        for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameter = parameters.get(i);
            TypeProjection value = contextArguments.get(i);
            parameterValues.put(parameter.getTypeConstructor(), value);
        }
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        return new TypeProjection(parameterDescriptor.getVariance() == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE, parameterDescriptor.getUpperBoundsAsType());
    }

    public static boolean hasUnsubstitutedTypeParameters(JetType type) {
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return true;
        }
        for (TypeProjection proj : type.getArguments()) {
            if (!SubstitutionUtils.hasUnsubstitutedTypeParameters(proj.getType())) continue;
            return true;
        }
        return false;
    }

    public static Map<TypeConstructor, TypeProjection> removeTrivialSubstitutions(Map<TypeConstructor, TypeProjection> context) {
        HashMap<TypeConstructor, TypeProjection> clean = Maps.newHashMap(context);
        boolean changed = false;
        Iterator iterator = clean.entrySet().iterator();
        while (iterator.hasNext()) {
            TypeProjection value;
            Map.Entry entry = iterator.next();
            TypeConstructor key = (TypeConstructor)entry.getKey();
            if (key != (value = (TypeProjection)entry.getValue()).getType().getConstructor() || value.getProjectionKind() != Variance.INVARIANT) continue;
            iterator.remove();
            changed = true;
        }
        return changed ? clean : context;
    }

    public static void assertNotImmediatelyRecursive(Map<TypeConstructor, TypeProjection> context) {
        for (Map.Entry<TypeConstructor, TypeProjection> entry : context.entrySet()) {
            TypeProjection value;
            TypeConstructor key = entry.getKey();
            if (!TypeUtils.typeConstructorUsedInType(key, (value = entry.getValue()).getType())) continue;
            throw new IllegalStateException("Immediately recursive substitution: " + context + "\nProblematic parameter: " + key + " -> " + value);
        }
    }
}

