/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class SubstitutingScope
implements JetScope {
    private final JetScope workerScope;
    private final TypeSubstitutor substitutor;
    private Map<DeclarationDescriptor, DeclarationDescriptor> substitutedDescriptors = null;
    private Collection<DeclarationDescriptor> allDescriptors = null;

    public SubstitutingScope(JetScope workerScope, @NotNull TypeSubstitutor substitutor) {
        this.workerScope = workerScope;
        this.substitutor = substitutor;
    }

    @Nullable
    private <D extends DeclarationDescriptor> D substitute(@Nullable D descriptor) {
        DeclarationDescriptor substituted;
        if (descriptor == null) {
            return null;
        }
        if (this.substitutor.isEmpty()) {
            return descriptor;
        }
        if (this.substitutedDescriptors == null) {
            this.substitutedDescriptors = Maps.newHashMap();
        }
        if ((substituted = this.substitutedDescriptors.get(descriptor)) == null && !this.substitutedDescriptors.containsKey(descriptor)) {
            substituted = descriptor.substitute(this.substitutor);
            this.substitutedDescriptors.put(descriptor, substituted);
        }
        return (D)substituted;
    }

    @NotNull
    private <D extends DeclarationDescriptor> Collection<D> substitute(@NotNull Collection<D> descriptors) {
        if (this.substitutor.isEmpty()) {
            return descriptors;
        }
        if (descriptors.isEmpty()) {
            return descriptors;
        }
        HashSet<DeclarationDescriptor> result = Sets.newHashSetWithExpectedSize(descriptors.size());
        for (DeclarationDescriptor descriptor : descriptors) {
            DeclarationDescriptor substitute = this.substitute(descriptor);
            if (substitute == null) continue;
            result.add(substitute);
        }
        return result;
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        return this.substitute(this.workerScope.getProperties(name));
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        return this.substitute(this.workerScope.getLocalVariable(name));
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        return this.substitute(this.workerScope.getClassifier(name));
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        return this.substitute(this.workerScope.getObjectDescriptor(name));
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getObjectDescriptors() {
        return this.substitute(this.workerScope.getObjectDescriptors());
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        return this.substitute(this.workerScope.getFunctions(name));
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.workerScope.getNamespace(name);
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.workerScope.getContainingDeclaration();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = this.substitute(this.workerScope.getAllDescriptors());
        }
        return this.allDescriptors;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        return this.substitute(this.workerScope.getOwnDeclaredDescriptors());
    }
}

