/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class FilteringScope
implements JetScope {
    @NotNull
    private final JetScope workerScope;
    @NotNull
    private final Predicate<DeclarationDescriptor> predicate;

    public FilteringScope(@NotNull JetScope workerScope, @NotNull Predicate<DeclarationDescriptor> predicate) {
        this.workerScope = workerScope;
        this.predicate = predicate;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        return Collections2.filter(this.workerScope.getFunctions(name), this.predicate);
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.workerScope.getContainingDeclaration();
    }

    @Nullable
    private <D extends DeclarationDescriptor> D filterDescriptor(@Nullable D descriptor) {
        return descriptor != null && this.predicate.apply(descriptor) ? (D)descriptor : null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.filterDescriptor(this.workerScope.getNamespace(name));
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        return this.filterDescriptor(this.workerScope.getClassifier(name));
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        return this.filterDescriptor(this.workerScope.getObjectDescriptor(name));
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getObjectDescriptors() {
        return Collections2.filter(this.workerScope.getObjectDescriptors(), this.predicate);
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        return Collections2.filter(this.workerScope.getProperties(name), this.predicate);
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        return this.filterDescriptor(this.workerScope.getLocalVariable(name));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        return Collections2.filter(this.workerScope.getAllDescriptors(), this.predicate);
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        return this.workerScope.getImplicitReceiversHierarchy();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        return Collections2.filter(this.workerScope.getDeclarationsByLabel(labelName), this.predicate);
    }

    @Override
    public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
        return this.filterDescriptor(this.workerScope.getPropertyByFieldReference(fieldName));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        return Collections2.filter(this.workerScope.getOwnDeclaredDescriptors(), this.predicate);
    }
}

