/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import org.jetbrains.annotations.NotNull;

public class NameUtils {
    private NameUtils() {
    }

    public static boolean isValidIdentified(@NotNull String name) {
        return name.length() > 0 && !name.startsWith("<") && !name.contains(".") && !name.contains("/");
    }

    public static void requireIdentifier(@NotNull String name) {
        if (!NameUtils.isValidIdentified(name)) {
            throw new IllegalArgumentException("invalid identifier: " + name);
        }
    }
}

