/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.declarations;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;

public class PsiBasedClassMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements ClassMemberDeclarationProvider {
    private final JetClassLikeInfo classInfo;

    public PsiBasedClassMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull JetClassLikeInfo classInfo) {
        super(storageManager);
        this.classInfo = classInfo;
    }

    @Override
    @NotNull
    public JetClassLikeInfo getOwnerInfo() {
        return this.classInfo;
    }

    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index) {
        for (JetDeclaration jetDeclaration : this.classInfo.getDeclarations()) {
            if (jetDeclaration instanceof JetClassObject) continue;
            index.putToIndex(jetDeclaration);
        }
        for (JetParameter jetParameter : this.classInfo.getPrimaryConstructorParameters()) {
            if (jetParameter.getValOrVarNode() == null) continue;
            index.putToIndex(jetParameter);
        }
    }

    public String toString() {
        return "Declarations for " + this.classInfo;
    }
}

