/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.declarations;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.EmptyPackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedPackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class FileBasedDeclarationProviderFactory
implements DeclarationProviderFactory {
    private final Predicate<FqName> isPackageDeclaredExternally;
    private final StorageManager storageManager;
    private final NotNullLazyValue<Index> index;
    private final MemoizedFunctionToNullable<FqName, PackageMemberDeclarationProvider> packageDeclarationProviders;

    public FileBasedDeclarationProviderFactory(@NotNull StorageManager storageManager, @NotNull Collection<JetFile> files) {
        this(storageManager, files, Predicates.alwaysFalse());
    }

    public FileBasedDeclarationProviderFactory(@NotNull StorageManager storageManager, final @NotNull Collection<JetFile> files, @NotNull Predicate<FqName> isPackageDeclaredExternally) {
        this.storageManager = storageManager;
        this.isPackageDeclaredExternally = isPackageDeclaredExternally;
        this.index = storageManager.createLazyValue(new Computable<Index>(){

            @Override
            public Index compute() {
                return FileBasedDeclarationProviderFactory.computeFilesByPackage(files);
            }
        });
        this.packageDeclarationProviders = storageManager.createMemoizedFunctionWithNullableValues(new Function<FqName, PackageMemberDeclarationProvider>(){

            @Override
            public PackageMemberDeclarationProvider fun(FqName fqName) {
                return FileBasedDeclarationProviderFactory.this.createPackageMemberDeclarationProvider(fqName);
            }
        }, StorageManager.ReferenceKind.STRONG);
    }

    @NotNull
    private static Index computeFilesByPackage(@NotNull Collection<JetFile> files) {
        Index index = new Index();
        for (JetFile file : files) {
            JetNamespaceHeader header = file.getNamespaceHeader();
            if (header == null) {
                throw new IllegalArgumentException("Scripts are not supported");
            }
            FqName packageFqName = new FqName(header.getQualifiedName());
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index, packageFqName);
            index.filesByPackage.put(packageFqName, file);
        }
        return index;
    }

    private static void addMeAndParentPackages(@NotNull Index index, @NotNull FqName name) {
        index.declaredPackages.add(name);
        if (!name.isRoot()) {
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index, name.parent());
        }
    }

    boolean isPackageDeclaredExplicitly(@NotNull FqName packageFqName) {
        return this.index.compute().declaredPackages.contains(packageFqName);
    }

    boolean isPackageDeclared(@NotNull FqName packageFqName) {
        return this.isPackageDeclaredExplicitly(packageFqName) || this.isPackageDeclaredExternally.apply(packageFqName);
    }

    Collection<FqName> getAllDeclaredSubPackagesOf(final @NotNull FqName parent) {
        return Collections2.filter(this.index.compute().declaredPackages, new Predicate<FqName>(){

            @Override
            public boolean apply(FqName fqName) {
                return !fqName.isRoot() && fqName.parent().equals(parent);
            }
        });
    }

    @Override
    public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        return this.packageDeclarationProviders.fun(packageFqName);
    }

    @Nullable
    public PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        if (!this.isPackageDeclaredExplicitly(packageFqName)) {
            if (this.isPackageDeclaredExternally.apply(packageFqName)) {
                return EmptyPackageMemberDeclarationProvider.INSTANCE;
            }
            return null;
        }
        return new FileBasedPackageMemberDeclarationProvider(this.storageManager, packageFqName, this, this.index.compute().filesByPackage.get(packageFqName));
    }

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull JetClassLikeInfo classLikeInfo) {
        if (!this.index.compute().filesByPackage.containsKey(classLikeInfo.getContainingPackageFqName())) {
            throw new IllegalStateException("This factory doesn't know about this class: " + classLikeInfo);
        }
        return new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
    }

    private static class Index {
        private final Multimap<FqName, JetFile> filesByPackage = HashMultimap.create();
        private final Set<FqName> declaredPackages = Sets.newHashSet();

        private Index() {
        }
    }
}

