/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.di.InjectorForBodyResolve;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetNamed;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.BodyResolver;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ScopeProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.util.QualifiedNamesUtil;

public class ResolveSessionUtils {
    public static final Name NO_NAME_FOR_LAZY_RESOLVE = Name.identifier("no_name_in_PSI_for_lazy_resolve_3d19d79d_1ba9_4cd0_b7f5_b46aa3cd5d40");
    private static final BodyResolveContextForLazy EMPTY_CONTEXT = new BodyResolveContextForLazy(Functions.constant(null));

    private ResolveSessionUtils() {
    }

    @NotNull
    public static BindingContext resolveToExpression(@NotNull ResolveSession resolveSession, @NotNull JetElement expression) {
        DelegatingBindingTrace trace = new DelegatingBindingTrace(resolveSession.getBindingContext(), "trace to resolve expression", expression);
        JetFile file = (JetFile)expression.getContainingFile();
        PsiElement topmostCandidateForAdditionalResolve = JetPsiUtil.getTopmostParentOfTypes(expression, JetNamedFunction.class, JetClassInitializer.class, JetProperty.class, JetDelegationSpecifierList.class);
        if (topmostCandidateForAdditionalResolve != null) {
            if (topmostCandidateForAdditionalResolve instanceof JetNamedFunction) {
                ResolveSessionUtils.functionAdditionalResolve(resolveSession, (JetNamedFunction)topmostCandidateForAdditionalResolve, trace, file);
            } else if (topmostCandidateForAdditionalResolve instanceof JetClassInitializer) {
                ResolveSessionUtils.initializerAdditionalResolve(resolveSession, (JetClassInitializer)topmostCandidateForAdditionalResolve, trace, file);
            } else if (topmostCandidateForAdditionalResolve instanceof JetProperty) {
                ResolveSessionUtils.propertyAdditionalResolve(resolveSession, (JetProperty)topmostCandidateForAdditionalResolve, trace, file);
            } else if (topmostCandidateForAdditionalResolve instanceof JetDelegationSpecifierList) {
                ResolveSessionUtils.delegationSpecifierAdditionalResolve(resolveSession, (JetDelegationSpecifierList)topmostCandidateForAdditionalResolve, trace, file);
            } else assert (false) : "Invalid type of the topmost parent";
            return trace.getBindingContext();
        }
        if (expression instanceof JetExpression) {
            JetScope scope;
            JetExpression jetExpression = (JetExpression)expression;
            if (trace.getBindingContext().get(BindingContext.RESOLUTION_SCOPE, jetExpression) == null && (scope = ResolveSessionUtils.getExpressionMemberScope(resolveSession, jetExpression)) != null) {
                trace.record(BindingContext.RESOLUTION_SCOPE, jetExpression, scope);
            }
        }
        return trace.getBindingContext();
    }

    private static void delegationSpecifierAdditionalResolve(KotlinCodeAnalyzer analyzer, JetDelegationSpecifierList specifier, DelegatingBindingTrace trace, JetFile file) {
        BodyResolver bodyResolver = ResolveSessionUtils.createBodyResolverWithEmptyContext(trace, file, analyzer.getRootModuleDescriptor());
        JetClassOrObject classOrObject = (JetClassOrObject)specifier.getParent();
        LazyClassDescriptor descriptor = (LazyClassDescriptor)analyzer.resolveToDescriptor(classOrObject);
        descriptor.getTypeConstructor().getSupertypes();
        bodyResolver.resolveDelegationSpecifierList(classOrObject, descriptor, descriptor.getUnsubstitutedPrimaryConstructor(), descriptor.getScopeForClassHeaderResolution(), descriptor.getScopeForMemberDeclarationResolution());
    }

    private static void propertyAdditionalResolve(ResolveSession resolveSession, final JetProperty jetProperty, DelegatingBindingTrace trace, JetFile file) {
        JetExpression propertyDelegate;
        final JetScope propertyResolutionScope = resolveSession.getInjector().getScopeProvider().getResolutionScopeForDeclaration(jetProperty);
        BodyResolveContextForLazy bodyResolveContext = new BodyResolveContextForLazy(new Function<JetDeclaration, JetScope>(){

            @Override
            public JetScope apply(JetDeclaration declaration) {
                assert (declaration.getParent() == jetProperty) : "Must be called only for property accessors, but called for " + declaration;
                return propertyResolutionScope;
            }
        });
        BodyResolver bodyResolver = ResolveSessionUtils.createBodyResolver(trace, file, bodyResolveContext, resolveSession.getRootModuleDescriptor());
        PropertyDescriptor descriptor = (PropertyDescriptor)resolveSession.resolveToDescriptor(jetProperty);
        JetExpression propertyInitializer = jetProperty.getInitializer();
        if (propertyInitializer != null) {
            bodyResolver.resolvePropertyInitializer(jetProperty, descriptor, propertyInitializer, propertyResolutionScope);
        }
        if ((propertyDelegate = jetProperty.getDelegateExpression()) != null) {
            bodyResolver.resolvePropertyDelegate(jetProperty, descriptor, propertyDelegate, propertyResolutionScope, propertyResolutionScope);
        }
        bodyResolver.resolvePropertyAccessors(jetProperty, descriptor);
    }

    private static void functionAdditionalResolve(ResolveSession resolveSession, JetNamedFunction namedFunction, DelegatingBindingTrace trace, JetFile file) {
        BodyResolver bodyResolver = ResolveSessionUtils.createBodyResolverWithEmptyContext(trace, file, resolveSession.getRootModuleDescriptor());
        JetScope scope = resolveSession.getInjector().getScopeProvider().getResolutionScopeForDeclaration(namedFunction);
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)resolveSession.resolveToDescriptor(namedFunction);
        bodyResolver.resolveFunctionBody(trace, namedFunction, functionDescriptor, scope);
    }

    private static boolean initializerAdditionalResolve(KotlinCodeAnalyzer analyzer, JetClassInitializer classInitializer, DelegatingBindingTrace trace, JetFile file) {
        BodyResolver bodyResolver = ResolveSessionUtils.createBodyResolverWithEmptyContext(trace, file, analyzer.getRootModuleDescriptor());
        JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)classInitializer, JetClassOrObject.class);
        LazyClassDescriptor classOrObjectDescriptor = (LazyClassDescriptor)analyzer.resolveToDescriptor(classOrObject);
        bodyResolver.resolveAnonymousInitializers(classOrObject, classOrObjectDescriptor.getUnsubstitutedPrimaryConstructor(), classOrObjectDescriptor.getScopeForPropertyInitializerResolution());
        return true;
    }

    private static BodyResolver createBodyResolver(DelegatingBindingTrace trace, JetFile file, BodyResolveContextForLazy bodyResolveContext, ModuleDescriptor module) {
        TopDownAnalysisParameters parameters = new TopDownAnalysisParameters(Predicates.<PsiFile>alwaysTrue(), false, true, Collections.<AnalyzerScriptParameter>emptyList());
        InjectorForBodyResolve bodyResolve = new InjectorForBodyResolve(file.getProject(), parameters, trace, bodyResolveContext, module);
        return bodyResolve.getBodyResolver();
    }

    private static BodyResolver createBodyResolverWithEmptyContext(DelegatingBindingTrace trace, JetFile file, ModuleDescriptor module) {
        return ResolveSessionUtils.createBodyResolver(trace, file, EMPTY_CONTEXT, module);
    }

    private static JetScope getExpressionResolutionScope(@NotNull ResolveSession resolveSession, @NotNull JetExpression expression) {
        ScopeProvider provider = resolveSession.getInjector().getScopeProvider();
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class);
        if (parentDeclaration == null) {
            return provider.getFileScope((JetFile)expression.getContainingFile());
        }
        return provider.getResolutionScopeForDeclaration(parentDeclaration);
    }

    public static JetScope getExpressionMemberScope(@NotNull ResolveSession resolveSession, @NotNull JetExpression expression) {
        DelegatingBindingTrace trace = new DelegatingBindingTrace(resolveSession.getBindingContext(), "trace to resolve a member scope of expression", expression);
        if (BindingContextUtils.isExpressionWithValidReference(expression, resolveSession.getBindingContext())) {
            NamespaceDescriptor packageDescriptor;
            JetNamespaceHeader namespaceHeader;
            JetUserType qualifier;
            QualifiedExpressionResolver qualifiedExpressionResolver = resolveSession.getInjector().getQualifiedExpressionResolver();
            if (expression.getParent() instanceof JetUserType && (qualifier = ((JetUserType)expression.getParent()).getQualifier()) != null) {
                Collection<? extends DeclarationDescriptor> descriptors = qualifiedExpressionResolver.lookupDescriptorsForUserType(qualifier, ResolveSessionUtils.getExpressionResolutionScope(resolveSession, expression), trace);
                for (DeclarationDescriptor declarationDescriptor : descriptors) {
                    if (!(declarationDescriptor instanceof LazyPackageDescriptor)) continue;
                    return ((LazyPackageDescriptor)declarationDescriptor).getMemberScope();
                }
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)expression, JetImportDirective.class, false) != null) {
                NamespaceDescriptor rootPackage = resolveSession.getPackageDescriptorByFqName(FqName.ROOT);
                assert (rootPackage != null);
                if (expression.getParent() instanceof JetDotQualifiedExpression) {
                    NamespaceDescriptor namespaceDescriptor;
                    JetExpression element = ((JetDotQualifiedExpression)expression.getParent()).getReceiverExpression();
                    String name = ((JetFile)expression.getContainingFile()).getPackageName();
                    NamespaceDescriptor namespaceDescriptor2 = namespaceDescriptor = name != null ? resolveSession.getPackageDescriptorByFqName(new FqName(name)) : rootPackage;
                    assert (namespaceDescriptor != null) : "File package should be already resolved and be found";
                    JetScope scope = namespaceDescriptor.getMemberScope();
                    Collection<? extends DeclarationDescriptor> descriptors = element instanceof JetDotQualifiedExpression ? qualifiedExpressionResolver.lookupDescriptorsForQualifiedExpression((JetDotQualifiedExpression)element, rootPackage.getMemberScope(), scope, trace, QualifiedExpressionResolver.LookupMode.EVERYTHING, false) : qualifiedExpressionResolver.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)element, rootPackage.getMemberScope(), scope, trace, QualifiedExpressionResolver.LookupMode.EVERYTHING, false, false);
                    for (DeclarationDescriptor declarationDescriptor : descriptors) {
                        if (!(declarationDescriptor instanceof NamespaceDescriptor)) continue;
                        return ((NamespaceDescriptor)declarationDescriptor).getMemberScope();
                    }
                } else {
                    return rootPackage.getMemberScope();
                }
            }
            if ((namespaceHeader = PsiTreeUtil.getParentOfType((PsiElement)expression, JetNamespaceHeader.class, false)) != null && (packageDescriptor = resolveSession.getPackageDescriptorByFqName(namespaceHeader.getParentFqName((JetReferenceExpression)expression))) != null) {
                return packageDescriptor.getMemberScope();
            }
        }
        return null;
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassDescriptorsByFqName(@NotNull KotlinCodeAnalyzer analyzer, @NotNull FqName fqName) {
        return ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(analyzer, fqName, false);
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(@NotNull KotlinCodeAnalyzer analyzer, @NotNull FqName fqName, boolean includeObjectDeclarations) {
        if (fqName.isRoot()) {
            return Collections.emptyList();
        }
        ArrayList<ClassDescriptor> classDescriptors = Lists.newArrayList();
        FqName packageFqName = fqName.parent();
        while (true) {
            NamespaceDescriptor packageDescriptor;
            if ((packageDescriptor = analyzer.getPackageDescriptorByFqName(packageFqName)) != null) {
                FqName classInPackagePath = new FqName(QualifiedNamesUtil.tail(packageFqName, fqName));
                Collection<ClassDescriptor> descriptors = ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(packageDescriptor, classInPackagePath, includeObjectDeclarations);
                classDescriptors.addAll(descriptors);
            }
            if (packageFqName.isRoot()) break;
            packageFqName = packageFqName.parent();
        }
        return classDescriptors;
    }

    private static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(NamespaceDescriptor packageDescriptor, FqName path, boolean includeObjectDeclarations) {
        if (path.isRoot()) {
            return Collections.emptyList();
        }
        List<JetScope> scopes = Arrays.asList(packageDescriptor.getMemberScope());
        List<Name> names = path.pathSegments();
        if (names.size() > 1) {
            for (Name subName : path.pathSegments().subList(0, names.size() - 1)) {
                ArrayList<JetScope> tempScopes = Lists.newArrayList();
                for (JetScope scope : scopes) {
                    ClassifierDescriptor classifier = scope.getClassifier(subName);
                    if (!(classifier instanceof ClassDescriptorBase)) continue;
                    ClassDescriptorBase classDescriptor = (ClassDescriptorBase)classifier;
                    tempScopes.add(classDescriptor.getUnsubstitutedInnerClassesScope());
                }
                scopes = tempScopes;
            }
        }
        Name shortName = path.shortName();
        ArrayList<ClassDescriptor> resultClassifierDescriptors = Lists.newArrayList();
        for (JetScope scope : scopes) {
            ClassDescriptor objectDescriptor;
            ClassifierDescriptor classifier = scope.getClassifier(shortName);
            if (classifier instanceof ClassDescriptor) {
                resultClassifierDescriptors.add((ClassDescriptor)classifier);
            }
            if (!includeObjectDeclarations || (objectDescriptor = scope.getObjectDescriptor(shortName)) == null) continue;
            resultClassifierDescriptors.add(objectDescriptor);
        }
        return resultClassifierDescriptors;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@NotNull JetNamed named) {
        Name name = named.getNameAsName();
        return ResolveSessionUtils.safeNameForLazyResolve(name);
    }

    @NotNull
    public static Name safeNameForLazyResolve(@Nullable Name name) {
        return name != null ? name : NO_NAME_FOR_LAZY_RESOLVE;
    }

    private static class BodyResolveContextForLazy
    implements BodiesResolveContext {
        private final Function<JetDeclaration, JetScope> declaringScopes;

        private BodyResolveContextForLazy(@NotNull Function<JetDeclaration, JetScope> declaringScopes) {
            this.declaringScopes = declaringScopes;
        }

        @Override
        public Collection<JetFile> getFiles() {
            return Collections.emptySet();
        }

        @Override
        public Map<JetClass, MutableClassDescriptor> getClasses() {
            return Collections.emptyMap();
        }

        @Override
        public Map<JetObjectDeclaration, MutableClassDescriptor> getObjects() {
            return Collections.emptyMap();
        }

        @Override
        public Map<JetProperty, PropertyDescriptor> getProperties() {
            return Collections.emptyMap();
        }

        @Override
        public Map<JetNamedFunction, SimpleFunctionDescriptor> getFunctions() {
            return Collections.emptyMap();
        }

        @Override
        public Function<JetDeclaration, JetScope> getDeclaringScopes() {
            return this.declaringScopes;
        }

        @Override
        public Map<JetScript, ScriptDescriptor> getScripts() {
            return Collections.emptyMap();
        }

        @Override
        public Map<JetScript, WritableScope> getScriptScopes() {
            return Collections.emptyMap();
        }

        @Override
        public void setTopDownAnalysisParameters(TopDownAnalysisParameters parameters) {
        }

        @Override
        public boolean completeAnalysisNeeded(@NotNull PsiElement element) {
            return true;
        }
    }
}

