/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    @NotNull
    public static Collection<DeclarationDescriptor> computeAllPackageDeclarations(PsiPackage psiPackage, JavaSemanticServices javaSemanticServices) {
        HashSet<DeclarationDescriptor> result = Sets.newHashSet();
        JavaDescriptorResolver descriptorResolver = javaSemanticServices.getDescriptorResolver();
        for (PsiPackage psiSubPackage : psiPackage.getSubPackages()) {
            NamespaceDescriptor childNs = descriptorResolver.resolveNamespace(new FqName(psiSubPackage.getQualifiedName()), DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN);
            if (childNs == null) continue;
            result.add(childNs);
        }
        for (PsiClass psiClass : javaSemanticServices.getPsiClassFinder().findPsiClasses(psiPackage)) {
            NamespaceDescriptor namespaceDescriptor;
            if (PackageClassUtils.isPackageClass(psiClass) || psiClass instanceof JetJavaMirrorMarker || !psiClass.hasModifierProperty("public")) continue;
            ProgressIndicatorProvider.checkCanceled();
            FqName fqName = new FqName(psiClass.getQualifiedName());
            ClassDescriptor classDescriptor = descriptorResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN);
            if (classDescriptor != null) {
                result.add(classDescriptor);
            }
            if ((namespaceDescriptor = descriptorResolver.resolveNamespace(fqName, DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN)) == null) continue;
            result.add(namespaceDescriptor);
        }
        return result;
    }
}

