/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jet.typeinfo.TypeInfoVariance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.JetTypeJetSignatureReader;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolvers;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.provider.DeclarationOrigin;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiClassWrapper;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.rt.signature.JetSignatureAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureExceptionsAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureReader;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public final class JavaSupertypeResolver {
    private BindingTrace trace;
    private JavaSemanticServices semanticServices;
    private JavaTypeTransformer typeTransformer;
    private JavaClassResolver classResolver;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setSemanticServices(JavaSemanticServices semanticServices) {
        this.semanticServices = semanticServices;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public Collection<JetType> getSupertypes(@NotNull ClassDescriptor classDescriptor, @NotNull PsiClassWrapper psiClass, @NotNull ClassPsiDeclarationProvider classData, @NotNull List<TypeParameterDescriptor> typeParameters) {
        ArrayList<JetType> result = new ArrayList<JetType>();
        String context = "class " + psiClass.getQualifiedName();
        if (psiClass.getJetClass().signature().length() > 0) {
            this.readSuperTypes(psiClass, typeParameters, classDescriptor, result, context);
        } else {
            TypeVariableResolver typeVariableResolverForSupertypes = TypeVariableResolvers.typeVariableResolverFromTypeParameters(typeParameters, classDescriptor, context);
            this.transformSupertypeList(result, psiClass.getPsiClass().getExtendsListTypes(), typeVariableResolverForSupertypes);
            this.transformSupertypeList(result, psiClass.getPsiClass().getImplementsListTypes(), typeVariableResolverForSupertypes);
        }
        this.reportIncompleteHierarchyForErrorTypes(classDescriptor, result);
        if (result.isEmpty()) {
            this.addBaseClass(psiClass, classData, classDescriptor, result);
        }
        return result;
    }

    private void readSuperTypes(PsiClassWrapper psiClass, List<TypeParameterDescriptor> typeParameters, ClassDescriptor classDescriptor, final List<JetType> result, String context) {
        final TypeVariableResolver typeVariableResolver = TypeVariableResolvers.typeVariableResolverFromTypeParameters(typeParameters, classDescriptor, context);
        new JetSignatureReader(psiClass.getJetClass().signature()).accept(new JetSignatureExceptionsAdapter(){

            @Override
            public JetSignatureVisitor visitFormalTypeParameter(String name, TypeInfoVariance variance, boolean reified) {
                return new JetSignatureAdapter();
            }

            @Override
            public JetSignatureVisitor visitSuperclass() {
                return new JetTypeJetSignatureReader(JavaSupertypeResolver.this.semanticServices, KotlinBuiltIns.getInstance(), typeVariableResolver){

                    @Override
                    protected void done(@NotNull JetType jetType) {
                        if (!jetType.equals(KotlinBuiltIns.getInstance().getAnyType())) {
                            result.add(jetType);
                        }
                    }
                };
            }

            @Override
            public JetSignatureVisitor visitInterface() {
                return this.visitSuperclass();
            }
        });
    }

    private void addBaseClass(@NotNull PsiClassWrapper psiClass, @NotNull ClassPsiDeclarationProvider classData, @NotNull ClassDescriptor classDescriptor, @NotNull List<JetType> result) {
        if (classData.getDeclarationOrigin() == DeclarationOrigin.KOTLIN || DescriptorResolverUtils.OBJECT_FQ_NAME.equalsTo(psiClass.getQualifiedName()) || classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            result.add(KotlinBuiltIns.getInstance().getAnyType());
        } else {
            ClassDescriptor object = this.resolveJavaLangObject();
            if (object != null) {
                result.add(object.getDefaultType());
            } else {
                result.add(KotlinBuiltIns.getInstance().getAnyType());
            }
        }
    }

    private void reportIncompleteHierarchyForErrorTypes(ClassDescriptor classDescriptor, List<JetType> result) {
        for (JetType supertype : result) {
            if (!ErrorUtils.isErrorType(supertype)) continue;
            this.trace.record(BindingContext.INCOMPLETE_HIERARCHY, classDescriptor);
        }
    }

    private void transformSupertypeList(List<JetType> result, PsiClassType[] extendsListTypes, TypeVariableResolver typeVariableResolver) {
        for (PsiClassType type : extendsListTypes) {
            JetType transform;
            PsiClass resolved = type.resolve();
            if (resolved != null) {
                String qualifiedName = resolved.getQualifiedName();
                assert (qualifiedName != null);
                if (JvmStdlibNames.JET_OBJECT.getFqName().equalsTo(qualifiedName)) continue;
            }
            if (ErrorUtils.isErrorType(transform = this.typeTransformer.transformToType(type, TypeUsage.SUPERTYPE, typeVariableResolver))) continue;
            result.add(TypeUtils.makeNotNullable(transform));
        }
    }

    @Nullable
    private ClassDescriptor resolveJavaLangObject() {
        ClassDescriptor clazz = this.classResolver.resolveClass(DescriptorResolverUtils.OBJECT_FQ_NAME, DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN);
        if (clazz == null) {
            // empty if block
        }
        return clazz;
    }
}

