/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jet.typeinfo.TypeInfoVariance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JetSignatureUtils;
import org.jetbrains.jet.lang.resolve.java.JetTypeJetSignatureReader;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolvers;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassAnnotation;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.rt.signature.JetSignatureAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureExceptionsAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureReader;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public final class JavaSignatureResolver {
    @NotNull
    private JavaSemanticServices semanticServices;

    public void setJavaSemanticServices(@NotNull JavaSemanticServices javaSemanticServices) {
        this.semanticServices = javaSemanticServices;
    }

    private static boolean isJavaLangObject(@NotNull JetType type) {
        ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor instanceof ClassDescriptor && DescriptorUtils.getFQName(classifierDescriptor).equalsTo(DescriptorResolverUtils.OBJECT_FQ_NAME);
    }

    @NotNull
    private static PsiTypeParameter getPsiTypeParameterByName(PsiTypeParameterListOwner clazz, String name) {
        for (PsiTypeParameter typeParameter : clazz.getTypeParameters()) {
            if (!typeParameter.getName().equals(name)) continue;
            return typeParameter;
        }
        throw new IllegalStateException("PsiTypeParameter '" + name + "' is not found");
    }

    private List<TypeParameterDescriptorInitialization> resolveClassTypeParametersFromJetSignature(String jetSignature, PsiClass clazz, ClassDescriptor classDescriptor) {
        String context = "class " + clazz.getQualifiedName();
        JetSignatureTypeParametersVisitor jetSignatureTypeParametersVisitor = new JetSignatureTypeParametersVisitor(classDescriptor, clazz, context){

            @Override
            public JetSignatureVisitor visitSuperclass() {
                return new JetSignatureAdapter();
            }

            @Override
            public JetSignatureVisitor visitInterface() {
                return new JetSignatureAdapter();
            }
        };
        new JetSignatureReader(jetSignature).accept(jetSignatureTypeParametersVisitor);
        return jetSignatureTypeParametersVisitor.r;
    }

    private static List<TypeParameterDescriptorInitialization> makeUninitializedTypeParameters(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameter[] typeParameters) {
        ArrayList<TypeParameterDescriptorInitialization> result = Lists.newArrayList();
        for (PsiTypeParameter typeParameter : typeParameters) {
            TypeParameterDescriptorInitialization typeParameterDescriptor = JavaSignatureResolver.makeUninitializedTypeParameter(containingDeclaration, typeParameter);
            result.add(typeParameterDescriptor);
        }
        return result;
    }

    @NotNull
    private static TypeParameterDescriptorInitialization makeUninitializedTypeParameter(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameter psiTypeParameter) {
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), false, Variance.INVARIANT, Name.identifier(psiTypeParameter.getName()), psiTypeParameter.getIndex());
        return new TypeParameterDescriptorInitialization(typeParameterDescriptor, psiTypeParameter);
    }

    private void initializeTypeParameter(TypeParameterDescriptorInitialization typeParameter, TypeVariableResolver typeVariableByPsiResolver) {
        TypeParameterDescriptorImpl typeParameterDescriptor = typeParameter.descriptor;
        if (typeParameter.origin == TypeParameterDescriptorOrigin.KOTLIN) {
            List upperBoundsForKotlin = typeParameter.upperBoundsForKotlin;
            assert (upperBoundsForKotlin != null);
            if (upperBoundsForKotlin.size() == 0) {
                typeParameterDescriptor.addUpperBound(KotlinBuiltIns.getInstance().getNullableAnyType());
            } else {
                for (JetType upperBound : upperBoundsForKotlin) {
                    typeParameterDescriptor.addUpperBound(upperBound);
                }
            }
        } else {
            PsiClassType[] referencedTypes = typeParameter.psiTypeParameter.getExtendsList().getReferencedTypes();
            if (referencedTypes.length == 0) {
                typeParameterDescriptor.addUpperBound(KotlinBuiltIns.getInstance().getNullableAnyType());
            } else if (referencedTypes.length == 1) {
                typeParameterDescriptor.addUpperBound(this.semanticServices.getTypeTransformer().transformToType(referencedTypes[0], TypeUsage.UPPER_BOUND, typeVariableByPsiResolver));
            } else {
                for (PsiClassType referencedType : referencedTypes) {
                    typeParameterDescriptor.addUpperBound(this.semanticServices.getTypeTransformer().transformToType(referencedType, TypeUsage.UPPER_BOUND, typeVariableByPsiResolver));
                }
            }
        }
        typeParameterDescriptor.setInitialized();
    }

    public void initializeTypeParameters(List<TypeParameterDescriptorInitialization> typeParametersInitialization, @NotNull DeclarationDescriptor typeParametersOwner, @NotNull String context) {
        ArrayList<TypeParameterDescriptorImpl> prevTypeParameters = Lists.newArrayList();
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayList();
        for (TypeParameterDescriptorInitialization typeParameterDescriptor : typeParametersInitialization) {
            typeParameters.add(typeParameterDescriptor.descriptor);
        }
        for (TypeParameterDescriptorInitialization psiTypeParameter : typeParametersInitialization) {
            prevTypeParameters.add(psiTypeParameter.descriptor);
            this.initializeTypeParameter(psiTypeParameter, TypeVariableResolvers.typeVariableResolverFromTypeParameters(typeParameters, typeParametersOwner, context));
        }
    }

    public List<TypeParameterDescriptorInitialization> createUninitializedClassTypeParameters(PsiClass psiClass, ClassDescriptor classDescriptor) {
        JetClassAnnotation jetClassAnnotation = JetClassAnnotation.get(psiClass);
        if (jetClassAnnotation.signature().length() > 0) {
            return this.resolveClassTypeParametersFromJetSignature(jetClassAnnotation.signature(), psiClass, classDescriptor);
        }
        return JavaSignatureResolver.makeUninitializedTypeParameters(classDescriptor, psiClass.getTypeParameters());
    }

    public List<TypeParameterDescriptor> resolveMethodTypeParameters(@NotNull PsiMethodWrapper method, @NotNull DeclarationDescriptor functionDescriptor) {
        PsiMethod psiMethod = method.getPsiMethod();
        List<TypeParameterDescriptorInitialization> typeParametersIntialization = method.getJetMethodAnnotation().typeParameters().length() > 0 ? this.resolveMethodTypeParametersFromJetSignature(method.getJetMethodAnnotation().typeParameters(), psiMethod, functionDescriptor) : JavaSignatureResolver.makeUninitializedTypeParameters(functionDescriptor, psiMethod.getTypeParameters());
        PsiClass psiMethodContainingClass = psiMethod.getContainingClass();
        assert (psiMethodContainingClass != null);
        String context = "method " + method.getName() + " in class " + psiMethodContainingClass.getQualifiedName();
        this.initializeTypeParameters(typeParametersIntialization, functionDescriptor, context);
        ArrayList<TypeParameterDescriptor> typeParameters = Lists.newArrayListWithCapacity(typeParametersIntialization.size());
        for (TypeParameterDescriptorInitialization tpdi : typeParametersIntialization) {
            typeParameters.add(tpdi.descriptor);
        }
        return typeParameters;
    }

    private List<TypeParameterDescriptorInitialization> resolveMethodTypeParametersFromJetSignature(String jetSignature, PsiMethod method, DeclarationDescriptor functionDescriptor) {
        PsiClass methodContainingClass = method.getContainingClass();
        assert (methodContainingClass != null);
        String context = "method " + method.getName() + " in class " + methodContainingClass.getQualifiedName();
        JetSignatureTypeParametersVisitor jetSignatureTypeParametersVisitor = new JetSignatureTypeParametersVisitor(functionDescriptor, method, context);
        new JetSignatureReader(jetSignature).acceptFormalTypeParametersOnly(jetSignatureTypeParametersVisitor);
        return jetSignatureTypeParametersVisitor.r;
    }

    private class JetSignatureTypeParametersVisitor
    extends JetSignatureExceptionsAdapter {
        @NotNull
        private final DeclarationDescriptor containingDeclaration;
        @NotNull
        private final PsiTypeParameterListOwner psiOwner;
        private final List<TypeParameterDescriptor> previousTypeParameters = new ArrayList<TypeParameterDescriptor>();
        private final TypeVariableResolver typeVariableResolver;
        private int formalTypeParameterIndex = 0;
        List<TypeParameterDescriptorInitialization> r = new ArrayList<TypeParameterDescriptorInitialization>();

        private JetSignatureTypeParametersVisitor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameterListOwner psiOwner, @NotNull String context) {
            this.containingDeclaration = containingDeclaration;
            this.psiOwner = psiOwner;
            this.typeVariableResolver = TypeVariableResolvers.typeVariableResolverFromTypeParameters(this.previousTypeParameters, containingDeclaration, context);
        }

        @Override
        public JetSignatureVisitor visitFormalTypeParameter(String name, TypeInfoVariance variance, boolean reified) {
            TypeParameterDescriptorImpl typeParameter = TypeParameterDescriptorImpl.createForFurtherModification(this.containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), reified, JetSignatureUtils.translateVariance(variance), Name.identifier(name), this.formalTypeParameterIndex++);
            this.previousTypeParameters.add(typeParameter);
            return new JetSignatureTypeParameterVisitor(this.psiOwner, name, this.typeVariableResolver, typeParameter){

                @Override
                protected void done(@NotNull TypeParameterDescriptorInitialization typeParameterDescriptor) {
                    JetSignatureTypeParametersVisitor.this.r.add(typeParameterDescriptor);
                    JetSignatureTypeParametersVisitor.this.previousTypeParameters.add(typeParameterDescriptor.descriptor);
                }
            };
        }
    }

    private abstract class JetSignatureTypeParameterVisitor
    extends JetSignatureExceptionsAdapter {
        @NotNull
        private final PsiTypeParameterListOwner psiOwner;
        @NotNull
        private final String name;
        @NotNull
        private final TypeVariableResolver typeVariableResolver;
        @NotNull
        private final TypeParameterDescriptorImpl typeParameterDescriptor;
        List<JetType> upperBounds = new ArrayList<JetType>();

        protected JetSignatureTypeParameterVisitor(@NotNull PsiTypeParameterListOwner psiOwner, @NotNull String name, @NotNull TypeVariableResolver typeVariableResolver, @NotNull TypeParameterDescriptorImpl typeParameterDescriptor) {
            if (name.isEmpty()) {
                throw new IllegalStateException();
            }
            this.psiOwner = psiOwner;
            this.name = name;
            this.typeVariableResolver = typeVariableResolver;
            this.typeParameterDescriptor = typeParameterDescriptor;
        }

        @Override
        public JetSignatureVisitor visitClassBound() {
            return new JetTypeJetSignatureReader(JavaSignatureResolver.this.semanticServices, KotlinBuiltIns.getInstance(), this.typeVariableResolver){

                @Override
                protected void done(@NotNull JetType jetType) {
                    if (JavaSignatureResolver.isJavaLangObject(jetType)) {
                        return;
                    }
                    JetSignatureTypeParameterVisitor.this.upperBounds.add(jetType);
                }
            };
        }

        @Override
        public JetSignatureVisitor visitInterfaceBound() {
            return new JetTypeJetSignatureReader(JavaSignatureResolver.this.semanticServices, KotlinBuiltIns.getInstance(), this.typeVariableResolver){

                @Override
                protected void done(@NotNull JetType jetType) {
                    JetSignatureTypeParameterVisitor.this.upperBounds.add(jetType);
                }
            };
        }

        @Override
        public void visitFormalTypeParameterEnd() {
            PsiTypeParameter psiTypeParameter = JavaSignatureResolver.getPsiTypeParameterByName(this.psiOwner, this.name);
            TypeParameterDescriptorInitialization typeParameterDescriptorInitialization = new TypeParameterDescriptorInitialization(this.typeParameterDescriptor, psiTypeParameter, this.upperBounds);
            this.done(typeParameterDescriptorInitialization);
        }

        protected abstract void done(@NotNull TypeParameterDescriptorInitialization var1);
    }

    public static class TypeParameterDescriptorInitialization {
        @NotNull
        private final TypeParameterDescriptorOrigin origin;
        @NotNull
        private final TypeParameterDescriptorImpl descriptor;
        private final PsiTypeParameter psiTypeParameter;
        @Nullable
        private final List<JetType> upperBoundsForKotlin;

        private TypeParameterDescriptorInitialization(@NotNull TypeParameterDescriptorImpl descriptor, @NotNull PsiTypeParameter psiTypeParameter) {
            this.origin = TypeParameterDescriptorOrigin.JAVA;
            this.descriptor = descriptor;
            this.psiTypeParameter = psiTypeParameter;
            this.upperBoundsForKotlin = null;
        }

        private TypeParameterDescriptorInitialization(@NotNull TypeParameterDescriptorImpl descriptor, @NotNull PsiTypeParameter psiTypeParameter, @Nullable List<JetType> upperBoundsForKotlin) {
            this.origin = TypeParameterDescriptorOrigin.KOTLIN;
            this.descriptor = descriptor;
            this.psiTypeParameter = psiTypeParameter;
            this.upperBoundsForKotlin = upperBoundsForKotlin;
        }

        @NotNull
        public TypeParameterDescriptorImpl getDescriptor() {
            return this.descriptor;
        }
    }

    private static enum TypeParameterDescriptorOrigin {
        JAVA,
        KOTLIN;

    }
}

