/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.PsiClass;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassObjectAnnotation;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSupertypeResolver;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassNonStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameBase;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public final class JavaClassObjectResolver {
    private BindingTrace trace;
    private JavaSemanticServices semanticServices;
    private JavaSupertypeResolver supertypesResolver;

    public void setSupertypesResolver(JavaSupertypeResolver supertypesResolver) {
        this.supertypesResolver = supertypesResolver;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setSemanticServices(JavaSemanticServices semanticServices) {
        this.semanticServices = semanticServices;
    }

    @Nullable
    public ClassDescriptorFromJvmBytecode createClassObjectDescriptor(@NotNull ClassDescriptor containing, @NotNull PsiClass psiClass) {
        DescriptorResolverUtils.checkPsiClassIsNotJet(psiClass);
        if (psiClass.isEnum()) {
            return this.createClassObjectDescriptorForEnum(containing, psiClass);
        }
        if (!DescriptorResolverUtils.isKotlinClass(psiClass)) {
            return null;
        }
        PsiClass classObjectPsiClass = JavaClassObjectResolver.getClassObjectPsiClass(psiClass);
        if (classObjectPsiClass == null) {
            return null;
        }
        return this.createClassObjectFromPsi(containing, classObjectPsiClass);
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode createClassObjectFromPsi(@NotNull ClassDescriptor containing, @NotNull PsiClass classObjectPsiClass) {
        String qualifiedName = classObjectPsiClass.getQualifiedName();
        assert (qualifiedName != null);
        FqName fqName = new FqName(qualifiedName);
        ClassPsiDeclarationProvider classObjectData = this.semanticServices.getPsiDeclarationProviderFactory().createBinaryClassData(classObjectPsiClass);
        ClassDescriptorFromJvmBytecode classObjectDescriptor = new ClassDescriptorFromJvmBytecode(containing, ClassKind.CLASS_OBJECT, false);
        classObjectDescriptor.setSupertypes(this.supertypesResolver.getSupertypes(classObjectDescriptor, new PsiClassWrapper(classObjectPsiClass), classObjectData, Collections.<TypeParameterDescriptor>emptyList()));
        this.setUpClassObjectDescriptor(classObjectDescriptor, containing, fqName, classObjectData, DescriptorUtils.getClassObjectName(containing.getName()));
        return classObjectDescriptor;
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode createClassObjectDescriptorForEnum(@NotNull ClassDescriptor containing, @NotNull PsiClass psiClass) {
        ClassDescriptorFromJvmBytecode classObjectDescriptor = this.createSyntheticClassObject(containing, psiClass);
        classObjectDescriptor.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValuesMethod(classObjectDescriptor, this.trace));
        classObjectDescriptor.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValueOfMethod(classObjectDescriptor, this.trace));
        return classObjectDescriptor;
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode createSyntheticClassObject(@NotNull ClassDescriptor containing, @NotNull PsiClass psiClass) {
        FqNameUnsafe fqName = DescriptorResolverUtils.getFqNameForClassObject(psiClass);
        ClassDescriptorFromJvmBytecode classObjectDescriptor = new ClassDescriptorFromJvmBytecode(containing, ClassKind.CLASS_OBJECT, false);
        ClassPsiDeclarationProvider data = this.semanticServices.getPsiDeclarationProviderFactory().createSyntheticClassObjectClassData(psiClass);
        this.setUpClassObjectDescriptor(classObjectDescriptor, containing, fqName, data, DescriptorUtils.getClassObjectName(containing.getName().asString()));
        return classObjectDescriptor;
    }

    private void setUpClassObjectDescriptor(@NotNull ClassDescriptorFromJvmBytecode classObjectDescriptor, @NotNull ClassDescriptor containing, @NotNull FqNameBase fqName, @NotNull ClassPsiDeclarationProvider data, @NotNull Name classObjectName) {
        classObjectDescriptor.setName(classObjectName);
        classObjectDescriptor.setModality(Modality.FINAL);
        classObjectDescriptor.setVisibility(containing.getVisibility());
        classObjectDescriptor.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        classObjectDescriptor.createTypeConstructor();
        JavaClassNonStaticMembersScope classMembersScope = new JavaClassNonStaticMembersScope(classObjectDescriptor, data, this.semanticServices);
        WritableScopeImpl writableScope = new WritableScopeImpl(classMembersScope, classObjectDescriptor, RedeclarationHandler.THROW_EXCEPTION, "Member lookup scope");
        writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        classObjectDescriptor.setScopeForMemberLookup(writableScope);
        classObjectDescriptor.setScopeForConstructorResolve(classMembersScope);
    }

    @Nullable
    private static PsiClass getClassObjectPsiClass(@NotNull PsiClass ownerClass) {
        for (PsiClass inner : ownerClass.getInnerClasses()) {
            if (!JetClassObjectAnnotation.get(inner).isDefined()) continue;
            return inner;
        }
        return null;
    }
}

