/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWrapper;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;

public class KotlinSignatureAnnotation
extends PsiAnnotationWrapper {
    private static final KotlinSignatureAnnotation NULL_ANNOTATION = new KotlinSignatureAnnotation(null);
    private String signature;

    private KotlinSignatureAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @Override
    protected void initialize() {
        this.signature = StringUtil.unescapeStringCharacters(this.getStringAttribute("value", ""));
    }

    @NotNull
    public String signature() {
        this.checkInitialized();
        return this.signature;
    }

    @NotNull
    public static KotlinSignatureAnnotation get(PsiModifierListOwner psiModifierListOwner) {
        PsiAnnotation annotation = JavaAnnotationResolver.findAnnotationWithExternal(psiModifierListOwner, JvmStdlibNames.KOTLIN_SIGNATURE.getFqName().asString());
        return annotation != null ? new KotlinSignatureAnnotation(annotation) : NULL_ANNOTATION;
    }

    static {
        NULL_ANNOTATION.checkInitialized();
    }
}

