/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWithAbiVersion;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;

public class JetPackageClassAnnotation
extends PsiAnnotationWithAbiVersion {
    private static final JetPackageClassAnnotation NULL_ANNOTATION = new JetPackageClassAnnotation(null);

    private JetPackageClassAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @NotNull
    public static JetPackageClassAnnotation get(PsiClass psiClass) {
        PsiAnnotation annotation = JavaAnnotationResolver.findOwnAnnotation(psiClass, JvmStdlibNames.JET_PACKAGE_CLASS.getFqName().asString());
        return annotation != null ? new JetPackageClassAnnotation(annotation) : NULL_ANNOTATION;
    }

    static {
        NULL_ANNOTATION.checkInitialized();
    }
}

