/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWithFlags;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;

public class JetConstructorAnnotation
extends PsiAnnotationWithFlags {
    private static final JetConstructorAnnotation NULL_ANNOTATION = new JetConstructorAnnotation(null);
    private boolean hidden;

    private JetConstructorAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.hidden = this.getBooleanAttribute("hidden", false);
    }

    public boolean hidden() {
        this.checkInitialized();
        return this.hidden;
    }

    public static JetConstructorAnnotation get(PsiMethod constructor) {
        PsiAnnotation annotation = JavaAnnotationResolver.findOwnAnnotation(constructor, JvmStdlibNames.JET_CONSTRUCTOR.getFqName().asString());
        return annotation != null ? new JetConstructorAnnotation(annotation) : NULL_ANNOTATION;
    }

    static {
        NULL_ANNOTATION.checkInitialized();
    }
}

