/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.CollectionClassMapping;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.JavaToKotlinMethodMap;
import org.jetbrains.jet.lang.resolve.java.JetClsMethod;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.PropagationHeuristics;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesUtil;
import org.jetbrains.jet.lang.resolve.java.provider.MembersCache;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class SignaturesPropagationData {
    private static final Logger LOG = Logger.getInstance(SignaturesPropagationData.class);
    private final List<TypeParameterDescriptor> modifiedTypeParameters;
    private final JavaDescriptorResolver.ValueParameterDescriptors modifiedValueParameters;
    private final JetType modifiedReturnType;
    private final List<String> signatureErrors = Lists.newArrayList();
    private final List<FunctionDescriptor> superFunctions;
    private final Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> autoTypeParameterToModified;
    final ClassDescriptor containingClass;

    public SignaturesPropagationData(@NotNull ClassDescriptor containingClass, @NotNull JetType autoReturnType, @NotNull JavaDescriptorResolver.ValueParameterDescriptors autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters, @NotNull PsiMethodWrapper method, @NotNull BindingTrace trace) {
        this.containingClass = containingClass;
        this.superFunctions = SignaturesPropagationData.getSuperFunctionsForMethod(method, trace, containingClass);
        this.autoTypeParameterToModified = SignaturesUtil.recreateTypeParametersAndReturnMapping(autoTypeParameters, null);
        this.modifiedTypeParameters = this.modifyTypeParametersAccordingToSuperMethods(autoTypeParameters);
        this.modifiedReturnType = this.modifyReturnTypeAccordingToSuperMethods(autoReturnType);
        this.modifiedValueParameters = this.modifyValueParametersAccordingToSuperMethods(autoValueParameters);
    }

    public List<TypeParameterDescriptor> getModifiedTypeParameters() {
        return this.modifiedTypeParameters;
    }

    public JavaDescriptorResolver.ValueParameterDescriptors getModifiedValueParameters() {
        return this.modifiedValueParameters;
    }

    public JetType getModifiedReturnType() {
        return this.modifiedReturnType;
    }

    public List<String> getSignatureErrors() {
        return this.signatureErrors;
    }

    public List<FunctionDescriptor> getSuperFunctions() {
        return this.superFunctions;
    }

    void reportError(String error) {
        this.signatureErrors.add(error);
    }

    private JetType modifyReturnTypeAccordingToSuperMethods(@NotNull JetType autoType) {
        List<TypeAndVariance> typesFromSuperMethods = ContainerUtil.map(this.superFunctions, new Function<FunctionDescriptor, TypeAndVariance>(){

            @Override
            public TypeAndVariance fun(FunctionDescriptor superFunction) {
                return new TypeAndVariance(superFunction.getReturnType(), Variance.OUT_VARIANCE);
            }
        });
        return this.modifyTypeAccordingToSuperMethods(autoType, typesFromSuperMethods, TypeUsage.MEMBER_SIGNATURE_COVARIANT);
    }

    private List<TypeParameterDescriptor> modifyTypeParametersAccordingToSuperMethods(List<TypeParameterDescriptor> autoTypeParameters) {
        ArrayList<TypeParameterDescriptor> result = Lists.newArrayList();
        for (TypeParameterDescriptor autoParameter : autoTypeParameters) {
            int index = autoParameter.getIndex();
            TypeParameterDescriptorImpl modifiedTypeParameter = this.autoTypeParameterToModified.get(autoParameter);
            ArrayList<Iterator<JetType>> upperBoundFromSuperFunctionsIterators = Lists.newArrayList();
            for (FunctionDescriptor functionDescriptor : this.superFunctions) {
                upperBoundFromSuperFunctionsIterators.add(functionDescriptor.getTypeParameters().get(index).getUpperBounds().iterator());
            }
            for (JetType jetType : autoParameter.getUpperBounds()) {
                ArrayList<TypeAndVariance> upperBoundsFromSuperFunctions = Lists.newArrayList();
                for (Iterator iterator : upperBoundFromSuperFunctionsIterators) {
                    assert (iterator.hasNext());
                    upperBoundsFromSuperFunctions.add(new TypeAndVariance((JetType)iterator.next(), Variance.INVARIANT));
                }
                JetType modifiedUpperBound = this.modifyTypeAccordingToSuperMethods(jetType, upperBoundsFromSuperFunctions, TypeUsage.UPPER_BOUND);
                modifiedTypeParameter.addUpperBound(modifiedUpperBound);
            }
            for (Iterator iterator : upperBoundFromSuperFunctionsIterators) {
                assert (!iterator.hasNext());
            }
            modifiedTypeParameter.setInitialized();
            result.add(modifiedTypeParameter);
        }
        return result;
    }

    private JavaDescriptorResolver.ValueParameterDescriptors modifyValueParametersAccordingToSuperMethods(@NotNull JavaDescriptorResolver.ValueParameterDescriptors parameters) {
        assert (parameters.getReceiverType() == null) : "Parameters before propagation have receiver type, but propagation should be disabled for functions compiled from Kotlin in class: " + DescriptorUtils.getFQName(this.containingClass);
        JetType receiverType = null;
        ArrayList<ValueParameterDescriptor> resultParameters = Lists.newArrayList();
        boolean shouldBeExtension = this.checkIfShouldBeExtension();
        for (ValueParameterDescriptor originalParam : parameters.getDescriptors()) {
            final int originalIndex = originalParam.getIndex();
            List<TypeAndVariance> typesFromSuperMethods = ContainerUtil.map(this.superFunctions, new Function<FunctionDescriptor, TypeAndVariance>(){

                @Override
                public TypeAndVariance fun(FunctionDescriptor superFunction) {
                    int index;
                    ReceiverParameterDescriptor receiver = superFunction.getReceiverParameter();
                    int n = index = receiver != null ? originalIndex - 1 : originalIndex;
                    if (index == -1) {
                        assert (receiver != null) : "can't happen: index is -1, while function is not extension";
                        return new TypeAndVariance(receiver.getType(), Variance.INVARIANT);
                    }
                    return new TypeAndVariance(superFunction.getValueParameters().get(index).getType(), Variance.INVARIANT);
                }
            });
            VarargCheckResult varargCheckResult = this.checkVarargInSuperFunctions(originalParam);
            JetType altType = this.modifyTypeAccordingToSuperMethods(varargCheckResult.parameterType, typesFromSuperMethods, TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT);
            if (shouldBeExtension && originalIndex == 0) {
                receiverType = altType;
                continue;
            }
            resultParameters.add(new ValueParameterDescriptorImpl(originalParam.getContainingDeclaration(), shouldBeExtension ? originalIndex - 1 : originalIndex, originalParam.getAnnotations(), originalParam.getName(), altType, originalParam.declaresDefaultValue(), varargCheckResult.isVararg ? KotlinBuiltIns.getInstance().getArrayElementType(altType) : null));
        }
        return new JavaDescriptorResolver.ValueParameterDescriptors(receiverType, resultParameters);
    }

    private static List<FunctionDescriptor> getSuperFunctionsForMethod(@NotNull PsiMethodWrapper method, @NotNull BindingTrace trace, @NotNull ClassDescriptor containingClass) {
        ArrayList<FunctionDescriptor> superFunctions = Lists.newArrayList();
        Map<ClassDescriptor, JetType> superclassToSupertype = SignaturesPropagationData.getSuperclassToSupertypeMap(containingClass);
        Multimap<FqName, Pair<FunctionDescriptor, PsiMethod>> superclassToFunctions = SignaturesPropagationData.getSuperclassToFunctionsMultimap(method, trace.getBindingContext(), containingClass);
        for (PsiMethod superMethod : PropagationHeuristics.getSuperMethods(method.getPsiMethod())) {
            DeclarationDescriptor superFun;
            PsiClass psiClass = superMethod.getContainingClass();
            assert (psiClass != null);
            String classFqNameString = psiClass.getQualifiedName();
            assert (classFqNameString != null);
            FqName classFqName = new FqName(classFqNameString);
            if (!JavaToKotlinClassMap.getInstance().mapPlatformClass(classFqName).isEmpty()) {
                for (FunctionDescriptor superFun2 : JavaToKotlinMethodMap.INSTANCE.getFunctions(superMethod, containingClass)) {
                    superFunctions.add(SignaturesPropagationData.substituteSuperFunction(superclassToSupertype, superFun2));
                }
                continue;
            }
            DeclarationDescriptor declarationDescriptor = superFun = superMethod instanceof JetClsMethod ? trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, ((JetClsMethod)superMethod).getOrigin()) : SignaturesPropagationData.findSuperFunction(superclassToFunctions.get(classFqName), superMethod);
            if (superFun == null) {
                if (MembersCache.isObjectMethodInInterface(superMethod)) continue;
                SignaturesPropagationData.reportCantFindSuperFunction(method);
                continue;
            }
            if (!(superFun instanceof FunctionDescriptor)) continue;
            superFunctions.add(SignaturesPropagationData.substituteSuperFunction(superclassToSupertype, (FunctionDescriptor)superFun));
        }
        Collections.sort(superFunctions, new Comparator<FunctionDescriptor>(){

            @Override
            public int compare(FunctionDescriptor fun1, FunctionDescriptor fun2) {
                FqNameUnsafe fqName1 = DescriptorUtils.getFQName(fun1.getContainingDeclaration());
                FqNameUnsafe fqName2 = DescriptorUtils.getFQName(fun2.getContainingDeclaration());
                return fqName1.asString().compareTo(fqName2.asString());
            }
        });
        return superFunctions;
    }

    @NotNull
    private static Multimap<FqName, Pair<FunctionDescriptor, PsiMethod>> getSuperclassToFunctionsMultimap(@NotNull PsiMethodWrapper method, @NotNull BindingContext bindingContext, @NotNull ClassDescriptor containingClass) {
        HashMultimap<FqName, Pair<FunctionDescriptor, PsiMethod>> result = HashMultimap.create();
        Name functionName = Name.identifier(method.getName());
        int parameterCount = method.getParameters().size();
        for (JetType supertype : TypeUtils.getAllSupertypes(containingClass.getDefaultType())) {
            ClassifierDescriptor klass = supertype.getConstructor().getDeclarationDescriptor();
            assert (klass != null);
            FqName fqName = DescriptorUtils.getFQName(klass).toSafe();
            for (FunctionDescriptor fun : klass.getDefaultType().getMemberScope().getFunctions(functionName)) {
                PsiElement declaration;
                CallableMemberDescriptor.Kind kind = fun.getKind();
                if (kind != CallableMemberDescriptor.Kind.DECLARATION && kind != CallableMemberDescriptor.Kind.DELEGATION || fun.getValueParameters().size() + (fun.getReceiverParameter() != null ? 1 : 0) != parameterCount || !((declaration = BindingContextUtils.descriptorToDeclaration(bindingContext, fun)) instanceof PsiMethod)) continue;
                result.put(fqName, Pair.create(fun, (PsiMethod)declaration));
            }
        }
        return result;
    }

    @Nullable
    private static DeclarationDescriptor findSuperFunction(@NotNull Collection<Pair<FunctionDescriptor, PsiMethod>> superFunctionCandidates, @NotNull PsiMethod superMethod) {
        PsiManager psiManager = PsiManager.getInstance(superMethod.getProject());
        for (Pair<FunctionDescriptor, PsiMethod> candidate : superFunctionCandidates) {
            if (!psiManager.areElementsEquivalent((PsiElement)candidate.second, superMethod)) continue;
            return (DeclarationDescriptor)candidate.first;
        }
        return null;
    }

    private boolean checkIfShouldBeExtension() {
        boolean someSupersExtension = false;
        boolean someSupersNotExtension = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            if (superFunction.getReceiverParameter() != null) {
                someSupersExtension = true;
                continue;
            }
            someSupersNotExtension = true;
        }
        if (someSupersExtension) {
            if (someSupersNotExtension) {
                this.reportError("Incompatible super methods: some are extension functions, some are not");
            } else {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private VarargCheckResult checkVarargInSuperFunctions(@NotNull ValueParameterDescriptor originalParam) {
        boolean someSupersVararg = false;
        boolean someSupersNotVararg = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            int index;
            int originalIndex = originalParam.getIndex();
            int n = index = superFunction.getReceiverParameter() != null ? originalIndex - 1 : originalIndex;
            if (index != -1 && superFunction.getValueParameters().get(index).getVarargElementType() != null) {
                someSupersVararg = true;
                continue;
            }
            someSupersNotVararg = true;
        }
        JetType originalVarargElementType = originalParam.getVarargElementType();
        JetType originalType = originalParam.getType();
        if (someSupersVararg && someSupersNotVararg) {
            this.reportError("Incompatible super methods: some have vararg parameter, some have not");
            return new VarargCheckResult(originalType, originalVarargElementType != null);
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (someSupersVararg && originalVarargElementType == null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            if (builtIns.isPrimitiveArray(originalType)) {
                return new VarargCheckResult(TypeUtils.makeNotNullable(originalType), true);
            }
            JetType varargElementType = builtIns.getArrayElementType(originalType);
            return new VarargCheckResult(builtIns.getArrayType(Variance.INVARIANT, varargElementType), true);
        }
        if (someSupersNotVararg && originalVarargElementType != null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            if (builtIns.isPrimitiveArray(originalType)) {
                return new VarargCheckResult(TypeUtils.makeNullable(originalType), false);
            }
            return new VarargCheckResult(TypeUtils.makeNullable(builtIns.getArrayType(Variance.OUT_VARIANCE, originalVarargElementType)), false);
        }
        return new VarargCheckResult(originalType, originalVarargElementType != null);
    }

    @NotNull
    private JetType modifyTypeAccordingToSuperMethods(@NotNull JetType autoType, @NotNull List<TypeAndVariance> typesFromSuper, @NotNull TypeUsage howThisTypeIsUsed) {
        if (ErrorUtils.isErrorType(autoType)) {
            return autoType;
        }
        boolean resultNullable = this.typeMustBeNullable(autoType, typesFromSuper, howThisTypeIsUsed);
        ClassifierDescriptor resultClassifier = this.modifyTypeClassifier(autoType, typesFromSuper);
        List<TypeProjection> resultArguments = this.getTypeArgsOfType(autoType, resultClassifier, typesFromSuper);
        JetScope resultScope = resultClassifier instanceof ClassDescriptor ? ((ClassDescriptor)resultClassifier).getMemberScope(resultArguments) : autoType.getMemberScope();
        JetTypeImpl type = new JetTypeImpl(autoType.getAnnotations(), resultClassifier.getTypeConstructor(), resultNullable, resultArguments, resultScope);
        PropagationHeuristics.checkArrayInReturnType(this, type, typesFromSuper);
        return type;
    }

    @NotNull
    private List<TypeProjection> getTypeArgsOfType(@NotNull JetType autoType, @NotNull ClassifierDescriptor classifier, @NotNull List<TypeAndVariance> typesFromSuper) {
        List<TypeProjection> autoArguments = autoType.getArguments();
        if (!(classifier instanceof ClassDescriptor)) {
            assert (autoArguments.isEmpty()) : "Unexpected type arguments when type constructor is not ClassDescriptor, type = " + autoType;
            return autoArguments;
        }
        List<List<TypeProjectionAndVariance>> typeArgumentsFromSuper = SignaturesPropagationData.calculateTypeArgumentsFromSuper((ClassDescriptor)classifier, typesFromSuper);
        ArrayList<TypeProjection> resultArguments = Lists.newArrayList();
        for (TypeParameterDescriptor parameter : classifier.getTypeConstructor().getParameters()) {
            TypeProjection argument = autoArguments.get(parameter.getIndex());
            JetType argumentType = argument.getType();
            List<TypeProjectionAndVariance> projectionsFromSuper = typeArgumentsFromSuper.get(parameter.getIndex());
            List<TypeAndVariance> argTypesFromSuper = SignaturesPropagationData.getTypes(projectionsFromSuper);
            JetType type = this.modifyTypeAccordingToSuperMethods(argumentType, argTypesFromSuper, TypeUsage.TYPE_ARGUMENT);
            Variance projectionKind = this.calculateArgumentProjectionKindFromSuper(argument, projectionsFromSuper);
            resultArguments.add(new TypeProjection(projectionKind, type));
        }
        return resultArguments;
    }

    private Variance calculateArgumentProjectionKindFromSuper(@NotNull TypeProjection argument, @NotNull List<TypeProjectionAndVariance> projectionsFromSuper) {
        LinkedHashSet<Variance> projectionKindsInSuper = Sets.newLinkedHashSet();
        for (TypeProjectionAndVariance projectionAndVariance : projectionsFromSuper) {
            projectionKindsInSuper.add(projectionAndVariance.typeProjection.getProjectionKind());
        }
        Variance defaultProjectionKind = argument.getProjectionKind();
        if (projectionKindsInSuper.size() == 0) {
            return defaultProjectionKind;
        }
        if (projectionKindsInSuper.size() == 1) {
            Variance projectionKindInSuper = (Variance)((Object)projectionKindsInSuper.iterator().next());
            if (defaultProjectionKind == Variance.INVARIANT || defaultProjectionKind == projectionKindInSuper) {
                return projectionKindInSuper;
            }
            this.reportError("Incompatible projection kinds in type arguments of super methods' return types: " + projectionsFromSuper + ", defined in current: " + argument);
            return defaultProjectionKind;
        }
        this.reportError("Incompatible projection kinds in type arguments of super methods' return types: " + projectionsFromSuper);
        return defaultProjectionKind;
    }

    @NotNull
    private static List<TypeAndVariance> getTypes(@NotNull List<TypeProjectionAndVariance> projections) {
        ArrayList<TypeAndVariance> types = Lists.newArrayList();
        for (TypeProjectionAndVariance projection : projections) {
            types.add(new TypeAndVariance(projection.typeProjection.getType(), SignaturesPropagationData.merge(projection.varianceOfPosition, projection.typeProjection.getProjectionKind())));
        }
        return types;
    }

    private static Variance merge(Variance positionOfOuter, Variance projectionKind) {
        if (positionOfOuter == Variance.INVARIANT) {
            return Variance.INVARIANT;
        }
        if (projectionKind == Variance.INVARIANT) {
            return positionOfOuter;
        }
        return positionOfOuter.superpose(projectionKind);
    }

    private static List<List<TypeProjectionAndVariance>> calculateTypeArgumentsFromSuper(@NotNull ClassDescriptor klass, @NotNull Collection<TypeAndVariance> typesFromSuper) {
        Multimap<TypeConstructor, TypeProjection> substitution = SubstitutionUtils.buildDeepSubstitutionMultimap(TypeUtils.makeUnsubstitutedType(klass, JetScope.EMPTY));
        ArrayList<List<TypeProjectionAndVariance>> parameterToArgumentsFromSuper = Lists.newArrayList();
        for (TypeParameterDescriptor ignored : klass.getTypeConstructor().getParameters()) {
            parameterToArgumentsFromSuper.add(new ArrayList());
        }
        for (TypeAndVariance typeFromSuper : typesFromSuper) {
            for (TypeParameterDescriptor parameter : typeFromSuper.type.getConstructor().getParameters()) {
                TypeProjection argument = typeFromSuper.type.getArguments().get(parameter.getIndex());
                for (TypeProjection projection : substitution.get(parameter.getTypeConstructor())) {
                    ClassifierDescriptor classifier = projection.getType().getConstructor().getDeclarationDescriptor();
                    if (!(classifier instanceof TypeParameterDescriptor) || classifier.getContainingDeclaration() != klass) continue;
                    int parameterIndex = ((TypeParameterDescriptor)classifier).getIndex();
                    Variance effectiveVariance = parameter.getVariance().superpose(typeFromSuper.varianceOfPosition);
                    ((List)parameterToArgumentsFromSuper.get(parameterIndex)).add(new TypeProjectionAndVariance(argument, effectiveVariance));
                }
            }
        }
        return parameterToArgumentsFromSuper;
    }

    private boolean typeMustBeNullable(@NotNull JetType autoType, @NotNull List<TypeAndVariance> typesFromSuper, @NotNull TypeUsage howThisTypeIsUsed) {
        boolean someSupersNotCovariantNullable = false;
        boolean someSupersCovariantNullable = false;
        boolean someSupersNotNull = false;
        for (TypeAndVariance typeFromSuper : typesFromSuper) {
            if (!typeFromSuper.type.isNullable()) {
                someSupersNotNull = true;
                continue;
            }
            if (typeFromSuper.varianceOfPosition == Variance.OUT_VARIANCE) {
                someSupersCovariantNullable = true;
                continue;
            }
            someSupersNotCovariantNullable = true;
        }
        if (someSupersNotNull && someSupersNotCovariantNullable) {
            this.reportError("Incompatible types in superclasses: " + typesFromSuper);
            return autoType.isNullable();
        }
        if (someSupersNotNull) {
            return false;
        }
        if (someSupersNotCovariantNullable || someSupersCovariantNullable) {
            boolean annotatedAsNotNull;
            boolean bl = annotatedAsNotNull = howThisTypeIsUsed != TypeUsage.TYPE_ARGUMENT && !autoType.isNullable();
            if (annotatedAsNotNull && someSupersNotCovariantNullable) {
                this.reportError("In superclass type is nullable: " + typesFromSuper + ", in subclass it is not: " + autoType);
                return true;
            }
            return !annotatedAsNotNull;
        }
        return autoType.isNullable();
    }

    @NotNull
    private ClassifierDescriptor modifyTypeClassifier(@NotNull JetType autoType, @NotNull List<TypeAndVariance> typesFromSuper) {
        ClassifierDescriptor fixed;
        ClassifierDescriptor classifier = autoType.getConstructor().getDeclarationDescriptor();
        if (!(classifier instanceof ClassDescriptor)) {
            assert (classifier != null) : "no declaration descriptor for type " + autoType;
            if (classifier instanceof TypeParameterDescriptor && this.autoTypeParameterToModified.containsKey(classifier)) {
                return this.autoTypeParameterToModified.get(classifier);
            }
            return classifier;
        }
        ClassDescriptor klass = (ClassDescriptor)classifier;
        CollectionClassMapping collectionMapping = CollectionClassMapping.getInstance();
        boolean someSupersMutable = false;
        boolean someSupersCovariantReadOnly = false;
        boolean someSupersNotCovariantReadOnly = false;
        for (TypeAndVariance typeFromSuper : typesFromSuper) {
            ClassifierDescriptor classifierFromSuper = typeFromSuper.type.getConstructor().getDeclarationDescriptor();
            if (!(classifierFromSuper instanceof ClassDescriptor)) continue;
            ClassDescriptor classFromSuper = (ClassDescriptor)classifierFromSuper;
            if (collectionMapping.isMutableCollection(classFromSuper)) {
                someSupersMutable = true;
                continue;
            }
            if (!collectionMapping.isReadOnlyCollection(classFromSuper)) continue;
            if (typeFromSuper.varianceOfPosition == Variance.OUT_VARIANCE) {
                someSupersCovariantReadOnly = true;
                continue;
            }
            someSupersNotCovariantReadOnly = true;
        }
        if (someSupersMutable && someSupersNotCovariantReadOnly) {
            this.reportError("Incompatible types in superclasses: " + typesFromSuper);
            return classifier;
        }
        if (someSupersMutable) {
            if (collectionMapping.isReadOnlyCollection(klass)) {
                return collectionMapping.convertReadOnlyToMutable(klass);
            }
        } else if ((someSupersNotCovariantReadOnly || someSupersCovariantReadOnly) && collectionMapping.isMutableCollection(klass)) {
            return collectionMapping.convertMutableToReadOnly(klass);
        }
        return (fixed = PropagationHeuristics.tryToFixOverridingTWithRawType(this, typesFromSuper)) != null ? fixed : classifier;
    }

    private static Map<ClassDescriptor, JetType> getSuperclassToSupertypeMap(ClassDescriptor containingClass) {
        HashMap<ClassDescriptor, JetType> superclassToSupertype = Maps.newHashMap();
        for (JetType supertype : TypeUtils.getAllSupertypes(containingClass.getDefaultType())) {
            ClassifierDescriptor superclass = supertype.getConstructor().getDeclarationDescriptor();
            assert (superclass instanceof ClassDescriptor);
            superclassToSupertype.put((ClassDescriptor)superclass, supertype);
        }
        return superclassToSupertype;
    }

    @NotNull
    private static FunctionDescriptor substituteSuperFunction(@NotNull Map<ClassDescriptor, JetType> superclassToSupertype, @NotNull FunctionDescriptor superFun) {
        DeclarationDescriptor superFunContainer = superFun.getContainingDeclaration();
        assert (superFunContainer instanceof ClassDescriptor) : superFunContainer;
        JetType supertype = superclassToSupertype.get(superFunContainer);
        assert (supertype != null) : "Couldn't find super type for super function: " + superFun;
        TypeSubstitutor supertypeSubstitutor = TypeSubstitutor.create(supertype);
        FunctionDescriptor substitutedSuperFun = superFun.substitute(supertypeSubstitutor);
        assert (substitutedSuperFun != null);
        return substitutedSuperFun;
    }

    private static boolean isArrayType(@NotNull JetType type) {
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        return builtIns.isArray(type) || builtIns.isPrimitiveArray(type);
    }

    private static void reportCantFindSuperFunction(PsiMethodWrapper method) {
        String errorMessage = "Can't find super function for " + method.getPsiMethod() + " defined in " + method.getPsiMethod().getContainingClass();
        if (SystemInfo.isMac) {
            LOG.error("Remove duplicates from your JDK definition\n" + errorMessage);
        } else {
            LOG.error(errorMessage);
        }
    }

    static class TypeAndVariance {
        public final JetType type;
        public final Variance varianceOfPosition;

        public TypeAndVariance(JetType type, Variance varianceOfPosition) {
            this.type = type;
            this.varianceOfPosition = varianceOfPosition;
        }

        public String toString() {
            return this.type.toString();
        }
    }

    private static class TypeProjectionAndVariance {
        public final TypeProjection typeProjection;
        public final Variance varianceOfPosition;

        public TypeProjectionAndVariance(TypeProjection typeProjection, Variance varianceOfPosition) {
            this.typeProjection = typeProjection;
            this.varianceOfPosition = varianceOfPosition;
        }

        public String toString() {
            return this.typeProjection.toString();
        }
    }

    private static class VarargCheckResult {
        public final JetType parameterType;
        public final boolean isVararg;

        public VarargCheckResult(JetType parameterType, boolean isVararg) {
            this.parameterType = parameterType;
            this.isVararg = isVararg;
        }
    }
}

