/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.ElementAlternativeSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesUtil;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.TypeTransformingVisitor;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class AlternativeMethodSignatureData
extends ElementAlternativeSignatureData {
    private final JetNamedFunction altFunDeclaration;
    private JavaDescriptorResolver.ValueParameterDescriptors altValueParameters;
    private JetType altReturnType;
    private List<TypeParameterDescriptor> altTypeParameters;
    private Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters;

    public AlternativeMethodSignatureData(@NotNull PsiMethodWrapper method, @NotNull JavaDescriptorResolver.ValueParameterDescriptors valueParameterDescriptors, @Nullable JetType originalReturnType, @NotNull List<TypeParameterDescriptor> methodTypeParameters, boolean hasSuperMethods) {
        String signature = method.getSignatureAnnotation().signature();
        if (signature.isEmpty()) {
            this.setAnnotated(false);
            this.altFunDeclaration = null;
            return;
        }
        this.setAnnotated(true);
        Project project = method.getPsiMethod().getProject();
        this.altFunDeclaration = JetPsiFactory.createFunction(project, signature);
        this.originalToAltTypeParameters = SignaturesUtil.recreateTypeParametersAndReturnMapping(methodTypeParameters, null);
        try {
            AlternativeMethodSignatureData.checkForSyntaxErrors(this.altFunDeclaration);
            AlternativeMethodSignatureData.checkEqualFunctionNames(this.altFunDeclaration, method);
            this.computeTypeParameters(methodTypeParameters);
            this.computeValueParameters(valueParameterDescriptors);
            if (originalReturnType != null) {
                this.altReturnType = AlternativeMethodSignatureData.computeReturnType(originalReturnType, this.altFunDeclaration.getReturnTypeRef(), this.originalToAltTypeParameters);
            }
            if (hasSuperMethods) {
                this.checkParameterAndReturnTypesForOverridingMethods(valueParameterDescriptors, methodTypeParameters, originalReturnType);
            }
        }
        catch (AlternativeSignatureMismatchException e) {
            this.setError(e.getMessage());
        }
    }

    private void checkParameterAndReturnTypesForOverridingMethods(@NotNull JavaDescriptorResolver.ValueParameterDescriptors valueParameterDescriptors, @NotNull List<TypeParameterDescriptor> methodTypeParameters, @Nullable JetType returnType) {
        int index;
        TypeSubstitutor substitutor = SignaturesUtil.createSubstitutorForTypeParameters(this.originalToAltTypeParameters);
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors.getDescriptors()) {
            index = valueParameterDescriptor.getIndex();
            ValueParameterDescriptor altParameter = this.altValueParameters.getDescriptors().get(index);
            JetType substituted = substitutor.substitute(valueParameterDescriptor.getType(), Variance.INVARIANT);
            assert (substituted != null);
            if (TypeUtils.equalTypes(substituted, altParameter.getType())) continue;
            throw new AlternativeSignatureMismatchException("Parameter type changed for method which overrides another: " + altParameter.getType() + ", was: " + valueParameterDescriptor.getType());
        }
        for (TypeParameterDescriptor typeParameterDescriptor : methodTypeParameters) {
            index = typeParameterDescriptor.getIndex();
            JetType substituted = substitutor.substitute(typeParameterDescriptor.getUpperBoundsAsType(), Variance.INVARIANT);
            assert (substituted != null);
            if (TypeUtils.equalTypes(substituted, this.altTypeParameters.get(index).getUpperBoundsAsType())) continue;
            throw new AlternativeSignatureMismatchException("Type parameter's upper bound changed for method which overrides another: " + this.altTypeParameters.get(index).getUpperBoundsAsType() + ", was: " + typeParameterDescriptor.getUpperBoundsAsType());
        }
        if (returnType != null) {
            JetType substitutedReturnType = substitutor.substitute(returnType, Variance.INVARIANT);
            assert (substitutedReturnType != null);
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(this.altReturnType, substitutedReturnType)) {
                throw new AlternativeSignatureMismatchException("Return type is changed to not subtype for method which overrides another: " + this.altReturnType + ", was: " + returnType);
            }
        }
    }

    @NotNull
    public JavaDescriptorResolver.ValueParameterDescriptors getValueParameters() {
        this.checkForErrors();
        return this.altValueParameters;
    }

    @NotNull
    public JetType getReturnType() {
        this.checkForErrors();
        return this.altReturnType;
    }

    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        this.checkForErrors();
        return this.altTypeParameters;
    }

    private void computeValueParameters(JavaDescriptorResolver.ValueParameterDescriptors valueParameterDescriptors) {
        List<ValueParameterDescriptor> parameterDescriptors = valueParameterDescriptors.getDescriptors();
        if (parameterDescriptors.size() != this.altFunDeclaration.getValueParameters().size()) {
            throw new AlternativeSignatureMismatchException("Method signature has %d value parameters, but alternative signature has %d", parameterDescriptors.size(), this.altFunDeclaration.getValueParameters().size());
        }
        ArrayList<ValueParameterDescriptor> altParamDescriptors = new ArrayList<ValueParameterDescriptor>();
        int size = parameterDescriptors.size();
        for (int i = 0; i < size; ++i) {
            JetType alternativeVarargElementType;
            JetType alternativeType;
            ValueParameterDescriptor originalParameterDescriptor = parameterDescriptors.get(i);
            JetParameter annotationValueParameter = this.altFunDeclaration.getValueParameters().get(i);
            JetTypeElement alternativeTypeElement = annotationValueParameter.getTypeReference().getTypeElement();
            assert (alternativeTypeElement != null);
            JetType originalParamVarargElementType = originalParameterDescriptor.getVarargElementType();
            if (originalParamVarargElementType == null) {
                if (annotationValueParameter.isVarArg()) {
                    throw new AlternativeSignatureMismatchException("Parameter in method signature is not vararg, but in alternative signature it is vararg");
                }
                alternativeType = TypeTransformingVisitor.computeType(alternativeTypeElement, originalParameterDescriptor.getType(), this.originalToAltTypeParameters, TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT);
                alternativeVarargElementType = null;
            } else {
                if (!annotationValueParameter.isVarArg()) {
                    throw new AlternativeSignatureMismatchException("Parameter in method signature is vararg, but in alternative signature it is not");
                }
                alternativeVarargElementType = TypeTransformingVisitor.computeType(alternativeTypeElement, originalParamVarargElementType, this.originalToAltTypeParameters, TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT);
                alternativeType = KotlinBuiltIns.getInstance().getArrayType(alternativeVarargElementType);
            }
            altParamDescriptors.add(new ValueParameterDescriptorImpl(originalParameterDescriptor.getContainingDeclaration(), originalParameterDescriptor.getIndex(), originalParameterDescriptor.getAnnotations(), originalParameterDescriptor.getName(), alternativeType, originalParameterDescriptor.declaresDefaultValue(), alternativeVarargElementType));
        }
        if (valueParameterDescriptors.getReceiverType() != null) {
            throw new UnsupportedOperationException("Alternative annotations for extension functions are not supported yet");
        }
        this.altValueParameters = new JavaDescriptorResolver.ValueParameterDescriptors(null, altParamDescriptors);
    }

    private void computeTypeParameters(List<TypeParameterDescriptor> typeParameters) {
        if (typeParameters.size() != this.altFunDeclaration.getTypeParameters().size()) {
            throw new AlternativeSignatureMismatchException("Method signature has %d type parameters, but alternative signature has %d", typeParameters.size(), this.altFunDeclaration.getTypeParameters().size());
        }
        this.altTypeParameters = new ArrayList<TypeParameterDescriptor>();
        int size = typeParameters.size();
        for (int i = 0; i < size; ++i) {
            TypeParameterDescriptor originalTypeParamDescriptor = typeParameters.get(i);
            TypeParameterDescriptorImpl altParamDescriptor = this.originalToAltTypeParameters.get(originalTypeParamDescriptor);
            JetTypeParameter altTypeParameter = (JetTypeParameter)this.altFunDeclaration.getTypeParameters().get(i);
            int upperBoundIndex = 0;
            for (JetType upperBound : originalTypeParamDescriptor.getUpperBounds()) {
                JetTypeElement altTypeElement;
                if (upperBoundIndex == 0) {
                    JetTypeReference extendsBound = altTypeParameter.getExtendsBound();
                    if (extendsBound == null) {
                        assert (originalTypeParamDescriptor.getUpperBounds().size() == 1);
                        altParamDescriptor.addDefaultUpperBound();
                        break;
                    }
                    altTypeElement = extendsBound.getTypeElement();
                } else {
                    JetTypeConstraint constraint = AlternativeMethodSignatureData.findTypeParameterConstraint(this.altFunDeclaration, originalTypeParamDescriptor.getName(), upperBoundIndex);
                    if (constraint == null) {
                        throw new AlternativeSignatureMismatchException("Upper bound #%d for type parameter %s is missing", upperBoundIndex, originalTypeParamDescriptor.getName());
                    }
                    altTypeElement = constraint.getBoundTypeReference().getTypeElement();
                }
                assert (altTypeElement != null);
                altParamDescriptor.addUpperBound(TypeTransformingVisitor.computeType(altTypeElement, upperBound, this.originalToAltTypeParameters, TypeUsage.UPPER_BOUND));
                ++upperBoundIndex;
            }
            if (AlternativeMethodSignatureData.findTypeParameterConstraint(this.altFunDeclaration, originalTypeParamDescriptor.getName(), upperBoundIndex) != null) {
                throw new AlternativeSignatureMismatchException("Extra upper bound #%d for type parameter %s", upperBoundIndex, originalTypeParamDescriptor.getName());
            }
            altParamDescriptor.setInitialized();
            this.altTypeParameters.add(altParamDescriptor);
        }
    }

    @Nullable
    private static JetTypeConstraint findTypeParameterConstraint(@NotNull JetFunction function, @NotNull Name typeParameterName, int index) {
        if (index != 0) {
            int currentIndex = 0;
            for (JetTypeConstraint constraint : function.getTypeConstraints()) {
                JetSimpleNameExpression parameterName = constraint.getSubjectTypeParameterName();
                assert (parameterName != null);
                if (typeParameterName.equals(parameterName.getReferencedNameAsName())) {
                    ++currentIndex;
                }
                if (currentIndex != index) continue;
                return constraint;
            }
        }
        return null;
    }

    private static void checkEqualFunctionNames(PsiNamedElement namedElement, PsiMethodWrapper method) {
        if (!ComparatorUtil.equalsNullable(method.getName(), namedElement.getName())) {
            throw new AlternativeSignatureMismatchException("Function names mismatch, original: %s, alternative: %s", method.getName(), namedElement.getName());
        }
    }
}

