/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.kt.JetPackageClassAnnotation;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class PackageClassUtils {
    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN.isRoot()) {
            return "_DefaultPackage";
        }
        return StringUtil.capitalize(packageFQN.shortName().asString()) + "Package";
    }

    public static FqName getPackageClassFqName(@NotNull FqName packageFQN) {
        return packageFQN.child(Name.identifier(PackageClassUtils.getPackageClassName(packageFQN)));
    }

    public static boolean isPackageClass(@NotNull PsiClass psiClass) {
        return JetPackageClassAnnotation.get(psiClass).isDefined();
    }

    public static boolean isPackageClass(@NotNull FqName fqName) {
        if (fqName.isRoot()) {
            return false;
        }
        return PackageClassUtils.getPackageClassFqName(fqName.parent()).equals(fqName);
    }
}

