/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.rt.signature.JetSignatureExceptionsAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureVariance;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public abstract class JetTypeJetSignatureReader
extends JetSignatureExceptionsAdapter {
    private final JavaSemanticServices javaSemanticServices;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final KotlinBuiltIns kotlinBuiltIns;
    private final TypeVariableResolver typeVariableResolver;
    private ClassDescriptor classDescriptor;
    private JetType errorType;
    private boolean nullable;
    private List<TypeProjection> typeArguments;

    public JetTypeJetSignatureReader(JavaSemanticServices javaSemanticServices, KotlinBuiltIns kotlinBuiltIns, TypeVariableResolver typeVariableResolver) {
        this.javaSemanticServices = javaSemanticServices;
        this.javaDescriptorResolver = javaSemanticServices.getDescriptorResolver();
        this.kotlinBuiltIns = kotlinBuiltIns;
        this.typeVariableResolver = typeVariableResolver;
    }

    private JetType getPrimitiveType(char descriptor, boolean nullable) {
        if (!nullable) {
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                if (jvmPrimitiveType.getJvmLetter() != descriptor) continue;
                return KotlinBuiltIns.getInstance().getPrimitiveJetType(jvmPrimitiveType.getPrimitiveType());
            }
            if (descriptor == 'V') {
                return KotlinBuiltIns.getInstance().getUnitType();
            }
        } else {
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                if (jvmPrimitiveType.getJvmLetter() != descriptor) continue;
                return KotlinBuiltIns.getInstance().getNullablePrimitiveJetType(jvmPrimitiveType.getPrimitiveType());
            }
            if (descriptor == 'V') {
                throw new IllegalStateException("incorrect signature: nullable void");
            }
        }
        throw new IllegalStateException("incorrect signature");
    }

    @Override
    public void visitBaseType(char descriptor, boolean nullable) {
        this.done(this.getPrimitiveType(descriptor, nullable));
    }

    @Override
    public void visitClassType(String signatureName, boolean nullable, boolean forceReal) {
        FqName fqName = JvmClassName.bySignatureName(signatureName).getFqName();
        this.enterClass(this.resolveClassDescriptorByFqName(fqName, forceReal), fqName.asString(), nullable);
    }

    private void enterClass(@Nullable ClassDescriptor classDescriptor, @NotNull String className, boolean nullable) {
        this.classDescriptor = classDescriptor;
        if (this.classDescriptor == null) {
            this.errorType = ErrorUtils.createErrorType("class not found by name: " + className);
        }
        this.nullable = nullable;
        this.typeArguments = new ArrayList<TypeProjection>();
    }

    @Nullable
    private ClassDescriptor resolveClassDescriptorByFqName(FqName ourName, boolean forceReal) {
        ClassDescriptor mappedDescriptor;
        if (!forceReal && (mappedDescriptor = JavaToKotlinClassMap.getInstance().mapKotlinClass(ourName, TypeUsage.MEMBER_SIGNATURE_INVARIANT)) != null) {
            return mappedDescriptor;
        }
        return this.javaDescriptorResolver.resolveClass(ourName, DescriptorSearchRule.INCLUDE_KOTLIN);
    }

    @Override
    public void visitInnerClassType(String signatureName, boolean nullable, boolean forceReal) {
        JvmClassName jvmClassName = JvmClassName.bySignatureName(signatureName);
        ClassDescriptor descriptor = this.resolveClassDescriptorByFqName(jvmClassName.getOuterClassFqName(), forceReal);
        for (String innerClassName : jvmClassName.getInnerClassNameList()) {
            descriptor = descriptor != null ? DescriptorUtils.getInnerClassByName(descriptor, innerClassName) : null;
        }
        this.enterClass(descriptor, signatureName, nullable);
    }

    private static Variance parseVariance(JetSignatureVariance variance) {
        switch (variance) {
            case INVARIANT: {
                return Variance.INVARIANT;
            }
            case OUT: {
                return Variance.OUT_VARIANCE;
            }
            case IN: {
                return Variance.IN_VARIANCE;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public JetSignatureVisitor visitTypeArgument(final JetSignatureVariance variance) {
        return new JetTypeJetSignatureReader(this.javaSemanticServices, this.kotlinBuiltIns, this.typeVariableResolver){

            @Override
            protected void done(@NotNull JetType jetType) {
                JetTypeJetSignatureReader.this.typeArguments.add(new TypeProjection(JetTypeJetSignatureReader.parseVariance(variance), jetType));
            }
        };
    }

    @Override
    public JetSignatureVisitor visitArrayType(final boolean nullable, final JetSignatureVariance wildcard) {
        return new JetTypeJetSignatureReader(this.javaSemanticServices, this.kotlinBuiltIns, this.typeVariableResolver){

            @Override
            public void visitBaseType(char descriptor, boolean nullable2) {
                JetType primitiveType = JetTypeJetSignatureReader.this.getPrimitiveType(descriptor, nullable2);
                JetType arrayType = !nullable2 ? KotlinBuiltIns.getInstance().getPrimitiveArrayJetTypeByPrimitiveJetType(primitiveType) : TypeUtils.makeNullableAsSpecified(KotlinBuiltIns.getInstance().getArrayType(primitiveType), nullable2);
                JetTypeJetSignatureReader.this.done(arrayType);
            }

            @Override
            protected void done(@NotNull JetType jetType) {
                JetType arrayType = TypeUtils.makeNullableAsSpecified(KotlinBuiltIns.getInstance().getArrayType(JetTypeJetSignatureReader.parseVariance(wildcard), jetType), nullable);
                JetTypeJetSignatureReader.this.done(arrayType);
            }
        };
    }

    @Override
    public void visitTypeVariable(String name, boolean nullable) {
        JetType r = TypeUtils.makeNullableAsSpecified(this.typeVariableResolver.getTypeVariable(name).getDefaultType(), nullable);
        this.done(r);
    }

    @Override
    public void visitEnd() {
        if (this.errorType != null == (this.classDescriptor != null)) {
            throw new IllegalStateException("must initialize either errorType or classDescriptor");
        }
        JetType jetType = this.errorType != null ? this.errorType : new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), this.classDescriptor.getTypeConstructor(), this.nullable, this.typeArguments, this.classDescriptor.getMemberScope(this.typeArguments));
        this.done(jetType);
    }

    protected abstract void done(@NotNull JetType var1);
}

