/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWithAbiVersion;
import org.jetbrains.jet.util.slicedmap.BasicWritableSlice;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class AbiVersionUtil {
    public static final WritableSlice<PsiClass, Integer> ABI_VERSION_ERRORS = new BasicWritableSlice<PsiClass, Integer>(Slices.ONLY_REWRITE_TO_EQUAL, true);
    public static final int INVALID_VERSION = -1;

    public static boolean isAbiVersionCompatible(int abiVersion) {
        return abiVersion == 6;
    }

    public static void checkAbiVersion(@NotNull PsiClass psiClass, @NotNull PsiAnnotationWithAbiVersion versionAnnotation, @NotNull BindingTrace trace) {
        if (!versionAnnotation.isDefined()) {
            return;
        }
        int abiVersion = versionAnnotation.getAbiVersion();
        if (AbiVersionUtil.isAbiVersionCompatible(abiVersion)) {
            return;
        }
        trace.record(ABI_VERSION_ERRORS, psiClass, abiVersion);
    }
}

