/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ArrayValue
implements CompileTimeConstant<List<CompileTimeConstant<?>>> {
    private final List<CompileTimeConstant<?>> value;
    private final JetType type;

    public ArrayValue(@NotNull List<CompileTimeConstant<?>> value, @NotNull JetType type) {
        this.value = value;
        this.type = type;
    }

    @Override
    @NotNull
    public List<CompileTimeConstant<?>> getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        return this.type;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data) {
        return visitor.visitArrayValue(this, data);
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayValue that = (ArrayValue)o;
        if (this.value == null) {
            return that.value == null;
        }
        int i = 0;
        for (CompileTimeConstant<?> thisObject : this.value) {
            if (!thisObject.equals(that.value.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.value == null) {
            return hashCode;
        }
        for (CompileTimeConstant<?> o : this.value) {
            hashCode += o.hashCode();
        }
        return hashCode;
    }
}

