/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.results;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadingConflictResolver;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;

public class ResolutionResultsHandler {
    public static ResolutionResultsHandler INSTANCE = new ResolutionResultsHandler();

    private ResolutionResultsHandler() {
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(@NotNull BindingTrace trace, @NotNull TracingStrategy tracing, @NotNull Set<ResolvedCallWithTrace<D>> candidates) {
        LinkedHashSet<ResolvedCallWithTrace<D>> successfulCandidates = Sets.newLinkedHashSet();
        LinkedHashSet<ResolvedCallWithTrace<D>> failedCandidates = Sets.newLinkedHashSet();
        LinkedHashSet<ResolvedCallWithTrace<D>> incompleteCandidates = Sets.newLinkedHashSet();
        LinkedHashSet candidatesWithWrongReceiver = Sets.newLinkedHashSet();
        for (ResolvedCallWithTrace<D> candidateCall : candidates) {
            ResolutionStatus status = candidateCall.getStatus();
            assert (status != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            if (status.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            if (status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                incompleteCandidates.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_TYPE_ERROR) {
                candidatesWithWrongReceiver.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_PRESENCE_ERROR) continue;
            failedCandidates.add(candidateCall);
        }
        if (!successfulCandidates.isEmpty() || !incompleteCandidates.isEmpty()) {
            return this.computeSuccessfulResult(trace, tracing, successfulCandidates, incompleteCandidates);
        }
        if (!failedCandidates.isEmpty()) {
            return this.computeFailedResult(trace, tracing, failedCandidates);
        }
        if (!candidatesWithWrongReceiver.isEmpty()) {
            tracing.unresolvedReferenceWrongReceiver(trace, candidatesWithWrongReceiver);
            return OverloadResolutionResultsImpl.candidatesWithWrongReceiver(candidatesWithWrongReceiver);
        }
        tracing.unresolvedReference(trace);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeSuccessfulResult(BindingTrace trace, TracingStrategy tracing, Set<ResolvedCallWithTrace<D>> successfulCandidates, Set<ResolvedCallWithTrace<D>> incompleteCandidates) {
        LinkedHashSet<ResolvedCallWithTrace<D>> successfulAndIncomplete = Sets.newLinkedHashSet();
        successfulAndIncomplete.addAll(successfulCandidates);
        successfulAndIncomplete.addAll(incompleteCandidates);
        OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(successfulAndIncomplete, true);
        if (results.isSingleResult()) {
            ResolvedCall resultingCall = results.getResultingCall();
            resultingCall.getTrace().moveAllMyDataTo(trace);
            if (resultingCall.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                return OverloadResolutionResultsImpl.incompleteTypeInference(resultingCall);
            }
        }
        if (results.isAmbiguity()) {
            tracing.recordAmbiguity(trace, results.getResultingCalls());
            if (ResolutionResultsHandler.allIncomplete(results.getResultingCalls())) {
                tracing.cannotCompleteResolve(trace, results.getResultingCalls());
                return OverloadResolutionResultsImpl.incompleteTypeInference(results.getResultingCalls());
            }
            if (ResolutionResultsHandler.allClean(results.getResultingCalls())) {
                tracing.ambiguity(trace, results.getResultingCalls());
            }
        }
        return results;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeFailedResult(BindingTrace trace, TracingStrategy tracing, Set<ResolvedCallWithTrace<D>> failedCandidates) {
        if (failedCandidates.size() != 1) {
            for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
                LinkedHashSet<ResolvedCallWithTrace<D>> thisLevel = Sets.newLinkedHashSet();
                for (ResolvedCallWithTrace<D> candidate : failedCandidates) {
                    if (!severityLevel.contains((Object)candidate.getStatus())) continue;
                    thisLevel.add(candidate);
                }
                if (thisLevel.isEmpty()) continue;
                OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(thisLevel, false);
                if (results.isSingleResult()) {
                    results.getResultingCall().getTrace().moveAllMyDataTo(trace);
                    return OverloadResolutionResultsImpl.singleFailedCandidate(results.getResultingCall());
                }
                tracing.noneApplicable(trace, results.getResultingCalls());
                tracing.recordAmbiguity(trace, results.getResultingCalls());
                return OverloadResolutionResultsImpl.manyFailedCandidates(results.getResultingCalls());
            }
            assert (false) : "Should not be reachable, cause every status must belong to some level";
            Set noOverrides = OverridingUtil.filterOverrides(failedCandidates, ResolvedCallImpl.MAP_TO_CANDIDATE);
            if (noOverrides.size() != 1) {
                tracing.noneApplicable(trace, noOverrides);
                tracing.recordAmbiguity(trace, noOverrides);
                return OverloadResolutionResultsImpl.manyFailedCandidates(noOverrides);
            }
            failedCandidates = noOverrides;
        }
        ResolvedCallWithTrace<D> failed = failedCandidates.iterator().next();
        failed.getTrace().moveAllMyDataTo(trace);
        return OverloadResolutionResultsImpl.singleFailedCandidate(failed);
    }

    private static <D extends CallableDescriptor> boolean allClean(@NotNull Collection<ResolvedCallWithTrace<D>> results) {
        for (ResolvedCallWithTrace<D> result : results) {
            if (!result.isDirty()) continue;
            return false;
        }
        return true;
    }

    private static <D extends CallableDescriptor> boolean allIncomplete(@NotNull Collection<ResolvedCallWithTrace<D>> results) {
        for (ResolvedCallWithTrace<D> result : results) {
            if (result.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(@NotNull Set<ResolvedCallWithTrace<D>> candidates, boolean discriminateGenerics) {
        ResolvedCallWithTrace<D> maximallySpecificGenericsDiscriminated;
        ResolvedCallWithTrace<D> maximallySpecific;
        if (candidates.size() == 1) {
            return OverloadResolutionResultsImpl.success(candidates.iterator().next());
        }
        Set<ResolvedCallWithTrace<D>> cleanCandidates = Sets.newLinkedHashSet(candidates);
        Iterator iterator = cleanCandidates.iterator();
        while (iterator.hasNext()) {
            ResolvedCallWithTrace candidate = (ResolvedCallWithTrace)iterator.next();
            if (!candidate.isDirty()) continue;
            iterator.remove();
        }
        if (cleanCandidates.isEmpty()) {
            cleanCandidates = candidates;
        }
        if ((maximallySpecific = OverloadingConflictResolver.INSTANCE.findMaximallySpecific(cleanCandidates, false)) != null) {
            return OverloadResolutionResultsImpl.success(maximallySpecific);
        }
        if (discriminateGenerics && (maximallySpecificGenericsDiscriminated = OverloadingConflictResolver.INSTANCE.findMaximallySpecific(cleanCandidates, true)) != null) {
            return OverloadResolutionResultsImpl.success(maximallySpecificGenericsDiscriminated);
        }
        Set noOverrides = OverridingUtil.filterOverrides(candidates, ResolvedCallImpl.MAP_TO_RESULT);
        if (noOverrides.size() == 1) {
            return OverloadResolutionResultsImpl.success(noOverrides.iterator().next());
        }
        return OverloadResolutionResultsImpl.ambiguity(noOverrides);
    }
}

