/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraints;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class ConstraintsUtil {
    @NotNull
    public static Set<JetType> getValues(@Nullable TypeConstraints typeConstraints) {
        LinkedHashSet<JetType> values = Sets.newLinkedHashSet();
        if (typeConstraints != null && !typeConstraints.isEmpty()) {
            Collection<JetType> upperBounds;
            if (typeConstraints.getExactBounds().size() == 1 && ConstraintsUtil.verifyOneExactBound(typeConstraints)) {
                JetType exactBound = typeConstraints.getExactBounds().iterator().next();
                return Collections.singleton(exactBound);
            }
            values.addAll(typeConstraints.getExactBounds());
            Collection<JetType> lowerBounds = ConstraintsUtil.filterNotContainingErrorType(typeConstraints.getLowerBounds());
            if (!lowerBounds.isEmpty()) {
                JetType superTypeOfLowerBounds = CommonSupertypes.commonSupertype(lowerBounds);
                for (JetType value : values) {
                    if (JetTypeChecker.INSTANCE.isSubtypeOf(superTypeOfLowerBounds, value)) continue;
                    values.add(superTypeOfLowerBounds);
                    break;
                }
                if (values.isEmpty()) {
                    values.add(superTypeOfLowerBounds);
                }
            }
            if (!(upperBounds = ConstraintsUtil.filterNotContainingErrorType(typeConstraints.getUpperBounds())).isEmpty()) {
                JetType subTypeOfUpperBounds = upperBounds.iterator().next();
                for (JetType value : values) {
                    if (JetTypeChecker.INSTANCE.isSubtypeOf(value, subTypeOfUpperBounds)) continue;
                    values.add(subTypeOfUpperBounds);
                    break;
                }
                if (values.isEmpty()) {
                    values.add(subTypeOfUpperBounds);
                }
            }
        }
        return values;
    }

    private static boolean verifyOneExactBound(@NotNull TypeConstraints typeConstraints) {
        JetType exactBound = typeConstraints.getExactBounds().iterator().next();
        for (JetType lowerBound : typeConstraints.getLowerBounds()) {
            if (JetTypeChecker.INSTANCE.isSubtypeOf(lowerBound, exactBound)) continue;
            return false;
        }
        for (JetType upperBound : typeConstraints.getUpperBounds()) {
            if (JetTypeChecker.INSTANCE.isSubtypeOf(exactBound, upperBound)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<JetType> filterNotContainingErrorType(@NotNull Collection<JetType> types) {
        return Collections2.filter(types, new Predicate<JetType>(){

            @Override
            public boolean apply(@Nullable JetType type) {
                return !ErrorUtils.containsErrorType(type);
            }
        });
    }

    @Nullable
    public static JetType getValue(@Nullable TypeConstraints typeConstraints) {
        if (typeConstraints == null) {
            return null;
        }
        Set<JetType> values = ConstraintsUtil.getValues(typeConstraints);
        if (values.size() == 1) {
            return values.iterator().next();
        }
        return null;
    }

    @Nullable
    public static TypeParameterDescriptor getFirstConflictingParameter(@NotNull ConstraintSystem constraintSystem) {
        for (TypeParameterDescriptor typeParameter : constraintSystem.getTypeVariables()) {
            TypeConstraints constraints = constraintSystem.getTypeConstraints(typeParameter);
            if (ConstraintsUtil.getValues(constraints).size() <= 1) continue;
            return typeParameter;
        }
        return null;
    }

    @NotNull
    public static Collection<TypeSubstitutor> getSubstitutorsForConflictingParameters(@NotNull ConstraintSystem constraintSystem) {
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(constraintSystem);
        if (firstConflictingParameter == null) {
            return Collections.emptyList();
        }
        Set<JetType> conflictingTypes = ConstraintsUtil.getValues(constraintSystem.getTypeConstraints(firstConflictingParameter));
        ArrayList substitutionContexts = Lists.newArrayList();
        for (JetType type : conflictingTypes) {
            LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = Maps.newLinkedHashMap();
            linkedHashMap.put(firstConflictingParameter.getTypeConstructor(), new TypeProjection(type));
            substitutionContexts.add(linkedHashMap);
        }
        for (TypeParameterDescriptor typeParameter : constraintSystem.getTypeVariables()) {
            if (typeParameter == firstConflictingParameter) continue;
            JetType jetType = ConstraintsUtil.getSafeValue(constraintSystem, typeParameter);
            for (Map map : substitutionContexts) {
                TypeProjection typeProjection = new TypeProjection(jetType);
                map.put(typeParameter.getTypeConstructor(), typeProjection);
            }
        }
        ArrayList<TypeSubstitutor> typeSubstitutors = Lists.newArrayList();
        for (Map map : substitutionContexts) {
            typeSubstitutors.add(TypeSubstitutor.create(map));
        }
        return typeSubstitutors;
    }

    @NotNull
    public static JetType getSafeValue(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter) {
        TypeConstraints constraints = constraintSystem.getTypeConstraints(typeParameter);
        JetType type = ConstraintsUtil.getValue(constraints);
        if (type != null) {
            return type;
        }
        return typeParameter.getUpperBoundsAsType();
    }

    public static boolean checkUpperBoundIsSatisfied(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter, boolean substituteOtherTypeParametersInBound) {
        TypeConstraints typeConstraints = constraintSystem.getTypeConstraints(typeParameter);
        assert (typeConstraints != null);
        JetType type = ConstraintsUtil.getValue(typeConstraints);
        if (type == null) {
            return true;
        }
        for (JetType upperBound : typeParameter.getUpperBounds()) {
            if (!substituteOtherTypeParametersInBound && TypeUtils.dependsOnTypeParameters(upperBound, constraintSystem.getTypeVariables())) continue;
            JetType substitutedUpperBound = constraintSystem.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            assert (substitutedUpperBound != null) : "We wanted to substitute projections as a result for " + typeParameter;
            if (JetTypeChecker.INSTANCE.isSubtypeOf(type, substitutedUpperBound)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkBoundsAreSatisfied(@NotNull ConstraintSystem constraintSystem, boolean substituteOtherTypeParametersInBounds) {
        for (TypeParameterDescriptor typeVariable : constraintSystem.getTypeVariables()) {
            if (ConstraintsUtil.checkUpperBoundIsSatisfied(constraintSystem, typeVariable, substituteOtherTypeParametersInBounds)) continue;
            return false;
        }
        return true;
    }
}

