/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.CallKey;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.util.slicedmap.BasicWritableSlice;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ResolutionResultsCache {
    public static final MemberType<FunctionDescriptor> FUNCTION_MEMBER_TYPE = new MemberType();
    public static final MemberType<VariableDescriptor> PROPERTY_MEMBER_TYPE = new MemberType();
    public static final WritableSlice<CallKey, OverloadResolutionResultsImpl<FunctionDescriptor>> RESOLUTION_RESULTS_FOR_FUNCTION = Slices.createSimpleSlice();
    public static final WritableSlice<CallKey, OverloadResolutionResultsImpl<VariableDescriptor>> RESOLUTION_RESULTS_FOR_PROPERTY = Slices.createSimpleSlice();
    public static final WritableSlice<CallKey, DelegatingBindingTrace> TRACE_DELTAS_CACHE = Slices.createSimpleSlice();
    public static final WritableSlice<CallKey, CallCandidateResolutionContext<FunctionDescriptor>> DEFERRED_COMPUTATION_FOR_CALL = Slices.createSimpleSlice();
    private final BindingTrace trace = new BindingTraceContext();

    @NotNull
    private static <D extends CallableDescriptor> WritableSlice<CallKey, OverloadResolutionResultsImpl<D>> getSliceByMemberType(@NotNull MemberType<D> memberType) {
        return memberType == FUNCTION_MEMBER_TYPE ? RESOLUTION_RESULTS_FOR_FUNCTION : RESOLUTION_RESULTS_FOR_PROPERTY;
    }

    public <D extends CallableDescriptor> void recordResolutionResults(@NotNull CallKey callKey, @NotNull MemberType<D> memberType, @NotNull OverloadResolutionResultsImpl<D> results) {
        this.trace.record(ResolutionResultsCache.getSliceByMemberType(memberType), callKey, results);
    }

    @Nullable
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> getResolutionResults(@NotNull CallKey callKey, @NotNull MemberType<D> memberType) {
        return this.trace.get(ResolutionResultsCache.getSliceByMemberType(memberType), callKey);
    }

    public void recordResolutionTrace(@NotNull CallKey callKey, @NotNull DelegatingBindingTrace delegatingTrace) {
        this.trace.record(TRACE_DELTAS_CACHE, callKey, delegatingTrace);
    }

    @Nullable
    public DelegatingBindingTrace getResolutionTrace(@NotNull CallKey callKey) {
        return this.trace.get(TRACE_DELTAS_CACHE, callKey);
    }

    public <D extends CallableDescriptor> void recordDeferredComputationForCall(@NotNull CallKey callKey, @NotNull CallCandidateResolutionContext<D> deferredComputation, @NotNull MemberType memberType) {
        if (memberType == PROPERTY_MEMBER_TYPE) {
            return;
        }
        this.trace.record(DEFERRED_COMPUTATION_FOR_CALL, callKey, deferredComputation);
    }

    @Nullable
    public CallCandidateResolutionContext<FunctionDescriptor> getDeferredComputation(@NotNull CallKey callKey) {
        return this.trace.get(DEFERRED_COMPUTATION_FOR_CALL, callKey);
    }

    @NotNull
    public static ResolutionResultsCache create() {
        return new ResolutionResultsCache();
    }

    static {
        BasicWritableSlice.initSliceDebugNames(ResolutionResultsCache.class);
    }

    public static class MemberType<D extends CallableDescriptor> {
    }
}

