/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallExpressionResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolveMode;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ArgumentTypeResolver {
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;

    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public static boolean isSubtypeOfForArgumentType(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == CallResolverUtil.PLACEHOLDER_FUNCTION_TYPE) {
            return ArgumentTypeResolver.isFunctionOrErrorType(supertype) || KotlinBuiltIns.getInstance().isAny(supertype);
        }
        if (supertype == CallResolverUtil.PLACEHOLDER_FUNCTION_TYPE) {
            return ArgumentTypeResolver.isFunctionOrErrorType(subtype);
        }
        return JetTypeChecker.INSTANCE.isSubtypeOf(subtype, supertype);
    }

    private static boolean isFunctionOrErrorType(@NotNull JetType supertype) {
        return KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(supertype) || ErrorUtils.isErrorType(supertype);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context) {
        this.checkTypesWithNoCallee(context, CallResolverUtil.ResolveArgumentsMode.SKIP_FUNCTION_ARGUMENTS);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof JetFunctionLiteralExpression) continue;
            this.expressionTypingServices.getType(context.scope, argumentExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        }
        if (resolveFunctionArgumentBodies == CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS) {
            this.checkTypesForFunctionArgumentsWithNoCallee(context);
        }
        for (JetTypeProjection jetTypeProjection : context.call.getTypeArguments()) {
            JetTypeReference typeReference = jetTypeProjection.getTypeReference();
            if (typeReference == null) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(jetTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        }
    }

    public void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !(argumentExpression instanceof JetFunctionLiteralExpression)) continue;
            this.expressionTypingServices.getType(context.scope, argumentExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        }
        for (JetExpression jetExpression : context.call.getFunctionLiteralArguments()) {
            this.expressionTypingServices.getType(context.scope, jetExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        }
    }

    public void checkUnmappedArgumentTypes(CallResolutionContext<?> context, Set<ValueArgument> unmappedArguments) {
        for (ValueArgument valueArgument : unmappedArguments) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            this.expressionTypingServices.getType(context.scope, argumentExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        }
    }

    public <D extends CallableDescriptor> void checkTypesForFunctionArguments(CallResolutionContext<?> context, ResolvedCallImpl<D> resolvedCall) {
        Map<ValueParameterDescriptor, ResolvedValueArgument> arguments = resolvedCall.getValueArguments();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : arguments.entrySet()) {
            ValueParameterDescriptor valueParameterDescriptor = entry.getKey();
            JetType varargElementType = valueParameterDescriptor.getVarargElementType();
            JetType functionType = varargElementType != null ? varargElementType : valueParameterDescriptor.getType();
            ResolvedValueArgument valueArgument = entry.getValue();
            List<ValueArgument> valueArguments = valueArgument.getArguments();
            for (ValueArgument argument : valueArguments) {
                JetExpression expression = argument.getArgumentExpression();
                if (!(expression instanceof JetFunctionLiteralExpression)) continue;
                this.expressionTypingServices.getType(context.scope, expression, functionType, context.dataFlowInfo, context.trace);
            }
        }
    }

    @NotNull
    public JetTypeInfo getArgumentTypeInfo(@Nullable JetExpression expression, @NotNull CallResolutionContext<?> context, @NotNull CallResolverUtil.ResolveArgumentsMode resolveArgumentsMode, @Nullable TemporaryBindingTrace traceToCommitForCall) {
        if (expression == null) {
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        if (expression instanceof JetFunctionLiteralExpression) {
            return this.getFunctionLiteralTypeInfo((JetFunctionLiteralExpression)expression, context, resolveArgumentsMode);
        }
        JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context.trace.getBindingContext());
        if (recordedTypeInfo != null) {
            return recordedTypeInfo;
        }
        CallExpressionResolver callExpressionResolver = this.expressionTypingServices.getCallExpressionResolver();
        if (!(expression instanceof JetCallExpression) && !(expression instanceof JetQualifiedExpression)) {
            return this.expressionTypingServices.getTypeInfo(context.scope, expression, context.expectedType, context.dataFlowInfo, context.trace);
        }
        JetTypeInfo result = expression instanceof JetCallExpression ? callExpressionResolver.getCallExpressionTypeInfo((JetCallExpression)expression, ReceiverValue.NO_RECEIVER, null, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE), ResolveMode.NESTED_CALL, context.resolutionResultsCache) : callExpressionResolver.getQualifiedExpressionTypeInfo((JetQualifiedExpression)expression, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE), ResolveMode.NESTED_CALL, context.resolutionResultsCache);
        BindingContextUtils.recordExpressionType(expression, context.trace, context.scope, result);
        if (traceToCommitForCall != null) {
            traceToCommitForCall.commit();
        }
        return result;
    }

    @NotNull
    public JetTypeInfo getFunctionLiteralTypeInfo(@NotNull JetFunctionLiteralExpression functionLiteralExpression, @NotNull CallResolutionContext<?> context, @NotNull CallResolverUtil.ResolveArgumentsMode resolveArgumentsMode) {
        if (resolveArgumentsMode == CallResolverUtil.ResolveArgumentsMode.SKIP_FUNCTION_ARGUMENTS) {
            JetType type = this.getFunctionLiteralType(functionLiteralExpression, context.scope, context.trace);
            return JetTypeInfo.create(type, context.dataFlowInfo);
        }
        return this.expressionTypingServices.getTypeInfo(context.scope, functionLiteralExpression, context.expectedType, context.dataFlowInfo, context.trace);
    }

    @Nullable
    private JetType getFunctionLiteralType(@NotNull JetFunctionLiteralExpression expression, @NotNull JetScope scope, @NotNull BindingTrace trace) {
        List<JetParameter> valueParameters = expression.getValueParameters();
        if (valueParameters.isEmpty()) {
            return CallResolverUtil.PLACEHOLDER_FUNCTION_TYPE;
        }
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<JetType> parameterTypes = Lists.newArrayList();
        for (JetParameter parameter : valueParameters) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope, temporaryTrace, CallResolverUtil.DONT_CARE));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetType returnType = this.resolveTypeRefWithDefault(functionLiteral.getReturnTypeRef(), scope, temporaryTrace, CallResolverUtil.DONT_CARE);
        assert (returnType != null);
        JetType receiverType = this.resolveTypeRefWithDefault(functionLiteral.getReceiverTypeRef(), scope, temporaryTrace, null);
        return KotlinBuiltIns.getInstance().getFunctionType(Collections.<AnnotationDescriptor>emptyList(), receiverType, parameterTypes, returnType);
    }

    @Nullable
    public JetType resolveTypeRefWithDefault(@Nullable JetTypeReference returnTypeRef, @NotNull JetScope scope, @NotNull BindingTrace trace, @Nullable JetType defaultValue) {
        if (returnTypeRef != null) {
            return this.expressionTypingServices.getTypeResolver().resolveType(scope, returnTypeRef, trace, true);
        }
        return defaultValue;
    }
}

