/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;

public class TraceBasedRedeclarationHandler
implements RedeclarationHandler {
    private final BindingTrace trace;

    public TraceBasedRedeclarationHandler(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    @Override
    public void handleRedeclaration(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        this.report(first);
        this.report(second);
    }

    private void report(DeclarationDescriptor descriptor) {
        PsiElement firstElement = BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), descriptor);
        if (firstElement == null) {
            throw new IllegalStateException("No declaration found for " + descriptor);
        }
        this.trace.report(Errors.REDECLARATION.on(firstElement, descriptor.getName().asString()));
    }
}

