/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.FilteringScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public interface Importer {
    public static final Importer DO_NOTHING = new Importer(){

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
        }
    };

    public void addAllUnderImport(@NotNull DeclarationDescriptor var1, @NotNull PlatformToKotlinClassMap var2);

    public void addAliasImport(@NotNull DeclarationDescriptor var1, @NotNull Name var2);

    public static class DelayedImporter
    extends StandardImporter {
        private final List<DelayedImportEntry> imports = Lists.newArrayList();

        public DelayedImporter(@NotNull WritableScope namespaceScope) {
            super(namespaceScope);
        }

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            this.imports.add(new AllUnderImportEntry(descriptor, platformToKotlinClassMap));
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            this.imports.add(new AliasImportEntry(descriptor, aliasName));
        }

        public void processImports() {
            for (DelayedImportEntry anImport : this.imports) {
                if (anImport instanceof AllUnderImportEntry) {
                    AllUnderImportEntry allUnderImportEntry = (AllUnderImportEntry)anImport;
                    this.importAllUnderDeclaration((DeclarationDescriptor)allUnderImportEntry.getFirst(), (PlatformToKotlinClassMap)allUnderImportEntry.getSecond());
                    continue;
                }
                AliasImportEntry aliasImportEntry = (AliasImportEntry)anImport;
                this.importDeclarationAlias((DeclarationDescriptor)aliasImportEntry.getFirst(), (Name)aliasImportEntry.getSecond());
            }
        }

        private static class AliasImportEntry
        extends Pair<DeclarationDescriptor, Name>
        implements DelayedImportEntry {
            public AliasImportEntry(DeclarationDescriptor first, Name second) {
                super(first, second);
            }
        }

        private static class AllUnderImportEntry
        extends Pair<DeclarationDescriptor, PlatformToKotlinClassMap>
        implements DelayedImportEntry {
            public AllUnderImportEntry(@NotNull DeclarationDescriptor first, @Nullable PlatformToKotlinClassMap second) {
                super(first, second);
            }
        }

        private static interface DelayedImportEntry {
        }
    }

    public static class StandardImporter
    implements Importer {
        private final WritableScope namespaceScope;

        public StandardImporter(WritableScope namespaceScope) {
            this.namespaceScope = namespaceScope;
        }

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            this.importAllUnderDeclaration(descriptor, platformToKotlinClassMap);
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            this.importDeclarationAlias(descriptor, aliasName);
        }

        @NotNull
        private static JetScope createFilteringScope(@NotNull JetScope scope, @NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            final Collection<ClassDescriptor> kotlinAnalogsForClassesInside = platformToKotlinClassMap.mapPlatformClassesInside(descriptor);
            if (kotlinAnalogsForClassesInside.isEmpty()) {
                return scope;
            }
            return new FilteringScope(scope, new Predicate<DeclarationDescriptor>(){

                @Override
                public boolean apply(DeclarationDescriptor descriptor) {
                    for (ClassDescriptor kotlinAnalog : kotlinAnalogsForClassesInside) {
                        if (!kotlinAnalog.getName().equals(descriptor.getName())) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        protected void importAllUnderDeclaration(@NotNull DeclarationDescriptor descriptor, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
            JetScope scopeToImport = null;
            if (descriptor instanceof NamespaceDescriptor) {
                scopeToImport = ((NamespaceDescriptor)descriptor).getMemberScope();
            }
            if (descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() != ClassKind.OBJECT) {
                ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
                scopeToImport = classDescriptor.getUnsubstitutedInnerClassesScope();
                ClassDescriptor classObjectDescriptor = classDescriptor.getClassObjectDescriptor();
                if (classObjectDescriptor != null) {
                    scopeToImport = classObjectDescriptor.getUnsubstitutedInnerClassesScope();
                }
            }
            if (scopeToImport != null) {
                this.namespaceScope.importScope(StandardImporter.createFilteringScope(scopeToImport, descriptor, platformToKotlinClassMap));
            }
        }

        protected void importDeclarationAlias(@NotNull DeclarationDescriptor descriptor, @NotNull Name aliasName) {
            if (descriptor instanceof ClassifierDescriptor) {
                this.namespaceScope.importClassifierAlias(aliasName, (ClassifierDescriptor)descriptor);
            } else if (descriptor instanceof NamespaceDescriptor) {
                this.namespaceScope.importNamespaceAlias(aliasName, (NamespaceDescriptor)descriptor);
            } else if (descriptor instanceof FunctionDescriptor) {
                this.namespaceScope.importFunctionAlias(aliasName, (FunctionDescriptor)descriptor);
            } else if (descriptor instanceof VariableDescriptor) {
                this.namespaceScope.importVariableAlias(aliasName, (VariableDescriptor)descriptor);
            }
        }
    }
}

